/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.bitmap;

final class ColorSpaceUtils {
    private ColorSpaceUtils() {
    }

    public static int[] YCbCr2RGB(int y, int cb, int cr, boolean useBT601) {
        double b;
        double g;
        double r;
        int[] rgb = new int[3];
        cb -= 128;
        cr -= 128;
        double y1 = (double)(y -= 16) * 1.164383562;
        if (useBT601) {
            r = y1 + (double)cr * 1.596026317;
            g = y1 - (double)cr * 0.8129674985 - (double)cb * 0.3917615979;
            b = y1 + (double)cb * 2.017232218;
        } else {
            r = y1 + (double)cr * 1.792741071;
            g = y1 - (double)cr * 0.5329093286 - (double)cb * 0.2132486143;
            b = y1 + (double)cb * 2.112401786;
        }
        rgb[0] = (int)(r + 0.5);
        rgb[1] = (int)(g + 0.5);
        rgb[2] = (int)(b + 0.5);
        for (int i = 0; i < 3; ++i) {
            if (rgb[i] < 0) {
                rgb[i] = 0;
                continue;
            }
            if (rgb[i] <= 255) continue;
            rgb[i] = 255;
        }
        return rgb;
    }

    public static int[] RGB2YCbCr(int r, int g, int b, boolean useBT601) {
        double cr;
        double cb;
        double y;
        int[] yCbCr = new int[3];
        if (useBT601) {
            y = (double)r * 0.299 * 219.0 / 255.0 + (double)g * 0.587 * 219.0 / 255.0 + (double)b * 0.114 * 219.0 / 255.0;
            cb = (double)(-r) * 0.168736 * 224.0 / 255.0 - (double)g * 0.331264 * 224.0 / 255.0 + (double)b * 0.5 * 224.0 / 255.0;
            cr = (double)r * 0.5 * 224.0 / 255.0 - (double)g * 0.418688 * 224.0 / 255.0 - (double)b * 0.081312 * 224.0 / 255.0;
        } else {
            y = (double)r * 0.2126 * 219.0 / 255.0 + (double)g * 0.7152 * 219.0 / 255.0 + (double)b * 0.0722 * 219.0 / 255.0;
            cb = (double)(-r) * 0.2126 / 1.8556 * 224.0 / 255.0 - (double)g * 0.7152 / 1.8556 * 224.0 / 255.0 + (double)b * 0.5 * 224.0 / 255.0;
            cr = (double)r * 0.5 * 224.0 / 255.0 - (double)g * 0.7152 / 1.5748 * 224.0 / 255.0 - (double)b * 0.0722 / 1.5748 * 224.0 / 255.0;
        }
        yCbCr[0] = 16 + (int)(y + 0.5);
        yCbCr[1] = 128 + (int)(cb + 0.5);
        yCbCr[2] = 128 + (int)(cr + 0.5);
        for (int i = 0; i < 3; ++i) {
            if (yCbCr[i] < 16) {
                yCbCr[i] = 16;
                continue;
            }
            if (i == 0) {
                if (yCbCr[i] <= 235) continue;
                yCbCr[i] = 235;
                continue;
            }
            if (yCbCr[i] <= 240) continue;
            yCbCr[i] = 240;
        }
        return yCbCr;
    }
}

