/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.bitmap;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import com.mortennobel.imagescaling.ResampleFilter;

class FilterOp {
    private int srcWidth;
    private int srcHeight;
    private final int dstWidth;
    private final int dstHeight;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private byte[] a;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private final ResampleFilter filter;

    public FilterOp(ResampleFilter filter, int dstWidth, int dstHeight) {
        this.filter = filter;
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
    }

    public int[] filter(Bitmap bitmap, Palette palette) {
        this.srcWidth = bitmap.getWidth();
        this.srcHeight = bitmap.getHeight();
        this.r = palette.getR();
        this.g = palette.getG();
        this.b = palette.getB();
        this.a = palette.getAlpha();
        this.horizontalSubsamplingData = this.createSubSampling(this.srcWidth, this.dstWidth);
        this.verticalSubsamplingData = this.createSubSampling(this.srcHeight, this.dstHeight);
        int[] workPixels = new int[this.srcHeight * this.dstWidth];
        this.filterHorizontally(bitmap.getInternalBuffer(), workPixels);
        int[] outPixels = new int[this.dstHeight * this.dstWidth];
        this.filterVertically(workPixels, outPixels);
        return outPixels;
    }

    private SubSamplingData createSubSampling(int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float scalingFactor = (float)(dstSize - 1) / (float)(srcSize - 1);
        int[] arrN = new int[dstSize];
        float fwidth = this.filter.getSamplingRadius();
        if (scalingFactor < 1.0f) {
            float width = fwidth / scalingFactor;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            for (int i = 0; i < dstSize; ++i) {
                int k;
                arrN[i] = 0;
                int subindex = i * numContributors;
                float center = (float)i / scalingFactor;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (int j = left; j <= right; ++j) {
                    float weight = this.filter.apply((center - (float)j) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k2 = arrN[i];
                    int n2 = i;
                    arrN[n2] = arrN[n2] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k2] = n;
                    arrWeight[subindex + k2] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        } else {
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i = 0; i < dstSize; ++i) {
                int k;
                arrN[i] = 0;
                int subindex = i * numContributors;
                float center = (float)i / scalingFactor;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j = left; j <= right; ++j) {
                    float weight = this.filter.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k3 = arrN[i];
                    int n3 = i;
                    arrN[n3] = arrN[n3] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k3] = n;
                    arrWeight[subindex + k3] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    private void filterVertically(int[] src, int[] trg) {
        for (int x = 0; x < this.dstWidth; ++x) {
            for (int y = this.dstHeight - 1; y >= 0; --y) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.matrixWidth;
                int max = this.verticalSubsamplingData.sampleCount[y];
                int ofsY = this.dstWidth * y;
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                float alpha = 0.0f;
                int index = yTimesNumContributors;
                for (int j = max - 1; j >= 0; --j) {
                    int color = src[x + this.dstWidth * this.verticalSubsamplingData.pixelPositions[index]];
                    float w = this.verticalSubsamplingData.weightFactors[index];
                    alpha += (float)(color >> 24 & 0xFF) * w;
                    red += (float)(color >> 16 & 0xFF) * w;
                    green += (float)(color >> 8 & 0xFF) * w;
                    blue += (float)(color & 0xFF) * w;
                    ++index;
                }
                int ri = (int)red;
                if (ri < 0) {
                    ri = 0;
                } else if (ri > 255) {
                    ri = 255;
                }
                int gi = (int)green;
                if (gi < 0) {
                    gi = 0;
                } else if (gi > 255) {
                    gi = 255;
                }
                int bi = (int)blue;
                if (bi < 0) {
                    bi = 0;
                } else if (bi > 255) {
                    bi = 255;
                }
                int ai = (int)alpha;
                if (ai < 0) {
                    ai = 0;
                } else if (ai > 255) {
                    ai = 255;
                }
                trg[x + ofsY] = ai << 24 | ri << 16 | gi << 8 | bi;
            }
        }
    }

    private void filterHorizontally(byte[] src, int[] trg) {
        for (int k = 0; k < this.srcHeight; ++k) {
            int destOfsY = this.dstWidth * k;
            int srcOfsY = this.srcWidth * k;
            for (int i = this.dstWidth - 1; i >= 0; --i) {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                float alpha = 0.0f;
                int max = this.horizontalSubsamplingData.sampleCount[i];
                int index = i * this.horizontalSubsamplingData.matrixWidth;
                for (int j = max - 1; j >= 0; --j) {
                    int ofsX = this.horizontalSubsamplingData.pixelPositions[index];
                    int palIdx = src[srcOfsY + ofsX] & 0xFF;
                    float w = this.horizontalSubsamplingData.weightFactors[index];
                    red += (float)(this.r[palIdx] & 0xFF) * w;
                    green += (float)(this.g[palIdx] & 0xFF) * w;
                    blue += (float)(this.b[palIdx] & 0xFF) * w;
                    alpha += (float)(this.a[palIdx] & 0xFF) * w;
                    ++index;
                }
                int ri = (int)red;
                if (ri < 0) {
                    ri = 0;
                } else if (ri > 255) {
                    ri = 255;
                }
                int gi = (int)green;
                if (gi < 0) {
                    gi = 0;
                } else if (gi > 255) {
                    gi = 255;
                }
                int bi = (int)blue;
                if (bi < 0) {
                    bi = 0;
                } else if (bi > 255) {
                    bi = 255;
                }
                int ai = (int)alpha;
                if (ai < 0) {
                    ai = 0;
                } else if (ai > 255) {
                    ai = 255;
                }
                trg[i + destOfsY] = ai << 24 | ri << 16 | gi << 8 | bi;
            }
        }
    }

    private class SubSamplingData {
        private final int[] sampleCount;
        private final int[] pixelPositions;
        private final float[] weightFactors;
        private final int matrixWidth;

        private SubSamplingData(int[] sampleCount, int[] pixelPositions, float[] weightFactors, int matrixWidth) {
            this.sampleCount = sampleCount;
            this.pixelPositions = pixelPositions;
            this.weightFactors = weightFactors;
            this.matrixWidth = matrixWidth;
        }
    }
}

