/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.core;

import bdsup2sub.core.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ApplicationAttributes {
    private static final String PROPERTY_FILE = "version.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String BUILD_DATE = "date";
    private final Properties properties = new Properties();
    private static final ApplicationAttributes INSTANCE = new ApplicationAttributes();

    private ApplicationAttributes() {
        this.loadProperties();
    }

    public static ApplicationAttributes getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return (String)this.properties.get(NAME);
    }

    public String getVersion() {
        return (String)this.properties.get(VERSION);
    }

    public String getBuildDate() {
        return (String)this.properties.get(BUILD_DATE);
    }

    private void loadProperties() {
        InputStream is = Constants.class.getClassLoader().getResourceAsStream(PROPERTY_FILE);
        if (is != null) {
            try {
                this.properties.load(is);
            }
            catch (IOException e) {
                this.fillWithDefaultValues();
            }
        } else {
            this.fillWithDefaultValues();
        }
    }

    private void fillWithDefaultValues() {
        this.properties.put(NAME, "BDSup2Sub");
        this.properties.put(VERSION, "unknown");
        this.properties.put(BUILD_DATE, "unknown");
    }
}

