/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.core;

import bdsup2sub.core.CaptionMoveModeX;
import bdsup2sub.core.CaptionMoveModeY;
import bdsup2sub.core.Constants;
import bdsup2sub.core.ForcedFlagState;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.PaletteMode;
import bdsup2sub.core.Resolution;
import bdsup2sub.core.ScalingFilter;
import bdsup2sub.core.StreamID;
import bdsup2sub.tools.Props;
import bdsup2sub.utils.PlatformUtils;
import bdsup2sub.utils.SubtitleUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    public static final Color OK_BACKGROUND = UIManager.getColor("TextField.background");
    public static final Color WARN_BACKGROUND = new Color(-64);
    public static final Color ERROR_BACKGROUND = new Color(-1987412);
    public static final boolean CONVERT_RESOLUTION_BY_DEFAULT = false;
    public static final boolean CONVERT_FRAMERATE_BY_DEFAULT = false;
    public static final int DEFAULT_PTS_DELAY = 0;
    public static final boolean FIX_SHORT_FRAMES_BY_DEFAULT = false;
    public static final int DEFAULT_MIN_DISPLAY_TIME_PTS = 45000;
    public static final boolean APPLY_FREE_SCALE_BY_DEFAULT = false;
    public static final double DEFAULT_FREE_SCALE_FACTOR_X = 1.0;
    public static final double DEFAULT_FREE_SCALE_FACTOR_Y = 1.0;
    public static final double MIN_FREE_SCALE_FACTOR = 0.5;
    public static final double MAX_FREE_SCALE_FACTOR = 2.0;
    public static final double DEFAULT_SOURCE_FRAMERATE = Framerate.FPS_23_976.getValue();
    public static final double DEFAULT_TARGET_FRAMERATE = Framerate.PAL.getValue();
    public static final Resolution DEFAULT_TARGET_RESOLUTION = Resolution.PAL;
    public static final ForcedFlagState DEFAULT_FORCED_FLAG_STATE = ForcedFlagState.KEEP;
    public static final int DEFAULT_ALPHA_CROP_THRESHOLD = 14;
    public static final int DEFAULT_ALPHA_THRESHOLD = 80;
    public static final int DEFAULT_LUMINANCE_MED_HIGH_THRESHOLD = 210;
    public static final int DEFAULT_LUMINANCE_LOW_MED_THRESHOLD = 160;
    public static final int DEFAULT_MOVE_Y_OFFSET = 10;
    public static final int DEFAULT_MOVE_X_OFFSET = 10;
    public static final int DEFAULT_CROP_LINE_COUNT = 0;
    public static final int DEFAULT_MERGE_PTS_DIFF = 18000;
    public static final OutputMode DEFAULT_OUTPUT_MODE = OutputMode.VOBSUB;
    private boolean convertResolution = false;
    private boolean convertFPS = false;
    private int delayPTS = 0;
    private boolean cliMode = true;
    private boolean fixShortFrames = false;
    private int minTimePTS = 45000;
    private boolean applyFreeScale = false;
    private double freeScaleFactorX = 1.0;
    private double freeScaleFactorY = 1.0;
    private double fpsSrc = DEFAULT_SOURCE_FRAMERATE;
    private double fpsTrg = DEFAULT_TARGET_FRAMERATE;
    private boolean fpsSrcCertain;
    private Resolution outputResolution = DEFAULT_TARGET_RESOLUTION;
    private int languageIdx;
    private boolean exportForced;
    private int cropOffsetY = 0;
    private ForcedFlagState forceAll = DEFAULT_FORCED_FLAG_STATE;
    private boolean swapCrCb;
    private CaptionMoveModeX moveModeX = CaptionMoveModeX.KEEP_POSITION;
    private CaptionMoveModeY moveModeY = CaptionMoveModeY.KEEP_POSITION;
    private int moveOffsetX = 10;
    private int moveOffsetY = 10;
    private boolean moveCaptions;
    private double cineBarFactor = 0.11904761904761904;
    private StreamID currentStreamID = StreamID.UNKNOWN;
    private boolean keepFps;
    private static final int RECENT_FILE_COUNT = 5;
    private static final String CONFIG_FILE = "bdsup2sup.ini";
    private static final Configuration INSTANCE = new Configuration();
    private final String configFilePath;
    private List<String> recentFiles;
    private int[] luminanceThreshold = new int[]{210, 160};
    private int alphaThreshold = 80;
    private Props props;

    private Configuration() {
        this.configFilePath = this.getConfigFilePath();
        this.props = new Props();
    }

    public void load() {
        this.readConfigFile();
        this.loadConfig();
    }

    private void readConfigFile() {
        this.props.clear();
        this.props.setHeader(Constants.APP_NAME + " " + Constants.APP_VERSION + " settings - don't modify manually");
        this.props.load(this.configFilePath);
    }

    private void loadConfig() {
        this.loadRecentFiles();
        this.convertResolution = this.loadConvertResolution();
        this.outputResolution = this.loadOutputResolution();
        this.convertFPS = this.loadConvertFPS();
        this.fpsSrc = this.loadFpsSrc();
        this.fpsTrg = this.loadFpsTrg();
        this.delayPTS = this.loadDelayPTS();
        this.fixShortFrames = this.loadFixShortFrames();
        this.minTimePTS = this.loadMinTimePTS();
        this.applyFreeScale = this.loadApplyFreeScale();
        this.freeScaleFactorX = this.loadFreeScaleFactorX();
        this.freeScaleFactorY = this.loadFreeScaleFactorY();
        this.forceAll = this.loadForceAll();
    }

    public void storeConfig() {
        if (!this.cliMode) {
            this.props.save(this.configFilePath);
        }
    }

    private void loadRecentFiles() {
        String filename;
        this.recentFiles = new ArrayList<String>();
        for (int i = 0; i < 5 && (filename = this.props.get("recent_" + i, "")).length() > 0; ++i) {
            if (!new File(filename).exists()) continue;
            this.recentFiles.add(filename);
        }
    }

    public static Configuration getInstance() {
        return INSTANCE;
    }

    public String getConfigFilePath() {
        if (PlatformUtils.isLinux()) {
            String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
            File configFileDir = new File((xdgConfigHome != null ? xdgConfigHome : System.getProperty("user.home") + "/.config") + "/bdsup2sub");
            if (!configFileDir.exists()) {
                configFileDir.mkdir();
            }
            return configFileDir + "/" + CONFIG_FILE;
        }
        if (PlatformUtils.isMac()) {
            File configFileDir = new File(System.getProperty("user.home") + "/Library/Application Support/bdsup2sub");
            if (!configFileDir.exists()) {
                configFileDir.mkdir();
            }
            return configFileDir + "/" + CONFIG_FILE;
        }
        File configFileDir = new File(System.getProperty("user.home") + "/bdsup2sub");
        if (!configFileDir.exists()) {
            configFileDir.mkdir();
        }
        return configFileDir + "/" + CONFIG_FILE;
    }

    public boolean isCliMode() {
        return this.cliMode;
    }

    public void setCliMode(boolean cliMode) {
        this.cliMode = cliMode;
    }

    public boolean isVerbose() {
        return this.props.get("verbose", false);
    }

    public void setVerbose(boolean verbose) {
        this.props.set("verbose", verbose);
    }

    public boolean getWritePGCEditPalette() {
        return this.props.get("writePGCEditPal", false);
    }

    public void setWritePGCEditPalette(boolean writePGCEditPalette) {
        this.props.set("writePGCEditPal", writePGCEditPalette);
    }

    public int getMergePTSdiff() {
        return this.props.get("mergePTSdiff", 18000);
    }

    public void setMergePTSdiff(int mergePTSdiff) {
        this.props.set("mergePTSdiff", mergePTSdiff);
    }

    public int getAlphaCrop() {
        return this.props.get("alphaCrop", 14);
    }

    public void setAlphaCrop(int alphaCrop) {
        this.props.set("alphaCrop", alphaCrop);
    }

    public boolean getFixZeroAlpha() {
        return this.props.get("fixZeroAlpha", false);
    }

    public void setFixZeroAlpha(boolean fixZeroAlpha) {
        this.props.set("fixZeroAlpha", fixZeroAlpha);
    }

    public ScalingFilter getScalingFilter() {
        ScalingFilter defaultScalingFilter = ScalingFilter.BILINEAR;
        try {
            return ScalingFilter.valueOf(this.props.get("filter", defaultScalingFilter.name()));
        }
        catch (IllegalArgumentException ex) {
            return defaultScalingFilter;
        }
    }

    public void setScalingFilter(ScalingFilter filter) {
        this.props.set("filter", filter.name());
    }

    public PaletteMode getPaletteMode() {
        PaletteMode defaultPaletteMode = PaletteMode.CREATE_NEW;
        try {
            return PaletteMode.valueOf(this.props.get("paletteMode", defaultPaletteMode.name()));
        }
        catch (IllegalArgumentException ex) {
            return defaultPaletteMode;
        }
    }

    public void setPaletteMode(PaletteMode paletteMode) {
        this.props.set("paletteMode", paletteMode.name());
    }

    public OutputMode getOutputMode() {
        try {
            return OutputMode.valueOf(this.props.get("outputMode", DEFAULT_OUTPUT_MODE.name()));
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_OUTPUT_MODE;
        }
    }

    public void setOutputMode(OutputMode outputMode) {
        this.props.set("outputMode", outputMode.name());
    }

    public String getLoadPath() {
        return this.props.get("loadPath", "");
    }

    public void setLoadPath(String loadPath) {
        this.props.set("loadPath", loadPath);
    }

    public String getColorProfilePath() {
        return this.props.get("colorPath", "");
    }

    public void setColorProfilePath(String colorProfilePath) {
        this.props.set("colorPath", colorProfilePath);
    }

    public Dimension getMainWindowSize() {
        return new Dimension(this.props.get("frameWidth", 800), this.props.get("frameHeight", 600));
    }

    public void setMainWindowSize(Dimension dimension) {
        this.props.set("frameWidth", dimension.width);
        this.props.set("frameHeight", dimension.height);
    }

    public Point getMainWindowLocation() {
        return new Point(this.props.get("framePosX", -1), this.props.get("framePosY", -1));
    }

    public void setMainWindowLocation(Point location) {
        this.props.set("framePosX", location.x);
        this.props.set("framePosY", location.y);
    }

    public List<String> getRecentFiles() {
        return this.recentFiles;
    }

    public void addToRecentFiles(String filename) {
        int index = this.recentFiles.indexOf(filename);
        if (index != -1) {
            this.recentFiles.remove(index);
            this.recentFiles.add(0, filename);
        } else {
            this.recentFiles.add(0, filename);
            if (this.recentFiles.size() > 5) {
                this.recentFiles.remove(this.recentFiles.size() - 1);
            }
        }
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            this.props.set("recent_" + i, this.recentFiles.get(i));
        }
    }

    public boolean getConvertResolution() {
        return this.convertResolution;
    }

    public void setConvertResolution(boolean convertResolution) {
        this.convertResolution = convertResolution;
    }

    public boolean loadConvertResolution() {
        return this.props.get("convertResolution", false);
    }

    public void storeConvertResolution(boolean convertResolution) {
        this.props.set("convertResolution", convertResolution);
    }

    public boolean getConvertFPS() {
        return this.convertFPS;
    }

    public void setConvertFPS(boolean convertFPS) {
        this.convertFPS = convertFPS;
    }

    public boolean loadConvertFPS() {
        return this.props.get("convertFPS", false);
    }

    public void storeConvertFPS(boolean convertFPS) {
        this.props.set("convertFPS", convertFPS);
    }

    public int getDelayPTS() {
        return this.delayPTS;
    }

    public void setDelayPTS(int delayPTS) {
        this.delayPTS = delayPTS;
    }

    public int loadDelayPTS() {
        return this.props.get("delayPTS", 0);
    }

    public void storeDelayPTS(int delayPTS) {
        this.props.set("delayPTS", delayPTS);
    }

    public boolean getFixShortFrames() {
        return this.fixShortFrames;
    }

    public void setFixShortFrames(boolean fixShortFrames) {
        this.fixShortFrames = fixShortFrames;
    }

    public boolean loadFixShortFrames() {
        return this.props.get("fixShortFrames", false);
    }

    public void storeFixShortFrames(boolean fixShortFrames) {
        this.props.set("fixShortFrames", fixShortFrames);
    }

    public int getMinTimePTS() {
        return this.minTimePTS;
    }

    public void setMinTimePTS(int minTimePTS) {
        this.minTimePTS = minTimePTS;
    }

    public int loadMinTimePTS() {
        return this.props.get("minTimePTS", 45000);
    }

    public void storeMinTimePTS(int minTimePTS) {
        this.props.set("minTimePTS", minTimePTS);
    }

    public boolean getApplyFreeScale() {
        return this.applyFreeScale;
    }

    public void setApplyFreeScale(boolean applyFreeScale) {
        this.applyFreeScale = applyFreeScale;
    }

    public boolean loadApplyFreeScale() {
        return this.props.get("applyFreeScale", false);
    }

    public void storeApplyFreeScale(boolean applyFreeScale) {
        this.props.set("applyFreeScale", applyFreeScale);
    }

    public double getFreeScaleFactorX() {
        return this.freeScaleFactorX;
    }

    public double getFreeScaleFactorY() {
        return this.freeScaleFactorY;
    }

    public void setFreeScaleFactor(double x, double y) {
        if (x < 0.5) {
            x = 0.5;
        } else if (x > 2.0) {
            x = 2.0;
        }
        this.freeScaleFactorX = x;
        if (y < 0.5) {
            y = 0.5;
        } else if (y > 2.0) {
            y = 2.0;
        }
        this.freeScaleFactorY = y;
    }

    public double loadFreeScaleFactorX() {
        return this.props.get("freeScaleX", 1.0);
    }

    public double loadFreeScaleFactorY() {
        return this.props.get("freeScaleY", 1.0);
    }

    public void storeFreeScaleFactor(double x, double y) {
        if (x < 0.5) {
            x = 0.5;
        } else if (x > 2.0) {
            x = 2.0;
        }
        this.props.set("freeScaleX", x);
        if (y < 0.5) {
            y = 0.5;
        } else if (y > 2.0) {
            y = 2.0;
        }
        this.props.set("freeScaleY", y);
    }

    public double getFPSSrc() {
        return this.fpsSrc;
    }

    public void setFpsSrc(double fpsSrc) {
        this.fpsSrc = fpsSrc;
    }

    public double loadFpsSrc() {
        return SubtitleUtils.getFps(this.props.get("fpsSrc", String.valueOf(DEFAULT_SOURCE_FRAMERATE)));
    }

    public void storeFPSSrc(double fpsSrc) {
        this.props.set("fpsSrc", fpsSrc);
    }

    public double getFpsTrg() {
        return this.fpsTrg;
    }

    public void setFpsTrg(double fpsTrg) {
        this.fpsTrg = fpsTrg;
        this.setDelayPTS((int)SubtitleUtils.syncTimePTS(this.getDelayPTS(), fpsTrg, fpsTrg));
        this.setMinTimePTS((int)SubtitleUtils.syncTimePTS(this.getMinTimePTS(), fpsTrg, fpsTrg));
    }

    public double loadFpsTrg() {
        return SubtitleUtils.getFps(this.props.get("fpsTrg", String.valueOf(DEFAULT_TARGET_FRAMERATE)));
    }

    public void storeFpsTrg(double fpsTrg) {
        this.props.set("fpsTrg", fpsTrg);
    }

    public boolean isFpsSrcCertain() {
        return this.fpsSrcCertain;
    }

    public void setFpsSrcCertain(boolean fpsSrcCertain) {
        this.fpsSrcCertain = fpsSrcCertain;
    }

    public Resolution getOutputResolution() {
        return this.outputResolution;
    }

    public void setOutputResolution(Resolution outputResolution) {
        this.outputResolution = outputResolution;
    }

    public Resolution loadOutputResolution() {
        try {
            return Resolution.valueOf(this.props.get("resolutionTrg", DEFAULT_TARGET_RESOLUTION.name()));
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_TARGET_RESOLUTION;
        }
    }

    public void storeOutputResolution(Resolution outputResolution) {
        this.props.set("resolutionTrg", outputResolution.name());
    }

    public int getAlphaThreshold() {
        return this.alphaThreshold;
    }

    public void setAlphaThreshold(int alphaThreshold) {
        this.alphaThreshold = alphaThreshold;
    }

    public int[] getLuminanceThreshold() {
        return this.luminanceThreshold;
    }

    public void setLuminanceThreshold(int[] luminanceThreshold) {
        this.luminanceThreshold = luminanceThreshold;
    }

    public int getLanguageIdx() {
        return this.languageIdx;
    }

    public void setLanguageIdx(int languageIdx) {
        this.languageIdx = languageIdx;
    }

    public boolean isExportForced() {
        return this.exportForced;
    }

    public void setExportForced(boolean exportForced) {
        this.exportForced = exportForced;
    }

    public int getCropOffsetY() {
        return this.cropOffsetY;
    }

    public void setCropOffsetY(int cropOffsetY) {
        this.cropOffsetY = cropOffsetY;
    }

    public ForcedFlagState getForceAll() {
        return this.forceAll;
    }

    public ForcedFlagState loadForceAll() {
        try {
            return ForcedFlagState.valueOf(this.props.get("forceAll", DEFAULT_FORCED_FLAG_STATE.name()));
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_FORCED_FLAG_STATE;
        }
    }

    public void setForceAll(ForcedFlagState forceAll) {
        this.forceAll = forceAll;
    }

    public void storeForceAll(ForcedFlagState forceAll) {
        this.props.set("forceAll", forceAll.name());
    }

    public boolean isSwapCrCb() {
        return this.swapCrCb;
    }

    public void setSwapCrCb(boolean swapCrCb) {
        this.swapCrCb = swapCrCb;
    }

    public void setMoveModeY(CaptionMoveModeY moveModeY) {
        this.moveModeY = moveModeY;
        this.moveCaptions = moveModeY != CaptionMoveModeY.KEEP_POSITION || this.moveModeX != CaptionMoveModeX.KEEP_POSITION;
    }

    public CaptionMoveModeY getMoveModeY() {
        return this.moveModeY;
    }

    public void setMoveModeX(CaptionMoveModeX moveModeX) {
        this.moveModeX = moveModeX;
        this.moveCaptions = this.moveModeY != CaptionMoveModeY.KEEP_POSITION || moveModeX != CaptionMoveModeX.KEEP_POSITION;
    }

    public CaptionMoveModeX getMoveModeX() {
        return this.moveModeX;
    }

    public void setMoveOffsetY(int moveOffsetY) {
        this.moveOffsetY = moveOffsetY;
    }

    public int getMoveOffsetY() {
        return this.moveOffsetY;
    }

    public void setMoveOffsetX(int moveOffsetX) {
        this.moveOffsetX = moveOffsetX;
    }

    public int getMoveOffsetX() {
        return this.moveOffsetX;
    }

    public boolean getMoveCaptions() {
        return this.moveCaptions;
    }

    public void setMoveCaptions(boolean moveCaptions) {
        this.moveCaptions = moveCaptions;
    }

    public double getCineBarFactor() {
        return this.cineBarFactor;
    }

    public void setCineBarFactor(double cineBarFactor) {
        this.cineBarFactor = cineBarFactor;
    }

    public StreamID getCurrentStreamID() {
        return this.currentStreamID;
    }

    public void setCurrentStreamID(StreamID currentStreamID) {
        this.currentStreamID = currentStreamID;
    }

    public boolean isKeepFps() {
        return this.keepFps;
    }

    public void setKeepFps(boolean keepFps) {
        this.keepFps = keepFps;
    }
}

