/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.core;

import bdsup2sub.core.Configuration;
import bdsup2sub.gui.main.MainFrameView;
import javax.swing.SwingUtilities;

public final class Logger {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger INSTANCE = new Logger();
    private int errorCount;
    private int warningCount;
    private MainFrameView mainFrame;

    private Logger() {
    }

    public static Logger getInstance() {
        return INSTANCE;
    }

    public void warn(String message) {
        ++this.warningCount;
        final String msg = "WARNING: " + message;
        if (this.mainFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Logger.this.mainFrame.printToConsole(msg);
                }
            });
        } else {
            System.out.print(msg);
        }
    }

    public void error(String message) {
        ++this.errorCount;
        final String msg = "ERROR: " + message;
        if (this.mainFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Logger.this.mainFrame.printToConsole(msg);
                }
            });
        } else {
            System.out.print(msg);
        }
    }

    public void trace(String message) {
        final String msg = message;
        if (configuration.isVerbose()) {
            if (this.mainFrame != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Logger.this.mainFrame.printToConsole(msg);
                    }
                });
            } else {
                System.out.print(msg);
            }
        }
    }

    public void info(String message) {
        final String msg = message;
        if (this.mainFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Logger.this.mainFrame.printToConsole(msg);
                }
            });
        } else {
            System.out.print(msg);
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void resetErrorCounter() {
        this.errorCount = 0;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void resetWarningCounter() {
        this.warningCount = 0;
    }

    public void printWarningsAndErrorsAndResetCounters() {
        if (this.warningCount + this.errorCount > 0) {
            String message = "";
            if (this.warningCount > 0) {
                message = this.warningCount == 1 ? message + this.warningCount + " warning" : message + this.warningCount + " warnings";
            }
            if (this.warningCount > 0 && this.errorCount > 0) {
                message = message + " and ";
            }
            if (this.errorCount > 0) {
                message = this.errorCount == 1 ? this.errorCount + " error" : this.errorCount + " errors";
            }
            message = this.warningCount + this.errorCount < 3 ? "There was " + message : "There were " + message;
            System.out.println(message);
        }
        this.resetWarningCounter();
        this.resetErrorCounter();
    }

    public void setMainFrame(MainFrameView mainFrame) {
        this.mainFrame = mainFrame;
    }
}

