/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.edit;

import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.gui.edit.EditDialogModel;
import bdsup2sub.gui.support.EditPane;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

class EditDialogView
extends JDialog {
    private static final Logger logger = Logger.getInstance();
    private JPanel jContentPane;
    private JPanel jPanelUp;
    private JPanel jPanelLayout;
    private JPanel jPanelOffsets;
    private JPanel jPanelTimes;
    private JPanel jPanelButtons;
    private JPanel jPanelCheck;
    private JLabel jLabelInfo;
    private JButton jButtonPrev;
    private JButton jButtonNext;
    private JButton jButtonStoreNext;
    private JButton jButtonStorePrev;
    private EditPane jPanelPreview;
    private JSlider jSliderVertical;
    private JSlider jSliderHorizontal;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JTextField jTextFieldX;
    private JTextField jTextFieldY;
    private JButton jButtonCenter;
    private JTextField jTextFieldStart;
    private JTextField jTextFieldEnd;
    private JTextField jTextFieldDuration;
    private JButton jButtonMin;
    private JButton jButtonMax;
    private JButton jButtonTop;
    private JButton jButtonBottom;
    private JButton jButtonStore;
    private JCheckBox jCheckBoxForced;
    private JCheckBox jCheckBoxExclude;
    private JPanel jPanelPatches;
    private JButton jButtonAddPatch;
    private JButton jButtonUndoPatch;
    private JButton jButtonUndoAllPatches;
    private final EditDialogModel model;

    public EditDialogView(EditDialogModel model, Frame owner) {
        super(owner, true);
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.setMinimumDimension();
        this.setSize(this.model.getMinWidth() + 36, this.model.getMinHeight() + 320);
        this.setContentPane(this.getJContentPane());
        GuiUtils.centerRelativeToOwner(this);
        this.setResizable(false);
    }

    private void setMinimumDimension() {
        switch (this.model.getOutputResolution()) {
            case PAL: 
            case NTSC: {
                this.model.setMinWidth(720);
                this.model.setMinHeight(405);
                break;
            }
            default: {
                this.model.setMinWidth(640);
                this.model.setMinHeight(320);
            }
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelUp = new GridBagConstraints();
            gridBagPanelUp.gridx = 0;
            gridBagPanelUp.anchor = 18;
            gridBagPanelUp.weightx = 1.0;
            gridBagPanelUp.weighty = 1.0;
            gridBagPanelUp.gridwidth = 2;
            gridBagPanelUp.fill = 2;
            gridBagPanelUp.gridy = 0;
            GridBagConstraints gridBagPanelLayout = new GridBagConstraints();
            gridBagPanelLayout.gridx = 0;
            gridBagPanelLayout.anchor = 18;
            gridBagPanelLayout.weightx = 1.0;
            gridBagPanelLayout.weighty = 1.0;
            gridBagPanelLayout.fill = 2;
            gridBagPanelLayout.gridy = 1;
            gridBagPanelLayout.gridwidth = 2;
            GridBagConstraints gridBagPanelTimes = new GridBagConstraints();
            gridBagPanelTimes.gridx = 0;
            gridBagPanelTimes.anchor = 18;
            gridBagPanelTimes.weightx = 1.0;
            gridBagPanelTimes.weighty = 1.0;
            gridBagPanelTimes.fill = 2;
            gridBagPanelTimes.gridy = 2;
            GridBagConstraints gridBagPanelOffsets = new GridBagConstraints();
            gridBagPanelOffsets.gridx = 1;
            gridBagPanelOffsets.anchor = 18;
            gridBagPanelOffsets.weightx = 1.0;
            gridBagPanelOffsets.weighty = 1.0;
            gridBagPanelOffsets.fill = 1;
            gridBagPanelOffsets.gridy = 2;
            GridBagConstraints gridBagPanelCheck = new GridBagConstraints();
            gridBagPanelCheck.gridx = 0;
            gridBagPanelCheck.fill = 1;
            gridBagPanelCheck.anchor = 18;
            gridBagPanelCheck.weightx = 1.0;
            gridBagPanelCheck.weighty = 1.0;
            gridBagPanelCheck.gridy = 3;
            GridBagConstraints gridBagPanelPatches = new GridBagConstraints();
            gridBagPanelPatches.gridx = 1;
            gridBagPanelPatches.fill = 1;
            gridBagPanelPatches.anchor = 18;
            gridBagPanelPatches.weightx = 1.0;
            gridBagPanelPatches.weighty = 1.0;
            gridBagPanelPatches.gridy = 3;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.fill = 2;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 1.0;
            gridBagPanelButtons.gridy = 4;
            gridBagPanelButtons.gridwidth = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelUp(), gridBagPanelUp);
            this.jContentPane.add((Component)this.getJPanelLayout(), gridBagPanelLayout);
            this.jContentPane.add((Component)this.getJPanelOffsets(), gridBagPanelOffsets);
            this.jContentPane.add((Component)this.getJPanelTimes(), gridBagPanelTimes);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
            this.jContentPane.add((Component)this.getJPanelCheck(), gridBagPanelCheck);
            this.jContentPane.add((Component)this.getJPanelPatches(), gridBagPanelPatches);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelUp() {
        if (this.jPanelUp == null) {
            GridBagConstraints gridBagButtonStorePrev = new GridBagConstraints();
            gridBagButtonStorePrev.gridx = 1;
            gridBagButtonStorePrev.gridy = 0;
            gridBagButtonStorePrev.anchor = 18;
            gridBagButtonStorePrev.insets = new Insets(2, 4, 2, 6);
            GridBagConstraints gridBagButtonStoreNext = new GridBagConstraints();
            gridBagButtonStoreNext.gridx = 2;
            gridBagButtonStoreNext.gridy = 0;
            gridBagButtonStoreNext.anchor = 18;
            gridBagButtonStoreNext.insets = new Insets(2, 4, 2, 12);
            GridBagConstraints gridBagButtonNext = new GridBagConstraints();
            gridBagButtonNext.gridx = 4;
            gridBagButtonNext.anchor = 18;
            gridBagButtonNext.insets = new Insets(2, 4, 2, 6);
            gridBagButtonNext.gridy = 0;
            GridBagConstraints gridBagButtonPrev = new GridBagConstraints();
            gridBagButtonPrev.gridx = 3;
            gridBagButtonPrev.anchor = 18;
            gridBagButtonPrev.insets = new Insets(2, 4, 2, 4);
            gridBagButtonPrev.gridy = 0;
            GridBagConstraints gridBagInfo = new GridBagConstraints();
            gridBagInfo.weightx = 1.0;
            gridBagInfo.anchor = 17;
            gridBagInfo.insets = new Insets(4, 6, 0, 4);
            gridBagInfo.weighty = 1.0;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setText("Info");
            this.jPanelUp = new JPanel();
            this.jPanelUp.setPreferredSize(new Dimension(400, 25));
            this.jPanelUp.setMinimumSize(new Dimension(400, 25));
            this.jPanelUp.setLayout(new GridBagLayout());
            this.jPanelUp.add((Component)this.jLabelInfo, gridBagInfo);
            this.jPanelUp.add((Component)this.getJButtonPrev(), gridBagButtonPrev);
            this.jPanelUp.add((Component)this.getJButtonNext(), gridBagButtonNext);
            this.jPanelUp.add((Component)this.getJButtonStoreNext(), gridBagButtonStoreNext);
            this.jPanelUp.add((Component)this.getJButtonStorePrev(), gridBagButtonStorePrev);
        }
        return this.jPanelUp;
    }

    private JPanel getJPanelLayout() {
        if (this.jPanelLayout == null) {
            GridBagConstraints gridBagSliderHorizontal = new GridBagConstraints();
            gridBagSliderHorizontal.fill = 2;
            gridBagSliderHorizontal.gridy = 1;
            gridBagSliderHorizontal.weightx = 1.0;
            gridBagSliderHorizontal.gridx = 0;
            GridBagConstraints gridBagSliderVertical = new GridBagConstraints();
            gridBagSliderVertical.fill = 3;
            gridBagSliderVertical.gridy = 0;
            gridBagSliderVertical.weightx = 1.0;
            gridBagSliderVertical.insets = new Insets(0, 0, 0, 2);
            gridBagSliderVertical.gridx = 1;
            GridBagConstraints gridBagPanelPreview = new GridBagConstraints();
            gridBagPanelPreview.gridx = 0;
            gridBagPanelPreview.anchor = 18;
            gridBagPanelPreview.weighty = 0.0;
            gridBagPanelPreview.gridy = 0;
            gridBagPanelPreview.insets = new Insets(0, 4, 0, 0);
            this.jPanelLayout = new JPanel();
            this.jPanelLayout.setLayout(new GridBagLayout());
            this.jPanelLayout.add((Component)this.getJPanelPreview(), gridBagPanelPreview);
            this.jPanelLayout.add((Component)this.getJSliderVertical(), gridBagSliderVertical);
            this.jPanelLayout.add((Component)this.getJSliderHorizontal(), gridBagSliderHorizontal);
        }
        return this.jPanelLayout;
    }

    private JPanel getJPanelOffsets() {
        if (this.jPanelOffsets == null) {
            GridBagConstraints gridBagButtonBottom = new GridBagConstraints();
            gridBagButtonBottom.gridx = 3;
            gridBagButtonBottom.anchor = 18;
            gridBagButtonBottom.weightx = 120.0;
            gridBagButtonBottom.insets = new Insets(1, 0, 0, 0);
            gridBagButtonBottom.weighty = 10.0;
            gridBagButtonBottom.gridy = 1;
            GridBagConstraints gridBagButtonTop = new GridBagConstraints();
            gridBagButtonTop.gridx = 2;
            gridBagButtonTop.anchor = 18;
            gridBagButtonTop.weightx = 10.0;
            gridBagButtonTop.insets = new Insets(1, 0, 0, 0);
            gridBagButtonTop.weighty = 10.0;
            gridBagButtonTop.gridy = 1;
            GridBagConstraints gridBagButtonCenter = new GridBagConstraints();
            gridBagButtonCenter.gridx = 2;
            gridBagButtonCenter.anchor = 18;
            gridBagButtonCenter.insets = new Insets(0, 0, 2, 0);
            gridBagButtonCenter.weightx = 10.0;
            gridBagButtonCenter.gridy = 0;
            GridBagConstraints gridBagTextY = new GridBagConstraints();
            gridBagTextY.fill = 0;
            gridBagTextY.gridy = 1;
            gridBagTextY.weightx = 6.0;
            gridBagTextY.anchor = 18;
            gridBagTextY.insets = new Insets(2, 0, 0, 0);
            gridBagTextY.weighty = 10.0;
            gridBagTextY.gridx = 1;
            GridBagConstraints gridBagTextX = new GridBagConstraints();
            gridBagTextX.fill = 0;
            gridBagTextX.gridy = 0;
            gridBagTextX.weightx = 6.0;
            gridBagTextX.anchor = 18;
            gridBagTextX.insets = new Insets(1, 0, 2, 0);
            gridBagTextX.weighty = 0.0;
            gridBagTextX.gridx = 1;
            GridBagConstraints gridBagLabelY = new GridBagConstraints();
            gridBagLabelY.gridx = 0;
            gridBagLabelY.anchor = 18;
            gridBagLabelY.weightx = 0.0;
            gridBagLabelY.weighty = 10.0;
            gridBagLabelY.insets = new Insets(4, 6, 0, 4);
            gridBagLabelY.gridy = 1;
            JLabel jLabelY = new JLabel();
            jLabelY.setText("Y Offset  ");
            jLabelY.setPreferredSize(new Dimension(80, 14));
            jLabelY.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelX = new GridBagConstraints();
            gridBagLabelX.gridx = 0;
            gridBagLabelX.anchor = 18;
            gridBagLabelX.weightx = 0.0;
            gridBagLabelX.weighty = 0.0;
            gridBagLabelX.insets = new Insets(4, 6, 2, 4);
            gridBagLabelX.gridy = 0;
            JLabel jLabelX = new JLabel();
            jLabelX.setText("X Offset  ");
            jLabelX.setPreferredSize(new Dimension(80, 14));
            jLabelX.setMinimumSize(new Dimension(80, 14));
            this.jPanelOffsets = new JPanel();
            this.jPanelOffsets.setLayout(new GridBagLayout());
            this.jPanelOffsets.setBorder(BorderFactory.createTitledBorder(null, "Position", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelOffsets.add((Component)jLabelX, gridBagLabelX);
            this.jPanelOffsets.add((Component)jLabelY, gridBagLabelY);
            this.jPanelOffsets.add((Component)this.getJTextFieldX(), gridBagTextX);
            this.jPanelOffsets.add((Component)this.getJTextFieldY(), gridBagTextY);
            this.jPanelOffsets.add((Component)this.getJButtonCenter(), gridBagButtonCenter);
            this.jPanelOffsets.add((Component)this.getJButtonTop(), gridBagButtonTop);
            this.jPanelOffsets.add((Component)this.getJButtonBottom(), gridBagButtonBottom);
        }
        return this.jPanelOffsets;
    }

    private JPanel getJPanelTimes() {
        if (this.jPanelTimes == null) {
            GridBagConstraints gridBagButtonMax = new GridBagConstraints();
            gridBagButtonMax.gridx = 3;
            gridBagButtonMax.weightx = 120.0;
            gridBagButtonMax.anchor = 17;
            gridBagButtonMax.gridy = 2;
            GridBagConstraints gridBagButtonMin = new GridBagConstraints();
            gridBagButtonMin.gridx = 2;
            gridBagButtonMin.weightx = 10.0;
            gridBagButtonMin.anchor = 17;
            gridBagButtonMin.gridy = 2;
            GridBagConstraints gridBagTextDuration = new GridBagConstraints();
            gridBagTextDuration.fill = 0;
            gridBagTextDuration.gridy = 2;
            gridBagTextDuration.weightx = 6.0;
            gridBagTextDuration.anchor = 17;
            gridBagTextDuration.insets = new Insets(2, 0, 0, 0);
            gridBagTextDuration.gridx = 1;
            GridBagConstraints gridBagTextEnd = new GridBagConstraints();
            gridBagTextEnd.fill = 0;
            gridBagTextEnd.gridy = 1;
            gridBagTextEnd.weightx = 6.0;
            gridBagTextEnd.insets = new Insets(2, 0, 2, 0);
            gridBagTextEnd.anchor = 17;
            gridBagTextEnd.gridx = 1;
            GridBagConstraints gridBagTextStart = new GridBagConstraints();
            gridBagTextStart.fill = 0;
            gridBagTextStart.gridy = 0;
            gridBagTextStart.weightx = 6.0;
            gridBagTextStart.anchor = 17;
            gridBagTextStart.insets = new Insets(2, 0, 2, 0);
            gridBagTextStart.gridx = 1;
            GridBagConstraints gridBagLabelDuration = new GridBagConstraints();
            gridBagLabelDuration.gridx = 0;
            gridBagLabelDuration.anchor = 17;
            gridBagLabelDuration.insets = new Insets(0, 6, 0, 4);
            gridBagLabelDuration.weightx = 0.0;
            gridBagLabelDuration.weighty = 0.0;
            gridBagLabelDuration.gridy = 2;
            JLabel jLabelDuration = new JLabel();
            jLabelDuration.setText("Duration (ms)");
            jLabelDuration.setPreferredSize(new Dimension(80, 14));
            jLabelDuration.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelEnd = new GridBagConstraints();
            gridBagLabelEnd.gridx = 0;
            gridBagLabelEnd.anchor = 17;
            gridBagLabelEnd.insets = new Insets(0, 6, 2, 4);
            gridBagLabelEnd.weightx = 0.0;
            gridBagLabelEnd.weighty = 0.0;
            gridBagLabelEnd.gridy = 1;
            JLabel jLabelEnd = new JLabel();
            jLabelEnd.setText("End Time");
            jLabelEnd.setPreferredSize(new Dimension(80, 14));
            jLabelEnd.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelStart = new GridBagConstraints();
            gridBagLabelStart.gridx = 0;
            gridBagLabelStart.anchor = 17;
            gridBagLabelStart.insets = new Insets(0, 6, 2, 4);
            gridBagLabelStart.weightx = 0.0;
            gridBagLabelStart.weighty = 0.0;
            gridBagLabelStart.gridy = 0;
            JLabel jLabelStart = new JLabel();
            jLabelStart.setText("Start Time");
            jLabelStart.setPreferredSize(new Dimension(80, 14));
            jLabelStart.setMinimumSize(new Dimension(80, 14));
            this.jPanelTimes = new JPanel();
            this.jPanelTimes.setLayout(new GridBagLayout());
            this.jPanelTimes.setBorder(BorderFactory.createTitledBorder(null, "Times", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelTimes.add((Component)jLabelStart, gridBagLabelStart);
            this.jPanelTimes.add((Component)jLabelEnd, gridBagLabelEnd);
            this.jPanelTimes.add((Component)jLabelDuration, gridBagLabelDuration);
            this.jPanelTimes.add((Component)this.getJTextFieldStart(), gridBagTextStart);
            this.jPanelTimes.add((Component)this.getJTextFieldEnd(), gridBagTextEnd);
            this.jPanelTimes.add((Component)this.getJTextFieldDuration(), gridBagTextDuration);
            this.jPanelTimes.add((Component)this.getJButtonMin(), gridBagButtonMin);
            this.jPanelTimes.add((Component)this.getJButtonMax(), gridBagButtonMax);
        }
        return this.jPanelTimes;
    }

    private JPanel getJPanelCheck() {
        if (this.jPanelCheck == null) {
            GridBagConstraints gridBagCheckExclude = new GridBagConstraints();
            gridBagCheckExclude.gridx = 0;
            gridBagCheckExclude.gridy = 1;
            gridBagCheckExclude.weighty = 1.0;
            gridBagCheckExclude.anchor = 18;
            gridBagCheckExclude.weightx = 1.0;
            gridBagCheckExclude.insets = new Insets(0, 6, 0, 4);
            GridBagConstraints gridBagCheckForced = new GridBagConstraints();
            gridBagCheckForced.gridx = 0;
            gridBagCheckForced.gridy = 0;
            gridBagCheckForced.anchor = 18;
            gridBagCheckForced.weighty = 1.0;
            gridBagCheckForced.weightx = 1.0;
            gridBagCheckForced.insets = new Insets(0, 6, 0, 4);
            this.jPanelCheck = new JPanel();
            this.jPanelCheck.setLayout(new GridBagLayout());
            this.jPanelCheck.setPreferredSize(new Dimension(400, 23));
            this.jPanelCheck.setBorder(BorderFactory.createTitledBorder(null, "Flags", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelCheck.add((Component)this.getJCheckBoxForced(), gridBagCheckForced);
            this.jPanelCheck.add((Component)this.getJCheckBoxExclude(), gridBagCheckExclude);
        }
        return this.jPanelCheck;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonStore = new GridBagConstraints();
            gridBagButtonStore.gridx = 1;
            gridBagButtonStore.weightx = 30.0;
            gridBagButtonStore.insets = new Insets(0, 0, 2, 0);
            gridBagButtonStore.gridy = 0;
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.insets = new Insets(0, 0, 2, 9);
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.gridx = 2;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.insets = new Insets(0, 6, 2, 0);
            gridBagButtonCancel.weightx = 1.0;
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.setPreferredSize(new Dimension(400, 23));
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
            this.jPanelButtons.add((Component)this.getJButtonStore(), gridBagButtonStore);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("  <  ");
            this.jButtonPrev.setMnemonic(37);
            this.jButtonPrev.setToolTipText("Lose changes and skip to previous frame");
        }
        return this.jButtonPrev;
    }

    void addPrevButtonActionListener(ActionListener actionListener) {
        this.jButtonPrev.addActionListener(actionListener);
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("  >  ");
            this.jButtonNext.setMnemonic(39);
            this.jButtonNext.setToolTipText("Lose changes and skip to next frame");
        }
        return this.jButtonNext;
    }

    void addNextButtonActionListener(ActionListener actionListener) {
        this.jButtonNext.addActionListener(actionListener);
    }

    private EditPane getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new EditPane();
            this.jPanelPreview.setLayout(new GridBagLayout());
            Dimension dim = new Dimension(this.model.getMinWidth(), this.model.getMinHeight());
            this.jPanelPreview.setPreferredSize(dim);
            this.jPanelPreview.setSize(dim);
            this.jPanelPreview.setMinimumSize(dim);
            this.jPanelPreview.setMaximumSize(dim);
            this.jPanelPreview.setSelectionAllowed(true);
        }
        return this.jPanelPreview;
    }

    void addPreviewPanelSelectListener(EditPane.SelectListener selectListener) {
        this.jPanelPreview.addSelectListener(selectListener);
    }

    void setPreviewPanelAspectRatio(double aspectRatio) {
        this.jPanelPreview.setAspectRatio(aspectRatio);
    }

    void setPreviewPanelOffsets(int x, int y) {
        this.jPanelPreview.setSubtitleOffsets(x, y);
    }

    void setPreviewPanelExcluded(boolean excluded) {
        this.jPanelPreview.setExcluded(excluded);
    }

    void repaintPreviewPanel() {
        this.jPanelPreview.repaint();
    }

    int[] getPreviewPanelSelection() {
        return this.jPanelPreview.getSelection();
    }

    void removePreviewPanelSelection() {
        this.jPanelPreview.removeSelection();
    }

    void setPreviewPanelImage(BufferedImage image, int width, int height) {
        this.jPanelPreview.setImage(image, width, height);
    }

    private JSlider getJSliderVertical() {
        if (this.jSliderVertical == null) {
            this.jSliderVertical = new JSlider();
            this.jSliderVertical.setOrientation(1);
            this.jSliderVertical.setToolTipText("Move subtitle vertically");
        }
        return this.jSliderVertical;
    }

    void addVerticalSliderChangeListener(ChangeListener changeListener) {
        this.jSliderVertical.addChangeListener(changeListener);
    }

    int getVerticalSliderValue() {
        return this.jSliderVertical.getValue();
    }

    void setVerticalSliderValue(int value) {
        this.jSliderVertical.setValue(value);
    }

    private JSlider getJSliderHorizontal() {
        if (this.jSliderHorizontal == null) {
            this.jSliderHorizontal = new JSlider();
            this.jSliderHorizontal.setToolTipText("Move subtitle horizontally");
        }
        return this.jSliderHorizontal;
    }

    void addHorizontalSliderChangeListener(ChangeListener changeListener) {
        this.jSliderHorizontal.addChangeListener(changeListener);
    }

    int getHorizontalSliderValue() {
        return this.jSliderHorizontal.getValue();
    }

    void setHorizontalSliderValue(int value) {
        this.jSliderHorizontal.setValue(value);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.setToolTipText("Lose changes and return");
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("  Ok  ");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.setToolTipText("Save changes and return");
            this.jButtonOk.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonOk;
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.jButtonOk.addActionListener(actionListener);
    }

    private JTextField getJTextFieldX() {
        if (this.jTextFieldX == null) {
            this.jTextFieldX = new JTextField();
            this.jTextFieldX.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldX.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldX.setToolTipText("Set X coordinate of upper left corner of subtitle");
        }
        return this.jTextFieldX;
    }

    void addXTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldX.addActionListener(actionListener);
    }

    void addXTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldX.getDocument().addDocumentListener(documentListener);
    }

    String getXTextFieldText() {
        return this.jTextFieldX.getText();
    }

    void setXTextFieldText(String text) {
        this.jTextFieldX.setText(text);
    }

    void setXTextFieldBackground(Color color) {
        this.jTextFieldX.setBackground(color);
    }

    private JTextField getJTextFieldY() {
        if (this.jTextFieldY == null) {
            this.jTextFieldY = new JTextField();
            this.jTextFieldY.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldY.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldY.setToolTipText("Set Y coordinate of upper left corner of subtitle");
        }
        return this.jTextFieldY;
    }

    void addYTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldY.addActionListener(actionListener);
    }

    void addYTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldY.getDocument().addDocumentListener(documentListener);
    }

    String getYTextFieldText() {
        return this.jTextFieldY.getText();
    }

    void setYTextFieldText(String text) {
        this.jTextFieldY.setText(text);
    }

    void setYTextFieldBackground(Color color) {
        this.jTextFieldY.setBackground(color);
    }

    private JButton getJButtonCenter() {
        if (this.jButtonCenter == null) {
            this.jButtonCenter = new JButton();
            this.jButtonCenter.setText("Center");
            this.jButtonCenter.setMnemonic('r');
            this.jButtonCenter.setToolTipText("Center subpicture horizontally");
        }
        return this.jButtonCenter;
    }

    void addCenterButtonActionListener(ActionListener actionListener) {
        this.jButtonCenter.addActionListener(actionListener);
    }

    private JTextField getJTextFieldStart() {
        if (this.jTextFieldStart == null) {
            this.jTextFieldStart = new JTextField();
            this.jTextFieldStart.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldStart.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldStart.setToolTipText("Set start time of subtitle");
        }
        return this.jTextFieldStart;
    }

    void addStartTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldStart.addActionListener(actionListener);
    }

    void addStartTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldStart.getDocument().addDocumentListener(documentListener);
    }

    String getStartTextFieldText() {
        return this.jTextFieldStart.getText();
    }

    void setStartTextFieldText(String text) {
        this.jTextFieldStart.setText(text);
    }

    void setStartTextFieldBackground(Color color) {
        this.jTextFieldStart.setBackground(color);
    }

    private JTextField getJTextFieldEnd() {
        if (this.jTextFieldEnd == null) {
            this.jTextFieldEnd = new JTextField();
            this.jTextFieldEnd.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldEnd.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldEnd.setToolTipText("Set end time of subtitle");
        }
        return this.jTextFieldEnd;
    }

    void addEndTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldEnd.addActionListener(actionListener);
    }

    void addEndTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldEnd.getDocument().addDocumentListener(documentListener);
    }

    String getEndTextFieldText() {
        return this.jTextFieldEnd.getText();
    }

    void setEndTextFieldText(String text) {
        this.jTextFieldEnd.setText(text);
    }

    void setEndTextFieldBackground(Color color) {
        this.jTextFieldEnd.setBackground(color);
    }

    private JTextField getJTextFieldDuration() {
        if (this.jTextFieldDuration == null) {
            this.jTextFieldDuration = new JTextField();
            this.jTextFieldDuration.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldDuration.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldDuration.setToolTipText("Set display duration of subtitle in milliseconds");
        }
        return this.jTextFieldDuration;
    }

    void addDurationTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldDuration.addActionListener(actionListener);
    }

    void addDurationTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldDuration.getDocument().addDocumentListener(documentListener);
    }

    String getDurationTextFieldText() {
        return this.jTextFieldDuration.getText();
    }

    void setDurationTextFieldText(String text) {
        this.jTextFieldDuration.setText(text);
    }

    void setDurationTextFieldBackground(Color color) {
        this.jTextFieldDuration.setBackground(color);
    }

    private JButton getJButtonMin() {
        if (this.jButtonMin == null) {
            this.jButtonMin = new JButton();
            this.jButtonMin.setText("   Min   ");
            this.jButtonMin.setMnemonic('n');
            this.jButtonMin.setToolTipText("Set minimum duration");
        }
        return this.jButtonMin;
    }

    void addMinButtonActionListener(ActionListener actionListener) {
        this.jButtonMin.addActionListener(actionListener);
    }

    private JButton getJButtonMax() {
        if (this.jButtonMax == null) {
            this.jButtonMax = new JButton();
            this.jButtonMax.setText("   Max  ");
            this.jButtonMax.setMnemonic('m');
            this.jButtonMax.setToolTipText("Set maximum duration");
        }
        return this.jButtonMax;
    }

    void addMaxButtonActionListener(ActionListener actionListener) {
        this.jButtonMax.addActionListener(actionListener);
    }

    private JButton getJButtonTop() {
        if (this.jButtonTop == null) {
            this.jButtonTop = new JButton();
            this.jButtonTop.setText("   Top  ");
            this.jButtonTop.setMnemonic('t');
            this.jButtonTop.setToolTipText("Move to upper cinemascope bar");
        }
        return this.jButtonTop;
    }

    void addTopButtonActionListener(ActionListener actionListener) {
        this.jButtonTop.addActionListener(actionListener);
    }

    private JButton getJButtonBottom() {
        if (this.jButtonBottom == null) {
            this.jButtonBottom = new JButton();
            this.jButtonBottom.setText("Bottom");
            this.jButtonBottom.setMnemonic('b');
            this.jButtonBottom.setToolTipText("Move to lower cinemascope bar");
        }
        return this.jButtonBottom;
    }

    void addBottomButtonActionListener(ActionListener actionListener) {
        this.jButtonBottom.addActionListener(actionListener);
    }

    private JButton getJButtonStore() {
        if (this.jButtonStore == null) {
            this.jButtonStore = new JButton();
            this.jButtonStore.setText("Save Changes");
            this.jButtonStore.setMnemonic('s');
            this.jButtonStore.setEnabled(false);
            this.jButtonStore.setToolTipText("Save changes and continue editing");
        }
        return this.jButtonStore;
    }

    void addStoreButtonActionListener(ActionListener actionListener) {
        this.jButtonStore.addActionListener(actionListener);
    }

    void enableStoreButton(boolean enabled) {
        this.jButtonStore.setEnabled(enabled);
    }

    private JCheckBox getJCheckBoxForced() {
        if (this.jCheckBoxForced == null) {
            this.jCheckBoxForced = new JCheckBox();
            this.jCheckBoxForced.setText("Forced Caption");
            this.jCheckBoxForced.setMnemonic('f');
            this.jCheckBoxForced.setToolTipText("Force display of this subtitle");
        }
        return this.jCheckBoxForced;
    }

    void addForcedCheckBoxActionListener(ActionListener actionListener) {
        this.jCheckBoxForced.addActionListener(actionListener);
    }

    boolean isForcedCheckBoxSelected() {
        return this.jCheckBoxForced.isSelected();
    }

    private JCheckBox getJCheckBoxExclude() {
        if (this.jCheckBoxExclude == null) {
            this.jCheckBoxExclude = new JCheckBox();
            this.jCheckBoxExclude.setText("Exclude from export");
            this.jCheckBoxExclude.setMnemonic('x');
            this.jCheckBoxExclude.setToolTipText("Exclude this subtitle from export");
        }
        return this.jCheckBoxExclude;
    }

    void addExcludeCheckBoxActionListener(ActionListener actionListener) {
        this.jCheckBoxExclude.addActionListener(actionListener);
    }

    boolean isExcludeCheckBoxSelected() {
        return this.jCheckBoxExclude.isSelected();
    }

    private JPanel getJPanelPatches() {
        if (this.jPanelPatches == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.weightx = 10.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 18;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            this.jPanelPatches = new JPanel();
            this.jPanelPatches.setLayout(new GridBagLayout());
            this.jPanelPatches.setBorder(BorderFactory.createTitledBorder(null, "Erase Patches", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelPatches.add((Component)this.getJButtonAddPatch(), gridBagConstraints);
            this.jPanelPatches.add((Component)this.getJButtonUndoPatch(), gridBagConstraints1);
            this.jPanelPatches.add((Component)this.getJButtonUndoAllPatches(), gridBagConstraints2);
        }
        return this.jPanelPatches;
    }

    private JButton getJButtonAddPatch() {
        if (this.jButtonAddPatch == null) {
            this.jButtonAddPatch = new JButton();
            this.jButtonAddPatch.setText("Erase");
            this.jButtonAddPatch.setMnemonic('e');
            this.jButtonAddPatch.setToolTipText("Add erase patch to make the selected area transparent");
            this.jButtonAddPatch.setEnabled(false);
        }
        return this.jButtonAddPatch;
    }

    void addAddPatchButtonActionListener(ActionListener actionListener) {
        this.jButtonAddPatch.addActionListener(actionListener);
    }

    void setAddPatchButtonEnabled(boolean enabled) {
        this.jButtonAddPatch.setEnabled(enabled);
    }

    private JButton getJButtonUndoPatch() {
        if (this.jButtonUndoPatch == null) {
            this.jButtonUndoPatch = new JButton();
            this.jButtonUndoPatch.setText("Undo Erase");
            this.jButtonUndoPatch.setMnemonic('u');
            this.jButtonUndoPatch.setToolTipText("Remove one erase patch from the stack (undo one delete step)");
            this.jButtonUndoPatch.setEnabled(false);
        }
        return this.jButtonUndoPatch;
    }

    void addUndoPatchButtonActionListener(ActionListener actionListener) {
        this.jButtonUndoPatch.addActionListener(actionListener);
    }

    void setUndoPatchButtonEnabled(boolean enabled) {
        this.jButtonUndoPatch.setEnabled(enabled);
    }

    private JButton getJButtonUndoAllPatches() {
        if (this.jButtonUndoAllPatches == null) {
            this.jButtonUndoAllPatches = new JButton();
            this.jButtonUndoAllPatches.setText("Undo All");
            this.jButtonUndoAllPatches.setMnemonic('a');
            this.jButtonUndoAllPatches.setEnabled(false);
            this.jButtonUndoAllPatches.setToolTipText("Remove all erase patches from the stack (undo all delete steps)");
        }
        return this.jButtonUndoAllPatches;
    }

    void addUndoAllPatchesButtonActionListener(ActionListener actionListener) {
        this.jButtonUndoAllPatches.addActionListener(actionListener);
    }

    void setUndoAllPatchesButtonEnabled(boolean enabled) {
        this.jButtonUndoAllPatches.setEnabled(enabled);
    }

    private JButton getJButtonStoreNext() {
        if (this.jButtonStoreNext == null) {
            this.jButtonStoreNext = new JButton();
            this.jButtonStoreNext.setText("<html><font color=\"red\"><b>&nbsp;&gt;&nbsp;</b></font></html>");
            this.jButtonStoreNext.setToolTipText("Store changes and skip to next frame");
            this.jButtonStoreNext.setMnemonic(34);
        }
        return this.jButtonStoreNext;
    }

    void addStoreNextButtonActionListener(ActionListener actionListener) {
        this.jButtonStoreNext.addActionListener(actionListener);
    }

    private JButton getJButtonStorePrev() {
        if (this.jButtonStorePrev == null) {
            this.jButtonStorePrev = new JButton();
            this.jButtonStorePrev.setText("<html><font color=\"red\"><b>&nbsp;&lt;&nbsp;</b></font></html>");
            this.jButtonStorePrev.setToolTipText("Store changes and skip to previous frame");
            this.jButtonStorePrev.setMnemonic(33);
        }
        return this.jButtonStorePrev;
    }

    void addStorePrevButtonActionListener(ActionListener actionListener) {
        this.jButtonStorePrev.addActionListener(actionListener);
    }

    void error(String message) {
        logger.error(message);
        JOptionPane.showMessageDialog(this, message, "Error!", 2);
    }

    public void setIndex(int idx) {
        this.model.setReady(false);
        this.model.setIndex(idx);
        this.model.setSubPicPrev(idx > 0 ? Core.getSubPictureTrg(idx - 1) : null);
        this.model.setSubPicNext(idx < Core.getNumFrames() - 1 ? Core.getSubPictureTrg(idx + 1) : null);
        try {
            Core.convertSup(idx, idx + 1, Core.getNumFrames());
            this.model.setSubPic(new SubPicture(Core.getSubPictureTrg(idx)));
            SubPicture subPic = this.model.getSubPic();
            this.model.setImage(Core.getTrgImagePatched(subPic));
            if (!subPic.getErasePatch().isEmpty()) {
                this.jButtonUndoPatch.setEnabled(true);
                this.jButtonUndoAllPatches.setEnabled(true);
            }
            this.model.setEnableSliders(false);
            this.jSliderHorizontal.setMaximum(subPic.getWidth());
            this.jSliderHorizontal.setValue(subPic.getXOffset());
            this.jSliderVertical.setMaximum(subPic.getHeight());
            this.jSliderVertical.setValue(subPic.getHeight() - subPic.getYOffset());
            this.model.setEnableSliders(true);
            this.jLabelInfo.setText("Frame " + (idx + 1) + " of " + Core.getNumFrames());
            this.jTextFieldStart.setText(TimeUtils.ptsToTimeStr(subPic.getStartTime()));
            this.jTextFieldEnd.setText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
            this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
            this.jTextFieldX.setText(String.valueOf(subPic.getXOffset()));
            this.jTextFieldY.setText(String.valueOf(subPic.getYOffset()));
            this.jPanelPreview.setSubtitleOffsets(subPic.getXOffset(), subPic.getYOffset());
            this.jPanelPreview.setScreenDimension(subPic.getWidth(), subPic.getHeight());
            this.jPanelPreview.setCropOffsetY(this.model.getCropOffsetY());
            this.jPanelPreview.setImage(this.model.getImage(), subPic.getImageWidth(), subPic.getImageHeight());
            this.jPanelPreview.repaint();
            this.jPanelPreview.setExcluded(subPic.isExcluded());
            this.jCheckBoxExclude.setSelected(subPic.isExcluded());
            this.jCheckBoxForced.setSelected(subPic.isForced());
            this.model.setReady(true);
        }
        catch (CoreException ex) {
            this.error(ex.getMessage());
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
            Core.exit();
            System.exit(4);
        }
    }
}

