/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.export;

import bdsup2sub.core.OutputMode;
import bdsup2sub.gui.export.ExportDialogModel;
import bdsup2sub.gui.export.ExportDialogView;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;

class ExportDialogController {
    private final ExportDialogModel model;
    private final ExportDialogView view;

    public ExportDialogController(ExportDialogModel model, ExportDialogView view) {
        this.model = model;
        this.view = view;
        view.addWindowListener(new ExportDialogListener());
        view.addFilenameTextFieldActionListener(new FilenameTextFieldActionListener());
        view.addFilenameButtonActionListener(new FilenameButtonActionListener());
        view.addLanguageComboBoxItemListener(new LanguageComboBoxItemListener());
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addSaveButtonActionListener(new SaveButtonActionListener());
        view.addForcedCheckBoxItemListener(new ForcedCheckBoxItemListener());
        view.addWritePGCPaletteCheckBoxItemListener(new WritePGCPalCheckBoxItemListener());
    }

    private class ExportDialogListener
    extends WindowAdapter {
        private ExportDialogListener() {
        }

        public void windowClosing(WindowEvent event) {
            ExportDialogController.this.model.setCanceled(true);
            ExportDialogController.this.view.dispose();
        }
    }

    private class WritePGCPalCheckBoxItemListener
    implements ItemListener {
        private WritePGCPalCheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ExportDialogController.this.model.setWritePGCPalette(ExportDialogController.this.view.isWritePGCPalCheckBoxSelected());
        }
    }

    private class ForcedCheckBoxItemListener
    implements ItemListener {
        private ForcedCheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ExportDialogController.this.model.setExportForced(ExportDialogController.this.view.isForcedCheckBoxSelected());
        }
    }

    private class SaveButtonActionListener
    implements ActionListener {
        private SaveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String filename = ExportDialogController.this.view.getFilenameTextFieldText();
            if (filename != null) {
                ExportDialogController.this.model.setFilename(FilenameUtils.removeExtension(filename) + "." + ExportDialogController.this.model.getExtension());
            }
            ExportDialogController.this.model.storeExportForced();
            ExportDialogController.this.model.storeLanguageIdx();
            if (ExportDialogController.this.model.getOutputMode() == OutputMode.VOBSUB || ExportDialogController.this.model.getOutputMode() == OutputMode.SUPIFO) {
                ExportDialogController.this.model.storeWritePGCPal();
            }
            ExportDialogController.this.model.setCanceled(false);
            ExportDialogController.this.view.dispose();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ExportDialogController.this.model.setCanceled(true);
            ExportDialogController.this.view.dispose();
        }
    }

    private class LanguageComboBoxItemListener
    implements ItemListener {
        private LanguageComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ExportDialogController.this.model.setLanguageIdx(ExportDialogController.this.view.getLanguageComboBoxSelectedItem());
        }
    }

    private class FilenameButtonActionListener
    implements ActionListener {
        private FilenameButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String defaultFilename;
            String parent = FilenameUtils.getParent(ExportDialogController.this.model.getFilename());
            String filename = ToolBox.getFilename(parent, defaultFilename = FilenameUtils.getName(ExportDialogController.this.model.getFilename()), Collections.singletonList(ExportDialogController.this.model.getExtension()), false, ExportDialogController.this.view);
            if (filename != null) {
                ExportDialogController.this.model.setFilename(FilenameUtils.removeExtension(filename) + "." + ExportDialogController.this.model.getExtension());
                ExportDialogController.this.view.setFilenameTextFieldText(ExportDialogController.this.model.getFilename());
            }
        }
    }

    private class FilenameTextFieldActionListener
    implements ActionListener {
        private FilenameTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String filename = ExportDialogController.this.view.getFilenameTextFieldText();
            if (filename != null) {
                ExportDialogController.this.model.setFilename(FilenameUtils.removeExtension(filename) + "." + ExportDialogController.this.model.getExtension());
            }
        }
    }
}

