/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.export;

import bdsup2sub.core.Configuration;
import bdsup2sub.core.OutputMode;

class ExportDialogModel {
    private final Configuration configuration = Configuration.getInstance();
    private String filename = "";
    private String extension;
    private String dialogTitle;
    private boolean canceled;
    private int languageIdx = this.configuration.getLanguageIdx();
    private boolean exportForced = this.configuration.isExportForced();
    private boolean writePGCPalette = this.configuration.getWritePGCEditPalette();

    public ExportDialogModel() {
        this.determineExtensionAndDialogTitle();
    }

    private void determineExtensionAndDialogTitle() {
        OutputMode outputMode = this.getOutputMode();
        this.dialogTitle = "Export ";
        if (outputMode == OutputMode.VOBSUB) {
            this.extension = "idx";
            this.dialogTitle = this.dialogTitle + "SUB/IDX (VobSub)";
        } else if (outputMode == OutputMode.SUPIFO) {
            this.extension = "ifo";
            this.dialogTitle = this.dialogTitle + "SUP/IFO (SUP DVD)";
        } else if (outputMode == OutputMode.BDSUP) {
            this.extension = "sup";
            this.dialogTitle = this.dialogTitle + "BD SUP";
        } else {
            this.extension = "xml";
            this.dialogTitle = this.dialogTitle + "XML (SONY BDN)";
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public int getLanguageIdx() {
        return this.languageIdx;
    }

    public void setLanguageIdx(int languageIdx) {
        this.languageIdx = languageIdx;
    }

    public void storeLanguageIdx() {
        this.configuration.setLanguageIdx(this.languageIdx);
    }

    public boolean getExportForced() {
        return this.exportForced;
    }

    public void setExportForced(boolean exportForced) {
        this.exportForced = exportForced;
    }

    public void storeExportForced() {
        this.configuration.setExportForced(this.exportForced);
    }

    public boolean getWritePGCPalette() {
        return this.writePGCPalette;
    }

    public void setWritePGCPalette(boolean writePGCPalette) {
        this.writePGCPalette = writePGCPalette;
    }

    public void storeWritePGCPal() {
        this.configuration.setWritePGCEditPalette(this.writePGCPalette);
    }

    public OutputMode getOutputMode() {
        return this.configuration.getOutputMode();
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }
}

