/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.main;

import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.InputMode;
import bdsup2sub.core.Logger;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.PaletteMode;
import bdsup2sub.core.ScalingFilter;
import bdsup2sub.gui.main.MainFrameModel;
import bdsup2sub.gui.main.ZoomableGraphicsPanel;
import bdsup2sub.gui.support.ActionMenu;
import bdsup2sub.gui.support.EditPane;
import bdsup2sub.utils.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class MainFrameView
extends JFrame
implements ClipboardOwner {
    private static final Logger logger = Logger.getInstance();
    private static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private JPanel jContentPane;
    private JPanel jPanelTop;
    private JPanel jPanelInfoSource;
    private JLabel jLabelInfoSource;
    private JScrollPane jScrollPaneSource;
    private ZoomableGraphicsPanel jPanelSource;
    private JPanel jPanelInfoTarget;
    private JLabel jLabelInfoTarget;
    private JScrollPane jScrollPaneTarget;
    private ZoomableGraphicsPanel jPanelTarget;
    private JPanel jPanelBottom;
    private EditPane jLayoutPane;
    private JScrollPane jScrollPaneConsole;
    private JTextArea console;
    private JMenuBar jMenuBar;
    private ActionMenu jMenuFile;
    private JMenuItem jMenuItemLoad;
    private JMenu jMenuRecentFiles;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemClose;
    private JMenuItem jMenuItemQuit;
    private ActionMenu jMenuEdit;
    private JMenuItem jMenuItemEditFrame;
    private JMenuItem jMenuItemEditDefaultDvdPalette;
    private JMenuItem jMenuItemEditImportedDvdPalette;
    private JMenuItem jMenuItemEditDvdFramePalette;
    private JMenuItem jMenuItemMoveAll;
    private JMenuItem jMenuItemResetCropOffset;
    private ActionMenu jMenuSettings;
    private JMenuItem jMenuItemConversionSettings;
    private JCheckBoxMenuItem jMenuItemSwapCrCb;
    private JCheckBoxMenuItem jMenuItemFixInvisibleFrames;
    private JCheckBoxMenuItem jMenuItemVerboseOutput;
    private ActionMenu jMenuHelp;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemAbout;
    private JComboBox jComboBoxSubNum;
    private JComboBox jComboBoxAlphaThreshold;
    private JComboBox jComboBoxMedLowThreshold;
    private JComboBox jComboBoxHiMedThreshold;
    private JComboBox jComboBoxOutputFormat;
    private JComboBox jComboBoxPalette;
    private JComboBox jComboBoxFilter;
    private JTextField jTextSubNum;
    private JTextField jTextAlphaThreshold;
    private JTextField jTextMedLowThreshold;
    private JTextField jTextHiMedThreshold;
    private JPopupMenu jPopupMenu;
    private JMenuItem jPopupMenuItemCopy;
    private JMenuItem jPopupMenuItemClear;
    private ActionListener recentFilesMenuActionListener;
    private final MainFrameModel model;

    public MainFrameView(MainFrameModel model) {
        super(Constants.APP_NAME + " " + Constants.APP_VERSION);
        this.model = model;
        this.initialize();
        logger.setMainFrame(this);
    }

    private void initialize() {
        this.setSize(this.model.getMainWindowSize());
        this.setMinimumSize(new Dimension(700, 300));
        this.setJMenuBar(this.getjMenuBar());
        this.setContentPane(this.getJContentPane());
        this.getJPopupMenu();
        this.initAlphaThresholdComboBoxSelectedIndices();
        this.updateRecentFilesMenu();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("icons/bdsup2sub_32.png")));
        this.setLocation();
    }

    private void setLocation() {
        Point mainWindowLocation = this.model.getMainWindowLocation();
        if (mainWindowLocation.x != -1 && mainWindowLocation.y != -1) {
            this.setLocation(mainWindowLocation);
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    private JMenuBar getjMenuBar() {
        if (this.jMenuBar == null) {
            this.jMenuBar = new JMenuBar();
            this.jMenuBar.add(this.getJMenuFile());
            this.jMenuBar.add(this.getJMenuEdit());
            this.jMenuBar.add(this.getJMenuPrefs());
            this.jMenuBar.add(this.getJMenuHelp());
        }
        return this.jMenuBar;
    }

    private JMenu getJMenuFile() {
        if (this.jMenuFile == null) {
            this.jMenuFile = new ActionMenu();
            this.jMenuFile.setName("");
            if (!PlatformUtils.isMac()) {
                this.jMenuFile.setMnemonic('f');
            }
            this.jMenuFile.setText("File");
            this.jMenuFile.add(this.getJMenuItemLoad());
            this.jMenuFile.add(this.getJMenuItemRecentFiles());
            this.jMenuFile.add(this.getJMenuItemSave());
            this.jMenuFile.add(this.getJMenuItemClose());
            JMenuItem quitMenuItem = this.getJMenuItemQuit();
            if (!PlatformUtils.isMac()) {
                this.jMenuFile.add(quitMenuItem);
            }
        }
        return this.jMenuFile;
    }

    private JMenuItem getJMenuItemLoad() {
        if (this.jMenuItemLoad == null) {
            this.jMenuItemLoad = new JMenuItem();
            this.jMenuItemLoad.setText("Load");
            this.jMenuItemLoad.setAccelerator(KeyStroke.getKeyStroke(79, MENU_SHORTCUT_KEY_MASK));
            if (!PlatformUtils.isMac()) {
                this.jMenuItemLoad.setMnemonic('l');
            }
        }
        return this.jMenuItemLoad;
    }

    void addLoadMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemLoad.addActionListener(actionListener);
    }

    void setLoadMenuItemEnabled(boolean enable) {
        this.jMenuItemLoad.setEnabled(enable);
    }

    private JMenu getJMenuItemRecentFiles() {
        if (this.jMenuRecentFiles == null) {
            this.jMenuRecentFiles = new JMenu();
            this.jMenuRecentFiles.setText("Recent Files");
            if (!PlatformUtils.isMac()) {
                this.jMenuRecentFiles.setMnemonic('r');
            }
        }
        return this.jMenuRecentFiles;
    }

    void addRecentFilesMenuItemActionListener(ActionListener actionListener) {
        this.recentFilesMenuActionListener = actionListener;
        for (int i = 0; i < this.jMenuRecentFiles.getItemCount(); ++i) {
            this.jMenuRecentFiles.getItem(i).addActionListener(this.recentFilesMenuActionListener);
        }
    }

    void updateRecentFilesMenu() {
        this.jMenuRecentFiles.setEnabled(false);
        List<String> recentFiles = this.model.getRecentFiles();
        int size = recentFiles.size();
        if (size > 0) {
            this.jMenuRecentFiles.removeAll();
            for (int i = 0; i < size; ++i) {
                JMenuItem j = new JMenuItem();
                String s = recentFiles.get(i);
                j.setText(i + ": " + s);
                j.setActionCommand(s);
                char keyCode = Character.forDigit(i, 10);
                j.setAccelerator(KeyStroke.getKeyStroke((int)keyCode, MENU_SHORTCUT_KEY_MASK));
                if (!PlatformUtils.isMac()) {
                    j.setMnemonic(keyCode);
                }
                j.addActionListener(this.recentFilesMenuActionListener);
                this.jMenuRecentFiles.add(j);
            }
            this.jMenuRecentFiles.setEnabled(true);
        }
    }

    private JMenuItem getJMenuItemSave() {
        if (this.jMenuItemSave == null) {
            this.jMenuItemSave = new JMenuItem();
            this.jMenuItemSave.setText("Export");
            this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
            if (!PlatformUtils.isMac()) {
                this.jMenuItemSave.setMnemonic('e');
            }
            this.jMenuItemSave.setEnabled(false);
        }
        return this.jMenuItemSave;
    }

    void addSaveMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemSave.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemClose() {
        if (this.jMenuItemClose == null) {
            this.jMenuItemClose = new JMenuItem();
            this.jMenuItemClose.setText("Close");
            this.jMenuItemClose.setEnabled(false);
            this.jMenuItemClose.setAccelerator(KeyStroke.getKeyStroke(87, MENU_SHORTCUT_KEY_MASK));
            if (!PlatformUtils.isMac()) {
                this.jMenuItemClose.setMnemonic('c');
            }
        }
        return this.jMenuItemClose;
    }

    void addCloseMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemClose.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemQuit() {
        if (this.jMenuItemQuit == null) {
            this.jMenuItemQuit = new JMenuItem();
            this.jMenuItemQuit.setText("Quit");
            this.jMenuItemQuit.setAccelerator(KeyStroke.getKeyStroke(81, MENU_SHORTCUT_KEY_MASK));
            if (!PlatformUtils.isMac()) {
                this.jMenuItemQuit.setMnemonic('q');
            }
        }
        return this.jMenuItemQuit;
    }

    void addQuitMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemQuit.addActionListener(actionListener);
    }

    void setQuitMenuItemEnabled(boolean enable) {
        this.jMenuItemQuit.setEnabled(enable);
    }

    private JMenu getJMenuEdit() {
        if (this.jMenuEdit == null) {
            this.jMenuEdit = new ActionMenu();
            this.jMenuEdit.setText("Edit");
            if (!PlatformUtils.isMac()) {
                this.jMenuEdit.setMnemonic('e');
            }
            this.jMenuEdit.add(this.getJMenuItemEditFrame());
            this.jMenuEdit.add(this.getJMenuItemEditDefaultDvdPalette());
            this.jMenuEdit.add(this.getJMenuItemEditImportedDvdPalette());
            this.jMenuEdit.add(this.getJMenuItemEditDvdFramePalette());
            this.jMenuEdit.add(this.getJMenuItemMoveAll());
            this.jMenuEdit.add(this.getJMenuItemResetCropOffset());
        }
        return this.jMenuEdit;
    }

    private JMenuItem getJMenuItemEditFrame() {
        if (this.jMenuItemEditFrame == null) {
            this.jMenuItemEditFrame = new JMenuItem();
            this.jMenuItemEditFrame.setText("Edit Frame");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemEditFrame.setMnemonic('f');
            }
            this.jMenuItemEditFrame.setEnabled(false);
        }
        return this.jMenuItemEditFrame;
    }

    void addEditFrameMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemEditFrame.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemEditDefaultDvdPalette() {
        if (this.jMenuItemEditDefaultDvdPalette == null) {
            this.jMenuItemEditDefaultDvdPalette = new JMenuItem();
            String text = "Edit default DVD Palette";
            this.jMenuItemEditDefaultDvdPalette.setText(text);
            if (!PlatformUtils.isMac()) {
                this.jMenuItemEditDefaultDvdPalette.setMnemonic('d');
            }
            this.jMenuItemEditDefaultDvdPalette.setDisplayedMnemonicIndex(text.indexOf("DVD"));
        }
        return this.jMenuItemEditDefaultDvdPalette;
    }

    void addEditDefaultDvdPaletteMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemEditDefaultDvdPalette.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemEditImportedDvdPalette() {
        if (this.jMenuItemEditImportedDvdPalette == null) {
            this.jMenuItemEditImportedDvdPalette = new JMenuItem();
            this.jMenuItemEditImportedDvdPalette.setEnabled(false);
            String text = "Edit imported DVD Palette";
            this.jMenuItemEditImportedDvdPalette.setText(text);
            if (!PlatformUtils.isMac()) {
                this.jMenuItemEditImportedDvdPalette.setMnemonic('i');
            }
            this.jMenuItemEditImportedDvdPalette.setDisplayedMnemonicIndex(text.indexOf("imported"));
        }
        return this.jMenuItemEditImportedDvdPalette;
    }

    void addEditImportedDvdPaletteMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemEditImportedDvdPalette.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemEditDvdFramePalette() {
        if (this.jMenuItemEditDvdFramePalette == null) {
            this.jMenuItemEditDvdFramePalette = new JMenuItem();
            this.jMenuItemEditDvdFramePalette.setEnabled(false);
            this.jMenuItemEditDvdFramePalette.setText("Edit DVD Frame Palette");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemEditDvdFramePalette.setMnemonic('p');
            }
        }
        return this.jMenuItemEditDvdFramePalette;
    }

    void addEditDvdFramePaletteMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemEditDvdFramePalette.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemMoveAll() {
        if (this.jMenuItemMoveAll == null) {
            this.jMenuItemMoveAll = new JMenuItem();
            this.jMenuItemMoveAll.setText("Move all captions");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemMoveAll.setMnemonic('m');
            }
            this.jMenuItemMoveAll.setEnabled(false);
        }
        return this.jMenuItemMoveAll;
    }

    void addMoveAllMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemMoveAll.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemResetCropOffset() {
        if (this.jMenuItemResetCropOffset == null) {
            this.jMenuItemResetCropOffset = new JMenuItem();
            if (!PlatformUtils.isMac()) {
                this.jMenuItemResetCropOffset.setMnemonic('r');
            }
            this.jMenuItemResetCropOffset.setText("Reset crop offset");
        }
        return this.jMenuItemResetCropOffset;
    }

    void addResetCropOffsetMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemResetCropOffset.addActionListener(actionListener);
    }

    private JMenu getJMenuPrefs() {
        if (this.jMenuSettings == null) {
            this.jMenuSettings = new ActionMenu();
            this.jMenuSettings.setText("Settings");
            if (!PlatformUtils.isMac()) {
                this.jMenuSettings.setMnemonic('s');
            }
            this.jMenuSettings.add(this.getJMenuItemConversionSettings());
            this.jMenuSettings.add(this.getJMenuItemSwapCrCb());
            this.jMenuSettings.add(this.getJMenuItemFixInvisibleFrames());
            this.jMenuSettings.add(this.getJMenuItemVerboseOutput());
        }
        return this.jMenuSettings;
    }

    private JMenuItem getJMenuItemConversionSettings() {
        if (this.jMenuItemConversionSettings == null) {
            this.jMenuItemConversionSettings = new JMenuItem();
            this.jMenuItemConversionSettings.setText("Conversion Settings");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemConversionSettings.setMnemonic('c');
            }
        }
        return this.jMenuItemConversionSettings;
    }

    void addConversionSettingsMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemConversionSettings.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemSwapCrCb() {
        if (this.jMenuItemSwapCrCb == null) {
            this.jMenuItemSwapCrCb = new JCheckBoxMenuItem();
            this.jMenuItemSwapCrCb.setText("Swap Cr/Cb");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemSwapCrCb.setMnemonic('s');
            }
            this.jMenuItemSwapCrCb.setSelected(false);
        }
        return this.jMenuItemSwapCrCb;
    }

    void addSwapCrCbMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemSwapCrCb.addActionListener(actionListener);
    }

    boolean isSwapCrCbSelected() {
        return this.jMenuItemSwapCrCb.isSelected();
    }

    private JMenuItem getJMenuItemFixInvisibleFrames() {
        if (this.jMenuItemFixInvisibleFrames == null) {
            this.jMenuItemFixInvisibleFrames = new JCheckBoxMenuItem();
            this.jMenuItemFixInvisibleFrames.setText("Fix invisible frames");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemFixInvisibleFrames.setMnemonic('f');
            }
            this.jMenuItemFixInvisibleFrames.setSelected(this.model.getFixZeroAlpha());
        }
        return this.jMenuItemFixInvisibleFrames;
    }

    void addFixInvisibleFramesMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemFixInvisibleFrames.addActionListener(actionListener);
    }

    boolean isFixInvisibleFramesSelected() {
        return this.jMenuItemFixInvisibleFrames.isSelected();
    }

    private JMenuItem getJMenuItemVerboseOutput() {
        if (this.jMenuItemVerboseOutput == null) {
            this.jMenuItemVerboseOutput = new JCheckBoxMenuItem();
            this.jMenuItemVerboseOutput.setText("Verbose Output");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemVerboseOutput.setMnemonic('v');
            }
            this.jMenuItemVerboseOutput.setSelected(this.model.isVerbose());
        }
        return this.jMenuItemVerboseOutput;
    }

    void addVerboseOutputMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemVerboseOutput.addActionListener(actionListener);
    }

    boolean isVerboseOutputSelected() {
        return this.jMenuItemVerboseOutput.isSelected();
    }

    private JMenu getJMenuHelp() {
        if (this.jMenuHelp == null) {
            this.jMenuHelp = new ActionMenu();
            this.jMenuHelp.setText("Help");
            if (!PlatformUtils.isMac()) {
                this.jMenuHelp.setMnemonic('h');
            }
            this.jMenuHelp.add(this.getJMenuItemHelp());
            JMenuItem aboutMenuItem = this.getJMenuItemAbout();
            if (!PlatformUtils.isMac()) {
                this.jMenuHelp.addSeparator();
                this.jMenuHelp.add(aboutMenuItem);
            }
        }
        return this.jMenuHelp;
    }

    private JMenuItem getJMenuItemHelp() {
        if (this.jMenuItemHelp == null) {
            this.jMenuItemHelp = new JMenuItem();
            this.jMenuItemHelp.setText("Get Help Online...");
            this.jMenuItemHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            if (!PlatformUtils.isMac()) {
                this.jMenuItemHelp.setMnemonic('h');
            }
        }
        return this.jMenuItemHelp;
    }

    void addHelpMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemHelp.addActionListener(actionListener);
    }

    private JMenuItem getJMenuItemAbout() {
        if (this.jMenuItemAbout == null) {
            this.jMenuItemAbout = new JMenuItem();
            this.jMenuItemAbout.setText("About");
            if (!PlatformUtils.isMac()) {
                this.jMenuItemAbout.setMnemonic('a');
            }
        }
        return this.jMenuItemAbout;
    }

    void addAboutMenuItemActionListener(ActionListener actionListener) {
        this.jMenuItemAbout.addActionListener(actionListener);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelTop = new GridBagConstraints();
            gridBagPanelTop.gridx = 0;
            gridBagPanelTop.gridy = 0;
            gridBagPanelTop.anchor = 17;
            gridBagPanelTop.fill = 2;
            gridBagPanelTop.insets = new Insets(0, 4, 0, 4);
            gridBagPanelTop.weightx = 0.0;
            gridBagPanelTop.ipadx = 0;
            gridBagPanelTop.weighty = 0.0;
            GridBagConstraints gridBagPanelInfoSource = new GridBagConstraints();
            gridBagPanelInfoSource.gridx = 0;
            gridBagPanelInfoSource.gridy = 1;
            gridBagPanelInfoSource.anchor = 18;
            gridBagPanelInfoSource.fill = 2;
            gridBagPanelInfoSource.insets = new Insets(4, 0, 0, 0);
            gridBagPanelInfoSource.weightx = 0.0;
            gridBagPanelInfoSource.weighty = 0.0;
            GridBagConstraints gridBagScrollPaneSource = new GridBagConstraints();
            gridBagScrollPaneSource.gridx = 0;
            gridBagScrollPaneSource.gridy = 2;
            gridBagScrollPaneSource.fill = 1;
            gridBagScrollPaneSource.anchor = 18;
            gridBagScrollPaneSource.weightx = 1.0;
            gridBagScrollPaneSource.weighty = 1.0;
            GridBagConstraints gridBagPanelInfoTarget = new GridBagConstraints();
            gridBagPanelInfoTarget.gridx = 0;
            gridBagPanelInfoTarget.gridy = 3;
            gridBagPanelInfoTarget.fill = 2;
            gridBagPanelInfoTarget.anchor = 17;
            gridBagPanelInfoTarget.gridwidth = 1;
            gridBagPanelInfoTarget.weighty = 0.0;
            gridBagPanelInfoTarget.weightx = 0.0;
            GridBagConstraints gridBagScrollPaneTarget = new GridBagConstraints();
            gridBagScrollPaneTarget.gridx = 0;
            gridBagScrollPaneTarget.gridy = 4;
            gridBagScrollPaneTarget.fill = 1;
            gridBagScrollPaneTarget.anchor = 18;
            gridBagScrollPaneTarget.weightx = 1.0;
            gridBagScrollPaneTarget.weighty = 1.0;
            GridBagConstraints gridBagPanelBottom = new GridBagConstraints();
            gridBagPanelBottom.gridx = 0;
            gridBagPanelBottom.gridy = 5;
            gridBagPanelBottom.anchor = 16;
            gridBagPanelBottom.fill = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setPreferredSize(new Dimension(800, 600));
            this.jContentPane.add((Component)this.getJPanelTop(), gridBagPanelTop);
            this.jContentPane.add((Component)this.getJPanelInfoSource(), gridBagPanelInfoSource);
            this.jContentPane.add((Component)this.getJScrollPaneSource(), gridBagScrollPaneSource);
            this.jContentPane.add((Component)this.getJPanelInfoTarget(), gridBagPanelInfoTarget);
            this.jContentPane.add((Component)this.getJScrollPaneTarget(), gridBagScrollPaneTarget);
            this.jContentPane.add((Component)this.getJPanelBottom(), gridBagPanelBottom);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelTop() {
        if (this.jPanelTop == null) {
            GridBagConstraints gridBagComboFilter = new GridBagConstraints();
            gridBagComboFilter.fill = 0;
            gridBagComboFilter.gridx = 7;
            gridBagComboFilter.gridy = 1;
            gridBagComboFilter.insets = new Insets(0, 4, 0, 4);
            gridBagComboFilter.anchor = 17;
            gridBagComboFilter.ipadx = 10;
            gridBagComboFilter.weightx = 5.0;
            GridBagConstraints gridBagLabelFilter = new GridBagConstraints();
            gridBagLabelFilter.gridx = 7;
            gridBagLabelFilter.anchor = 17;
            gridBagLabelFilter.insets = new Insets(0, 4, 0, 4);
            gridBagLabelFilter.gridy = 0;
            GridBagConstraints gridBagLabelPalette = new GridBagConstraints();
            gridBagLabelPalette.insets = new Insets(0, 4, 0, 4);
            gridBagLabelPalette.anchor = 17;
            gridBagLabelPalette.gridx = 6;
            gridBagLabelPalette.gridy = 0;
            GridBagConstraints gridBagComboPalette = new GridBagConstraints();
            gridBagComboPalette.fill = 0;
            gridBagComboPalette.gridx = 6;
            gridBagComboPalette.gridy = 1;
            gridBagComboPalette.anchor = 17;
            gridBagComboPalette.insets = new Insets(0, 4, 0, 4);
            gridBagComboPalette.ipadx = 10;
            gridBagComboPalette.weightx = 0.0;
            GridBagConstraints gridBagLabelSubNum = new GridBagConstraints();
            gridBagLabelSubNum.gridx = 0;
            gridBagLabelSubNum.gridy = 0;
            gridBagLabelSubNum.anchor = 17;
            gridBagLabelSubNum.insets = new Insets(0, 8, 0, 4);
            GridBagConstraints gridBagComboBoxSubNum = new GridBagConstraints();
            gridBagComboBoxSubNum.gridx = 0;
            gridBagComboBoxSubNum.gridy = 1;
            gridBagComboBoxSubNum.anchor = 17;
            gridBagComboBoxSubNum.ipadx = 10;
            gridBagComboBoxSubNum.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelAlphaThr = new GridBagConstraints();
            gridBagLabelAlphaThr.gridx = 1;
            gridBagLabelAlphaThr.gridy = 0;
            gridBagLabelAlphaThr.anchor = 17;
            gridBagLabelAlphaThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxAlphaThr = new GridBagConstraints();
            gridBagComboBoxAlphaThr.gridx = 1;
            gridBagComboBoxAlphaThr.gridy = 1;
            gridBagComboBoxAlphaThr.anchor = 17;
            gridBagComboBoxAlphaThr.ipadx = 10;
            gridBagComboBoxAlphaThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelMedLowThr = new GridBagConstraints();
            gridBagLabelMedLowThr.gridx = 2;
            gridBagLabelMedLowThr.gridy = 0;
            gridBagLabelMedLowThr.anchor = 17;
            gridBagLabelMedLowThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxMedLowThr = new GridBagConstraints();
            gridBagComboBoxMedLowThr.gridx = 2;
            gridBagComboBoxMedLowThr.gridy = 1;
            gridBagComboBoxMedLowThr.anchor = 17;
            gridBagComboBoxMedLowThr.ipadx = 10;
            gridBagComboBoxMedLowThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelHiMedThr = new GridBagConstraints();
            gridBagLabelHiMedThr.gridx = 3;
            gridBagLabelHiMedThr.gridy = 0;
            gridBagLabelHiMedThr.anchor = 17;
            gridBagLabelHiMedThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagJComboBoxHiMedThr = new GridBagConstraints();
            gridBagJComboBoxHiMedThr.gridx = 3;
            gridBagJComboBoxHiMedThr.gridy = 1;
            gridBagJComboBoxHiMedThr.anchor = 17;
            gridBagJComboBoxHiMedThr.ipadx = 10;
            gridBagJComboBoxHiMedThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelOutFormat = new GridBagConstraints();
            gridBagLabelOutFormat.gridx = 5;
            gridBagLabelOutFormat.gridy = 0;
            gridBagLabelOutFormat.anchor = 17;
            gridBagLabelOutFormat.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxOutFormat = new GridBagConstraints();
            gridBagComboBoxOutFormat.gridx = 5;
            gridBagComboBoxOutFormat.gridy = 1;
            gridBagComboBoxOutFormat.anchor = 17;
            gridBagComboBoxOutFormat.weightx = 0.0;
            gridBagComboBoxOutFormat.fill = 0;
            gridBagComboBoxOutFormat.ipadx = 10;
            gridBagComboBoxOutFormat.insets = new Insets(0, 4, 0, 4);
            JLabel jLabelSubNum = new JLabel();
            jLabelSubNum.setText("Subtitle");
            jLabelSubNum.setPreferredSize(new Dimension(100, 20));
            JLabel jLabelAlphaThr = new JLabel();
            jLabelAlphaThr.setText("Alpha Threshold");
            jLabelAlphaThr.setPreferredSize(new Dimension(100, 20));
            JLabel jLabelMedLowThr = new JLabel();
            jLabelMedLowThr.setText("Med/Low Threshold");
            jLabelMedLowThr.setPreferredSize(new Dimension(100, 20));
            JLabel jLabelHiMedThr = new JLabel();
            jLabelHiMedThr.setText("Hi/Med Threshold");
            jLabelHiMedThr.setPreferredSize(new Dimension(100, 20));
            JLabel jLabelOutFormat = new JLabel();
            jLabelOutFormat.setText("Output Format");
            jLabelOutFormat.setPreferredSize(new Dimension(120, 20));
            JLabel jLabelPalette = new JLabel();
            jLabelPalette.setPreferredSize(new Dimension(120, 20));
            jLabelPalette.setText("Palette");
            JLabel jLabelFilter = new JLabel();
            jLabelFilter.setPreferredSize(new Dimension(120, 20));
            jLabelFilter.setText("Filter");
            this.jPanelTop = new JPanel();
            this.jPanelTop.setLayout(new GridBagLayout());
            this.jPanelTop.setPreferredSize(new Dimension(600, 40));
            this.jPanelTop.setMinimumSize(new Dimension(600, 40));
            this.jPanelTop.setMaximumSize(new Dimension(600, 40));
            this.jPanelTop.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jPanelTop.add((Component)jLabelSubNum, gridBagLabelSubNum);
            this.jPanelTop.add((Component)this.getJComboBoxSubNum(), gridBagComboBoxSubNum);
            this.jPanelTop.add((Component)jLabelAlphaThr, gridBagLabelAlphaThr);
            this.jPanelTop.add((Component)this.getJComboBoxAlphaThreshold(), gridBagComboBoxAlphaThr);
            this.jPanelTop.add((Component)jLabelMedLowThr, gridBagLabelMedLowThr);
            this.jPanelTop.add((Component)this.getJComboBoxMedLowThreshold(), gridBagComboBoxMedLowThr);
            this.jPanelTop.add((Component)jLabelHiMedThr, gridBagLabelHiMedThr);
            this.jPanelTop.add((Component)this.getJComboBoxHiMedThreshold(), gridBagJComboBoxHiMedThr);
            this.jPanelTop.add((Component)jLabelOutFormat, gridBagLabelOutFormat);
            this.jPanelTop.add((Component)this.getJComboBoxOutputFormat(), gridBagComboBoxOutFormat);
            this.jPanelTop.add((Component)this.getJComboBoxPalette(), gridBagComboPalette);
            this.jPanelTop.add((Component)jLabelPalette, gridBagLabelPalette);
            this.jPanelTop.add((Component)jLabelFilter, gridBagLabelFilter);
            this.jPanelTop.add((Component)this.getJComboBoxFilter(), gridBagComboFilter);
        }
        return this.jPanelTop;
    }

    private JPanel getJPanelInfoSource() {
        if (this.jPanelInfoSource == null) {
            GridBagConstraints gridBagLabelInfoSup = new GridBagConstraints();
            gridBagLabelInfoSup.anchor = 17;
            gridBagLabelInfoSup.insets = new Insets(4, 8, 2, 8);
            gridBagLabelInfoSup.gridwidth = 1;
            gridBagLabelInfoSup.gridx = 0;
            gridBagLabelInfoSup.gridy = 0;
            gridBagLabelInfoSup.weightx = 1.0;
            gridBagLabelInfoSup.fill = 2;
            this.jLabelInfoSource = new JLabel();
            this.jLabelInfoSource.setHorizontalAlignment(2);
            this.jLabelInfoSource.setHorizontalTextPosition(2);
            this.jPanelInfoSource = new JPanel();
            this.jPanelInfoSource.setLayout(new GridBagLayout());
            this.jPanelInfoSource.setPreferredSize(new Dimension(600, 20));
            this.jPanelInfoSource.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.lightGray));
            this.jPanelInfoSource.add((Component)this.jLabelInfoSource, gridBagLabelInfoSup);
        }
        return this.jPanelInfoSource;
    }

    private JScrollPane getJScrollPaneSource() {
        if (this.jScrollPaneSource == null) {
            this.jScrollPaneSource = new JScrollPane();
            this.jScrollPaneSource.setHorizontalScrollBarPolicy(30);
            this.jScrollPaneSource.setVerticalScrollBarPolicy(20);
            this.jScrollPaneSource.setViewportView(this.getJPanelSource());
        }
        return this.jScrollPaneSource;
    }

    private JPanel getJPanelSource() {
        if (this.jPanelSource == null) {
            this.jPanelSource = new ZoomableGraphicsPanel();
        }
        return this.jPanelSource;
    }

    private JPanel getJPanelInfoTarget() {
        if (this.jPanelInfoTarget == null) {
            GridBagConstraints gridBagLabelSubInfo = new GridBagConstraints();
            gridBagLabelSubInfo.gridx = 0;
            gridBagLabelSubInfo.weightx = 1.0;
            gridBagLabelSubInfo.insets = new Insets(4, 8, 2, 8);
            gridBagLabelSubInfo.fill = 2;
            gridBagLabelSubInfo.anchor = 17;
            gridBagLabelSubInfo.gridy = 0;
            this.jLabelInfoTarget = new JLabel();
            this.jLabelInfoTarget.setHorizontalTextPosition(2);
            this.jLabelInfoTarget.setHorizontalAlignment(2);
            this.jPanelInfoTarget = new JPanel();
            this.jPanelInfoTarget.setLayout(new GridBagLayout());
            this.jPanelInfoTarget.setPreferredSize(new Dimension(300, 20));
            this.jPanelInfoTarget.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jPanelInfoTarget.add((Component)this.jLabelInfoTarget, gridBagLabelSubInfo);
        }
        return this.jPanelInfoTarget;
    }

    private JScrollPane getJScrollPaneTarget() {
        if (this.jScrollPaneTarget == null) {
            this.jScrollPaneTarget = new JScrollPane();
            this.jScrollPaneTarget.setViewportView(this.getJPanelTarget());
        }
        return this.jScrollPaneTarget;
    }

    private JPanel getJPanelTarget() {
        if (this.jPanelTarget == null) {
            this.jPanelTarget = new ZoomableGraphicsPanel();
        }
        return this.jPanelTarget;
    }

    private JPanel getJPanelBottom() {
        if (this.jPanelBottom == null) {
            GridBagConstraints gridBagLayout = new GridBagConstraints();
            gridBagLayout.anchor = 12;
            gridBagLayout.gridx = 1;
            gridBagLayout.gridy = 0;
            gridBagLayout.weightx = 1.0;
            gridBagLayout.weighty = 1.0;
            gridBagLayout.fill = 1;
            GridBagConstraints gridBagConsole = new GridBagConstraints();
            gridBagConsole.fill = 1;
            gridBagConsole.gridy = 0;
            gridBagConsole.weightx = 2.0;
            gridBagConsole.weighty = 2.0;
            gridBagConsole.gridx = 0;
            this.jPanelBottom = new JPanel();
            this.jPanelBottom.setLayout(new GridBagLayout());
            this.jPanelBottom.setPreferredSize(new Dimension(300, 150));
            this.jPanelBottom.setMinimumSize(new Dimension(300, 150));
            this.jPanelBottom.add((Component)this.getJPanelLayout(), gridBagLayout);
            this.jPanelBottom.add((Component)this.getJScrollPaneConsole(), gridBagConsole);
        }
        return this.jPanelBottom;
    }

    private JPanel getJPanelLayout() {
        if (this.jLayoutPane == null) {
            this.jLayoutPane = new EditPane(true);
            this.jLayoutPane.setLayout(new GridBagLayout());
            this.jLayoutPane.setPreferredSize(new Dimension(180, 100));
            this.jLayoutPane.setMaximumSize(new Dimension(180, 100));
        }
        return this.jLayoutPane;
    }

    void addLayoutPaneMouseListener(MouseListener mouseListener) {
        this.jLayoutPane.addMouseListener(mouseListener);
    }

    void setLayoutPaneAspectRatio(double trgRatio) {
        this.jLayoutPane.setAspectRatio(trgRatio);
    }

    void setLayoutPaneCropOffsetY(int cropOfsY) {
        this.jLayoutPane.setCropOffsetY(cropOfsY);
    }

    void repaintLayoutPane() {
        this.jLayoutPane.repaint();
    }

    private JScrollPane getJScrollPaneConsole() {
        if (this.jScrollPaneConsole == null) {
            this.jScrollPaneConsole = new JScrollPane();
            this.jScrollPaneConsole.setViewportView(this.getConsole());
        }
        return this.jScrollPaneConsole;
    }

    private JTextArea getConsole() {
        if (this.console == null) {
            this.console = new JTextArea();
            this.console.setEditable(false);
            this.console.setFont(new Font("Monospaced", 0, 12));
        }
        return this.console;
    }

    void addConsoleMouseListener(MouseListener mouseListener) {
        this.console.addMouseListener(mouseListener);
    }

    public void printToConsole(String message) {
        Document doc = this.console.getDocument();
        int length = doc.getLength();
        try {
            doc.insertString(length, message, null);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    public void flushConsole() {
        this.console.setCaretPosition(this.console.getDocument().getLength());
    }

    String getConsoleSelectedText() {
        return this.console.getSelectedText();
    }

    void setConsoleText(String text) {
        this.console.setText(text);
    }

    private JComboBox getJComboBoxSubNum() {
        if (this.jComboBoxSubNum == null) {
            this.jComboBoxSubNum = new JComboBox();
            this.jComboBoxSubNum.setEnabled(false);
            this.jComboBoxSubNum.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxSubNum.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxSubNum.setToolTipText("Set subtitle number");
            this.jComboBoxSubNum.setEditable(true);
            this.jTextSubNum = (JTextField)this.jComboBoxSubNum.getEditor().getEditorComponent();
        }
        return this.jComboBoxSubNum;
    }

    void addSubNumComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxSubNum.addActionListener(actionListener);
    }

    void addSubNumComboBoxDocumentListener(DocumentListener documentListener) {
        this.jTextSubNum.getDocument().addDocumentListener(documentListener);
    }

    void setSubNumComboBoxBackground(Color color) {
        this.jTextSubNum.setBackground(color);
    }

    String getSubNumComboBoxText() {
        return this.jTextSubNum.getText();
    }

    void initSubNumComboBox(int subCount) {
        this.jComboBoxSubNum.removeAllItems();
        for (int i = 1; i <= subCount; ++i) {
            this.jComboBoxSubNum.addItem(i);
        }
        this.jComboBoxSubNum.setSelectedIndex(0);
    }

    Object getSubNumComboBoxSelectedItem() {
        return this.jComboBoxSubNum.getSelectedItem();
    }

    void setSubNumComboBoxSelectedIndex(int index) {
        this.jComboBoxSubNum.setSelectedIndex(index);
    }

    private JComboBox getJComboBoxAlphaThreshold() {
        if (this.jComboBoxAlphaThreshold == null) {
            this.jComboBoxAlphaThreshold = new JComboBox();
            this.jComboBoxAlphaThreshold.setEnabled(false);
            this.jComboBoxAlphaThreshold.setEditable(true);
            this.jComboBoxAlphaThreshold.setToolTipText("Set alpha threshold");
            this.jComboBoxAlphaThreshold.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxAlphaThreshold.setMinimumSize(new Dimension(80, 20));
            for (int i = 0; i < 256; ++i) {
                this.jComboBoxAlphaThreshold.addItem(i);
            }
            this.jTextAlphaThreshold = (JTextField)this.jComboBoxAlphaThreshold.getEditor().getEditorComponent();
        }
        return this.jComboBoxAlphaThreshold;
    }

    void addAlphaThresholdComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxAlphaThreshold.addActionListener(actionListener);
    }

    void addAlphaThresholdComboBoxDocumentListener(DocumentListener documentListener) {
        this.jTextAlphaThreshold.getDocument().addDocumentListener(documentListener);
    }

    void initAlphaThresholdComboBoxSelectedIndices() {
        this.jComboBoxAlphaThreshold.setSelectedIndex(this.model.getAlphaThreshold());
        this.jComboBoxHiMedThreshold.setSelectedIndex(this.model.getLuminanceThreshold()[0]);
        this.jComboBoxMedLowThreshold.setSelectedIndex(this.model.getLuminanceThreshold()[1]);
    }

    Object getAlphaThresholdComboBoxSelectedItem() {
        return this.jComboBoxAlphaThreshold.getSelectedItem();
    }

    String getAlphaThresholdComboBoxText() {
        return this.jTextAlphaThreshold.getText();
    }

    void setAlphaThresholdComboBoxSelectedIndex(int index) {
        this.jComboBoxAlphaThreshold.setSelectedIndex(index);
    }

    void setAlphaThresholdComboBoxBackground(Color color) {
        this.jTextAlphaThreshold.setBackground(color);
    }

    private JComboBox getJComboBoxHiMedThreshold() {
        if (this.jComboBoxHiMedThreshold == null) {
            this.jComboBoxHiMedThreshold = new JComboBox();
            this.jComboBoxHiMedThreshold.setEditable(true);
            this.jComboBoxHiMedThreshold.setEnabled(false);
            this.jComboBoxHiMedThreshold.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxHiMedThreshold.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxHiMedThreshold.setToolTipText("Set medium/high luminance threshold");
            for (int i = 0; i < 256; ++i) {
                this.jComboBoxHiMedThreshold.addItem(i);
            }
            this.jTextHiMedThreshold = (JTextField)this.jComboBoxHiMedThreshold.getEditor().getEditorComponent();
        }
        return this.jComboBoxHiMedThreshold;
    }

    void addHiMedThresholdComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxHiMedThreshold.addActionListener(actionListener);
    }

    void addHiMedThresholdComboBoxDocumentListener(DocumentListener documentListener) {
        this.jTextHiMedThreshold.getDocument().addDocumentListener(documentListener);
    }

    void setHiMedThresholdComboBoxBackground(Color color) {
        this.jTextHiMedThreshold.setBackground(color);
    }

    String getHiMedThresholdComboBoxText() {
        return this.jTextHiMedThreshold.getText();
    }

    Object getHiMedThresholdComboBoxSelectedItem() {
        return this.jComboBoxHiMedThreshold.getSelectedItem();
    }

    void setHiMedThresholdComboBoxSelectedIndex(int index) {
        this.jComboBoxHiMedThreshold.setSelectedIndex(index);
    }

    private JComboBox getJComboBoxMedLowThreshold() {
        if (this.jComboBoxMedLowThreshold == null) {
            this.jComboBoxMedLowThreshold = new JComboBox();
            this.jComboBoxMedLowThreshold.setEditable(true);
            this.jComboBoxMedLowThreshold.setEnabled(false);
            this.jComboBoxMedLowThreshold.setToolTipText("Set low/medium luminance threshold");
            this.jComboBoxMedLowThreshold.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxMedLowThreshold.setMinimumSize(new Dimension(80, 20));
            for (int i = 0; i < 256; ++i) {
                this.jComboBoxMedLowThreshold.addItem(i);
            }
            this.jTextMedLowThreshold = (JTextField)this.jComboBoxMedLowThreshold.getEditor().getEditorComponent();
        }
        return this.jComboBoxMedLowThreshold;
    }

    void addMedLowThresholdComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxMedLowThreshold.addActionListener(actionListener);
    }

    void addMedLowThresholdComboBoxDocumentListener(DocumentListener documentListener) {
        this.jTextMedLowThreshold.getDocument().addDocumentListener(documentListener);
    }

    void setMedLowThresholdComboBoxBackground(Color color) {
        this.jTextMedLowThreshold.setBackground(color);
    }

    String getMedLowThresholdComboBoxText() {
        return this.jTextMedLowThreshold.getText();
    }

    Object getMedLowThresholdComboBoxSelectedItem() {
        return this.jComboBoxMedLowThreshold.getSelectedItem();
    }

    void setMedLowThresholdComboBoxSelectedIndex(int index) {
        this.jComboBoxMedLowThreshold.setSelectedIndex(index);
    }

    private JComboBox getJComboBoxOutputFormat() {
        if (this.jComboBoxOutputFormat == null) {
            this.jComboBoxOutputFormat = new JComboBox();
            this.jComboBoxOutputFormat.setEnabled(false);
            this.jComboBoxOutputFormat.setToolTipText("Select export format");
            this.jComboBoxOutputFormat.setPreferredSize(new Dimension(120, 20));
            for (OutputMode mode : OutputMode.values()) {
                this.jComboBoxOutputFormat.addItem(mode.toString());
            }
            this.jComboBoxOutputFormat.setSelectedIndex(this.model.getOutputMode().ordinal());
        }
        return this.jComboBoxOutputFormat;
    }

    void addOutputFormatComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxOutputFormat.addActionListener(actionListener);
    }

    int getOutputFormatComboBoxSelectedIndex() {
        return this.jComboBoxOutputFormat.getSelectedIndex();
    }

    void setComboBoxOutFormatEnabled(boolean enable) {
        this.jComboBoxOutputFormat.setEnabled(enable);
    }

    private JComboBox getJComboBoxPalette() {
        if (this.jComboBoxPalette == null) {
            this.jComboBoxPalette = new JComboBox();
            this.jComboBoxPalette.setEnabled(false);
            this.jComboBoxPalette.setToolTipText("Select palette mode");
            this.jComboBoxPalette.setPreferredSize(new Dimension(120, 20));
            for (PaletteMode mode : PaletteMode.values()) {
                this.jComboBoxPalette.addItem(mode.toString());
            }
            this.jComboBoxPalette.setSelectedIndex(this.model.getPaletteMode().ordinal());
        }
        return this.jComboBoxPalette;
    }

    void addPaletteComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxPalette.addActionListener(actionListener);
    }

    int getPaletteComboBoxSelectedIndex() {
        return this.jComboBoxPalette.getSelectedIndex();
    }

    private JComboBox getJComboBoxFilter() {
        if (this.jComboBoxFilter == null) {
            this.jComboBoxFilter = new JComboBox();
            this.jComboBoxFilter.setEnabled(false);
            this.jComboBoxFilter.setToolTipText("Select filter for scaling");
            this.jComboBoxFilter.setPreferredSize(new Dimension(120, 20));
            for (ScalingFilter filter : ScalingFilter.values()) {
                this.jComboBoxFilter.addItem(filter.toString());
            }
            this.jComboBoxFilter.setSelectedIndex(this.model.getScalingFilter().ordinal());
        }
        return this.jComboBoxFilter;
    }

    void addFilterComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxFilter.addActionListener(actionListener);
    }

    int getFilterComboBoxSelectedIndex() {
        return this.jComboBoxFilter.getSelectedIndex();
    }

    void enableCoreComponents(boolean state) {
        this.jMenuItemLoad.setEnabled(state);
        this.jMenuRecentFiles.setEnabled(state && this.model.getRecentFiles().size() > 0);
        this.jMenuItemSave.setEnabled(state && Core.getNumFrames() > 0);
        this.jMenuItemClose.setEnabled(state);
        this.jMenuItemEditFrame.setEnabled(state);
        this.jMenuItemMoveAll.setEnabled(state);
        this.jComboBoxSubNum.setEnabled(state);
        this.jComboBoxOutputFormat.setEnabled(state);
        this.jComboBoxFilter.setEnabled(state);
    }

    void enableVobSubMenuCombo() {
        boolean b = (this.model.getOutputMode() == OutputMode.VOBSUB || this.model.getOutputMode() == OutputMode.SUPIFO) && (Core.getInputMode() != InputMode.VOBSUB && Core.getInputMode() != InputMode.SUPIFO || this.model.getPaletteMode() != PaletteMode.KEEP_EXISTING);
        this.jComboBoxAlphaThreshold.setEnabled(b);
        this.jComboBoxHiMedThreshold.setEnabled(b);
        this.jComboBoxMedLowThreshold.setEnabled(b);
        b = Core.getInputMode() == InputMode.VOBSUB || Core.getInputMode() == InputMode.SUPIFO;
        this.jMenuItemEditImportedDvdPalette.setEnabled(b);
        this.jMenuItemEditDvdFramePalette.setEnabled(b);
    }

    void enableVobsubBits(boolean b) {
        boolean ready = Core.isReady();
        Core.setReady(false);
        this.jComboBoxPalette.removeAllItems();
        for (PaletteMode m : PaletteMode.values()) {
            if (b && m == PaletteMode.CREATE_DITHERED) continue;
            this.jComboBoxPalette.addItem(m.toString());
        }
        if (!b || this.model.getPaletteMode() != PaletteMode.CREATE_DITHERED) {
            this.jComboBoxPalette.setSelectedIndex(this.model.getPaletteMode().ordinal());
        } else {
            this.jComboBoxPalette.setSelectedIndex(PaletteMode.CREATE_NEW.ordinal());
        }
        if (!b || Core.getInputMode() == InputMode.VOBSUB || Core.getInputMode() == InputMode.SUPIFO) {
            this.jComboBoxPalette.setEnabled(true);
        } else {
            this.jComboBoxPalette.setEnabled(false);
        }
        this.enableVobSubMenuCombo();
        Core.setReady(ready);
    }

    void closeSub() {
        this.jComboBoxSubNum.removeAllItems();
        this.enableCoreComponents(false);
        this.jMenuItemLoad.setEnabled(true);
        this.updateRecentFilesMenu();
        this.jComboBoxPalette.setEnabled(false);
        this.jComboBoxAlphaThreshold.setEnabled(false);
        this.jComboBoxHiMedThreshold.setEnabled(false);
        this.jComboBoxMedLowThreshold.setEnabled(false);
        this.jMenuItemEditImportedDvdPalette.setEnabled(false);
        this.jMenuItemEditDvdFramePalette.setEnabled(false);
        this.jLayoutPane.setImage(null, 1, 1);
        this.jLayoutPane.repaint();
        this.jPanelTarget.setImage(null);
        this.jPanelSource.setImage(null);
        this.jLabelInfoTarget.setText("");
        this.jLabelInfoSource.setText("");
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJPopupMenuItemCopy());
            this.jPopupMenu.add(this.getJPopupMenuItemClear());
        }
        return this.jPopupMenu;
    }

    void showPopupMenu(int x, int y) {
        this.jPopupMenu.show(this.console, x, y);
    }

    private JMenuItem getJPopupMenuItemCopy() {
        if (this.jPopupMenuItemCopy == null) {
            this.jPopupMenuItemCopy = new JMenuItem();
            this.jPopupMenuItemCopy.setText("Copy");
        }
        return this.jPopupMenuItemCopy;
    }

    void addCopyPopupMenuItemActionListener(ActionListener actionListener) {
        this.jPopupMenuItemCopy.addActionListener(actionListener);
    }

    void setCopyPopupMenuItemEnabled(boolean enable) {
        this.jPopupMenuItemCopy.setEnabled(enable);
    }

    private JMenuItem getJPopupMenuItemClear() {
        if (this.jPopupMenuItemClear == null) {
            this.jPopupMenuItemClear = new JMenuItem();
            this.jPopupMenuItemClear.setText("Clear");
        }
        return this.jPopupMenuItemClear;
    }

    void addClearPopupMenuItemActionListener(ActionListener actionListener) {
        this.jPopupMenuItemClear.addActionListener(actionListener);
    }

    void addTransferHandler(TransferHandler transferHandler) {
        this.setTransferHandler(transferHandler);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    void refreshSrcFrame(int index) {
        BufferedImage img = Core.getSrcImage();
        this.jPanelSource.setImage(img);
        this.jLabelInfoSource.setText(Core.getSrcInfoStr(index));
    }

    void refreshTrgFrame(int index) {
        this.jLayoutPane.setScreenDimension(Core.getTrgWidth(index), Core.getTrgHeight(index));
        this.jLayoutPane.setSubtitleOffsets(Core.getTrgOfsX(index), Core.getTrgOfsY(index));
        this.jLayoutPane.setCropOffsetY(this.model.getCropOffsetY());
        this.jLayoutPane.setImage(Core.getTrgImage(), Core.getTrgImgWidth(index), Core.getTrgImgHeight(index));
        this.jLayoutPane.setExcluded(Core.getTrgExcluded(index));
        this.jPanelTarget.setImage(Core.getTrgImage());
        this.jLabelInfoTarget.setText(Core.getTrgInfoStr(index));
        this.jLayoutPane.repaint();
    }

    void exit(int code) {
        if (code == 0 && this.getExtendedState() != 6) {
            this.model.setMainWindowSize(this.getSize());
            this.model.setMainWindowLocation(this.getLocation());
        }
        Core.exit();
        System.exit(code);
    }

    void warningDialog() {
        int w = logger.getWarningCount();
        logger.resetWarningCounter();
        int e = logger.getErrorCount();
        logger.resetErrorCounter();
        if (w + e > 0) {
            String s = "";
            if (w > 0) {
                s = w == 1 ? s + w + " warning" : s + w + " warnings";
            }
            if (w > 0 && e > 0) {
                s = s + " and ";
            }
            if (e > 0) {
                s = e == 1 ? e + " error" : e + " errors";
            }
            s = w + e < 3 ? "There was " + s : "There were " + s;
            JOptionPane.showMessageDialog(this, s + "\nCheck the log for details", "Warning!", 2);
        }
    }

    public void error(String message) {
        logger.error(message);
        JOptionPane.showMessageDialog(this, message, "Error!", 2);
    }
}

