/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.move;

import bdsup2sub.core.Logger;
import bdsup2sub.gui.move.MoveDialogModel;
import bdsup2sub.gui.support.EditPane;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

class MoveDialogView
extends JDialog {
    private static final Logger logger = Logger.getInstance();
    private static final Dimension DIMENSION_LABEL = new Dimension(80, 14);
    private static final Dimension DIMENSION_TEXTFIELD = new Dimension(40, 20);
    private JPanel jContentPane;
    private JPanel jPanelUp;
    private JPanel jPanelLayout;
    private JPanel jPanelOffsets;
    private JPanel jPanelMove;
    private JPanel jPanelButtons;
    private JLabel jLabelInfo;
    private JButton jButtonPrev;
    private JButton jButtonNext;
    private EditPane jPanelPreview;
    private JLabel jLabelOffsetY;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JTextField jTextFieldRatio;
    private JTextField jTextFieldOffsetY;
    private JButton jButton21_9;
    private JButton jButton240_1;
    private JButton jButton235_1;
    private JRadioButton jRadioButtonKeepY;
    private JRadioButton jRadioButtonInside;
    private JRadioButton jRadioButtonOutside;
    private JPanel jPanelCrop;
    private JTextField jTextFieldCropOfsY;
    private JButton jButtonCropBars;
    private JRadioButton jRadioButtonKeepX;
    private JRadioButton jRadioButtonLeft;
    private JRadioButton jRadioButtonRight;
    private JTextField jTextFieldOffsetX;
    private JRadioButton jRadioButtonCenter;
    private final MoveDialogModel model;

    public MoveDialogView(MoveDialogModel model, Frame owner) {
        super(owner, "Move all captions", true);
        this.model = model;
        this.initialize();
        GuiUtils.centerRelativeToOwner(this);
        this.setResizable(false);
        switch (model.getMoveModeY()) {
            case KEEP_POSITION: {
                this.jRadioButtonKeepY.setSelected(true);
                break;
            }
            case MOVE_INSIDE_BOUNDS: {
                this.jRadioButtonInside.setSelected(true);
                break;
            }
            case MOVE_OUTSIDE_BOUNDS: {
                this.jRadioButtonOutside.setSelected(true);
            }
        }
        switch (model.getMoveModeX()) {
            case KEEP_POSITION: {
                this.jRadioButtonKeepX.setSelected(true);
                break;
            }
            case LEFT: {
                this.jRadioButtonLeft.setSelected(true);
                break;
            }
            case RIGHT: {
                this.jRadioButtonRight.setSelected(true);
                break;
            }
            case CENTER: {
                this.jRadioButtonCenter.setSelected(true);
            }
        }
        ButtonGroup radioButtonsY = new ButtonGroup();
        radioButtonsY.add(this.jRadioButtonKeepY);
        radioButtonsY.add(this.jRadioButtonInside);
        radioButtonsY.add(this.jRadioButtonOutside);
        ButtonGroup radioButtonsX = new ButtonGroup();
        radioButtonsX.add(this.jRadioButtonKeepX);
        radioButtonsX.add(this.jRadioButtonLeft);
        radioButtonsX.add(this.jRadioButtonRight);
        radioButtonsX.add(this.jRadioButtonCenter);
        this.jTextFieldRatio.setText(ToolBox.formatDouble(model.getTargetScreenAspectRatio()));
        this.jTextFieldOffsetX.setText(String.valueOf(model.getOffsetX()));
        this.jTextFieldOffsetY.setText(String.valueOf(model.getOffsetY()));
        this.jTextFieldCropOfsY.setText(ToolBox.formatDouble(model.getTargetScreenAspectRatio()));
        this.jTextFieldCropOfsY.setText(String.valueOf(model.getCropOfsY()));
    }

    private void initialize() {
        this.setSize(392, 546);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelCrop = new GridBagConstraints();
            gridBagPanelCrop.gridx = 0;
            gridBagPanelCrop.weightx = 1.0;
            gridBagPanelCrop.weighty = 1.0;
            gridBagPanelCrop.anchor = 18;
            gridBagPanelCrop.fill = 2;
            gridBagPanelCrop.gridy = 4;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 0.0;
            gridBagPanelButtons.fill = 2;
            gridBagPanelButtons.gridy = 5;
            GridBagConstraints gridBagPanelRadio = new GridBagConstraints();
            gridBagPanelRadio.gridx = 0;
            gridBagPanelRadio.anchor = 18;
            gridBagPanelRadio.weightx = 1.0;
            gridBagPanelRadio.weighty = 1.0;
            gridBagPanelRadio.fill = 2;
            gridBagPanelRadio.gridy = 2;
            GridBagConstraints gridBagPanelOffsets = new GridBagConstraints();
            gridBagPanelOffsets.gridx = 0;
            gridBagPanelOffsets.anchor = 18;
            gridBagPanelOffsets.weightx = 1.0;
            gridBagPanelOffsets.weighty = 1.0;
            gridBagPanelOffsets.fill = 2;
            gridBagPanelOffsets.gridy = 3;
            GridBagConstraints gridBagPanelLayout = new GridBagConstraints();
            gridBagPanelLayout.gridx = 0;
            gridBagPanelLayout.anchor = 18;
            gridBagPanelLayout.weightx = 1.0;
            gridBagPanelLayout.weighty = 1.0;
            gridBagPanelLayout.fill = 2;
            gridBagPanelLayout.gridy = 1;
            GridBagConstraints gridBagPanelUp = new GridBagConstraints();
            gridBagPanelUp.gridx = 0;
            gridBagPanelUp.anchor = 18;
            gridBagPanelUp.weightx = 1.0;
            gridBagPanelUp.weighty = 1.0;
            gridBagPanelUp.fill = 2;
            gridBagPanelUp.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelUp(), gridBagPanelUp);
            this.jContentPane.add((Component)this.getJPanelLayout(), gridBagPanelLayout);
            this.jContentPane.add((Component)this.getJPanelOffsets(), gridBagPanelOffsets);
            this.jContentPane.add((Component)this.getJPanelMove(), gridBagPanelRadio);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
            this.jContentPane.add((Component)this.getJPanelCrop(), gridBagPanelCrop);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelUp() {
        if (this.jPanelUp == null) {
            GridBagConstraints gridBagButtonNext = new GridBagConstraints();
            gridBagButtonNext.gridx = 2;
            gridBagButtonNext.anchor = 18;
            gridBagButtonNext.insets = new Insets(2, 4, 2, 9);
            gridBagButtonNext.gridy = 0;
            GridBagConstraints gridBagButtonPrev = new GridBagConstraints();
            gridBagButtonPrev.gridx = 1;
            gridBagButtonPrev.anchor = 18;
            gridBagButtonPrev.insets = new Insets(2, 4, 2, 4);
            gridBagButtonPrev.gridy = 0;
            GridBagConstraints gridBagInfo = new GridBagConstraints();
            gridBagInfo.weightx = 1.0;
            gridBagInfo.anchor = 17;
            gridBagInfo.insets = new Insets(4, 6, 0, 4);
            gridBagInfo.weighty = 1.0;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setText("Info");
            this.jPanelUp = new JPanel();
            this.jPanelUp.setPreferredSize(new Dimension(200, 20));
            this.jPanelUp.setLayout(new GridBagLayout());
            this.jPanelUp.add((Component)this.jLabelInfo, gridBagInfo);
            this.jPanelUp.add((Component)this.getJButtonPrev(), gridBagButtonPrev);
            this.jPanelUp.add((Component)this.getJButtonNext(), gridBagButtonNext);
        }
        return this.jPanelUp;
    }

    private JPanel getJPanelLayout() {
        if (this.jPanelLayout == null) {
            GridBagConstraints gridBagPanelPreview = new GridBagConstraints();
            gridBagPanelPreview.gridx = 0;
            gridBagPanelPreview.anchor = 18;
            gridBagPanelPreview.weighty = 0.0;
            gridBagPanelPreview.gridy = 0;
            gridBagPanelPreview.insets = new Insets(0, 4, 0, 0);
            this.jPanelLayout = new JPanel();
            this.jPanelLayout.setLayout(new GridBagLayout());
            this.jPanelLayout.add((Component)this.getJPanelPreview(), gridBagPanelPreview);
        }
        return this.jPanelLayout;
    }

    private JPanel getJPanelOffsets() {
        if (this.jPanelOffsets == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 4;
            GridBagConstraints gridBagBtn235_1 = new GridBagConstraints();
            gridBagBtn235_1.gridx = 5;
            gridBagBtn235_1.insets = new Insets(0, 0, 0, 6);
            gridBagBtn235_1.anchor = 13;
            gridBagBtn235_1.gridy = 1;
            GridBagConstraints gridBagBtn240_1 = new GridBagConstraints();
            gridBagBtn240_1.gridx = 6;
            gridBagBtn240_1.insets = new Insets(0, 0, 0, 0);
            gridBagBtn240_1.anchor = 13;
            gridBagBtn240_1.gridy = 1;
            GridBagConstraints gridBagLabelRatio1 = new GridBagConstraints();
            gridBagLabelRatio1.gridx = 2;
            gridBagLabelRatio1.weightx = 20.0;
            gridBagLabelRatio1.anchor = 17;
            gridBagLabelRatio1.insets = new Insets(0, 0, 0, 0);
            gridBagLabelRatio1.gridy = 1;
            JLabel jLabelRatio1 = new JLabel();
            jLabelRatio1.setText(": 1");
            jLabelRatio1.setHorizontalAlignment(2);
            jLabelRatio1.setHorizontalTextPosition(2);
            GridBagConstraints gridBagButtonBtn21_9 = new GridBagConstraints();
            gridBagButtonBtn21_9.gridx = 4;
            gridBagButtonBtn21_9.anchor = 13;
            gridBagButtonBtn21_9.insets = new Insets(0, 0, 0, 6);
            gridBagButtonBtn21_9.weightx = 0.0;
            gridBagButtonBtn21_9.gridy = 1;
            GridBagConstraints gridBagTextRatio = new GridBagConstraints();
            gridBagTextRatio.fill = 0;
            gridBagTextRatio.gridy = 1;
            gridBagTextRatio.weightx = 2.0;
            gridBagTextRatio.anchor = 17;
            gridBagTextRatio.insets = new Insets(0, 0, 0, 0);
            gridBagTextRatio.weighty = 0.0;
            gridBagTextRatio.gridx = 1;
            this.jLabelOffsetY = new JLabel();
            this.jLabelOffsetY.setText("Offset Y");
            this.jLabelOffsetY.setPreferredSize(DIMENSION_LABEL);
            this.jLabelOffsetY.setSize(DIMENSION_LABEL);
            this.jLabelOffsetY.setMinimumSize(DIMENSION_LABEL);
            this.jLabelOffsetY.setMaximumSize(DIMENSION_LABEL);
            GridBagConstraints gridBagLabelRatio = new GridBagConstraints();
            gridBagLabelRatio.gridx = 0;
            gridBagLabelRatio.anchor = 17;
            gridBagLabelRatio.weightx = 0.0;
            gridBagLabelRatio.weighty = 0.0;
            gridBagLabelRatio.insets = new Insets(0, 6, 0, 4);
            gridBagLabelRatio.gridy = 1;
            JLabel jLabelRatio = new JLabel();
            jLabelRatio.setText("Aspect ratio");
            jLabelRatio.setPreferredSize(DIMENSION_LABEL);
            jLabelRatio.setSize(DIMENSION_LABEL);
            jLabelRatio.setMinimumSize(DIMENSION_LABEL);
            jLabelRatio.setMaximumSize(DIMENSION_LABEL);
            this.jPanelOffsets = new JPanel();
            this.jPanelOffsets.setLayout(new GridBagLayout());
            this.jPanelOffsets.setBorder(BorderFactory.createTitledBorder(null, "Screen Ratio", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelOffsets.add((Component)jLabelRatio, gridBagLabelRatio);
            this.jPanelOffsets.add((Component)this.getJTextFieldRatio(), gridBagTextRatio);
            this.jPanelOffsets.add((Component)this.getJButton21_9(), gridBagButtonBtn21_9);
            this.jPanelOffsets.add((Component)jLabelRatio1, gridBagLabelRatio1);
            this.jPanelOffsets.add((Component)this.getJButton240_1(), gridBagBtn240_1);
            this.jPanelOffsets.add((Component)this.getJButton235_1(), gridBagBtn235_1);
        }
        return this.jPanelOffsets;
    }

    private JPanel getJPanelMove() {
        if (this.jPanelMove == null) {
            GridBagConstraints gridBagRadioCenter = new GridBagConstraints();
            gridBagRadioCenter.gridx = 0;
            gridBagRadioCenter.gridwidth = 2;
            gridBagRadioCenter.anchor = 17;
            gridBagRadioCenter.insets = new Insets(0, 4, 0, 0);
            gridBagRadioCenter.weightx = 1.0;
            gridBagRadioCenter.gridy = 3;
            GridBagConstraints gridBagTextOfsX = new GridBagConstraints();
            gridBagTextOfsX.gridy = 4;
            gridBagTextOfsX.weightx = 10.0;
            gridBagTextOfsX.insets = new Insets(0, 0, 0, 0);
            gridBagTextOfsX.anchor = 17;
            gridBagTextOfsX.gridx = 1;
            GridBagConstraints gridBagLabelOfsX = new GridBagConstraints();
            gridBagLabelOfsX.gridx = 0;
            gridBagLabelOfsX.insets = new Insets(0, 6, 0, 4);
            gridBagLabelOfsX.anchor = 17;
            gridBagLabelOfsX.weightx = 0.0;
            gridBagLabelOfsX.gridy = 4;
            JLabel jLabelOffsetX = new JLabel();
            jLabelOffsetX.setText("Offset X");
            jLabelOffsetX.setPreferredSize(DIMENSION_LABEL);
            jLabelOffsetX.setSize(DIMENSION_LABEL);
            jLabelOffsetX.setMinimumSize(DIMENSION_LABEL);
            jLabelOffsetX.setMaximumSize(DIMENSION_LABEL);
            GridBagConstraints gridBagTextOfsY = new GridBagConstraints();
            gridBagTextOfsY.anchor = 17;
            gridBagTextOfsY.insets = new Insets(0, 0, 0, 0);
            gridBagTextOfsY.gridwidth = 1;
            gridBagTextOfsY.gridx = 3;
            gridBagTextOfsY.gridy = 4;
            gridBagTextOfsY.weightx = 10.0;
            GridBagConstraints gridBagLabelOfsY = new GridBagConstraints();
            gridBagLabelOfsY.anchor = 17;
            gridBagLabelOfsY.gridx = 2;
            gridBagLabelOfsY.gridy = 4;
            gridBagLabelOfsY.weightx = 0.0;
            gridBagLabelOfsY.insets = new Insets(0, 6, 0, 4);
            GridBagConstraints gridBagRadioRight = new GridBagConstraints();
            gridBagRadioRight.gridx = 0;
            gridBagRadioRight.insets = new Insets(0, 4, 0, 0);
            gridBagRadioRight.anchor = 17;
            gridBagRadioRight.gridwidth = 2;
            gridBagRadioRight.weightx = 1.0;
            gridBagRadioRight.gridy = 2;
            GridBagConstraints gridBagRadioLeft = new GridBagConstraints();
            gridBagRadioLeft.gridx = 0;
            gridBagRadioLeft.anchor = 17;
            gridBagRadioLeft.insets = new Insets(0, 4, 0, 0);
            gridBagRadioLeft.gridwidth = 2;
            gridBagRadioLeft.weightx = 1.0;
            gridBagRadioLeft.gridy = 1;
            GridBagConstraints gridBagRadioKeepX = new GridBagConstraints();
            gridBagRadioKeepX.gridx = 0;
            gridBagRadioKeepX.insets = new Insets(0, 4, 0, 0);
            gridBagRadioKeepX.anchor = 17;
            gridBagRadioKeepX.gridwidth = 2;
            gridBagRadioKeepX.weightx = 1.0;
            gridBagRadioKeepX.gridy = 0;
            GridBagConstraints gridBagRadioKeepY = new GridBagConstraints();
            gridBagRadioKeepY.gridx = 2;
            gridBagRadioKeepY.anchor = 17;
            gridBagRadioKeepY.insets = new Insets(0, 4, 0, 0);
            gridBagRadioKeepY.gridwidth = 2;
            gridBagRadioKeepY.weightx = 1.0;
            gridBagRadioKeepY.gridy = 0;
            GridBagConstraints gridBagRadioOutside = new GridBagConstraints();
            gridBagRadioOutside.gridx = 2;
            gridBagRadioOutside.weightx = 1.0;
            gridBagRadioOutside.anchor = 17;
            gridBagRadioOutside.insets = new Insets(0, 4, 0, 0);
            gridBagRadioOutside.gridwidth = 2;
            gridBagRadioOutside.gridy = 2;
            GridBagConstraints gridBagRadioInside = new GridBagConstraints();
            gridBagRadioInside.anchor = 17;
            gridBagRadioInside.insets = new Insets(0, 4, 0, 0);
            gridBagRadioInside.gridy = 1;
            gridBagRadioInside.gridx = 2;
            gridBagRadioInside.gridwidth = 2;
            gridBagRadioInside.weightx = 1.0;
            this.jPanelMove = new JPanel();
            this.jPanelMove.setLayout(new GridBagLayout());
            this.jPanelMove.setBorder(BorderFactory.createTitledBorder(null, "Move", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelMove.add((Component)this.getJRadioButtonInside(), gridBagRadioInside);
            this.jPanelMove.add((Component)this.getJRadioButtonOutside(), gridBagRadioOutside);
            this.jPanelMove.add((Component)this.getJRadioButtonKeepY(), gridBagRadioKeepY);
            this.jPanelMove.add((Component)this.getJRadioButtonKeepX(), gridBagRadioKeepX);
            this.jPanelMove.add((Component)this.getJRadioButtonLeft(), gridBagRadioLeft);
            this.jPanelMove.add((Component)this.getJRadioButtonRight(), gridBagRadioRight);
            this.jPanelMove.add((Component)this.jLabelOffsetY, gridBagLabelOfsY);
            this.jPanelMove.add((Component)this.getJTextFieldOffsetY(), gridBagTextOfsY);
            this.jPanelMove.add((Component)jLabelOffsetX, gridBagLabelOfsX);
            this.jPanelMove.add((Component)this.getJTextFieldOffsetX(), gridBagTextOfsX);
            this.jPanelMove.add((Component)this.getJRadioButtonCenter(), gridBagRadioCenter);
        }
        return this.jPanelMove;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.insets = new Insets(0, 0, 2, 9);
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.gridx = 2;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.insets = new Insets(0, 6, 2, 0);
            gridBagButtonCancel.weightx = 1.0;
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
        }
        return this.jPanelButtons;
    }

    void setInfoLabelText(String text) {
        this.jLabelInfo.setText(text);
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("  <  ");
            this.jButtonPrev.setMnemonic(37);
            this.jButtonPrev.setToolTipText("Lose changes and skip to previous frame");
        }
        return this.jButtonPrev;
    }

    void addPrevButtonActionListener(ActionListener actionListener) {
        this.jButtonPrev.addActionListener(actionListener);
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("  >  ");
            this.jButtonNext.setMnemonic(39);
            this.jButtonNext.setToolTipText("Lose changes and skip to next frame");
        }
        return this.jButtonNext;
    }

    void addNextButtonActionListener(ActionListener actionListener) {
        this.jButtonNext.addActionListener(actionListener);
    }

    private EditPane getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new EditPane();
            this.jPanelPreview.setLayout(new GridBagLayout());
            Dimension dim = new Dimension(384, 216);
            this.jPanelPreview.setPreferredSize(dim);
            this.jPanelPreview.setSize(dim);
            this.jPanelPreview.setMinimumSize(dim);
            this.jPanelPreview.setMaximumSize(dim);
        }
        return this.jPanelPreview;
    }

    void repaintPreviewPanel() {
        this.jPanelPreview.repaint();
    }

    void setPreviewPanelAspectRatio(double aspectRatio) {
        this.jPanelPreview.setAspectRatio(aspectRatio);
    }

    void setPreviewPanelSubtitleOffsets(int xOffset, int yOffset) {
        this.jPanelPreview.setSubtitleOffsets(xOffset, yOffset);
    }

    void setPreviewPanelScreenDimension(int width, int height) {
        this.jPanelPreview.setScreenDimension(width, height);
    }

    void setPreviewPanelImage(BufferedImage image, int width, int height) {
        this.jPanelPreview.setImage(image, width, height);
    }

    void setPreviewPanelCropOffsetY(int offset) {
        this.jPanelPreview.setCropOffsetY(offset);
    }

    void setPreviewPanelExcluded(boolean excluded) {
        this.jPanelPreview.setExcluded(excluded);
    }

    void setPreviewPanelCropOfsY(int offset) {
        this.jPanelPreview.setCropOffsetY(offset);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.setToolTipText("Lose changes and return");
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("Move all");
            this.jButtonOk.setMnemonic('m');
            this.jButtonOk.setPreferredSize(new Dimension(79, 23));
            this.jButtonOk.setToolTipText("Save changes and return");
            this.jButtonOk.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonOk;
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.jButtonOk.addActionListener(actionListener);
    }

    private JTextField getJTextFieldRatio() {
        if (this.jTextFieldRatio == null) {
            this.jTextFieldRatio = new JTextField();
            this.jTextFieldRatio.setPreferredSize(DIMENSION_TEXTFIELD);
            this.jTextFieldRatio.setSize(DIMENSION_TEXTFIELD);
            this.jTextFieldRatio.setMinimumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldRatio.setMaximumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldRatio.setToolTipText("Set inner frame ratio");
        }
        return this.jTextFieldRatio;
    }

    void addRatioTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldRatio.addActionListener(actionListener);
    }

    void addRatioTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldRatio.getDocument().addDocumentListener(documentListener);
    }

    String getRatioTextFieldText() {
        return this.jTextFieldRatio.getText();
    }

    void setRatioTextFieldText(String text) {
        this.jTextFieldRatio.setText(text);
    }

    void setRatioTextFieldBackground(Color color) {
        this.jTextFieldRatio.setBackground(color);
    }

    private JTextField getJTextFieldOffsetY() {
        if (this.jTextFieldOffsetY == null) {
            this.jTextFieldOffsetY = new JTextField();
            this.jTextFieldOffsetY.setPreferredSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetY.setSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetY.setMinimumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetY.setMaximumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetY.setToolTipText("Set offset from lower/upper border in pixels");
        }
        return this.jTextFieldOffsetY;
    }

    void addOffsetYTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldOffsetY.addActionListener(actionListener);
    }

    void addOffsetYTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldOffsetY.getDocument().addDocumentListener(documentListener);
    }

    String getOffsetYTextFieldText() {
        return this.jTextFieldOffsetY.getText();
    }

    void setOffsetYTextFieldText(String text) {
        this.jTextFieldOffsetY.setText(text);
    }

    void setOffsetYTextFieldBackground(Color color) {
        this.jTextFieldOffsetY.setBackground(color);
    }

    void error(String message) {
        logger.error(message);
        JOptionPane.showMessageDialog(this, message, "Error!", 2);
    }

    private JButton getJButton21_9() {
        if (this.jButton21_9 == null) {
            this.jButton21_9 = new JButton();
            this.jButton21_9.setText("21:9");
            this.jButton21_9.setToolTipText("Set inner frame ratio to 21:9");
        }
        return this.jButton21_9;
    }

    void add_21_9_ButtonActionListener(ActionListener actionListener) {
        this.jButton21_9.addActionListener(actionListener);
    }

    private JButton getJButton240_1() {
        if (this.jButton240_1 == null) {
            this.jButton240_1 = new JButton();
            this.jButton240_1.setText("2.40:1");
            this.jButton240_1.setToolTipText("Set inner frame ratio to 2.40:1");
        }
        return this.jButton240_1;
    }

    void add_240_1_ButtonActionListener(ActionListener actionListener) {
        this.jButton240_1.addActionListener(actionListener);
    }

    private JButton getJButton235_1() {
        if (this.jButton235_1 == null) {
            this.jButton235_1 = new JButton();
            this.jButton235_1.setText("2.35:1");
            this.jButton235_1.setToolTipText("Set inner frame ratio to 2.35:1");
        }
        return this.jButton235_1;
    }

    void add_235_1_ButtonActionListener(ActionListener actionListener) {
        this.jButton235_1.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonInside() {
        if (this.jRadioButtonInside == null) {
            this.jRadioButtonInside = new JRadioButton();
            this.jRadioButtonInside.setText("move inside bounds");
            this.jRadioButtonInside.setToolTipText("Move the subtitles inside the inner frame");
            this.jRadioButtonInside.setMnemonic('i');
        }
        return this.jRadioButtonInside;
    }

    void addInsideRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonInside.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonOutside() {
        if (this.jRadioButtonOutside == null) {
            this.jRadioButtonOutside = new JRadioButton();
            this.jRadioButtonOutside.setText("move outside bounds");
            this.jRadioButtonOutside.setToolTipText("Move the subtitles outside the inner frame as much as possible");
            this.jRadioButtonOutside.setMnemonic('o');
        }
        return this.jRadioButtonOutside;
    }

    void addOutsideRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonOutside.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonKeepY() {
        if (this.jRadioButtonKeepY == null) {
            this.jRadioButtonKeepY = new JRadioButton();
            this.jRadioButtonKeepY.setText("keep Y position");
            this.jRadioButtonKeepY.setToolTipText("Don't alter current Y position");
            this.jRadioButtonKeepY.setMnemonic('y');
        }
        return this.jRadioButtonKeepY;
    }

    void addKeepYRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonKeepY.addActionListener(actionListener);
    }

    private JPanel getJPanelCrop() {
        if (this.jPanelCrop == null) {
            GridBagConstraints gridBagBtnCrop = new GridBagConstraints();
            gridBagBtnCrop.anchor = 13;
            gridBagBtnCrop.insets = new Insets(0, 0, 0, 0);
            gridBagBtnCrop.weightx = 10.0;
            GridBagConstraints gridBagLabelCropY = new GridBagConstraints();
            gridBagLabelCropY.anchor = 17;
            gridBagLabelCropY.insets = new Insets(0, 6, 0, 4);
            gridBagLabelCropY.weightx = 0.0;
            GridBagConstraints gridBagTextCropY = new GridBagConstraints();
            gridBagTextCropY.fill = 0;
            gridBagTextCropY.insets = new Insets(0, 0, 0, 0);
            gridBagTextCropY.anchor = 17;
            gridBagTextCropY.weightx = 2.0;
            JLabel jLabelCropOfsY = new JLabel();
            jLabelCropOfsY.setPreferredSize(DIMENSION_LABEL);
            jLabelCropOfsY.setSize(DIMENSION_LABEL);
            jLabelCropOfsY.setMinimumSize(DIMENSION_LABEL);
            jLabelCropOfsY.setMaximumSize(DIMENSION_LABEL);
            jLabelCropOfsY.setText("Crop Offset Y");
            this.jPanelCrop = new JPanel();
            this.jPanelCrop.setLayout(new GridBagLayout());
            this.jPanelCrop.setBorder(BorderFactory.createTitledBorder(null, "Crop", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelCrop.add((Component)jLabelCropOfsY, gridBagLabelCropY);
            this.jPanelCrop.add((Component)this.getJTextFieldCropOfsY(), gridBagTextCropY);
            this.jPanelCrop.add((Component)this.getJButtonCropBars(), gridBagBtnCrop);
        }
        return this.jPanelCrop;
    }

    private JTextField getJTextFieldCropOfsY() {
        if (this.jTextFieldCropOfsY == null) {
            this.jTextFieldCropOfsY = new JTextField();
            this.jTextFieldCropOfsY.setPreferredSize(DIMENSION_TEXTFIELD);
            this.jTextFieldCropOfsY.setSize(DIMENSION_TEXTFIELD);
            this.jTextFieldCropOfsY.setMinimumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldCropOfsY.setMaximumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldCropOfsY.setToolTipText("Set number of lines to be cropped from upper and lower border");
        }
        return this.jTextFieldCropOfsY;
    }

    void addCropOfsYTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldCropOfsY.addActionListener(actionListener);
    }

    void addCropOfsYTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldCropOfsY.getDocument().addDocumentListener(documentListener);
    }

    String getCropOfsYTextFieldText() {
        return this.jTextFieldCropOfsY.getText();
    }

    void setCropOfsYTextFieldText(String text) {
        this.jTextFieldCropOfsY.setText(text);
    }

    void setCropOfsYTextFieldBackground(Color color) {
        this.jTextFieldCropOfsY.setBackground(color);
    }

    private JButton getJButtonCropBars() {
        if (this.jButtonCropBars == null) {
            this.jButtonCropBars = new JButton();
            this.jButtonCropBars.setToolTipText("Set crop offsets to cinemascope bars");
            this.jButtonCropBars.setText("Crop Bars");
            this.jButtonCropBars.setPreferredSize(new Dimension(79, 23));
            this.jButtonCropBars.setMnemonic('b');
        }
        return this.jButtonCropBars;
    }

    void addCropBarsButtonActionListener(ActionListener actionListener) {
        this.jButtonCropBars.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonKeepX() {
        if (this.jRadioButtonKeepX == null) {
            this.jRadioButtonKeepX = new JRadioButton();
            this.jRadioButtonKeepX.setText("keep X position");
            this.jRadioButtonKeepX.setToolTipText("Don't alter current X position");
            this.jRadioButtonKeepX.setMnemonic('x');
        }
        return this.jRadioButtonKeepX;
    }

    void addKeepXRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonKeepX.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonLeft() {
        if (this.jRadioButtonLeft == null) {
            this.jRadioButtonLeft = new JRadioButton();
            this.jRadioButtonLeft.setText("move left");
            this.jRadioButtonLeft.setToolTipText("Move to the left");
            this.jRadioButtonLeft.setMnemonic('l');
        }
        return this.jRadioButtonLeft;
    }

    void addLeftRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonLeft.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonRight() {
        if (this.jRadioButtonRight == null) {
            this.jRadioButtonRight = new JRadioButton();
            this.jRadioButtonRight.setText("move right");
            this.jRadioButtonRight.setToolTipText("Move to the right");
            this.jRadioButtonRight.setMnemonic('r');
        }
        return this.jRadioButtonRight;
    }

    void addRightRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonRight.addActionListener(actionListener);
    }

    private JRadioButton getJRadioButtonCenter() {
        if (this.jRadioButtonCenter == null) {
            this.jRadioButtonCenter = new JRadioButton();
            this.jRadioButtonCenter.setText("move to center");
            this.jRadioButtonCenter.setToolTipText("Move to center");
            this.jRadioButtonCenter.setMnemonic('e');
        }
        return this.jRadioButtonCenter;
    }

    void addCenterRadioButtonActionListener(ActionListener actionListener) {
        this.jRadioButtonCenter.addActionListener(actionListener);
    }

    private JTextField getJTextFieldOffsetX() {
        if (this.jTextFieldOffsetX == null) {
            this.jTextFieldOffsetX = new JTextField();
            this.jTextFieldOffsetX.setPreferredSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetX.setSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetX.setMinimumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetX.setMaximumSize(DIMENSION_TEXTFIELD);
            this.jTextFieldOffsetX.setToolTipText("Set offset from left/right border in pixels");
        }
        return this.jTextFieldOffsetX;
    }

    void addOffsetXTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldOffsetX.addActionListener(actionListener);
    }

    void addOffsetXTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldOffsetX.getDocument().addDocumentListener(documentListener);
    }

    String getOffsetXTextFieldText() {
        return this.jTextFieldOffsetX.getText();
    }

    void setOffsetXTextFieldText(String text) {
        this.jTextFieldOffsetX.setText(text);
    }

    void setOffsetXTextFieldBackground(Color color) {
        this.jTextFieldOffsetX.setBackground(color);
    }
}

