/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.palette;

import bdsup2sub.gui.palette.DvdPaletteDialogController;
import bdsup2sub.gui.palette.DvdPaletteDialogModel;
import bdsup2sub.gui.palette.DvdPaletteDialogView;
import java.awt.Color;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class DvdPaletteDialog {
    private final DvdPaletteDialogModel model = new DvdPaletteDialogModel();
    private final DvdPaletteDialogView view;
    private final DvdPaletteDialogController controller;

    public DvdPaletteDialog(Frame owner, String[] colorNames, Color[] currentColors, Color[] defaultColors, String colorProfilePath) {
        this.initModel(colorNames, currentColors, defaultColors, colorProfilePath);
        this.view = new DvdPaletteDialogView(this.model, owner);
        this.controller = new DvdPaletteDialogController(this.model, this.view);
    }

    private void initModel(String[] colorNames, Color[] currentColors, Color[] defaultColors, String colorProfilePath) {
        this.model.setColorProfilePath(colorProfilePath);
        this.model.setColorNames(colorNames);
        this.model.setColorIcons(new ImageIcon[colorNames.length]);
        this.model.setDefaultColors(defaultColors);
        Color[] selectedColors = new Color[colorNames.length];
        for (int i = 0; i < colorNames.length; ++i) {
            selectedColors[i] = new Color(currentColors[i].getRGB());
        }
        this.model.setSelectedColors(selectedColors);
    }

    public void setVisible(boolean visible) {
        this.view.setVisible(visible);
    }

    public boolean wasCanceled() {
        return this.model.wasCanceled();
    }

    public Color[] getColors() {
        return this.model.getSelectedColors();
    }

    public String getPath() {
        return this.model.getColorProfilePath();
    }
}

