/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.palette;

import bdsup2sub.core.Core;
import bdsup2sub.gui.palette.FramePaletteDialogModel;
import bdsup2sub.gui.palette.FramePaletteDialogView;
import bdsup2sub.utils.ToolBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

class FramePaletteDialogController {
    private final FramePaletteDialogModel model;
    private final FramePaletteDialogView view;

    public FramePaletteDialogController(FramePaletteDialogModel model, FramePaletteDialogView view) {
        this.model = model;
        this.view = view;
        this.addColorComboBoxActionListeners(view);
        this.addAlphaComboBoxActionListeners(view);
        this.addButtonActionListeners(view);
        view.addComboBoxCellRenderers(new TextWithColorIconListCellRenderer());
    }

    private void addColorComboBoxActionListeners(FramePaletteDialogView view) {
        view.addColor1ComboBoxActionListener(new Color1ComboBoxActionListener());
        view.addColor2ComboBoxActionListener(new Color2ComboBoxActionListener());
        view.addColor3ComboBoxActionListener(new Color3ComboBoxActionListener());
        view.addColor4ComboBoxActionListener(new Color4ComboBoxActionListener());
    }

    private void addAlphaComboBoxActionListeners(FramePaletteDialogView view) {
        view.addAlpha1ComboBoxActionListener(new Alpha1ComboBoxActionListener());
        view.addAlpha2ComboBoxActionListener(new Alpha2ComboBoxActionListener());
        view.addAlpha3ComboBoxActionListener(new Alpha3ComboBoxActionListener());
        view.addAlpha4ComboBoxActionListener(new Alpha4ComboBoxActionListener());
    }

    private void addButtonActionListeners(FramePaletteDialogView view) {
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addOkButtonActionListener(new OkButtonActionListener());
        view.addSetAllButtonActionListener(new SetAllButtonActionListener());
        view.addResetAllButtonActionListener(new ResetAllButtonActionListener());
        view.addResetButtonActionListener(new ResetButtonActionListener());
    }

    private void updateArrayElementWithSelectedItem(JComboBox comboBox, int[] array, int index) {
        int idx;
        if (this.model.isReady() && (idx = ToolBox.getInt(comboBox.getSelectedItem().toString())) >= 0 && idx < 16) {
            array[index] = idx;
        }
    }

    private void setPaletteAndAlphaValues(int subtitleIndex) {
        int[] alpha = Core.getFrameAlpha(subtitleIndex);
        int[] palette = Core.getFramePal(subtitleIndex);
        if (alpha != null) {
            System.arraycopy(this.model.getAlpha(), 0, alpha, 0, alpha.length);
        }
        if (palette != null) {
            System.arraycopy(this.model.getPalette(), 0, palette, 0, palette.length);
        }
    }

    private void resetPaletteAndAlphaValues(int subtitleIndex) {
        int[] originalAlpha = Core.getOriginalFrameAlpha(subtitleIndex);
        int[] originalPalette = Core.getOriginalFramePal(subtitleIndex);
        int[] alpha = Core.getFrameAlpha(subtitleIndex);
        int[] palette = Core.getFramePal(subtitleIndex);
        if (alpha != null && originalAlpha != null) {
            System.arraycopy(originalAlpha, 0, alpha, 0, alpha.length);
        }
        if (palette != null && originalPalette != null) {
            System.arraycopy(originalPalette, 0, palette, 0, palette.length);
        }
        this.setCurrentSubtitleIndex(subtitleIndex);
    }

    void setCurrentSubtitleIndex(int idx) {
        this.model.setCurrentSubtitleIndex(idx);
        this.model.setReady(false);
        this.copyAlphaAndPaletteValuesFromCurrentSubtitle();
        this.view.updateComboBoxSelections();
        this.model.setReady(true);
    }

    private void copyAlphaAndPaletteValuesFromCurrentSubtitle() {
        this.model.setAlpha(new int[4]);
        this.model.setPalette(new int[4]);
        int[] alpha = Core.getFrameAlpha(this.model.getCurrentSubtitleIndex());
        int[] palette = Core.getFramePal(this.model.getCurrentSubtitleIndex());
        if (alpha != null) {
            System.arraycopy(alpha, 0, this.model.getAlpha(), 0, alpha.length);
        }
        if (palette != null) {
            System.arraycopy(palette, 0, this.model.getPalette(), 0, palette.length);
        }
    }

    private class TextWithColorIconListCellRenderer
    extends DefaultListCellRenderer {
        private TextWithColorIconListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            int idx = ToolBox.getInt(value.toString());
            if (idx >= 0) {
                this.setText(FramePaletteDialogModel.COLOR_NAME[idx]);
                this.setIcon(FramePaletteDialogController.this.model.getColorPreviewIcon()[idx]);
            }
            return retValue;
        }
    }

    private class ResetButtonActionListener
    implements ActionListener {
        private ResetButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FramePaletteDialogController.this.resetPaletteAndAlphaValues(FramePaletteDialogController.this.model.getCurrentSubtitleIndex());
        }
    }

    private class ResetAllButtonActionListener
    implements ActionListener {
        private ResetAllButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            for (int j = 0; j < Core.getNumFrames(); ++j) {
                FramePaletteDialogController.this.resetPaletteAndAlphaValues(j);
            }
            FramePaletteDialogController.this.view.dispose();
        }
    }

    private class SetAllButtonActionListener
    implements ActionListener {
        private SetAllButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            for (int j = 0; j < Core.getNumFrames(); ++j) {
                FramePaletteDialogController.this.setPaletteAndAlphaValues(j);
            }
            FramePaletteDialogController.this.view.dispose();
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FramePaletteDialogController.this.setPaletteAndAlphaValues(FramePaletteDialogController.this.model.getCurrentSubtitleIndex());
            FramePaletteDialogController.this.view.dispose();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FramePaletteDialogController.this.view.dispose();
        }
    }

    private class Alpha4ComboBoxActionListener
    implements ActionListener {
        private Alpha4ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getAlpha(), 3);
        }
    }

    private class Alpha3ComboBoxActionListener
    implements ActionListener {
        private Alpha3ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getAlpha(), 2);
        }
    }

    private class Alpha2ComboBoxActionListener
    implements ActionListener {
        private Alpha2ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getAlpha(), 1);
        }
    }

    private class Alpha1ComboBoxActionListener
    implements ActionListener {
        private Alpha1ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getAlpha(), 0);
        }
    }

    private class Color4ComboBoxActionListener
    implements ActionListener {
        private Color4ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getPalette(), 3);
        }
    }

    private class Color3ComboBoxActionListener
    implements ActionListener {
        private Color3ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getPalette(), 2);
        }
    }

    private class Color2ComboBoxActionListener
    implements ActionListener {
        private Color2ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getPalette(), 1);
        }
    }

    private class Color1ComboBoxActionListener
    implements ActionListener {
        private Color1ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialogController.this.updateArrayElementWithSelectedItem((JComboBox)event.getSource(), FramePaletteDialogController.this.model.getPalette(), 0);
        }
    }
}

