/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.support;

import bdsup2sub.core.Core;
import bdsup2sub.core.CoreThreadState;
import bdsup2sub.gui.support.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class Progress
extends JDialog {
    private JPanel jContentPane;
    private JButton jButtonCancel;
    private JProgressBar jProgressBar;
    private JLabel jLabelProgress;
    private Timer timer;

    public Progress(Frame owner) {
        super(owner, true);
        this.initialize();
        GuiUtils.centerRelativeToOwner(this);
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(224, 139));
        this.setResizable(false);
        this.setBounds(new Rectangle(0, 0, 224, 139));
        this.setMaximumSize(new Dimension(224, 139));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Core.cancel();
            }
        });
    }

    public void setVisible(boolean b) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new ProgressTimer(), 200L, 200L);
        super.setVisible(b);
    }

    public void setText(String s) {
        this.jLabelProgress.setText(s);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagBtnCancel = new GridBagConstraints();
            gridBagBtnCancel.insets = new Insets(8, 8, 8, 8);
            gridBagBtnCancel.gridx = 0;
            gridBagBtnCancel.gridy = 2;
            GridBagConstraints gridBagProgressBar = new GridBagConstraints();
            gridBagProgressBar.gridy = 1;
            gridBagProgressBar.fill = 3;
            gridBagProgressBar.insets = new Insets(8, 8, 8, 8);
            gridBagProgressBar.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints.gridy = 0;
            this.jLabelProgress = new JLabel();
            this.jLabelProgress.setText("Exporting SUB/IDX");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabelProgress, gridBagConstraints);
            this.jContentPane.add((Component)this.getJProgressBar(), gridBagProgressBar);
            this.jContentPane.add((Component)this.getJButtonCancel(), gridBagBtnCancel);
        }
        return this.jContentPane;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Core.cancel();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setPreferredSize(new Dimension(200, 20));
            this.jProgressBar.setMinimumSize(new Dimension(200, 20));
            this.jProgressBar.setStringPainted(true);
        }
        return this.jProgressBar;
    }

    public void setProgress(int val) {
        this.jProgressBar.setValue(val);
        this.jProgressBar.repaint();
    }

    private class ProgressTimer
    extends TimerTask {
        private ProgressTimer() {
        }

        public void run() {
            if (Core.getStatus() != CoreThreadState.ACTIVE) {
                Progress.this.timer.cancel();
                Progress.this.dispose();
            }
        }
    }
}

