/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.bd;

import bdsup2sub.core.Configuration;
import bdsup2sub.supstream.ImageObject;
import bdsup2sub.supstream.PaletteInfo;
import bdsup2sub.supstream.SubPicture;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubPictureBD
extends SubPicture {
    private static final Configuration configuration = Configuration.getInstance();
    private int objectID;
    private List<ImageObject> imageObjectList = new ArrayList<ImageObject>();
    private int windowWidth;
    private int windowHeight;
    private int xWindowOffset;
    private int yWindowOffset;
    private int type;
    private List<List<PaletteInfo>> palettes = new ArrayList<List<PaletteInfo>>();

    public SubPictureBD() {
        for (int i = 0; i < 8; ++i) {
            this.palettes.add(new ArrayList());
        }
    }

    public SubPictureBD(SubPictureBD other) {
        super(other);
        for (int i = 0; i < 8; ++i) {
            this.palettes.add(new ArrayList());
        }
        this.objectID = other.objectID;
        this.windowWidth = other.windowWidth;
        this.windowHeight = other.windowHeight;
        this.xWindowOffset = other.xWindowOffset;
        this.yWindowOffset = other.yWindowOffset;
        this.type = other.type;
        if (other.palettes != null) {
            this.palettes = new ArrayList<List<PaletteInfo>>();
            for (List<PaletteInfo> pi : other.palettes) {
                ArrayList<PaletteInfo> cpi = new ArrayList<PaletteInfo>(pi);
                this.palettes.add(cpi);
            }
        }
        for (ImageObject io : other.imageObjectList) {
            this.imageObjectList.add(new ImageObject(io));
        }
    }

    public boolean isMergableWith(SubPictureBD previous) {
        if (previous != null && (previous.getEndTime() == 0L || this.getStartTime() - previous.getEndTime() < (long)configuration.getMergePTSdiff())) {
            return this.isThisImageObjectIdenticalWith(previous.getImageObject());
        }
        return false;
    }

    private boolean isThisImageObjectIdenticalWith(ImageObject previousImageObject) {
        ImageObject thisImageObject = this.getImageObject();
        if (previousImageObject != null && thisImageObject != null) {
            return previousImageObject.getBufferSize() == thisImageObject.getBufferSize() && previousImageObject.getWidth() == thisImageObject.getWidth() && previousImageObject.getHeight() == thisImageObject.getHeight();
        }
        return false;
    }

    @Override
    public int getImageWidth() {
        return this.imageObjectList.get(this.objectID).getWidth();
    }

    @Override
    public int getImageHeight() {
        return this.imageObjectList.get(this.objectID).getHeight();
    }

    @Override
    public int getXOffset() {
        return this.imageObjectList.get(this.objectID).getXOffset();
    }

    @Override
    public int getYOffset() {
        return this.imageObjectList.get(this.objectID).getYOffset();
    }

    ImageObject getImageObject(int index) {
        return this.imageObjectList.get(index);
    }

    ImageObject getImageObject() {
        return this.imageObjectList.get(this.objectID);
    }

    int getObjectID() {
        return this.objectID;
    }

    public void setObjectID(int objectID) {
        this.objectID = objectID;
    }

    public List<ImageObject> getImageObjectList() {
        return this.imageObjectList;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    int getXWindowOffset() {
        return this.xWindowOffset;
    }

    public void setXWindowOffset(int xWindowOffset) {
        this.xWindowOffset = xWindowOffset;
    }

    int getYWindowOffset() {
        return this.yWindowOffset;
    }

    public void setYWindowOffset(int yWindowOffset) {
        this.yWindowOffset = yWindowOffset;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public List<List<PaletteInfo>> getPalettes() {
        return this.palettes;
    }
}

