/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.bdnxml;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.BitmapBounds;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.Logger;
import bdsup2sub.core.Resolution;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.SubtitleStream;
import bdsup2sub.supstream.bdnxml.SubPictureXml;
import bdsup2sub.tools.QuantizeFilter;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupXml
implements SubtitleStream {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private List<SubPictureXml> subPictures = new ArrayList<SubPictureXml>();
    private Palette palette;
    private Bitmap bitmap;
    private int primaryColorIndex;
    private int numForcedFrames;
    private String pathName;
    private String title;
    private String language = "eng";
    private Resolution resolution = Resolution.HD_1080;
    private double fps = Framerate.FPS_23_976.getValue();
    private double fpsXml = SupXml.XmlFps(this.fps);
    private static final String[] xmlStates = new String[]{"bdn", "description", "name", "language", "format", "events", "event", "graphic"};

    public SupXml(String filename) throws CoreException {
        this.pathName = FilenameUtils.addSeparator(FilenameUtils.getParent(filename));
        this.title = FilenameUtils.removeExtension(FilenameUtils.getName(filename));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            XmlHandler handler = new XmlHandler();
            saxParser.parse(new File(filename), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(e.getMessage());
        }
        catch (SAXException e) {
            throw new CoreException(e.getMessage());
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage());
        }
        logger.trace("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    private static double XmlFps(double fps) {
        if (fps == Framerate.FPS_23_975.getValue()) {
            return Framerate.FPS_24.getValue();
        }
        if (fps == Framerate.FPS_23_976.getValue()) {
            return Framerate.FPS_24.getValue();
        }
        if (fps == Framerate.NTSC.getValue()) {
            return 30.0;
        }
        if (fps == Framerate.NTSC_I.getValue()) {
            return 60.0;
        }
        return fps;
    }

    @Override
    public void close() {
    }

    @Override
    public void decode(int index) throws CoreException {
        try {
            IndexColorModel icm;
            File f = new File(this.subPictures.get(index).getFileName());
            if (!f.exists()) {
                throw new CoreException("file " + this.subPictures.get(index).getFileName() + " not found.");
            }
            BufferedImage img = ImageIO.read(f);
            int w = img.getWidth();
            int h = img.getHeight();
            this.palette = null;
            if (img.getType() == 13 && ((icm = (IndexColorModel)img.getColorModel()).getMapSize() < 255 || icm.hasAlpha() && icm.getAlpha(255) == 0)) {
                this.palette = new Palette(256);
                for (int i = 0; i < icm.getMapSize(); ++i) {
                    int alpha = icm.getRGB(i) >> 24 & 0xFF;
                    if (alpha >= configuration.getAlphaCrop()) {
                        this.palette.setARGB(i, icm.getRGB(i));
                        continue;
                    }
                    this.palette.setARGB(i, 0);
                }
                WritableRaster raster = img.getRaster();
                this.bitmap = new Bitmap(img.getWidth(), img.getHeight(), (byte[])raster.getDataElements(0, 0, img.getWidth(), img.getHeight(), null));
            }
            if (this.palette == null) {
                int[] pixels = new int[w * h];
                img.getRGB(0, 0, w, h, pixels, 0, w);
                QuantizeFilter qf = new QuantizeFilter();
                this.bitmap = new Bitmap(img.getWidth(), img.getHeight());
                int[] ct = qf.quantize(pixels, this.bitmap.getInternalBuffer(), w, h, 255, false, false);
                int size = ct.length;
                if (size > 255) {
                    logger.warn("Quantizer failed.\n");
                    size = 255;
                }
                this.palette = new Palette(256);
                for (int i = 0; i < size; ++i) {
                    int alpha = ct[i] >> 24 & 0xFF;
                    if (alpha >= configuration.getAlphaCrop()) {
                        this.palette.setARGB(i, ct[i]);
                        continue;
                    }
                    this.palette.setARGB(i, 0);
                }
            }
            this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette.getAlpha(), configuration.getAlphaThreshold(), this.palette.getY());
            BitmapBounds bounds = this.bitmap.getCroppingBounds(this.palette.getAlpha(), configuration.getAlphaCrop());
            if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
                w = bounds.xMax - bounds.xMin + 1;
                h = bounds.yMax - bounds.yMin + 1;
                if (w < 2) {
                    w = 2;
                }
                if (h < 2) {
                    h = 2;
                }
                this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, w, h);
                SubPictureXml pic = this.subPictures.get(index);
                pic.setImageWidth(w);
                pic.setImageHeight(h);
                pic.setOfsX(pic.getOriginalXOffset() + bounds.xMin);
                pic.setOfsY(pic.getOriginalYOffset() + bounds.yMin);
            }
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage());
        }
        catch (OutOfMemoryError e) {
            JOptionPane.showMessageDialog(null, "Out of heap! Use -Xmx256m to increase heap!", "Error!", 2);
            throw new CoreException("Out of heap! Use -Xmx256m to increase heap!");
        }
    }

    public static void writeXml(String fname, SortedMap<Integer, SubPicture> pics) throws CoreException {
        double fps = configuration.getFpsTrg();
        double fpsXml = SupXml.XmlFps(fps);
        BufferedWriter out = null;
        String name = FilenameUtils.removeExtension(FilenameUtils.getName(fname));
        try {
            out = new BufferedWriter(new FileWriter(fname));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write("<BDN Version=\"0.93\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"BD-03-006-0093b BDN File Format.xsd\">");
            out.newLine();
            out.write("  <Description>");
            out.newLine();
            out.write("    <Name Title=\"" + name + "\" Content=\"\"/>");
            out.newLine();
            out.write("    <Language Code=\"" + Constants.LANGUAGES[configuration.getLanguageIdx()][2] + "\"/>");
            out.newLine();
            String res = configuration.getOutputResolution().getResolutionNameForXml();
            out.write("    <Format VideoFormat=\"" + res + "\" FrameRate=\"" + ToolBox.formatDouble(fps) + "\" DropFrame=\"False\"/>");
            out.newLine();
            long t = ((SubPicture)pics.get(pics.firstKey())).getStartTime();
            if (fps != fpsXml) {
                t = (t * 2000L + 1001L) / 2002L;
            }
            String ts = TimeUtils.ptsToTimeStrXml(t, fpsXml);
            t = ((SubPicture)pics.get(pics.lastKey())).getEndTime();
            if (fps != fpsXml) {
                t = (t * 2000L + 1001L) / 2002L;
            }
            String te = TimeUtils.ptsToTimeStrXml(t, fpsXml);
            out.write("    <Events Type=\"Graphic\" FirstEventInTC=\"" + ts + "\" LastEventOutTC=\"" + te + "\" NumberofEvents=\"" + pics.size() + "\"/>");
            out.newLine();
            out.write("  </Description>");
            out.newLine();
            out.write("  <Events>");
            out.newLine();
            for (int idx : pics.keySet()) {
                SubPicture p = (SubPicture)pics.get(idx);
                t = p.getStartTime();
                if (fps != fpsXml) {
                    t = (t * 2000L + 1001L) / 2002L;
                }
                ts = TimeUtils.ptsToTimeStrXml(t, fpsXml);
                t = p.getEndTime();
                if (fps != fpsXml) {
                    t = (t * 2000L + 1001L) / 2002L;
                }
                te = TimeUtils.ptsToTimeStrXml(t, fpsXml);
                String forced = p.isForced() ? "True" : "False";
                out.write("    <Event InTC=\"" + ts + "\" OutTC=\"" + te + "\" Forced=\"" + forced + "\">");
                out.newLine();
                String pname = SupXml.getPNGname(name, idx + 1);
                out.write("      <Graphic Width=\"" + p.getImageWidth() + "\" Height=\"" + p.getImageHeight() + "\" X=\"" + p.getXOffset() + "\" Y=\"" + p.getYOffset() + "\">" + pname + "</Graphic>");
                out.newLine();
                out.write("    </Event>");
                out.newLine();
            }
            out.write("  </Events>");
            out.newLine();
            out.write("</BDN>");
            out.newLine();
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette.getColorModel());
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette.getColorModel());
    }

    @Override
    public int getForcedFrameCount() {
        return this.numForcedFrames;
    }

    @Override
    public int getFrameCount() {
        return this.subPictures.size();
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public long getStartOffset(int index) {
        return 0L;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get(index).getEndTime();
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get(index).getStartTime();
    }

    @Override
    public boolean isForced(int index) {
        return this.subPictures.get(index).isForced();
    }

    public static String getPNGname(String fn, int idx) {
        return fn + "_" + ToolBox.leftZeroPad(idx, 4) + ".png";
    }

    public String getLanguage() {
        return this.language;
    }

    public double getFps() {
        return this.fps;
    }

    class XmlHandler
    extends DefaultHandler {
        XmlState state;
        StringBuffer txt;
        boolean valid;
        SubPictureXml pic;

        XmlHandler() {
        }

        private XmlState findState(String s) {
            for (XmlState x : XmlState.values()) {
                if (!s.toLowerCase().equals(xmlStates[x.ordinal()])) continue;
                return x;
            }
            return XmlState.UNKNOWN;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.state = this.findState(qName);
            if (this.state != XmlState.BDN && !this.valid) {
                logger.error("BDN tag missing");
            }
            this.txt = null;
            block0 : switch (this.state) {
                case UNKNOWN: {
                    logger.error("Unknown tag " + qName + "\n");
                    break;
                }
                case BDN: {
                    if (this.valid) {
                        logger.error("BDN must be used only once");
                        break;
                    }
                    this.valid = true;
                    break;
                }
                case NAME: {
                    String at = atts.getValue("Title");
                    if (at == null) break;
                    SupXml.this.title = at;
                    logger.trace("Title: " + SupXml.this.title + "\n");
                    break;
                }
                case LANGUAGE: {
                    String at = atts.getValue("Code");
                    if (at == null) break;
                    SupXml.this.language = at;
                    logger.trace("Language: " + SupXml.this.language + "\n");
                    break;
                }
                case FORMAT: {
                    String at = atts.getValue("FrameRate");
                    if (at != null) {
                        SupXml.this.fps = SubtitleUtils.getFps(at);
                        SupXml.this.fpsXml = SupXml.XmlFps(SupXml.this.fps);
                        logger.trace("fps: " + ToolBox.formatDouble(SupXml.this.fps) + "\n");
                    }
                    if ((at = atts.getValue("VideoFormat")) == null) break;
                    String res = at;
                    for (Resolution r : Resolution.values()) {
                        if (res.length() == 4 && res.charAt(0) != '7') {
                            res = res.replace('p', 'i');
                        }
                        if (!r.getResolutionNameForXml().equalsIgnoreCase(res)) continue;
                        SupXml.this.resolution = r;
                        logger.trace("Language: " + r.getResolutionNameForXml() + "\n");
                        break block0;
                    }
                    break;
                }
                case EVENTS: {
                    int n;
                    String at = atts.getValue("NumberofEvents");
                    if (at == null || (n = ToolBox.getInt(at)) <= 0) break;
                    Core.setProgressMax(n);
                    break;
                }
                case EVENT: {
                    this.pic = new SubPictureXml();
                    SupXml.this.subPictures.add(this.pic);
                    int num = SupXml.this.subPictures.size();
                    logger.info("#" + num + "\n");
                    Core.setProgress(num);
                    String at = atts.getValue("InTC");
                    if (at != null) {
                        this.pic.setStartTime(TimeUtils.timeStrXmlToPTS(at, SupXml.this.fpsXml));
                        if (this.pic.getStartTime() == -1L) {
                            this.pic.setStartTime(0L);
                            logger.warn("Invalid start time " + at + "\n");
                        }
                    }
                    if ((at = atts.getValue("OutTC")) != null) {
                        this.pic.setEndTime(TimeUtils.timeStrXmlToPTS(at, SupXml.this.fpsXml));
                        if (this.pic.getEndTime() == -1L) {
                            this.pic.setEndTime(0L);
                            logger.warn("Invalid end time " + at + "\n");
                        }
                    }
                    if (SupXml.this.fps != SupXml.this.fpsXml) {
                        this.pic.setStartTime((this.pic.getStartTime() * 1001L + 500L) / 1000L);
                        this.pic.setEndTime((this.pic.getEndTime() * 1001L + 500L) / 1000L);
                    }
                    this.pic.setForced((at = atts.getValue("Forced")) != null && at.equalsIgnoreCase("true"));
                    if (this.pic.isForced()) {
                        SupXml.this.numForcedFrames++;
                    }
                    int[] dim = SupXml.this.resolution.getDimensions();
                    this.pic.setWidth(dim[0]);
                    this.pic.setHeight(dim[1]);
                    break;
                }
                case GRAPHIC: {
                    this.pic.setImageWidth(ToolBox.getInt(atts.getValue("Width")));
                    this.pic.setImageHeight(ToolBox.getInt(atts.getValue("Height")));
                    this.pic.setOfsX(ToolBox.getInt(atts.getValue("X")));
                    this.pic.setOfsY(ToolBox.getInt(atts.getValue("Y")));
                    this.pic.storeOriginalOffsets();
                    this.txt = new StringBuffer();
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            XmlState endState = this.findState(qName);
            if (this.state == XmlState.GRAPHIC && endState == XmlState.GRAPHIC) {
                this.pic.setFileName(SupXml.this.pathName + this.txt.toString().trim());
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.txt != null) {
                this.txt.append(ch, start, length);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum XmlState {
        BDN,
        DESCRIPT,
        NAME,
        LANGUAGE,
        FORMAT,
        EVENTS,
        EVENT,
        GRAPHIC,
        UNKNOWN;

    }
}

