/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.CoreException;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.supstream.dvd.SupDvdUtil;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public final class SubDvdWriter {
    private static final Configuration configuration = Configuration.getInstance();
    private static final byte[] PACK_HEADER = new byte[]{0, 0, 1, -70, 68, 2, -60, -126, 4, -87, 1, -119, -61, -8};
    private static final byte[] HEADER_FIRST = new byte[]{0, 0, 1, -67, 0, 0, -127, -128, 5, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0};
    private static final byte[] HEADER_NEXT = new byte[]{0, 0, 1, -67, 0, 0, -127, 0, 0, 32};
    private static final byte[] CONTROL_HEADER = new byte[]{0, 0, 0, 1, 3, 50, 16, 4, -1, -1, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, -1, 0, 0, 0, 0, 2, -1};

    private SubDvdWriter() {
    }

    public static byte[] createSubFrame(SubPictureDVD pic, Bitmap bm) {
        int i;
        int controlHeaderLen;
        int forcedOfs;
        byte[] even = SupDvdUtil.encodeLines(bm, true);
        byte[] odd = SupDvdUtil.encodeLines(bm, false);
        if (pic.isForced()) {
            forcedOfs = 0;
            SubDvdWriter.CONTROL_HEADER[2] = 1;
            SubDvdWriter.CONTROL_HEADER[3] = 0;
            controlHeaderLen = CONTROL_HEADER.length;
        } else {
            forcedOfs = 1;
            SubDvdWriter.CONTROL_HEADER[2] = 0;
            SubDvdWriter.CONTROL_HEADER[3] = 1;
            controlHeaderLen = CONTROL_HEADER.length - 1;
        }
        int ptm = (int)pic.getStartTime();
        SubDvdWriter.HEADER_FIRST[9] = (byte)(ptm >> 29 & 0xE | 0x21);
        SubDvdWriter.HEADER_FIRST[10] = (byte)(ptm >> 22);
        SubDvdWriter.HEADER_FIRST[11] = (byte)(ptm >> 14 | 1);
        SubDvdWriter.HEADER_FIRST[12] = (byte)(ptm >> 7);
        SubDvdWriter.HEADER_FIRST[13] = (byte)(ptm * 2 + 1);
        SubDvdWriter.CONTROL_HEADER[5] = (byte)((pic.getPal()[3] & 0xF) << 4 | pic.getPal()[2] & 0xF);
        SubDvdWriter.CONTROL_HEADER[6] = (byte)((pic.getPal()[1] & 0xF) << 4 | pic.getPal()[0] & 0xF);
        SubDvdWriter.CONTROL_HEADER[8] = (byte)((pic.getAlpha()[3] & 0xF) << 4 | pic.getAlpha()[2] & 0xF);
        SubDvdWriter.CONTROL_HEADER[9] = (byte)((pic.getAlpha()[1] & 0xF) << 4 | pic.getAlpha()[0] & 0xF);
        SubDvdWriter.CONTROL_HEADER[11] = (byte)(pic.getXOffset() >> 4 & 0xFF);
        int tmp = pic.getXOffset() + bm.getWidth() - 1;
        SubDvdWriter.CONTROL_HEADER[12] = (byte)((pic.getXOffset() & 0xF) << 4 | tmp >> 8 & 0xF);
        SubDvdWriter.CONTROL_HEADER[13] = (byte)(tmp & 0xFF);
        int yOfs = pic.getYOffset() - configuration.getCropOffsetY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.getHeight() - pic.getImageHeight() - 2 * configuration.getCropOffsetY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        SubDvdWriter.CONTROL_HEADER[14] = (byte)(yOfs >> 4 & 0xFF);
        tmp = yOfs + bm.getHeight() - 1;
        SubDvdWriter.CONTROL_HEADER[15] = (byte)((yOfs & 0xF) << 4 | tmp >> 8 & 0xF);
        SubDvdWriter.CONTROL_HEADER[16] = (byte)(tmp & 0xFF);
        SubDvdWriter.CONTROL_HEADER[18] = 0;
        SubDvdWriter.CONTROL_HEADER[19] = 4;
        tmp = even.length + CONTROL_HEADER[19];
        SubDvdWriter.CONTROL_HEADER[20] = (byte)(tmp >> 8 & 0xFF);
        SubDvdWriter.CONTROL_HEADER[21] = (byte)(tmp & 0xFF);
        tmp = (int)((pic.getEndTime() - pic.getStartTime()) / 1024L);
        SubDvdWriter.CONTROL_HEADER[23] = (byte)(tmp >> 8 & 0xFF);
        SubDvdWriter.CONTROL_HEADER[24] = (byte)(tmp & 0xFF);
        tmp = even.length + odd.length + 22 + (pic.isForced() ? 1 : 0) + 4;
        SubDvdWriter.CONTROL_HEADER[forcedOfs + 0] = (byte)(tmp >> 8 & 0xFF);
        SubDvdWriter.CONTROL_HEADER[forcedOfs + 1] = (byte)(tmp & 0xFF);
        SubDvdWriter.CONTROL_HEADER[25] = (byte)(tmp >> 8 & 0xFF);
        SubDvdWriter.CONTROL_HEADER[26] = (byte)(tmp & 0xFF);
        tmp = even.length + odd.length + 4 + controlHeaderLen;
        SubDvdWriter.HEADER_FIRST[15] = (byte)(tmp >> 8);
        SubDvdWriter.HEADER_FIRST[16] = (byte)tmp;
        tmp = even.length + odd.length + 2;
        SubDvdWriter.HEADER_FIRST[17] = (byte)(tmp >> 8);
        SubDvdWriter.HEADER_FIRST[18] = (byte)tmp;
        int sizeRLE = even.length + odd.length;
        int bufSize = PACK_HEADER.length + HEADER_FIRST.length + controlHeaderLen + sizeRLE;
        int numAdditionalPackets = 0;
        if (bufSize > 2048) {
            numAdditionalPackets = 1;
            int remainingRLEsize = sizeRLE - (2048 - PACK_HEADER.length - HEADER_FIRST.length);
            while (remainingRLEsize > 2048 - PACK_HEADER.length - HEADER_NEXT.length - controlHeaderLen) {
                remainingRLEsize -= 2048 - PACK_HEADER.length - HEADER_NEXT.length;
                bufSize += PACK_HEADER.length + HEADER_NEXT.length;
                ++numAdditionalPackets;
            }
            tmp = 2048 - PACK_HEADER.length - 6;
        } else {
            tmp = bufSize - PACK_HEADER.length - 6;
        }
        byte[] buf = new byte[(1 + numAdditionalPackets) * 2048];
        int diff = buf.length - bufSize;
        int stuffingBytes = diff > 0 && diff < 6 ? diff : 0;
        int ofs = 0;
        for (byte packHeader : PACK_HEADER) {
            buf[ofs++] = packHeader;
        }
        SubDvdWriter.HEADER_FIRST[4] = (byte)((tmp += stuffingBytes) >> 8);
        SubDvdWriter.HEADER_FIRST[5] = (byte)tmp;
        SubDvdWriter.HEADER_FIRST[8] = (byte)(5 + stuffingBytes);
        for (i = 0; i < 14; ++i) {
            buf[ofs++] = HEADER_FIRST[i];
        }
        for (i = 0; i < stuffingBytes; ++i) {
            buf[ofs++] = -1;
        }
        for (i = 14; i < HEADER_FIRST.length; ++i) {
            buf[ofs++] = HEADER_FIRST[i];
        }
        tmp = sizeRLE;
        if (numAdditionalPackets > 0 && (tmp = 2048 - PACK_HEADER.length - stuffingBytes - HEADER_FIRST.length) > sizeRLE) {
            tmp = sizeRLE;
        }
        for (i = 0; i < tmp; ++i) {
            buf[ofs++] = i < even.length ? even[i] : odd[i - even.length];
        }
        int ofsRLE = tmp;
        int controlHeaderWritten = 0;
        if (numAdditionalPackets == 1 && ofs < 2048) {
            while (ofs < 2048) {
                buf[ofs] = CONTROL_HEADER[forcedOfs + controlHeaderWritten++];
                ++ofs;
            }
        }
        for (int p = 0; p < numAdditionalPackets; ++p) {
            int rleSizeLeft;
            if (p == numAdditionalPackets - 1) {
                rleSizeLeft = sizeRLE - ofsRLE;
                tmp = HEADER_NEXT.length + (controlHeaderLen - controlHeaderWritten) + (sizeRLE - ofsRLE) - 6;
            } else {
                tmp = 2048 - PACK_HEADER.length - 6;
                rleSizeLeft = 2048 - PACK_HEADER.length - HEADER_NEXT.length;
                if (rleSizeLeft > sizeRLE - ofsRLE) {
                    rleSizeLeft = sizeRLE - ofsRLE;
                }
            }
            SubDvdWriter.PACK_HEADER[13] = -8;
            for (byte packHeader : PACK_HEADER) {
                buf[ofs++] = packHeader;
            }
            SubDvdWriter.HEADER_NEXT[4] = (byte)(tmp >> 8);
            SubDvdWriter.HEADER_NEXT[5] = (byte)tmp;
            for (byte b : HEADER_NEXT) {
                buf[ofs++] = b;
            }
            for (int i2 = ofsRLE; i2 < ofsRLE + rleSizeLeft; ++i2) {
                buf[ofs++] = i2 < even.length ? even[i2] : odd[i2 - even.length];
            }
            ofsRLE += rleSizeLeft;
            if (p == numAdditionalPackets - 1) continue;
            while (ofs < (p + 2) * 2048) {
                buf[ofs] = CONTROL_HEADER[forcedOfs + controlHeaderWritten++];
                ++ofs;
            }
        }
        for (int i3 = controlHeaderWritten; i3 < controlHeaderLen; ++i3) {
            buf[ofs++] = CONTROL_HEADER[forcedOfs + i3];
        }
        diff = buf.length - ofs;
        if (diff >= 6) {
            buf[ofs++] = 0;
            buf[ofs++] = 0;
            buf[ofs++] = 1;
            buf[ofs++] = -66;
            buf[ofs++] = (byte)((diff -= 6) >> 8);
            buf[ofs++] = (byte)diff;
            while (ofs < buf.length) {
                buf[ofs] = -1;
                ++ofs;
            }
        }
        return buf;
    }

    public static void writeIdx(String fname, SubPicture pic, int[] offsets, int[] timestamps, Palette palette) throws CoreException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(fname));
            out.write("# VobSub index file, v7 (do not modify this line!)");
            out.newLine();
            out.write("# Created by " + Constants.APP_NAME + " " + Constants.APP_VERSION);
            out.newLine();
            out.newLine();
            out.write("# Frame size");
            out.newLine();
            out.write("size: " + pic.getWidth() + "x" + (pic.getHeight() - 2 * configuration.getCropOffsetY()));
            out.newLine();
            out.newLine();
            out.write("# Origin - upper-left corner");
            out.newLine();
            out.write("org: 0, 0");
            out.newLine();
            out.newLine();
            out.write("# Scaling");
            out.newLine();
            out.write("scale: 100%, 100%");
            out.newLine();
            out.newLine();
            out.write("# Alpha blending");
            out.newLine();
            out.write("alpha: 100%");
            out.newLine();
            out.newLine();
            out.write("# Smoothing");
            out.newLine();
            out.write("smooth: OFF");
            out.newLine();
            out.newLine();
            out.write("# Fade in/out in milliseconds");
            out.newLine();
            out.write("fadein/out: 0, 0");
            out.newLine();
            out.newLine();
            out.write("# Force subtitle placement relative to (org.x, org.y)");
            out.newLine();
            out.write("align: OFF at LEFT TOP");
            out.newLine();
            out.newLine();
            out.write("# For correcting non-progressive desync. (in millisecs or hh:mm:ss:ms)");
            out.newLine();
            out.write("time offset: 0");
            out.newLine();
            out.newLine();
            out.write("# ON: displays only forced subtitles, OFF: shows everything");
            out.newLine();
            out.write("forced subs: OFF");
            out.newLine();
            out.newLine();
            out.write("# The palette of the generated file");
            out.newLine();
            out.write("palette: ");
            for (i = 0; i < palette.getSize(); ++i) {
                int[] rbg = palette.getRGB(i);
                int val = rbg[0] << 16 | rbg[1] << 8 | rbg[2];
                out.write(ToolBox.toHexLeftZeroPadded(val, 6).substring(2));
                if (i == palette.getSize() - 1) continue;
                out.write(", ");
            }
            out.newLine();
            out.newLine();
            out.write("# Custom colors (transp idxs and the four colors)");
            out.newLine();
            out.write("custom colors: OFF, tridx: 1000, colors: 000000, 444444, 888888, cccccc");
            out.newLine();
            out.newLine();
            out.write("# Language index in use");
            out.newLine();
            out.write("langidx: 0");
            out.newLine();
            out.newLine();
            out.write("# " + Constants.LANGUAGES[configuration.getLanguageIdx()][0]);
            out.newLine();
            out.write("id: " + Constants.LANGUAGES[configuration.getLanguageIdx()][1] + ", index: 0");
            out.newLine();
            out.write("# Decomment next line to activate alternative name in DirectVobSub / Windows Media Player 6.x");
            out.newLine();
            out.write("# alt: " + Constants.LANGUAGES[configuration.getLanguageIdx()][0]);
            out.newLine();
            out.write("# Vob/Cell ID: 1, 1 (PTS: 0)");
            out.newLine();
            for (i = 0; i < timestamps.length; ++i) {
                out.write("timestamp: " + TimeUtils.ptsToTimeStrIdx(timestamps[i]));
                out.write(", filepos: " + ToolBox.toHexLeftZeroPadded(offsets[i], 9).substring(2));
                out.newLine();
            }
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }
}

