/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.BitmapBounds;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.ImageObjectFragment;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.dvd.DvdSubtitleStream;
import bdsup2sub.supstream.dvd.IfoParser;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.supstream.dvd.SupDvdUtil;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.ByteUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class SupDvd
implements DvdSubtitleStream {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private List<SubPictureDVD> subPictures = new ArrayList<SubPictureDVD>();
    private int screenWidth = 720;
    private int screenHeight = 576;
    private int languageIdx;
    private Palette srcPalette;
    private Palette palette;
    private Bitmap bitmap;
    private FileBuffer fileBuffer;
    private int primaryColorIndex;
    private int numForcedFrames;
    private static int[] lastAlpha = new int[]{0, 15, 15, 15};

    public SupDvd(String supFile, String ifoFile) throws CoreException {
        IfoParser ifoParser = new IfoParser(ifoFile);
        this.screenHeight = ifoParser.getScreenHeight();
        this.screenWidth = ifoParser.getScreenWidth();
        this.languageIdx = ifoParser.getLanguageIdx();
        this.srcPalette = ifoParser.getSrcPalette();
        this.readSupFile(supFile);
    }

    private void readSupFile(String supFile) throws CoreException {
        try {
            long offset = 0L;
            this.fileBuffer = new FileBuffer(supFile);
            long size = this.fileBuffer.getSize();
            Core.setProgressMax((int)size);
            int i = 0;
            do {
                logger.info("# " + ++i + "\n");
                Core.setProgress(offset);
                logger.trace("Offset: " + ToolBox.toHexLeftZeroPadded(offset, 8) + "\n");
            } while ((offset = this.readSupFrame(offset, this.fileBuffer)) < size);
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
        logger.info("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    private long readSupFrame(long offset, FileBuffer buffer) throws CoreException {
        try {
            long startOffset = offset;
            if (buffer.getWord(offset) != 21328) {
                throw new CoreException("Missing packet identifier at offset " + ToolBox.toHexLeftZeroPadded(offset, 8));
            }
            SubPictureDVD pic = new SubPictureDVD();
            pic.setOffset(offset);
            pic.setWidth(this.screenWidth);
            pic.setHeight(this.screenHeight);
            int pts = buffer.getDWordLE(offset += 2L);
            pic.setStartTime(pts);
            int length = buffer.getWord(offset += 8L);
            int ctrlOfsRel = buffer.getWord(offset += 2L);
            int rleSize = ctrlOfsRel - 2;
            int ctrlSize = length - ctrlOfsRel - 2;
            if (ctrlSize < 0) {
                throw new CoreException("Invalid control buffer size");
            }
            long ctrlOffset = (long)ctrlOfsRel + offset;
            pic.setRleFragments(new ArrayList<ImageObjectFragment>(1));
            ImageObjectFragment rleFrag = new ImageObjectFragment(offset += 2L, rleSize);
            pic.getRleFragments().add(rleFrag);
            pic.setRleSize(rleSize);
            pic.setPal(new int[4]);
            pic.setAlpha(new int[4]);
            int alphaSum = 0;
            int[] alphaUpdate = new int[4];
            int delay = -1;
            boolean colorAlphaUpdate = false;
            logger.trace("SP_DCSQT at ofs: " + ToolBox.toHexLeftZeroPadded(ctrlOffset, 8) + "\n");
            byte[] ctrlHeader = new byte[ctrlSize];
            for (int i = 0; i < ctrlSize; ++i) {
                ctrlHeader[i] = (byte)buffer.getByte(ctrlOffset + (long)i);
            }
            try {
                int index = 0;
                int endSeqOfs = ByteUtils.getWord(ctrlHeader, index) - ctrlOfsRel - 2;
                if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                    logger.warn("Invalid end sequence offset -> no end time\n");
                    endSeqOfs = ctrlSize;
                }
                index += 2;
                block15: while (index < endSeqOfs) {
                    int cmd = ByteUtils.getByte(ctrlHeader, index++);
                    switch (cmd) {
                        case 0: {
                            pic.setForced(true);
                            ++this.numForcedFrames;
                            continue block15;
                        }
                        case 1: {
                            continue block15;
                        }
                        case 3: {
                            int b = ByteUtils.getByte(ctrlHeader, index++);
                            pic.getPal()[3] = b >> 4;
                            pic.getPal()[2] = b & 0xF;
                            b = ByteUtils.getByte(ctrlHeader, index++);
                            pic.getPal()[1] = b >> 4;
                            pic.getPal()[0] = b & 0xF;
                            logger.trace("Palette:   " + pic.getPal()[0] + ", " + pic.getPal()[1] + ", " + pic.getPal()[2] + ", " + pic.getPal()[3] + "\n");
                            continue block15;
                        }
                        case 4: {
                            int b = ByteUtils.getByte(ctrlHeader, index++);
                            pic.getAlpha()[3] = b >> 4;
                            pic.getAlpha()[2] = b & 0xF;
                            b = ByteUtils.getByte(ctrlHeader, index++);
                            pic.getAlpha()[1] = b >> 4;
                            pic.getAlpha()[0] = b & 0xF;
                            for (int i = 0; i < 4; ++i) {
                                alphaSum += pic.getAlpha()[i] & 0xFF;
                            }
                            logger.trace("Alpha:     " + pic.getAlpha()[0] + ", " + pic.getAlpha()[1] + ", " + pic.getAlpha()[2] + ", " + pic.getAlpha()[3] + "\n");
                            continue block15;
                        }
                        case 5: {
                            int xOfs = ByteUtils.getByte(ctrlHeader, index) << 4 | ByteUtils.getByte(ctrlHeader, index + 1) >> 4;
                            pic.setOfsX(xOfs);
                            pic.setImageWidth(((ByteUtils.getByte(ctrlHeader, index + 1) & 0xF) << 8 | ByteUtils.getByte(ctrlHeader, index + 2)) - xOfs + 1);
                            int yOfs = ByteUtils.getByte(ctrlHeader, index + 3) << 4 | ByteUtils.getByte(ctrlHeader, index + 4) >> 4;
                            pic.setOfsY(yOfs);
                            pic.setImageHeight(((ByteUtils.getByte(ctrlHeader, index + 4) & 0xF) << 8 | ByteUtils.getByte(ctrlHeader, index + 5)) - yOfs + 1);
                            logger.trace("Area info: (" + pic.getXOffset() + ", " + pic.getYOffset() + ") - (" + (pic.getXOffset() + pic.getImageWidth() - 1) + ", " + (pic.getYOffset() + pic.getImageHeight() - 1) + ")\n");
                            index += 6;
                            continue block15;
                        }
                        case 6: {
                            pic.setEvenOffset(ByteUtils.getWord(ctrlHeader, index) - 4);
                            pic.setOddOffset(ByteUtils.getWord(ctrlHeader, index + 2) - 4);
                            index += 4;
                            logger.trace("RLE ofs:   " + ToolBox.toHexLeftZeroPadded(pic.getEvenOffset(), 4) + ", " + ToolBox.toHexLeftZeroPadded(pic.getOddOffset(), 4) + "\n");
                            continue block15;
                        }
                        case 7: {
                            colorAlphaUpdate = true;
                            int alphaUpdateSum = 0;
                            int b = ByteUtils.getByte(ctrlHeader, index + 10);
                            alphaUpdate[3] = b >> 4;
                            alphaUpdate[2] = b & 0xF;
                            b = ByteUtils.getByte(ctrlHeader, index + 11);
                            alphaUpdate[1] = b >> 4;
                            alphaUpdate[0] = b & 0xF;
                            for (int i = 0; i < 4; ++i) {
                                alphaUpdateSum += alphaUpdate[i] & 0xFF;
                            }
                            if (alphaUpdateSum > alphaSum) {
                                alphaSum = alphaUpdateSum;
                                System.arraycopy(alphaUpdate, 0, pic.getAlpha(), 0, 4);
                                b = ByteUtils.getByte(ctrlHeader, index + 8);
                                pic.getPal()[3] = b >> 4;
                                pic.getPal()[2] = b & 0xF;
                                b = ByteUtils.getByte(ctrlHeader, index + 9);
                                pic.getPal()[1] = b >> 4;
                                pic.getPal()[0] = b & 0xF;
                            }
                            index = endSeqOfs;
                            delay = ByteUtils.getWord(ctrlHeader, index) * 1024;
                            endSeqOfs = ByteUtils.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                            if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                                logger.warn("Invalid end sequence offset -> no end time\n");
                                endSeqOfs = ctrlSize;
                            }
                            index += 4;
                            continue block15;
                        }
                        case 255: {
                            break block15;
                        }
                        default: {
                            logger.warn("Unknown control sequence " + ToolBox.toHexLeftZeroPadded(cmd, 2) + " skipped\n");
                            continue block15;
                        }
                    }
                }
                if (endSeqOfs != ctrlSize) {
                    int ctrlSeqCount = 1;
                    index = -1;
                    int nextIndex = endSeqOfs;
                    while (nextIndex != index) {
                        index = nextIndex;
                        delay = ByteUtils.getWord(ctrlHeader, index) * 1024;
                        nextIndex = ByteUtils.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                        ++ctrlSeqCount;
                    }
                    if (ctrlSeqCount > 2) {
                        logger.warn("Control sequence(s) ignored - result may be erratic.");
                    }
                    pic.setEndTime(pic.getStartTime() + (long)delay);
                } else {
                    pic.setEndTime(pic.getStartTime());
                }
                pic.storeOriginal();
                if (colorAlphaUpdate) {
                    logger.warn("Palette update/alpha fading detected - result may be erratic.\n");
                }
                if (alphaSum == 0) {
                    if (configuration.getFixZeroAlpha()) {
                        System.arraycopy(lastAlpha, 0, pic.getAlpha(), 0, 4);
                        logger.warn("Invisible caption due to zero alpha - used alpha info of last caption.\n");
                    } else {
                        logger.warn("Invisible caption due to zero alpha (not fixed due to user setting).\n");
                    }
                }
                lastAlpha = pic.getAlpha();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new CoreException("Index " + ex.getMessage() + " out of bounds in control header.");
            }
            this.subPictures.add(pic);
            return startOffset + (long)length + 10L;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    private void decode(SubPictureDVD pic) throws CoreException {
        this.palette = SupDvdUtil.decodePalette(pic, this.srcPalette);
        this.bitmap = SupDvdUtil.decodeImage(pic, this.fileBuffer, this.palette.getIndexOfMostTransparentPaletteEntry());
        BitmapBounds bounds = this.bitmap.getCroppingBounds(this.palette.getAlpha(), configuration.getAlphaCrop());
        if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
            int width = bounds.xMax - bounds.xMin + 1;
            int height = bounds.yMax - bounds.yMin + 1;
            if (width < 2) {
                width = 2;
            }
            if (height < 2) {
                height = 2;
            }
            this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, width, height);
            pic.setImageWidth(width);
            pic.setImageHeight(height);
            pic.setOfsX(pic.getOriginalX() + bounds.xMin);
            pic.setOfsY(pic.getOriginalY() + bounds.yMin);
        }
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette.getAlpha(), configuration.getAlphaThreshold(), this.palette.getY());
    }

    public int[] getFramePalette(int index) {
        return this.subPictures.get(index).getPal();
    }

    public int[] getOriginalFramePalette(int index) {
        return this.subPictures.get(index).getOriginalPal();
    }

    public int[] getFrameAlpha(int index) {
        return this.subPictures.get(index).getAlpha();
    }

    public int[] getOriginalFrameAlpha(int index) {
        return this.subPictures.get(index).getOriginalAlpha();
    }

    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette.getColorModel());
    }

    public Palette getPalette() {
        return this.palette;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette.getColorModel());
    }

    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    public int getFrameCount() {
        return this.subPictures.size();
    }

    public int getForcedFrameCount() {
        return this.numForcedFrames;
    }

    public boolean isForced(int index) {
        return this.subPictures.get(index).isForced();
    }

    public void close() {
        if (this.fileBuffer != null) {
            this.fileBuffer.close();
        }
    }

    public long getEndTime(int index) {
        return this.subPictures.get(index).getEndTime();
    }

    public long getStartTime(int index) {
        return this.subPictures.get(index).getStartTime();
    }

    public long getStartOffset(int index) {
        return this.subPictures.get(index).getOffset();
    }

    public int getLanguageIndex() {
        return this.languageIdx;
    }

    public Palette getSrcPalette() {
        return this.srcPalette;
    }

    public void setSrcPalette(Palette pal) {
        this.srcPalette = pal;
    }
}

