/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.core.Configuration;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.supstream.dvd.SupDvdUtil;

public final class SupDvdWriter {
    private static final Configuration configuration = Configuration.getInstance();
    private static final byte[] CONTROL_HEADER = new byte[]{0, 0, 0, 1, 3, 50, 16, 4, -1, -1, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, -1, 0, 0, 0, 0, 2, -1};

    private SupDvdWriter() {
    }

    public static byte[] createSupFrame(SubPictureDVD pic, Bitmap bm) {
        int controlHeaderLen;
        int forcedOfs;
        byte[] even = SupDvdUtil.encodeLines(bm, true);
        byte[] odd = SupDvdUtil.encodeLines(bm, false);
        if (pic.isForced()) {
            forcedOfs = 0;
            SupDvdWriter.CONTROL_HEADER[2] = 1;
            SupDvdWriter.CONTROL_HEADER[3] = 0;
            controlHeaderLen = CONTROL_HEADER.length;
        } else {
            forcedOfs = 1;
            SupDvdWriter.CONTROL_HEADER[2] = 0;
            SupDvdWriter.CONTROL_HEADER[3] = 1;
            controlHeaderLen = CONTROL_HEADER.length - 1;
        }
        int sizeRLE = even.length + odd.length;
        int bufSize = 14 + controlHeaderLen + sizeRLE;
        byte[] buf = new byte[bufSize];
        buf[0] = 83;
        buf[1] = 80;
        int pts = (int)pic.getStartTime();
        buf[5] = (byte)(pts >> 24);
        buf[4] = (byte)(pts >> 16);
        buf[3] = (byte)(pts >> 8);
        buf[2] = (byte)pts;
        int tmp = controlHeaderLen + sizeRLE + 4;
        buf[10] = (byte)(tmp >> 8);
        buf[11] = (byte)tmp;
        tmp = sizeRLE + 2;
        buf[12] = (byte)(tmp >> 8);
        buf[13] = (byte)tmp;
        int ofs = 14;
        for (byte b : even) {
            buf[ofs++] = b;
        }
        for (byte b : odd) {
            buf[ofs++] = b;
        }
        SupDvdWriter.CONTROL_HEADER[5] = (byte)((pic.getPal()[3] & 0xF) << 4 | pic.getPal()[2] & 0xF);
        SupDvdWriter.CONTROL_HEADER[6] = (byte)((pic.getPal()[1] & 0xF) << 4 | pic.getPal()[0] & 0xF);
        SupDvdWriter.CONTROL_HEADER[8] = (byte)((pic.getAlpha()[3] & 0xF) << 4 | pic.getAlpha()[2] & 0xF);
        SupDvdWriter.CONTROL_HEADER[9] = (byte)((pic.getAlpha()[1] & 0xF) << 4 | pic.getAlpha()[0] & 0xF);
        SupDvdWriter.CONTROL_HEADER[11] = (byte)(pic.getXOffset() >> 4 & 0xFF);
        tmp = pic.getXOffset() + bm.getWidth() - 1;
        SupDvdWriter.CONTROL_HEADER[12] = (byte)((pic.getXOffset() & 0xF) << 4 | tmp >> 8 & 0xF);
        SupDvdWriter.CONTROL_HEADER[13] = (byte)(tmp & 0xFF);
        int yOfs = pic.getYOffset() - configuration.getCropOffsetY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.getHeight() - pic.getImageHeight() - 2 * configuration.getCropOffsetY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        SupDvdWriter.CONTROL_HEADER[14] = (byte)(yOfs >> 4 & 0xFF);
        tmp = yOfs + bm.getHeight() - 1;
        SupDvdWriter.CONTROL_HEADER[15] = (byte)((yOfs & 0xF) << 4 | tmp >> 8 & 0xF);
        SupDvdWriter.CONTROL_HEADER[16] = (byte)(tmp & 0xFF);
        SupDvdWriter.CONTROL_HEADER[18] = 0;
        SupDvdWriter.CONTROL_HEADER[19] = 4;
        tmp = even.length + CONTROL_HEADER[19];
        SupDvdWriter.CONTROL_HEADER[20] = (byte)(tmp >> 8 & 0xFF);
        SupDvdWriter.CONTROL_HEADER[21] = (byte)(tmp & 0xFF);
        tmp = (int)((pic.getEndTime() - pic.getStartTime()) / 1024L);
        SupDvdWriter.CONTROL_HEADER[23] = (byte)(tmp >> 8 & 0xFF);
        SupDvdWriter.CONTROL_HEADER[24] = (byte)(tmp & 0xFF);
        tmp = sizeRLE + 22 + (pic.isForced() ? 1 : 0) + 4;
        SupDvdWriter.CONTROL_HEADER[forcedOfs + 0] = (byte)(tmp >> 8 & 0xFF);
        SupDvdWriter.CONTROL_HEADER[forcedOfs + 1] = (byte)(tmp & 0xFF);
        SupDvdWriter.CONTROL_HEADER[25] = (byte)(tmp >> 8 & 0xFF);
        SupDvdWriter.CONTROL_HEADER[26] = (byte)(tmp & 0xFF);
        for (int i = 0; i < controlHeaderLen; ++i) {
            buf[ofs++] = CONTROL_HEADER[forcedOfs + i];
        }
        return buf;
    }
}

