/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.tools;

import java.util.Vector;

class OctTreeQuantizer {
    private static final int MAX_LEVEL = 5;
    private OctTreeNode root;
    private int reduceColors;
    private int maximumColors;
    private int colors = 0;
    private Vector[] colorList;

    public OctTreeQuantizer() {
        this.setup(256);
        this.colorList = new Vector[6];
        for (int i = 0; i < 6; ++i) {
            this.colorList[i] = new Vector();
        }
        this.root = new OctTreeNode();
    }

    public void setup(int numColors) {
        this.maximumColors = numColors;
        this.reduceColors = Math.max(512, numColors * 2);
    }

    public void addPixels(int[] pixels, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            this.insertColor(pixels[i + offset]);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
    }

    public int getIndexForColor(int argb) {
        int alpha = argb >> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        OctTreeNode node = this.root;
        for (int level = 0; level <= 5; ++level) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((alpha & bit) != 0) {
                index += 8;
            }
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                return node.index;
            }
            if (child.isLeaf) {
                return child.index;
            }
            node = child;
        }
        return 0;
    }

    private void insertColor(int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        OctTreeNode node = this.root;
        for (int level = 0; level <= 5; ++level) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((alpha & bit) != 0) {
                index += 8;
            }
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                ++node.children;
                child = new OctTreeNode();
                child.parent = node;
                node.leaf[index] = child;
                node.isLeaf = false;
                this.colorList[level].addElement(child);
                if (level == 5) {
                    child.isLeaf = true;
                    child.count = 1;
                    child.totalAlpha = alpha;
                    child.totalRed = red;
                    child.totalGreen = green;
                    child.totalBlue = blue;
                    child.level = level;
                    ++this.colors;
                    return;
                }
                node = child;
                continue;
            }
            if (child.isLeaf) {
                ++child.count;
                child.totalAlpha += alpha;
                child.totalRed += red;
                child.totalGreen += green;
                child.totalBlue += blue;
                return;
            }
            node = child;
        }
    }

    private void reduceTree(int numColors) {
        for (int level = 4; level >= 0; --level) {
            Vector v = this.colorList[level];
            if (v == null || v.size() <= 0) continue;
            for (int j = 0; j < v.size(); ++j) {
                OctTreeNode node = (OctTreeNode)v.elementAt(j);
                if (node.children <= 0) continue;
                for (int i = 0; i < node.leaf.length; ++i) {
                    OctTreeNode child = node.leaf[i];
                    if (child == null) continue;
                    node.count += child.count;
                    node.totalAlpha += child.totalAlpha;
                    node.totalRed += child.totalRed;
                    node.totalGreen += child.totalGreen;
                    node.totalBlue += child.totalBlue;
                    node.leaf[i] = null;
                    --node.children;
                    --this.colors;
                    this.colorList[level + 1].removeElement(child);
                }
                node.isLeaf = true;
                ++this.colors;
                if (this.colors > numColors) continue;
                return;
            }
        }
    }

    public int[] buildColorTable() {
        int[] table = new int[this.colors];
        this.buildColorTable(this.root, table, 0);
        return table;
    }

    public void buildColorTable(int[] pixels, int[] table) {
        int count = pixels.length;
        this.maximumColors = table.length;
        for (int pixel : pixels) {
            this.insertColor(pixel);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        this.buildColorTable(this.root, table, 0);
    }

    private int buildColorTable(OctTreeNode node, int[] table, int index) {
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        if (node.isLeaf) {
            int count = node.count;
            table[index] = node.totalAlpha / count << 24 | node.totalRed / count << 16 | node.totalGreen / count << 8 | node.totalBlue / count;
            node.index = index++;
        } else {
            for (int i = 0; i < node.leaf.length; ++i) {
                if (node.leaf[i] == null) continue;
                node.index = index;
                index = this.buildColorTable(node.leaf[i], table, index);
            }
        }
        return index;
    }

    class OctTreeNode {
        int children;
        int level;
        OctTreeNode parent;
        OctTreeNode[] leaf = new OctTreeNode[16];
        boolean isLeaf;
        int count;
        int totalAlpha;
        int totalRed;
        int totalGreen;
        int totalBlue;
        int index;

        OctTreeNode() {
        }
    }
}

