/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.utils;

import bdsup2sub.tools.JFileFilter;
import bdsup2sub.utils.FilenameUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolBox {
    private static final DecimalFormat FPS_FORMATTER = new DecimalFormat("##.###", DecimalFormatSymbols.getInstance(Locale.US));

    public static String leftZeroPad(int value, int width) {
        return String.format("%0" + width + "d", value);
    }

    public static String toHexLeftZeroPadded(long value, int width) {
        return String.format("0x%0" + width + "x", value);
    }

    public static String formatDouble(double value) {
        return FPS_FORMATTER.format(value);
    }

    public static void setString(byte[] buffer, int index, String s) {
        for (int i = 0; i < s.length(); ++i) {
            buffer[index + i] = (byte)s.charAt(i);
        }
    }

    public static void showException(Throwable ex) {
        StackTraceElement[] ste;
        String m = "<html>";
        m = m + ex.getClass().getName() + "<p>";
        if (ex.getMessage() != null) {
            m = m + ex.getMessage() + "<p>";
        }
        for (StackTraceElement e : ste = ex.getStackTrace()) {
            m = m + e.toString() + "<p>";
        }
        m = m + "</html>";
        ex.printStackTrace();
        JOptionPane.showMessageDialog(null, m, "Error", 0);
    }

    public static String getFilename(String path, String filename, List<String> extensions, boolean loadDialog, Component parent) {
        int returnVal;
        File file;
        if (path == null || path.isEmpty()) {
            path = ".";
        }
        JFileChooser fileChooser = new JFileChooser(path);
        if (extensions != null) {
            JFileFilter fileFilter = new JFileFilter();
            for (String extension : extensions) {
                fileFilter.addExtension(extension);
            }
            fileChooser.setFileFilter(fileFilter);
        }
        fileChooser.setFileSelectionMode(0);
        if (filename != null && !filename.isEmpty() && (file = new File(FilenameUtils.addSeparator(path) + filename)).canRead()) {
            fileChooser.setSelectedFile(file);
        }
        if (!loadDialog) {
            fileChooser.setDialogType(1);
        }
        if ((returnVal = fileChooser.showDialog(parent, null)) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static byte[] getFileID(String fname, int num) {
        byte[] buf = new byte[num];
        File f = new File(fname);
        if (f.length() < (long)num) {
            return null;
        }
        try {
            FileInputStream fi = new FileInputStream(fname);
            fi.read(buf);
            fi.close();
        }
        catch (Exception ex) {
            return null;
        }
        return buf;
    }

    public static int getInt(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static double getDouble(String s) {
        try {
            return Double.parseDouble(s.trim());
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
    }
}

