/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.bitmap;

import bdsup2sub.bitmap.ColorSpaceUtils;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;

public class Palette {
    private final int size;
    private final byte[] r;
    private final byte[] g;
    private final byte[] b;
    private final byte[] a;
    private final byte[] y;
    private final byte[] cb;
    private final byte[] cr;
    private final boolean useBT601;

    public Palette(int size, boolean useBT601) {
        this.size = size;
        this.useBT601 = useBT601;
        this.r = new byte[size];
        this.g = new byte[size];
        this.b = new byte[size];
        this.a = new byte[size];
        this.y = new byte[size];
        this.cb = new byte[size];
        this.cr = new byte[size];
        int[] yCbCr = ColorSpaceUtils.RGB2YCbCr(0, 0, 0, useBT601);
        for (int i = 0; i < size; ++i) {
            this.a[i] = 0;
            this.r[i] = 0;
            this.g[i] = 0;
            this.b[i] = 0;
            this.y[i] = (byte)yCbCr[0];
            this.cb[i] = (byte)yCbCr[1];
            this.cr[i] = (byte)yCbCr[2];
        }
    }

    public Palette(int size) {
        this(size, false);
    }

    public Palette(byte[] red, byte[] green, byte[] blue, byte[] alpha, boolean useBT601) {
        this.size = red.length;
        this.useBT601 = useBT601;
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        this.a = new byte[this.size];
        this.y = new byte[this.size];
        this.cb = new byte[this.size];
        this.cr = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = alpha[i];
            this.r[i] = red[i];
            this.g[i] = green[i];
            this.b[i] = blue[i];
            int[] yCbCr = ColorSpaceUtils.RGB2YCbCr(this.r[i] & 0xFF, this.g[i] & 0xFF, this.b[i] & 0xFF, useBT601);
            this.y[i] = (byte)yCbCr[0];
            this.cb[i] = (byte)yCbCr[1];
            this.cr[i] = (byte)yCbCr[2];
        }
    }

    public Palette(byte[] red, byte[] green, byte[] blue, byte[] alpha) {
        this(red, green, blue, alpha, false);
    }

    public Palette(Palette palette) {
        this.size = palette.getSize();
        this.useBT601 = palette.usesBT601();
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        this.a = new byte[this.size];
        this.y = new byte[this.size];
        this.cb = new byte[this.size];
        this.cr = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = palette.a[i];
            this.r[i] = palette.r[i];
            this.g[i] = palette.g[i];
            this.b[i] = palette.b[i];
            this.y[i] = palette.y[i];
            this.cb[i] = palette.cb[i];
            this.cr[i] = palette.cr[i];
        }
    }

    public ColorModel getColorModel() {
        return new IndexColorModel(8, this.size, this.r, this.g, this.b, this.a);
    }

    public void setColor(int index, Color c) {
        this.setRGB(index, c.getRed(), c.getGreen(), c.getBlue());
        this.setAlpha(index, c.getAlpha());
    }

    public void setARGB(int index, int c) {
        this.setColor(index, new Color(c, true));
    }

    public Color getColor(int index) {
        return new Color(this.r[index] & 0xFF, this.g[index] & 0xFF, this.b[index] & 0xFF, this.a[index] & 0xFF);
    }

    public int getARGB(int index) {
        return (this.a[index] & 0xFF) << 24 | (this.r[index] & 0xFF) << 16 | (this.g[index] & 0xFF) << 8 | this.b[index] & 0xFF;
    }

    public void setRGB(int index, int red, int green, int blue) {
        this.r[index] = (byte)red;
        this.g[index] = (byte)green;
        this.b[index] = (byte)blue;
        int[] yCbCr = ColorSpaceUtils.RGB2YCbCr(red, green, blue, this.useBT601);
        this.y[index] = (byte)yCbCr[0];
        this.cb[index] = (byte)yCbCr[1];
        this.cr[index] = (byte)yCbCr[2];
    }

    public void setYCbCr(int index, int yn, int cbn, int crn) {
        this.y[index] = (byte)yn;
        this.cb[index] = (byte)cbn;
        this.cr[index] = (byte)crn;
        int[] rgb = ColorSpaceUtils.YCbCr2RGB(yn, cbn, crn, this.useBT601);
        this.r[index] = (byte)rgb[0];
        this.g[index] = (byte)rgb[1];
        this.b[index] = (byte)rgb[2];
    }

    public void setAlpha(int index, int alpha) {
        this.a[index] = (byte)alpha;
    }

    public int getAlpha(int index) {
        return this.a[index] & 0xFF;
    }

    public byte[] getAlpha() {
        return Arrays.copyOf(this.a, this.a.length);
    }

    public int[] getRGB(int index) {
        int[] rgb = new int[]{this.r[index] & 0xFF, this.g[index] & 0xFF, this.b[index] & 0xFF};
        return rgb;
    }

    public int[] getYCbCr(int index) {
        int[] yCbCr = new int[]{this.y[index] & 0xFF, this.cb[index] & 0xFF, this.cr[index] & 0xFF};
        return yCbCr;
    }

    public byte[] getR() {
        return Arrays.copyOf(this.r, this.r.length);
    }

    public byte[] getG() {
        return Arrays.copyOf(this.g, this.g.length);
    }

    public byte[] getB() {
        return Arrays.copyOf(this.b, this.b.length);
    }

    public byte[] getY() {
        return Arrays.copyOf(this.y, this.y.length);
    }

    public byte[] getCb() {
        return Arrays.copyOf(this.cb, this.cb.length);
    }

    public byte[] getCr() {
        return Arrays.copyOf(this.cr, this.cr.length);
    }

    public int getSize() {
        return this.size;
    }

    public int getIndexOfMostTransparentPaletteEntry() {
        int transpIdx = 0;
        int minAlpha = 256;
        for (int i = 0; i < this.size; ++i) {
            if ((this.a[i] & 0xFF) >= minAlpha) continue;
            minAlpha = this.a[i] & 0xFF;
            transpIdx = i;
            if (minAlpha == 0) break;
        }
        return transpIdx;
    }

    public boolean usesBT601() {
        return this.useBT601;
    }
}

