/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.cli;

import bdsup2sub.cli.CommandLineOptions;
import bdsup2sub.core.CaptionMoveModeX;
import bdsup2sub.core.CaptionMoveModeY;
import bdsup2sub.core.Constants;
import bdsup2sub.core.ForcedFlagState;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.PaletteMode;
import bdsup2sub.core.Resolution;
import bdsup2sub.core.ScalingFilter;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.ToolBox;
import bdsup2sub.utils.optional.Optional;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private boolean printHelpMode;
    private boolean printVersionMode;
    private boolean cliMode;
    private File inputFile;
    private File outputFile;
    private Optional<OutputMode> outputMode = Optional.absent();
    private boolean loadSettings;
    private Optional<Resolution> resolution = Optional.absent();
    private Optional<Double> sourceFrameRate = Optional.absent();
    private Optional<Double> targetFrameRate = Optional.absent();
    private boolean convertFpsMode;
    private boolean synchronizeFpsMode;
    private Optional<Double> delay = Optional.absent();
    private Optional<ScalingFilter> scalingFilter = Optional.absent();
    private Optional<PaletteMode> paletteMode = Optional.absent();
    private Optional<Double> minimumDisplayTime = Optional.absent();
    private Optional<Double> maximumTimeDifference = Optional.absent();
    private Optional<CaptionMoveModeY> moveModeY = Optional.absent();
    private double screenRatio;
    private int moveYOffset;
    private Optional<CaptionMoveModeX> moveModeX = Optional.absent();
    private Optional<Integer> moveXOffset = Optional.absent();
    private Optional<Integer> cropLines = Optional.absent();
    private Optional<Integer> alphaCropThreshold = Optional.absent();
    private Optional<Double> scaleX = Optional.absent();
    private Optional<Double> scaleY = Optional.absent();
    private Optional<Boolean> exportPalette = Optional.absent();
    private Optional<Boolean> exportForcedSubtitlesOnly = Optional.absent();
    private Optional<ForcedFlagState> forcedFlagState = Optional.absent();
    private Optional<Boolean> swapCrCb = Optional.absent();
    private Optional<Boolean> fixInvisibleFrames = Optional.absent();
    private Optional<Boolean> verbose = Optional.absent();
    private Optional<Integer> alphaThreshold = Optional.absent();
    private Optional<Integer> lumLowMedThreshold = Optional.absent();
    private Optional<Integer> lumMedHighThreshold = Optional.absent();
    private Optional<Integer> languageIndex = Optional.absent();
    private File paletteFile;
    private Options options = new CommandLineOptions().getOptions();

    public void parse(String ... args) throws ParseException {
        CommandLine line = new PosixParser().parse(this.options, args);
        if (line.hasOption("h")) {
            this.printHelpMode = true;
        } else if (line.hasOption("V")) {
            this.printVersionMode = true;
        } else {
            this.parseInputFileOption(line);
            this.parseOutputFileOption(line);
            this.cliMode = line.hasOption("o");
            this.loadSettings = line.hasOption("L") || !this.cliMode;
            this.parseResolutionOption(line);
            this.parseTargetFramerateOption(line);
            this.parseConvertFramerateOption(line);
            this.parseDelayOption(line);
            this.parseScalingFilterOption(line);
            this.parsePaletteModeOption(line);
            this.parseMinimumDisplayTimeOption(line);
            this.parseMaxTimeDiffOption(line);
            this.parseMoveYOption(line);
            this.parseMoveXOption(line);
            this.parseCropLinesOption(line);
            this.parseAlphaCropThresholdOption(line);
            this.parseScaleOption(line);
            this.exportPalette = line.hasOption("P") ? Optional.of(Boolean.TRUE) : Optional.absent();
            this.exportForcedSubtitlesOnly = line.hasOption("D") ? Optional.of(Boolean.TRUE) : Optional.absent();
            this.parseForcedFlagOption(line);
            this.swapCrCb = line.hasOption("w") ? Optional.of(Boolean.TRUE) : Optional.absent();
            this.fixInvisibleFrames = line.hasOption("i") ? Optional.of(Boolean.TRUE) : Optional.absent();
            this.verbose = line.hasOption("v") ? Optional.of(Boolean.TRUE) : Optional.absent();
            this.parseAlphaThresholdOption(line);
            this.parseLuminanceThresholdOption(line);
            this.parseLanguageCodeOption(line);
            this.parsePaletteFileOption(line);
        }
    }

    private void parseInputFileOption(CommandLine line) throws ParseException {
        if (line.getArgList().isEmpty() && line.hasOption("o")) {
            throw new ParseException("Missing input file.");
        }
        if (line.getArgList().size() > 1) {
            throw new ParseException("Too many input files.");
        }
        if (line.getArgList().size() == 1) {
            this.inputFile = new File(line.getArgList().get(0).toString());
            if (!this.inputFile.exists()) {
                throw new ParseException("Input file not found: " + this.inputFile.getAbsolutePath());
            }
        }
    }

    private void parseOutputFileOption(CommandLine line) throws ParseException {
        if (line.hasOption("o")) {
            String value = line.getOptionValue("o");
            this.outputFile = new File(value);
            String extension = FilenameUtils.getExtension(value);
            if (extension.isEmpty()) {
                throw new ParseException("No extension given for output " + this.outputFile);
            }
            if (extension.equalsIgnoreCase("sup")) {
                this.outputMode = Optional.of(OutputMode.BDSUP);
            } else if (extension.equalsIgnoreCase("sub") || extension.equals("idx")) {
                this.outputMode = Optional.of(OutputMode.VOBSUB);
            } else if (extension.equalsIgnoreCase("xml")) {
                this.outputMode = Optional.of(OutputMode.XML);
            } else if (extension.equalsIgnoreCase("ifo")) {
                this.outputMode = Optional.of(OutputMode.SUPIFO);
            } else {
                throw new ParseException("Unknown extension of output " + this.outputFile);
            }
        }
    }

    private void parseResolutionOption(CommandLine line) throws ParseException {
        String value;
        if (line.hasOption("r") && !(value = line.getOptionValue("r")).equalsIgnoreCase("keep")) {
            if (value.equalsIgnoreCase("pal") || value.equalsIgnoreCase("576")) {
                this.resolution = Optional.of(Resolution.PAL);
            } else if (value.equalsIgnoreCase("ntsc") || value.equalsIgnoreCase("480")) {
                this.resolution = Optional.of(Resolution.NTSC);
            } else if (value.equalsIgnoreCase("720p") || value.equalsIgnoreCase("720")) {
                this.resolution = Optional.of(Resolution.HD_720);
            } else if (value.equalsIgnoreCase("1440x1080")) {
                this.resolution = Optional.of(Resolution.HD_1440x1080);
            } else if (value.equalsIgnoreCase("1080p") || value.equalsIgnoreCase("1080")) {
                this.resolution = Optional.of(Resolution.HD_1080);
            } else {
                throw new ParseException("Illegal resolution: " + value);
            }
        }
    }

    private void parseTargetFramerateOption(CommandLine line) throws ParseException {
        if (line.hasOption("T")) {
            this.synchronizeFpsMode = true;
            String value = line.getOptionValue("T");
            if (!value.equalsIgnoreCase("keep")) {
                this.targetFrameRate = Optional.of(SubtitleUtils.getFps(value));
                if (this.targetFrameRate.get() <= 0.0) {
                    throw new ParseException("Invalid target framerate: " + value);
                }
            }
        }
    }

    private void parseConvertFramerateOption(CommandLine line) throws ParseException {
        if (line.hasOption("C")) {
            this.convertFpsMode = true;
            if (line.getOptionValues("C").length != 2) {
                throw new ParseException("2 arguments needed for framerate conversion.");
            }
            String value = line.getOptionValues("C")[0];
            if (!value.equalsIgnoreCase("auto")) {
                this.sourceFrameRate = Optional.of(SubtitleUtils.getFps(value));
                if (this.sourceFrameRate.get() <= 0.0) {
                    throw new ParseException("Invalid source framerate: " + value);
                }
            }
            value = line.getOptionValues("C")[1];
            this.targetFrameRate = Optional.of(SubtitleUtils.getFps(value));
            if (this.targetFrameRate.get() <= 0.0) {
                throw new ParseException("Invalid target framerate: " + value);
            }
        }
    }

    private void parseDelayOption(CommandLine line) throws ParseException {
        if (line.hasOption("d")) {
            String value = line.getOptionValue("d");
            try {
                this.delay = Optional.of(Double.parseDouble(value.trim()));
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Illegal delay value: " + value);
            }
        }
    }

    private void parseScalingFilterOption(CommandLine line) throws ParseException {
        if (line.hasOption("f")) {
            String value = line.getOptionValue("f");
            boolean found = false;
            for (ScalingFilter f : ScalingFilter.values()) {
                if (!f.toString().equalsIgnoreCase(value)) continue;
                this.scalingFilter = Optional.of(f);
                found = true;
                break;
            }
            if (!found) {
                throw new ParseException("Illegal scaling filter value: " + value);
            }
        }
    }

    private void parsePaletteModeOption(CommandLine line) throws ParseException {
        if (line.hasOption("p")) {
            String value = line.getOptionValue("p");
            if (value.equalsIgnoreCase("keep")) {
                this.paletteMode = Optional.of(PaletteMode.KEEP_EXISTING);
            } else if (value.equalsIgnoreCase("create")) {
                this.paletteMode = Optional.of(PaletteMode.CREATE_NEW);
            } else if (value.equalsIgnoreCase("dither")) {
                this.paletteMode = Optional.of(PaletteMode.CREATE_DITHERED);
            } else {
                throw new ParseException("Invalid palette mode: " + value);
            }
        }
    }

    private void parseMinimumDisplayTimeOption(CommandLine line) throws ParseException {
        if (line.hasOption("m")) {
            String value = line.getOptionValue("m");
            try {
                this.minimumDisplayTime = Optional.of(Double.parseDouble(value.trim()));
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Illegal minimum display time value: " + value);
            }
            if (this.minimumDisplayTime.get() <= 0.0) {
                throw new ParseException("Illegal minimum display time value: " + value);
            }
        }
    }

    private void parseMaxTimeDiffOption(CommandLine line) throws ParseException {
        if (line.hasOption("x")) {
            String value = line.getOptionValue("x");
            try {
                this.maximumTimeDifference = Optional.of(Double.parseDouble(value.trim()));
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Illegal maximum merge time difference value: " + value);
            }
            if (this.maximumTimeDifference.get() < 0.0) {
                throw new ParseException("Illegal maximum merge time difference value: " + value);
            }
        }
    }

    private void parseMoveYOption(CommandLine line) throws ParseException {
        if (line.hasOption("I") || line.hasOption("O")) {
            String option;
            this.moveModeY = line.hasOption("I") ? Optional.of(CaptionMoveModeY.MOVE_INSIDE_BOUNDS) : Optional.of(CaptionMoveModeY.MOVE_OUTSIDE_BOUNDS);
            String string = option = line.hasOption("I") ? "I" : "O";
            if (line.getOptionValues(option).length != 2) {
                throw new ParseException("2 arguments needed for moving captions.");
            }
            this.screenRatio = ToolBox.getDouble(line.getOptionValues(option)[0]);
            if (this.screenRatio <= 1.7777777777777777) {
                throw new ParseException("Invalid screen ratio: " + this.screenRatio);
            }
            this.moveYOffset = ToolBox.getInt(line.getOptionValues(option)[1]);
            if (this.moveYOffset < 0) {
                throw new ParseException("Invalid pixel offset: " + this.moveYOffset);
            }
        }
    }

    private void parseMoveXOption(CommandLine line) throws ParseException {
        if (line.hasOption("X")) {
            if (line.getOptionValues("X") == null || line.getOptionValues("X").length < 1) {
                throw new ParseException("Missing argument for moving captions.");
            }
            String value = line.getOptionValues("X")[0];
            if (value.equalsIgnoreCase("left")) {
                this.moveModeX = Optional.of(CaptionMoveModeX.LEFT);
            } else if (value.equalsIgnoreCase("center")) {
                this.moveModeX = Optional.of(CaptionMoveModeX.CENTER);
            } else if (value.equalsIgnoreCase("right")) {
                this.moveModeX = Optional.of(CaptionMoveModeX.RIGHT);
            } else {
                throw new ParseException("Invalid move mode: " + value);
            }
            if ((this.moveModeX.get() == CaptionMoveModeX.LEFT || this.moveModeX.get() == CaptionMoveModeX.RIGHT) && line.getOptionValues("X").length > 1) {
                value = line.getOptionValues("X")[1];
                this.moveXOffset = Optional.of(ToolBox.getInt(value));
                if (this.moveXOffset.get() < 0) {
                    throw new ParseException("Invalid pixel offset: " + value);
                }
            }
        }
    }

    private void parseCropLinesOption(CommandLine line) throws ParseException {
        if (line.hasOption("c")) {
            String value = line.getOptionValue("c");
            this.cropLines = Optional.of(ToolBox.getInt(value.trim()));
            if (this.cropLines.get() < 0) {
                throw new ParseException("Invalid crop lines value: " + value);
            }
        }
    }

    private void parseAlphaCropThresholdOption(CommandLine line) throws ParseException {
        if (line.hasOption("a")) {
            String value = line.getOptionValue("a");
            this.alphaCropThreshold = Optional.of(ToolBox.getInt(value.trim()));
            if (this.alphaCropThreshold.get() < 0 || this.alphaCropThreshold.get() > 255) {
                throw new ParseException("Illegal number range for alpha cropping threshold: " + value);
            }
        }
    }

    private void parseScaleOption(CommandLine line) throws ParseException {
        if (line.hasOption("S")) {
            if (line.getOptionValues("S").length != 2) {
                throw new ParseException("2 arguments needed for scaling.");
            }
            String value = line.getOptionValues("S")[0];
            this.scaleX = Optional.of(ToolBox.getDouble(value));
            if (this.scaleX.get() < 0.5 || this.scaleX.get() > 2.0) {
                throw new ParseException("Invalid x scaling factor: " + value);
            }
            value = line.getOptionValues("S")[1];
            this.scaleY = Optional.of(ToolBox.getDouble(value));
            if (this.scaleY.get() < 0.5 || this.scaleY.get() > 2.0) {
                throw new ParseException("Invalid y scaling factor: " + value);
            }
        }
    }

    private void parseForcedFlagOption(CommandLine line) throws ParseException {
        if (line.hasOption("F")) {
            String value = line.getOptionValue("F");
            if (value.equalsIgnoreCase("set")) {
                this.forcedFlagState = Optional.of(ForcedFlagState.SET);
            } else if (value.equalsIgnoreCase("clear")) {
                this.forcedFlagState = Optional.of(ForcedFlagState.CLEAR);
            } else {
                throw new ParseException("Invalid forced flag state: " + value);
            }
        }
    }

    private void parseAlphaThresholdOption(CommandLine line) throws ParseException {
        if (line.hasOption("A")) {
            String value = line.getOptionValue("A");
            this.alphaThreshold = Optional.of(ToolBox.getInt(value.trim()));
            if (this.alphaThreshold.get() < 0 || this.alphaThreshold.get() > 255) {
                throw new ParseException("Illegal number range for alpha threshold: " + value);
            }
        }
    }

    private void parseLuminanceThresholdOption(CommandLine line) throws ParseException {
        String value;
        if (line.hasOption("M")) {
            value = line.getOptionValue("M");
            this.lumLowMedThreshold = Optional.of(ToolBox.getInt(value.trim()));
            if (this.lumLowMedThreshold.get() < 0 || this.lumLowMedThreshold.get() > 255) {
                throw new ParseException("Illegal number range for luminance threshold: " + value);
            }
        }
        if (line.hasOption("H")) {
            value = line.getOptionValue("H");
            this.lumMedHighThreshold = Optional.of(ToolBox.getInt(value.trim()));
            if (this.lumMedHighThreshold.get() < 0 || this.lumMedHighThreshold.get() > 255) {
                throw new ParseException("Illegal number range for luminance threshold: " + value);
            }
        }
        if (this.lumLowMedThreshold.isPresent() || this.lumMedHighThreshold.isPresent()) {
            int medHigh;
            int lowMed = this.lumLowMedThreshold.isPresent() ? this.lumLowMedThreshold.get() : 160;
            int n = medHigh = this.lumMedHighThreshold.isPresent() ? this.lumMedHighThreshold.get() : 210;
            if (lowMed > medHigh) {
                throw new ParseException("Invalid luminance threshold values: " + this.lumLowMedThreshold + ", " + this.lumMedHighThreshold);
            }
        }
    }

    private void parseLanguageCodeOption(CommandLine line) throws ParseException {
        if (line.hasOption("l")) {
            String value = line.getOptionValue("l");
            boolean found = false;
            for (int i = 0; i < Constants.LANGUAGES.length; ++i) {
                if (!Constants.LANGUAGES[i][1].equalsIgnoreCase(value)) continue;
                this.languageIndex = Optional.of(i);
                found = true;
                break;
            }
            if (!found) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unknown language code: " + value + "\n");
                sb.append("Use one of the following 2 character codes:\n");
                for (String[] language : Constants.LANGUAGES) {
                    sb.append("    " + language[1] + " - " + language[0] + "\n");
                }
                throw new ParseException(sb.toString());
            }
        }
    }

    private void parsePaletteFileOption(CommandLine line) throws ParseException {
        if (line.hasOption("t")) {
            String value = line.getOptionValue("t");
            this.paletteFile = new File(value);
            if (!this.paletteFile.exists()) {
                throw new ParseException("Palette file not found: " + value);
            }
            if (!Arrays.equals("#COL".getBytes(), ToolBox.getFileID(value, 4))) {
                throw new ParseException("Invalid palette file: " + value);
            }
        }
    }

    public boolean isPrintHelpMode() {
        return this.printHelpMode;
    }

    public boolean isPrintVersionMode() {
        return this.printVersionMode;
    }

    public boolean isCliMode() {
        return this.cliMode;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public Optional<OutputMode> getOutputMode() {
        return this.outputMode;
    }

    public boolean isLoadSettings() {
        return this.loadSettings;
    }

    public Optional<Resolution> getResolution() {
        return this.resolution;
    }

    public Optional<Double> getSourceFrameRate() {
        return this.sourceFrameRate;
    }

    public Optional<Double> getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public boolean isConvertFpsMode() {
        return this.convertFpsMode;
    }

    public boolean isSynchronizeFpsMode() {
        return this.synchronizeFpsMode;
    }

    public Optional<Double> getDelay() {
        return this.delay;
    }

    public Optional<ScalingFilter> getScalingFilter() {
        return this.scalingFilter;
    }

    public Optional<PaletteMode> getPaletteMode() {
        return this.paletteMode;
    }

    public Optional<Double> getMinimumDisplayTime() {
        return this.minimumDisplayTime;
    }

    public Optional<Double> getMaximumTimeDifference() {
        return this.maximumTimeDifference;
    }

    public Optional<CaptionMoveModeY> getMoveModeY() {
        return this.moveModeY;
    }

    public int getMoveYOffset() {
        return this.moveYOffset;
    }

    public Optional<CaptionMoveModeX> getMoveModeX() {
        return this.moveModeX;
    }

    public Optional<Integer> getMoveXOffset() {
        return this.moveXOffset;
    }

    public double getScreenRatio() {
        return this.screenRatio;
    }

    public Optional<Integer> getCropLines() {
        return this.cropLines;
    }

    public Optional<Integer> getAlphaCropThreshold() {
        return this.alphaCropThreshold;
    }

    public Optional<Double> getScaleX() {
        return this.scaleX;
    }

    public Optional<Double> getScaleY() {
        return this.scaleY;
    }

    public Optional<Boolean> isExportPalette() {
        return this.exportPalette;
    }

    public Optional<Boolean> isExportForcedSubtitlesOnly() {
        return this.exportForcedSubtitlesOnly;
    }

    public Optional<ForcedFlagState> getForcedFlagState() {
        return this.forcedFlagState;
    }

    public Optional<Boolean> isSwapCrCb() {
        return this.swapCrCb;
    }

    public Optional<Boolean> isFixInvisibleFrames() {
        return this.fixInvisibleFrames;
    }

    public Optional<Boolean> isVerbose() {
        return this.verbose;
    }

    public Optional<Integer> getAlphaThreshold() {
        return this.alphaThreshold;
    }

    public Optional<Integer> getLumLowMedThreshold() {
        return this.lumLowMedThreshold;
    }

    public Optional<Integer> getLumMedHighThreshold() {
        return this.lumMedHighThreshold;
    }

    public Optional<Integer> getLanguageIndex() {
        return this.languageIndex;
    }

    public File getPaletteFile() {
        return this.paletteFile;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                Option opt1 = (Option)o1;
                Option opt2 = (Option)o2;
                int opt1Index = CommandLineOptions.OPTION_ORDER.indexOf(opt1.getOpt());
                int opt2Index = CommandLineOptions.OPTION_ORDER.indexOf(opt2.getOpt());
                return (int)Math.signum(opt1Index - opt2Index);
            }
        });
        formatter.setWidth(79);
        String command = System.getProperty("wrapper") == null ? "java -jar BDSup2Sub" : "bdsup2sub";
        formatter.printHelp(command + " [options] -o <output> <input>", this.options);
    }
}

