/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.core;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.BitmapWithPalette;
import bdsup2sub.bitmap.ErasePatch;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.CaptionMoveModeX;
import bdsup2sub.core.CaptionMoveModeY;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.CoreThreadState;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.InputMode;
import bdsup2sub.core.Logger;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.PaletteMode;
import bdsup2sub.core.Resolution;
import bdsup2sub.core.StreamID;
import bdsup2sub.gui.support.Progress;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.SubtitleStream;
import bdsup2sub.supstream.bd.SupBD;
import bdsup2sub.supstream.bd.SupBDWriter;
import bdsup2sub.supstream.bdnxml.SupXml;
import bdsup2sub.supstream.dvd.DvdSubtitleStream;
import bdsup2sub.supstream.dvd.IfoWriter;
import bdsup2sub.supstream.dvd.SubDvd;
import bdsup2sub.supstream.dvd.SubDvdWriter;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.supstream.dvd.SupDvd;
import bdsup2sub.supstream.dvd.SupDvdUtil;
import bdsup2sub.supstream.dvd.SupDvdWriter;
import bdsup2sub.supstream.hd.SupHD;
import bdsup2sub.tools.EnhancedPngEncoder;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Core
extends Thread {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private static Palette currentDVDPalette = new Palette(Constants.DEFAULT_PALETTE_RED, Constants.DEFAULT_PALETTE_GREEN, Constants.DEFAULT_PALETTE_BLUE, Constants.DEFAULT_PALETTE_ALPHA, true);
    private static final int MIN_IMAGE_DIMENSION = 8;
    private static Palette defaultSourceDVDPalette;
    private static Palette currentSourceDVDPalette;
    private static final int[] DEFAULT_ALPHA;
    private static Bitmap trgBitmapUnpatched;
    private static Bitmap trgBitmap;
    private static Palette trgPal;
    private static SubPictureDVD subVobTrg;
    private static SupBD supBD;
    private static SupHD supHD;
    private static SupXml supXml;
    private static SubDvd subDVD;
    private static SupDvd supDVD;
    private static SubtitleStream subtitleStream;
    private static SubPicture[] subPictures;
    private static InputMode inMode;
    private static boolean useBT601;
    private static String fileName;
    private static Progress progress;
    private static int progressMax;
    private static int progressLast;
    private static RunType runType;
    private static CoreThreadState state;
    private static Exception threadException;
    private static volatile boolean ready;
    private static final Object semaphore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        state = CoreThreadState.ACTIVE;
        threadException = null;
        try {
            switch (runType) {
                case CREATESUB: {
                    Core.writeSub(fileName);
                    return;
                }
                case READSUP: {
                    Core.readSup(fileName);
                    return;
                }
                case READVOBSUB: {
                    Core.readVobSub(fileName);
                    return;
                }
                case READSUPIFO: {
                    Core.readSupIfo(fileName);
                    return;
                }
                case READXML: {
                    Core.readXml(fileName);
                    return;
                }
                case MOVEALL: {
                    Core.moveAllToBounds();
                    return;
                }
            }
            return;
        }
        catch (Exception ex) {
            threadException = ex;
            return;
        }
        finally {
            state = CoreThreadState.INACTIVE;
        }
    }

    public static void close() {
        ready = false;
        if (supBD != null) {
            supBD.close();
        }
        if (supHD != null) {
            supHD.close();
        }
        if (supXml != null) {
            supXml.close();
        }
        if (subDVD != null) {
            subDVD.close();
        }
        if (supDVD != null) {
            supDVD.close();
        }
    }

    public static void exit() {
        configuration.storeConfig();
        if (supBD != null) {
            supBD.close();
        }
        if (supHD != null) {
            supHD.close();
        }
        if (supXml != null) {
            supXml.close();
        }
        if (subDVD != null) {
            subDVD.close();
        }
        if (supDVD != null) {
            supDVD.close();
        }
    }

    public static void readStreamThreaded(String fname, JFrame parent, StreamID sid) throws Exception {
        File ifoFile;
        boolean xml = FilenameUtils.getExtension(fname).equalsIgnoreCase("xml");
        boolean idx = FilenameUtils.getExtension(fname).equalsIgnoreCase("idx");
        boolean ifo = FilenameUtils.getExtension(fname).equalsIgnoreCase("ifo");
        fileName = fname;
        progressMax = (int)new File(fname).length();
        progressLast = 0;
        progress = new Progress(parent);
        progress.setTitle("Loading");
        progress.setText("Loading subtitle stream");
        runType = xml || sid == StreamID.XML ? RunType.READXML : (idx || sid == StreamID.DVDSUB || sid == StreamID.IDX ? RunType.READVOBSUB : (ifo || sid == StreamID.IFO ? RunType.READSUPIFO : ((ifoFile = new File(FilenameUtils.removeExtension(fname) + ".ifo")).exists() ? RunType.READSUPIFO : RunType.READSUP)));
        configuration.setCurrentStreamID(sid);
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        state = CoreThreadState.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    public static void createSubThreaded(String fname, JFrame parent) throws Exception {
        fileName = fname;
        progressMax = subtitleStream.getFrameCount();
        progressLast = 0;
        progress = new Progress(parent);
        progress.setTitle("Exporting");
        OutputMode outputMode = configuration.getOutputMode();
        if (outputMode == OutputMode.VOBSUB) {
            progress.setText("Exporting SUB/IDX");
        } else if (outputMode == OutputMode.BDSUP) {
            progress.setText("Exporting SUP(BD)");
        } else if (outputMode == OutputMode.XML) {
            progress.setText("Exporting XML/PNG");
        } else {
            progress.setText("Exporting SUP/IFO");
        }
        runType = RunType.CREATESUB;
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        state = CoreThreadState.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    private static void determineFramePal(int index) {
        if (inMode != InputMode.VOBSUB && inMode != InputMode.SUPIFO || configuration.getPaletteMode() != PaletteMode.KEEP_EXISTING) {
            int[] rgbSrc = subtitleStream.getPalette().getRGB(subtitleStream.getPrimaryColorIndex());
            Palette trgPallete = currentDVDPalette;
            int minDistance = 0xFFFFFF;
            int colIdx = 0;
            for (int idx = 1; idx < trgPallete.getSize(); idx += 2) {
                int bd;
                int gd;
                int[] rgb = trgPallete.getRGB(idx);
                int rd = rgbSrc[0] - rgb[0];
                int distance = rd * rd + (gd = rgbSrc[1] - rgb[1]) * gd + (bd = rgbSrc[2] - rgb[2]) * bd;
                if (distance < minDistance) {
                    colIdx = idx;
                    minDistance = distance;
                    if (minDistance == 0) break;
                }
                if (idx != 1) continue;
                --idx;
            }
            int[] palFrame = new int[]{0, colIdx, colIdx == 1 ? colIdx + 2 : colIdx + 1, 0};
            subVobTrg.setAlpha(DEFAULT_ALPHA);
            subVobTrg.setPal(palFrame);
            trgPal = SupDvdUtil.decodePalette(subVobTrg, trgPallete);
        } else {
            Palette miniPal = new Palette(4, true);
            DvdSubtitleStream substreamDvd = inMode == InputMode.VOBSUB ? subDVD : supDVD;
            int[] alpha = substreamDvd.getFrameAlpha(index);
            int[] palFrame = substreamDvd.getFramePalette(index);
            for (int i = 0; i < 4; ++i) {
                int a = alpha[i] * 255 / 15;
                if (a >= configuration.getAlphaCrop()) {
                    miniPal.setARGB(i, currentSourceDVDPalette.getARGB(palFrame[i]));
                    miniPal.setAlpha(i, a);
                    continue;
                }
                miniPal.setARGB(i, 0);
            }
            subVobTrg.setAlpha(alpha);
            subVobTrg.setPal(palFrame);
            trgPal = miniPal;
        }
    }

    public static void readSup(String fname) throws CoreException {
        byte[] id;
        logger.info("Loading " + fname + "\n");
        logger.resetErrorCounter();
        logger.resetWarningCounter();
        String fnl = FilenameUtils.getName(fname.toLowerCase());
        for (int i = 0; i < Constants.LANGUAGES.length; ++i) {
            if (!fnl.contains(Constants.LANGUAGES[i][0].toLowerCase())) continue;
            configuration.setLanguageIdx(i);
            logger.info("Selected language '" + Constants.LANGUAGES[i][0] + " (" + Constants.LANGUAGES[i][1] + ")' by filename\n");
            break;
        }
        if (subtitleStream != null) {
            subtitleStream.close();
        }
        if ((id = ToolBox.getFileID(fname, 2)) != null && id[0] == 80 && id[1] == 71) {
            supBD = new SupBD(fname);
            subtitleStream = supBD;
            supHD = null;
            inMode = InputMode.BDSUP;
        } else {
            supHD = new SupHD(fname);
            subtitleStream = supHD;
            supBD = null;
            inMode = InputMode.HDDVDSUP;
        }
        subtitleStream.decode(0);
        subVobTrg = new SubPictureDVD();
        int maxLum = subtitleStream.getPalette().getY()[subtitleStream.getPrimaryColorIndex()] & 0xFF;
        int[] luminanceThreshold = new int[2];
        configuration.setLuminanceThreshold(luminanceThreshold);
        if (maxLum > 30) {
            luminanceThreshold[0] = maxLum * 2 / 3;
            luminanceThreshold[1] = maxLum / 3;
        } else {
            luminanceThreshold[0] = 210;
            luminanceThreshold[1] = 160;
        }
        if (subtitleStream == supBD) {
            configuration.setFpsSrc(supBD.getFps(0));
            configuration.setFpsSrcCertain(true);
            if (configuration.isKeepFps()) {
                configuration.setFpsTrg(configuration.getFPSSrc());
            }
        } else {
            useBT601 = false;
            configuration.setFpsSrcCertain(false);
            configuration.setFpsSrc(Framerate.FPS_23_976.getValue());
        }
    }

    public static void readXml(String fname) throws CoreException {
        logger.info("Loading " + fname + "\n");
        logger.resetErrorCounter();
        logger.resetWarningCounter();
        if (subtitleStream != null) {
            subtitleStream.close();
        }
        supXml = new SupXml(fname);
        subtitleStream = supXml;
        inMode = InputMode.XML;
        subtitleStream.decode(0);
        subVobTrg = new SubPictureDVD();
        int maxLum = subtitleStream.getPalette().getY()[subtitleStream.getPrimaryColorIndex()] & 0xFF;
        int[] luminanceThreshold = new int[2];
        configuration.setLuminanceThreshold(luminanceThreshold);
        if (maxLum > 30) {
            luminanceThreshold[0] = maxLum * 2 / 3;
            luminanceThreshold[1] = maxLum / 3;
        } else {
            luminanceThreshold[0] = 210;
            luminanceThreshold[1] = 160;
        }
        for (int i = 0; i < Constants.LANGUAGES.length; ++i) {
            if (!Constants.LANGUAGES[i][2].equalsIgnoreCase(supXml.getLanguage())) continue;
            configuration.setLanguageIdx(i);
            break;
        }
        configuration.setFpsSrc(supXml.getFps());
        configuration.setFpsSrcCertain(true);
        if (configuration.isKeepFps()) {
            configuration.setFpsTrg(configuration.getFPSSrc());
        }
    }

    public static void readVobSub(String fname) throws CoreException {
        Core.readDVDSubstream(fname, true);
    }

    public static void readSupIfo(String fname) throws CoreException {
        Core.readDVDSubstream(fname, false);
    }

    private static void readDVDSubstream(String fname, boolean isVobSub) throws CoreException {
        DvdSubtitleStream substreamDvd;
        String fnI;
        String fnS;
        logger.info("Loading " + fname + "\n");
        logger.resetErrorCounter();
        logger.resetWarningCounter();
        if (subtitleStream != null) {
            subtitleStream.close();
        }
        if (isVobSub) {
            if (configuration.getCurrentStreamID() == StreamID.DVDSUB) {
                fnS = fname;
                fnI = FilenameUtils.removeExtension(fname) + ".idx";
            } else {
                fnI = fname;
                fnS = FilenameUtils.removeExtension(fname) + ".sub";
            }
            subDVD = new SubDvd(fnS, fnI);
            subtitleStream = subDVD;
            inMode = InputMode.VOBSUB;
            substreamDvd = subDVD;
        } else {
            if (FilenameUtils.getExtension(fname).equalsIgnoreCase("ifo")) {
                fnI = fname;
                fnS = FilenameUtils.removeExtension(fname) + ".sup";
            } else {
                fnI = FilenameUtils.removeExtension(fname) + ".ifo";
                fnS = fname;
            }
            supDVD = new SupDvd(fnS, fnI);
            subtitleStream = supDVD;
            inMode = InputMode.SUPIFO;
            substreamDvd = supDVD;
        }
        subtitleStream.decode(0);
        subVobTrg = new SubPictureDVD();
        defaultSourceDVDPalette = substreamDvd.getSrcPalette();
        currentSourceDVDPalette = new Palette(defaultSourceDVDPalette);
        int primColIdx = subtitleStream.getPrimaryColorIndex();
        int yMax = subtitleStream.getPalette().getY()[primColIdx] & 0xFF;
        int[] luminanceThreshold = new int[2];
        configuration.setLuminanceThreshold(luminanceThreshold);
        if (yMax > 10) {
            int yMin = yMax;
            for (int i = 0; i < 4; ++i) {
                int y = subtitleStream.getPalette().getY()[i] & 0xFF;
                int a = subtitleStream.getPalette().getAlpha(i);
                if (y >= yMin || a <= configuration.getAlphaThreshold()) continue;
                yMin = y;
            }
            luminanceThreshold[0] = yMin + (yMax - yMin) * 9 / 10;
            luminanceThreshold[1] = yMin + (yMax - yMin) * 3 / 10;
        } else {
            luminanceThreshold[0] = 210;
            luminanceThreshold[1] = 160;
        }
        configuration.setLanguageIdx(substreamDvd.getLanguageIndex());
        int h = subtitleStream.getSubPicture(0).getHeight();
        switch (h) {
            case 480: {
                configuration.setFpsSrc(Framerate.NTSC.getValue());
                useBT601 = true;
                configuration.setFpsSrcCertain(true);
                break;
            }
            case 576: {
                configuration.setFpsSrc(Framerate.PAL.getValue());
                useBT601 = true;
                configuration.setFpsSrcCertain(true);
                break;
            }
            default: {
                useBT601 = false;
                configuration.setFpsSrc(Framerate.FPS_23_976.getValue());
                configuration.setFpsSrcCertain(false);
            }
        }
    }

    private static void validateTimes(int idx, SubPicture subPic, SubPicture subPicNext, SubPicture subPicPrev) {
        int minTimePTS;
        long nextStartTime;
        long lastEndTime;
        long startTime = subPic.getStartTime();
        long endTime = subPic.getEndTime();
        long delay = 450000L;
        ++idx;
        long l = lastEndTime = subPicPrev != null ? subPicPrev.getEndTime() : -1L;
        if (startTime < lastEndTime) {
            logger.warn("start time of frame " + idx + " < end of last frame -> fixed\n");
            startTime = lastEndTime;
        }
        long l2 = nextStartTime = subPicNext != null ? subPicNext.getStartTime() : 0L;
        if (nextStartTime == 0L) {
            nextStartTime = endTime > startTime ? endTime : startTime + 450000L;
        }
        if (endTime <= startTime) {
            if (endTime == 0L) {
                logger.warn("missing end time of frame " + idx + " -> fixed\n");
            } else {
                logger.warn("end time of frame " + idx + " <= start time -> fixed\n");
            }
            endTime = startTime + 450000L;
            if (endTime > nextStartTime) {
                endTime = nextStartTime;
            }
        } else if (endTime > nextStartTime) {
            logger.warn("end time of frame " + idx + " > start time of next frame -> fixed\n");
            endTime = nextStartTime;
        }
        if (endTime - startTime < (long)(minTimePTS = configuration.getMinTimePTS())) {
            if (configuration.getFixShortFrames()) {
                endTime = startTime + (long)minTimePTS;
                if (endTime > nextStartTime) {
                    endTime = nextStartTime;
                }
                logger.warn("duration of frame " + idx + " was shorter than " + ToolBox.formatDouble((double)minTimePTS / 90.0) + "ms -> fixed\n");
            } else {
                logger.warn("duration of frame " + idx + " is shorter than " + ToolBox.formatDouble((double)minTimePTS / 90.0) + "ms\n");
            }
        }
        if (subPic.getStartTime() != startTime) {
            subPic.setStartTime(SubtitleUtils.syncTimePTS(startTime, configuration.getFpsTrg(), configuration.getFpsTrg()));
        }
        if (subPic.getEndTime() != endTime) {
            subPic.setEndTime(SubtitleUtils.syncTimePTS(endTime, configuration.getFpsTrg(), configuration.getFpsTrg()));
        }
    }

    private static boolean updateTrgPic(int index) {
        int spaceTrg;
        int spaceSrc;
        double fy;
        double fx;
        SubPicture picSrc = subtitleStream.getSubPicture(index);
        SubPicture picTrg = subPictures[index];
        double scaleX = (double)picTrg.getWidth() / (double)picSrc.getWidth();
        double scaleY = (double)picTrg.getHeight() / (double)picSrc.getHeight();
        if (configuration.getApplyFreeScale()) {
            fx = configuration.getFreeScaleFactorX();
            fy = configuration.getFreeScaleFactorY();
        } else {
            fx = 1.0;
            fy = 1.0;
        }
        int wOld = picTrg.getImageWidth();
        int hOld = picTrg.getImageHeight();
        int wNew = (int)((double)picSrc.getImageWidth() * scaleX * fx + 0.5);
        if (wNew < 8) {
            wNew = picSrc.getImageWidth();
        } else if (wNew > picTrg.getWidth()) {
            wNew = picTrg.getWidth();
        }
        int hNew = (int)((double)picSrc.getImageHeight() * scaleY * fy + 0.5);
        if (hNew < 8) {
            hNew = picSrc.getImageHeight();
        } else if (hNew > picTrg.getHeight()) {
            hNew = picTrg.getHeight();
        }
        picTrg.setImageWidth(wNew);
        picTrg.setImageHeight(hNew);
        if (wNew != wOld) {
            int xOfs = (int)((double)picSrc.getXOffset() * scaleX + 0.5);
            spaceSrc = (int)((double)(picSrc.getWidth() - picSrc.getImageWidth()) * scaleX + 0.5);
            spaceTrg = picTrg.getWidth() - wNew;
            if ((xOfs += (spaceTrg - spaceSrc) / 2) < 0) {
                xOfs = 0;
            } else if (xOfs + wNew > picTrg.getWidth()) {
                xOfs = picTrg.getWidth() - wNew;
            }
            picTrg.setOfsX(xOfs);
        }
        if (hNew != hOld) {
            int yOfs = (int)((double)picSrc.getYOffset() * scaleY + 0.5);
            spaceSrc = (int)((double)(picSrc.getHeight() - picSrc.getImageHeight()) * scaleY + 0.5);
            spaceTrg = picTrg.getHeight() - hNew;
            if ((yOfs += (spaceTrg - spaceSrc) / 2) + hNew > picTrg.getHeight()) {
                yOfs = picTrg.getHeight() - hNew;
            }
            picTrg.setOfsY(yOfs);
        }
        return wNew != wOld || hNew != hOld;
    }

    public static void scanSubtitles() {
        SubPicture picSrc;
        double fy;
        double fx;
        double factTS;
        boolean convertFPS = configuration.getConvertFPS();
        subPictures = new SubPicture[subtitleStream.getFrameCount()];
        double d = factTS = convertFPS ? configuration.getFPSSrc() / configuration.getFpsTrg() : 1.0;
        if (!configuration.getConvertResolution() && Core.getNumFrames() > 0) {
            configuration.setOutputResolution(SubtitleUtils.getResolutionForDimension(Core.getSubPictureSrc(0).getWidth(), Core.getSubPictureSrc(0).getHeight()));
        }
        if (configuration.getApplyFreeScale()) {
            fx = configuration.getFreeScaleFactorX();
            fy = configuration.getFreeScaleFactorY();
        } else {
            fx = 1.0;
            fy = 1.0;
        }
        for (int i = 0; i < subPictures.length; ++i) {
            double scaleY;
            double scaleX;
            picSrc = subtitleStream.getSubPicture(i);
            Core.subPictures[i] = new SubPicture(picSrc);
            long ts = picSrc.getStartTime();
            long te = picSrc.getEndTime();
            int delayPTS = configuration.getDelayPTS();
            if (!convertFPS) {
                subPictures[i].setStartTime(ts + (long)delayPTS);
                subPictures[i].setEndTime(te + (long)delayPTS);
            } else {
                subPictures[i].setStartTime((long)((double)ts * factTS + 0.5) + (long)delayPTS);
                subPictures[i].setEndTime((long)((double)te * factTS + 0.5) + (long)delayPTS);
            }
            subPictures[i].setStartTime(SubtitleUtils.syncTimePTS(subPictures[i].getStartTime(), configuration.getFpsTrg(), configuration.getFpsTrg()));
            subPictures[i].setEndTime(SubtitleUtils.syncTimePTS(subPictures[i].getEndTime(), configuration.getFpsTrg(), configuration.getFpsTrg()));
            SubPicture picTrg = subPictures[i];
            switch (configuration.getForceAll()) {
                case SET: {
                    picTrg.setForced(true);
                    break;
                }
                case CLEAR: {
                    picTrg.setForced(false);
                }
            }
            if (configuration.getConvertResolution()) {
                picTrg.setWidth(configuration.getOutputResolution().getDimensions()[0]);
                picTrg.setHeight(configuration.getOutputResolution().getDimensions()[1]);
                scaleX = (double)picTrg.getWidth() / (double)picSrc.getWidth();
                scaleY = (double)picTrg.getHeight() / (double)picSrc.getHeight();
            } else {
                picTrg.setWidth(picSrc.getWidth());
                picTrg.setHeight(picSrc.getHeight());
                scaleX = 1.0;
                scaleY = 1.0;
            }
            int w = (int)((double)picSrc.getImageWidth() * scaleX * fx + 0.5);
            if (w < 8) {
                w = picSrc.getImageWidth();
            } else if (w > picTrg.getWidth()) {
                w = picTrg.getWidth();
            }
            int h = (int)((double)picSrc.getImageHeight() * scaleY * fy + 0.5);
            if (h < 8) {
                h = picSrc.getImageHeight();
            } else if (h > picTrg.getHeight()) {
                h = picTrg.getHeight();
            }
            picTrg.setImageWidth(w);
            picTrg.setImageHeight(h);
            int xOfs = (int)((double)picSrc.getXOffset() * scaleX + 0.5);
            int spaceSrc = (int)((double)(picSrc.getWidth() - picSrc.getImageWidth()) * scaleX + 0.5);
            int spaceTrg = picTrg.getWidth() - w;
            if ((xOfs += (spaceTrg - spaceSrc) / 2) < 0) {
                xOfs = 0;
            } else if (xOfs + w > picTrg.getWidth()) {
                xOfs = picTrg.getWidth() - w;
            }
            picTrg.setOfsX(xOfs);
            int yOfs = (int)((double)picSrc.getYOffset() * scaleY + 0.5);
            spaceSrc = (int)((double)(picSrc.getHeight() - picSrc.getImageHeight()) * scaleY + 0.5);
            spaceTrg = picTrg.getHeight() - h;
            if ((yOfs += (spaceTrg - spaceSrc) / 2) + h > picTrg.getHeight()) {
                yOfs = picTrg.getHeight() - h;
            }
            picTrg.setOfsY(yOfs);
        }
        SubPicture picPrev = null;
        for (int i = 0; i < subPictures.length; ++i) {
            SubPicture picNext = i < subPictures.length - 1 ? subPictures[i + 1] : null;
            picSrc = subPictures[i];
            Core.validateTimes(i, subPictures[i], picNext, picPrev);
            picPrev = picSrc;
        }
    }

    public static void reScanSubtitles(Resolution resOld, double fpsTrgOld, int delayOld, boolean convertFpsOld, double fsXOld, double fsYOld) {
        SubPicture picOld;
        double factY;
        double factX;
        double fsYNew;
        double fsXNew;
        if (configuration.getApplyFreeScale()) {
            fsXNew = configuration.getFreeScaleFactorX();
            fsYNew = configuration.getFreeScaleFactorY();
        } else {
            fsXNew = 1.0;
            fsYNew = 1.0;
        }
        boolean convertFPS = configuration.getConvertFPS();
        double fpsTrg = configuration.getFpsTrg();
        double fpsSrc = configuration.getFPSSrc();
        double factTS = convertFPS && !convertFpsOld ? fpsSrc / fpsTrg : (!convertFPS && convertFpsOld ? fpsTrgOld / fpsSrc : (convertFPS && convertFpsOld && fpsTrg != fpsTrgOld ? fpsTrgOld / fpsTrg : 1.0));
        if (!configuration.getConvertResolution() && Core.getNumFrames() > 0) {
            configuration.setOutputResolution(SubtitleUtils.getResolutionForDimension(Core.getSubPictureSrc(0).getWidth(), Core.getSubPictureSrc(0).getHeight()));
        }
        if (resOld != configuration.getOutputResolution()) {
            int[] rOld = resOld.getDimensions();
            int[] rNew = configuration.getOutputResolution().getDimensions();
            factX = (double)rNew[0] / (double)rOld[0];
            factY = (double)rNew[1] / (double)rOld[1];
        } else {
            factX = 1.0;
            factY = 1.0;
        }
        for (int i = 0; i < subPictures.length; ++i) {
            double scaleY;
            double scaleX;
            picOld = subPictures[i];
            SubPicture picSrc = subtitleStream.getSubPicture(i);
            Core.subPictures[i] = new SubPicture(picOld);
            switch (configuration.getForceAll()) {
                case SET: {
                    subPictures[i].setForced(true);
                    break;
                }
                case CLEAR: {
                    subPictures[i].setForced(false);
                }
            }
            long ts = picOld.getStartTime();
            long te = picOld.getEndTime();
            int delayPTS = configuration.getDelayPTS();
            if (factTS == 1.0) {
                subPictures[i].setStartTime(ts - (long)delayOld + (long)delayPTS);
                subPictures[i].setEndTime(te - (long)delayOld + (long)delayPTS);
            } else {
                subPictures[i].setStartTime((long)((double)ts * factTS + 0.5) - (long)delayOld + (long)delayPTS);
                subPictures[i].setEndTime((long)((double)te * factTS + 0.5) - (long)delayOld + (long)delayPTS);
            }
            subPictures[i].setStartTime(SubtitleUtils.syncTimePTS(subPictures[i].getStartTime(), fpsTrg, fpsTrg));
            subPictures[i].setEndTime(SubtitleUtils.syncTimePTS(subPictures[i].getEndTime(), fpsTrg, fpsTrg));
            if (configuration.getConvertResolution()) {
                subPictures[i].setWidth(configuration.getOutputResolution().getDimensions()[0]);
                subPictures[i].setHeight(configuration.getOutputResolution().getDimensions()[1]);
                scaleX = (double)subPictures[i].getWidth() / (double)picSrc.getWidth();
                scaleY = (double)subPictures[i].getHeight() / (double)picSrc.getHeight();
            } else {
                subPictures[i].setWidth(picSrc.getWidth());
                subPictures[i].setHeight(picSrc.getHeight());
                scaleX = 1.0;
                scaleY = 1.0;
            }
            int w = (int)((double)picSrc.getImageWidth() * scaleX * fsXNew + 0.5);
            if (w < 8) {
                w = picSrc.getImageWidth();
            } else if (w > subPictures[i].getWidth()) {
                w = subPictures[i].getWidth();
                fsXNew = (double)w / (double)picSrc.getImageWidth() / scaleX;
            }
            int h = (int)((double)picSrc.getImageHeight() * scaleY * fsYNew + 0.5);
            if (h < 8) {
                h = picSrc.getImageHeight();
            } else if (h > subPictures[i].getHeight()) {
                h = subPictures[i].getHeight();
                fsYNew = (double)h / (double)picSrc.getImageHeight() / scaleY;
            }
            subPictures[i].setImageWidth(w);
            subPictures[i].setImageHeight(h);
            int xOfs = (int)((double)picOld.getXOffset() * factX + 0.5);
            if (fsXNew != fsXOld) {
                int spaceTrgOld = (int)((double)(picOld.getWidth() - picOld.getImageWidth()) * factX + 0.5);
                int spaceTrg = subPictures[i].getWidth() - w;
                xOfs += (spaceTrg - spaceTrgOld) / 2;
            }
            if (xOfs < 0) {
                xOfs = 0;
            } else if (xOfs + w > subPictures[i].getWidth()) {
                xOfs = subPictures[i].getWidth() - w;
            }
            subPictures[i].setOfsX(xOfs);
            int yOfs = (int)((double)picOld.getYOffset() * factY + 0.5);
            if (fsYNew != fsYOld) {
                int spaceTrgOld = (int)((double)(picOld.getHeight() - picOld.getImageHeight()) * factY + 0.5);
                int spaceTrg = subPictures[i].getHeight() - h;
                yOfs += (spaceTrg - spaceTrgOld) / 2;
            }
            if (yOfs < 0) {
                yOfs = 0;
            }
            if (yOfs + h > subPictures[i].getHeight()) {
                yOfs = subPictures[i].getHeight() - h;
            }
            subPictures[i].setOfsY(yOfs);
            double fx = factX * fsXNew / fsXOld;
            double fy = factY * fsYNew / fsYOld;
            List<ErasePatch> erasePatches = subPictures[i].getErasePatch();
            if (erasePatches.isEmpty()) continue;
            for (int j = 0; j < erasePatches.size(); ++j) {
                ErasePatch ep = erasePatches.get(j);
                int x = (int)((double)ep.x * fx + 0.5);
                int y = (int)((double)ep.y * fy + 0.5);
                int width = (int)((double)ep.width * fx + 0.5);
                int height = (int)((double)ep.height * fy + 0.5);
                erasePatches.set(j, new ErasePatch(x, y, width, height));
            }
        }
        SubPicture subPicPrev = null;
        for (int i = 0; i < subPictures.length; ++i) {
            SubPicture subPicNext = i < subPictures.length - 1 ? subPictures[i + 1] : null;
            picOld = subPictures[i];
            Core.validateTimes(i, subPictures[i], subPicNext, subPicPrev);
            subPicPrev = picOld;
        }
    }

    public static void convertSup(int index, int displayNum, int displayMax) throws CoreException {
        Core.convertSup(index, displayNum, displayMax, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertSup(int index, int displayNum, int displayMax, boolean skipScaling) throws CoreException {
        int h;
        int w;
        int startOfs = (int)subtitleStream.getStartOffset(index);
        SubPicture subPic = subtitleStream.getSubPicture(index);
        logger.info("Decoding frame " + displayNum + "/" + displayMax + (subtitleStream == supXml ? "\n" : " at offset " + ToolBox.toHexLeftZeroPadded(startOfs, 8) + "\n"));
        Object object = semaphore;
        synchronized (object) {
            subtitleStream.decode(index);
            w = subPic.getImageWidth();
            h = subPic.getImageHeight();
            OutputMode outputMode = configuration.getOutputMode();
            if (outputMode == OutputMode.VOBSUB || outputMode == OutputMode.SUPIFO) {
                Core.determineFramePal(index);
            }
            Core.updateTrgPic(index);
        }
        SubPicture picTrg = subPictures[index];
        picTrg.setWasDecoded(true);
        int trgWidth = picTrg.getImageWidth();
        int trgHeight = picTrg.getImageHeight();
        if (trgWidth < 8 || trgHeight < 8 || w < 8 || h < 8) {
            trgWidth = w;
            trgHeight = h;
        }
        if (!skipScaling) {
            Bitmap tBm;
            ResampleFilter f;
            switch (configuration.getScalingFilter()) {
                case BELL: {
                    f = ResampleFilters.getBellFilter();
                    break;
                }
                case BICUBIC: {
                    f = ResampleFilters.getBiCubicFilter();
                    break;
                }
                case BICUBIC_SPLINE: {
                    f = ResampleFilters.getBSplineFilter();
                    break;
                }
                case HERMITE: {
                    f = ResampleFilters.getHermiteFilter();
                    break;
                }
                case LANCZOS3: {
                    f = ResampleFilters.getLanczos3Filter();
                    break;
                }
                case TRIANGLE: {
                    f = ResampleFilters.getTriangleFilter();
                    break;
                }
                case MITCHELL: {
                    f = ResampleFilters.getMitchellFilter();
                    break;
                }
                default: {
                    f = null;
                }
            }
            Palette tPal = trgPal;
            OutputMode outputMode = configuration.getOutputMode();
            PaletteMode paletteMode = configuration.getPaletteMode();
            if (outputMode == OutputMode.VOBSUB || outputMode == OutputMode.SUPIFO) {
                tBm = w == trgWidth && h == trgHeight ? ((inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO) && paletteMode == PaletteMode.KEEP_EXISTING ? subtitleStream.getBitmap() : subtitleStream.getBitmap().getBitmapWithNormalizedPalette(subtitleStream.getPalette().getAlpha(), configuration.getAlphaThreshold(), subtitleStream.getPalette().getY(), configuration.getLuminanceThreshold())) : ((inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO) && paletteMode == PaletteMode.KEEP_EXISTING ? (f != null ? subtitleStream.getBitmap().scaleFilter(trgWidth, trgHeight, subtitleStream.getPalette(), f) : subtitleStream.getBitmap().scaleBilinear(trgWidth, trgHeight, subtitleStream.getPalette())) : (f != null ? subtitleStream.getBitmap().scaleFilterLm(trgWidth, trgHeight, subtitleStream.getPalette(), configuration.getAlphaThreshold(), configuration.getLuminanceThreshold(), f) : subtitleStream.getBitmap().scaleBilinearLm(trgWidth, trgHeight, subtitleStream.getPalette(), configuration.getAlphaThreshold(), configuration.getLuminanceThreshold())));
            } else {
                tPal = subtitleStream.getPalette();
                if (w == trgWidth && h == trgHeight) {
                    tBm = subtitleStream.getBitmap();
                } else if (paletteMode == PaletteMode.KEEP_EXISTING) {
                    tBm = f != null ? subtitleStream.getBitmap().scaleFilter(trgWidth, trgHeight, subtitleStream.getPalette(), f) : subtitleStream.getBitmap().scaleBilinear(trgWidth, trgHeight, subtitleStream.getPalette());
                } else {
                    boolean dither = paletteMode == PaletteMode.CREATE_DITHERED;
                    BitmapWithPalette pb = f != null ? subtitleStream.getBitmap().scaleFilter(trgWidth, trgHeight, subtitleStream.getPalette(), f, dither) : subtitleStream.getBitmap().scaleBilinear(trgWidth, trgHeight, subtitleStream.getPalette(), dither);
                    tBm = pb.bitmap;
                    tPal = pb.palette;
                }
            }
            if (!picTrg.getErasePatch().isEmpty()) {
                trgBitmapUnpatched = new Bitmap(tBm);
                int col = tPal.getIndexOfMostTransparentPaletteEntry();
                for (ErasePatch ep : picTrg.getErasePatch()) {
                    tBm.fillRectangularWithColorIndex(ep.x, ep.y, ep.width, ep.height, (byte)col);
                }
            } else {
                trgBitmapUnpatched = tBm;
            }
            trgBitmap = tBm;
            trgPal = tPal;
        }
        if (configuration.isCliMode()) {
            Core.moveToBounds(picTrg, displayNum, configuration.getCineBarFactor(), configuration.getMoveOffsetX(), configuration.getMoveOffsetY(), configuration.getMoveModeX(), configuration.getMoveModeY(), configuration.getCropOffsetY());
        }
    }

    public static void writeSub(String fname) throws CoreException {
        FilterOutputStream out = null;
        ArrayList<Integer> offsets = null;
        ArrayList<Integer> timestamps = null;
        TreeMap<Integer, SubPicture> exportedSubPictures = new TreeMap<Integer, SubPicture>();
        int frameNum = 0;
        String fn = "";
        logger.resetErrorCounter();
        logger.resetWarningCounter();
        List<Integer> subPicturesToBeExported = Core.getSubPicturesToBeExported();
        if (subPicturesToBeExported.isEmpty()) {
            logger.warn("There is no subpicture to be exported.");
            return;
        }
        OutputMode outputMode = configuration.getOutputMode();
        try {
            if (outputMode == OutputMode.VOBSUB) {
                fname = FilenameUtils.removeExtension(fname) + ".sub";
                out = new BufferedOutputStream(new FileOutputStream(fname));
                offsets = new ArrayList<Integer>();
                timestamps = new ArrayList<Integer>();
            } else if (outputMode == OutputMode.SUPIFO) {
                fname = FilenameUtils.removeExtension(fname) + ".sup";
                out = new BufferedOutputStream(new FileOutputStream(fname));
            } else if (outputMode == OutputMode.BDSUP) {
                fname = FilenameUtils.removeExtension(fname) + ".sup";
                out = new BufferedOutputStream(new FileOutputStream(fname));
            } else {
                fn = FilenameUtils.removeExtension(fname);
                fname = fn + ".xml";
            }
            logger.info("\nWriting " + fname + "\n");
            int offset = 0;
            for (int i : subPicturesToBeExported) {
                byte[] buf;
                if (Core.isCanceled()) {
                    throw new CoreException("Canceled by user!");
                }
                Core.setProgress(i);
                SubPicture subPicture = subPictures[i];
                if (outputMode == OutputMode.VOBSUB) {
                    offsets.add(offset);
                    Core.convertSup(i, frameNum / 2 + 1, subPicturesToBeExported.size());
                    subVobTrg.copyInfo(subPicture);
                    buf = SubDvdWriter.createSubFrame(subVobTrg, trgBitmap);
                    out.write(buf);
                    offset += buf.length;
                    timestamps.add((int)subPicture.getStartTime());
                } else if (outputMode == OutputMode.SUPIFO) {
                    Core.convertSup(i, frameNum / 2 + 1, subPicturesToBeExported.size());
                    subVobTrg.copyInfo(subPicture);
                    buf = SupDvdWriter.createSupFrame(subVobTrg, trgBitmap);
                    out.write(buf);
                } else if (outputMode == OutputMode.BDSUP) {
                    subPicture.setCompositionNumber(frameNum);
                    Core.convertSup(i, frameNum / 2 + 1, subPicturesToBeExported.size());
                    buf = SupBDWriter.createSupFrame(subPicture, trgBitmap, trgPal);
                    out.write(buf);
                } else {
                    Core.convertSup(i, frameNum / 2 + 1, subPicturesToBeExported.size());
                    String fnp = SupXml.getPNGname(fn, i + 1);
                    out = new BufferedOutputStream(new FileOutputStream(fnp));
                    EnhancedPngEncoder pngEncoder = new EnhancedPngEncoder(trgBitmap.getImage(trgPal.getColorModel()));
                    byte[] buf2 = pngEncoder.pngEncode();
                    out.write(buf2);
                    out.close();
                    exportedSubPictures.put(i, subPicture);
                }
                frameNum += 2;
            }
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
        boolean importedDVDPalette = inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO;
        Palette trgPallete = null;
        PaletteMode paletteMode = configuration.getPaletteMode();
        if (outputMode == OutputMode.VOBSUB) {
            int[] ofs = new int[offsets.size()];
            for (int i = 0; i < ofs.length; ++i) {
                ofs[i] = (Integer)offsets.get(i);
            }
            int[] ts = new int[timestamps.size()];
            for (int i = 0; i < ts.length; ++i) {
                ts[i] = (Integer)timestamps.get(i);
            }
            fname = FilenameUtils.removeExtension(fname) + ".idx";
            logger.info("\nWriting " + fname + "\n");
            trgPallete = !importedDVDPalette || paletteMode != PaletteMode.KEEP_EXISTING ? currentDVDPalette : currentSourceDVDPalette;
            SubDvdWriter.writeIdx(fname, subPictures[0], ofs, ts, trgPallete);
        } else if (outputMode == OutputMode.XML) {
            logger.info("\nWriting " + fname + "\n");
            SupXml.writeXml(fname, exportedSubPictures);
        } else if (outputMode == OutputMode.SUPIFO) {
            trgPallete = !importedDVDPalette || paletteMode != PaletteMode.KEEP_EXISTING ? currentDVDPalette : currentSourceDVDPalette;
            fname = FilenameUtils.removeExtension(fname) + ".ifo";
            logger.info("\nWriting " + fname + "\n");
            IfoWriter.writeIFO(fname, subPictures[0].getHeight(), trgPallete);
        }
        if (trgPallete != null && configuration.getWritePGCEditPalette()) {
            String fnp = FilenameUtils.removeExtension(fname) + ".txt";
            logger.info("\nWriting " + fnp + "\n");
            Core.writePGCEditPal(fnp, trgPallete);
        }
        state = CoreThreadState.FINISHED;
    }

    public static void moveAllThreaded(JFrame parent) throws Exception {
        progressMax = subtitleStream.getFrameCount();
        progressLast = 0;
        progress = new Progress(parent);
        progress.setTitle("Moving");
        progress.setText("Moving all captions");
        runType = RunType.MOVEALL;
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        state = CoreThreadState.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    public static void moveAllToBounds() throws CoreException {
        String sy = null;
        switch (configuration.getMoveModeY()) {
            case MOVE_INSIDE_BOUNDS: {
                sy = "inside";
                break;
            }
            case MOVE_OUTSIDE_BOUNDS: {
                sy = "outside";
            }
        }
        String sx = null;
        switch (configuration.getMoveModeX()) {
            case CENTER: {
                sx = "center vertically";
                break;
            }
            case LEFT: {
                sx = "left";
                break;
            }
            case RIGHT: {
                sx = "right";
            }
        }
        String s = "Moving captions ";
        if (sy != null) {
            s = s + sy + " cinemascope bars";
            if (sx != null) {
                s = s + " and to the " + sx;
            }
            logger.trace(s + ".\n");
        } else if (sx != null) {
            logger.trace(s + "to the " + sx + ".\n");
        }
        if (!configuration.isCliMode()) {
            for (int idx = 0; idx < subPictures.length; ++idx) {
                Core.setProgress(idx);
                if (!subPictures[idx].isWasDecoded()) {
                    Core.convertSup(idx, idx + 1, subPictures.length, true);
                }
                Core.moveToBounds(subPictures[idx], idx + 1, configuration.getCineBarFactor(), configuration.getMoveOffsetX(), configuration.getMoveOffsetY(), configuration.getMoveModeX(), configuration.getMoveModeY(), configuration.getCropOffsetY());
            }
        }
    }

    public static void moveToBounds(SubPicture pic, int idx, double barFactor, int offsetX, int offsetY, CaptionMoveModeX mmx, CaptionMoveModeY mmy, int cropOffsetY) {
        int barHeight = (int)((double)pic.getHeight() * barFactor + 0.5);
        int y1 = pic.getYOffset();
        int h = pic.getHeight();
        int w = pic.getWidth();
        int hi = pic.getImageHeight();
        int wi = pic.getImageWidth();
        int y2 = y1 + hi;
        if (mmy != CaptionMoveModeY.KEEP_POSITION) {
            CaptionType c = y1 < h / 2 && y2 < h / 2 ? CaptionType.UP : (y1 > h / 2 && y2 > h / 2 ? CaptionType.DOWN : CaptionType.FULL);
            switch (c) {
                case FULL: {
                    logger.warn("Caption " + idx + " not moved (too large)\n");
                    break;
                }
                case UP: {
                    if (mmy == CaptionMoveModeY.MOVE_INSIDE_BOUNDS) {
                        pic.setOfsY(barHeight + offsetY);
                    } else {
                        pic.setOfsY(offsetY);
                    }
                    logger.trace("Caption " + idx + " moved to y position " + pic.getYOffset() + "\n");
                    break;
                }
                case DOWN: {
                    if (mmy == CaptionMoveModeY.MOVE_INSIDE_BOUNDS) {
                        pic.setOfsY(h - barHeight - offsetY - hi);
                    } else {
                        pic.setOfsY(h - offsetY - hi);
                    }
                    logger.trace("Caption " + idx + " moved to y position " + pic.getYOffset() + "\n");
                }
            }
            if (pic.getYOffset() < cropOffsetY) {
                pic.getYOffset();
            } else {
                int yMax = pic.getHeight() - pic.getImageHeight() - cropOffsetY;
                if (pic.getYOffset() > yMax) {
                    pic.setOfsY(yMax);
                }
            }
        }
        switch (mmx) {
            case LEFT: {
                if (w - wi >= offsetX) {
                    pic.setOfsX(offsetX);
                    break;
                }
                pic.setOfsX((w - wi) / 2);
                break;
            }
            case RIGHT: {
                if (w - wi >= offsetX) {
                    pic.setOfsX(w - wi - offsetX);
                    break;
                }
                pic.setOfsX((w - wi) / 2);
                break;
            }
            case CENTER: {
                pic.setOfsX((w - wi) / 2);
            }
        }
    }

    private static void writePGCEditPal(String fname, Palette p) throws CoreException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fname));
            out.write("# Palette file for PGCEdit - colors given as R,G,B components (0..255)");
            out.newLine();
            for (int i = 0; i < p.getSize(); ++i) {
                int[] rgb = p.getRGB(i);
                out.write("Color " + i + "=" + rgb[0] + ", " + rgb[1] + ", " + rgb[2]);
                out.newLine();
            }
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static int countForcedIncluded() {
        int n = 0;
        for (SubPicture pic : subPictures) {
            if (!pic.isForced() || pic.isExcluded()) continue;
            ++n;
        }
        return n;
    }

    private static List<Integer> getSubPicturesToBeExported() {
        ArrayList<Integer> subPicturesToBeExported = new ArrayList<Integer>();
        for (int i = 0; i < subPictures.length; ++i) {
            SubPicture subPicture = subPictures[i];
            if (subPicture.isExcluded() || configuration.isExportForced() && !subPicture.isForced()) continue;
            subPicturesToBeExported.add(i);
        }
        return subPicturesToBeExported;
    }

    public static boolean isReady() {
        return ready;
    }

    public static void setReady(boolean r) {
        ready = r;
    }

    public static void cancel() {
        state = CoreThreadState.CANCELED;
    }

    public static boolean isCanceled() {
        return state == CoreThreadState.CANCELED;
    }

    public static CoreThreadState getStatus() {
        return state;
    }

    public static void setProgress(long p) {
        int val;
        if (progress != null && (val = (int)(p * 100L / (long)progressMax)) > progressLast) {
            progressLast = val;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        progress.setProgress(val);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static InputMode getInputMode() {
        return inMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getSrcImage() {
        Object object = semaphore;
        synchronized (object) {
            return subtitleStream.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getSrcImage(int idx) throws CoreException {
        Object object = semaphore;
        synchronized (object) {
            subtitleStream.decode(idx);
            return subtitleStream.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getTrgImage() {
        Object object = semaphore;
        synchronized (object) {
            return trgBitmap.getImage(trgPal.getColorModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getTrgImagePatched(SubPicture pic) {
        Object object = semaphore;
        synchronized (object) {
            if (!pic.getErasePatch().isEmpty()) {
                Bitmap trgBitmapPatched = new Bitmap(trgBitmapUnpatched);
                int col = trgPal.getIndexOfMostTransparentPaletteEntry();
                for (ErasePatch ep : pic.getErasePatch()) {
                    trgBitmapPatched.fillRectangularWithColorIndex(ep.x, ep.y, ep.width, ep.height, (byte)col);
                }
                return trgBitmapPatched.getImage(trgPal.getColorModel());
            }
            return trgBitmapUnpatched.getImage(trgPal.getColorModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgWidth(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgHeight(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgImgWidth(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getImageWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgImgHeight(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getImageHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getTrgExcluded(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].isExcluded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgOfsX(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getXOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgOfsY(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getYOffset();
        }
    }

    public static int getNumFrames() {
        return subtitleStream == null ? 0 : subtitleStream.getFrameCount();
    }

    public static int getNumForcedFrames() {
        return subtitleStream == null ? 0 : subtitleStream.getForcedFrameCount();
    }

    public static String getTrgInfoStr(int index) {
        SubPicture pic = subPictures[index];
        String text = "screen size: " + Core.getTrgWidth(index) + "x" + Core.getTrgHeight(index) + "    ";
        text = text + "image size: " + Core.getTrgImgWidth(index) + "x" + Core.getTrgImgHeight(index) + "    ";
        text = text + "pos: (" + pic.getXOffset() + "," + pic.getYOffset() + ") - (" + (pic.getXOffset() + Core.getTrgImgWidth(index)) + "," + (pic.getYOffset() + Core.getTrgImgHeight(index)) + ")    ";
        text = text + "start: " + TimeUtils.ptsToTimeStr(pic.getStartTime()) + "    ";
        text = text + "end: " + TimeUtils.ptsToTimeStr(pic.getEndTime()) + "    ";
        text = text + "forced: " + (pic.isForced() ? "yes" : "no");
        return text;
    }

    public static String getSrcInfoStr(int index) {
        SubPicture pic = subtitleStream.getSubPicture(index);
        String text = "screen size: " + pic.getWidth() + "x" + pic.getHeight() + "    ";
        text = text + "image size: " + pic.getImageWidth() + "x" + pic.getImageHeight() + "    ";
        text = text + "pos: (" + pic.getXOffset() + "," + pic.getYOffset() + ") - (" + (pic.getXOffset() + pic.getImageWidth()) + "," + (pic.getYOffset() + pic.getImageHeight()) + ")    ";
        text = text + "start: " + TimeUtils.ptsToTimeStr(pic.getStartTime()) + "    ";
        text = text + "end: " + TimeUtils.ptsToTimeStr(pic.getEndTime()) + "    ";
        text = text + "forced: " + (pic.isForced() ? "yes" : "no");
        return text;
    }

    public static Palette getCurrentDVDPalette() {
        return currentDVDPalette;
    }

    public static void setCurrentDVDPalette(Palette pal) {
        currentDVDPalette = pal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubPicture getSubPictureTrg(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubPicture getSubPictureSrc(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subtitleStream.getSubPicture(index);
        }
    }

    public static boolean usesBT601() {
        return useBT601;
    }

    public static void setProgressMax(int max) {
        progressMax = max;
    }

    public static Palette getDefSrcDVDPalette() {
        return defaultSourceDVDPalette;
    }

    public static Palette getCurSrcDVDPalette() {
        return currentSourceDVDPalette;
    }

    public static void setCurSrcDVDPalette(Palette pal) {
        currentSourceDVDPalette = pal;
        DvdSubtitleStream substreamDvd = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDvd = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDvd = supDVD;
        }
        substreamDvd.setSrcPalette(currentSourceDVDPalette);
    }

    public static int[] getFramePal(int index) {
        DvdSubtitleStream substreamDvd = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDvd = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDvd = supDVD;
        }
        if (substreamDvd != null) {
            return substreamDvd.getFramePalette(index);
        }
        return null;
    }

    public static int[] getFrameAlpha(int index) {
        DvdSubtitleStream substreamDvd = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDvd = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDvd = supDVD;
        }
        if (substreamDvd != null) {
            return substreamDvd.getFrameAlpha(index);
        }
        return null;
    }

    public static int[] getOriginalFramePal(int index) {
        DvdSubtitleStream substreamDvd = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDvd = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDvd = supDVD;
        }
        if (substreamDvd != null) {
            return substreamDvd.getOriginalFramePalette(index);
        }
        return null;
    }

    public static int[] getOriginalFrameAlpha(int index) {
        DvdSubtitleStream substreamDvd = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDvd = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDvd = supDVD;
        }
        if (substreamDvd != null) {
            return substreamDvd.getOriginalFrameAlpha(index);
        }
        return null;
    }

    static {
        DEFAULT_ALPHA = new int[]{0, 15, 15, 15};
        inMode = InputMode.VOBSUB;
        state = CoreThreadState.INACTIVE;
        semaphore = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CaptionType {
        UP,
        DOWN,
        FULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RunType {
        READSUP,
        READXML,
        READVOBSUB,
        READSUPIFO,
        CREATESUB,
        CREATESUP,
        MOVEALL;

    }
}

