/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.conversion;

import bdsup2sub.core.ForcedFlagState;
import bdsup2sub.core.Resolution;
import bdsup2sub.gui.conversion.ConversionDialogModel;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

class ConversionDialogView
extends JDialog {
    private static final Dimension DIM_LABEL = new Dimension(80, 20);
    private static final String[] FRAMERATES = new String[]{"23.975", "23.976", "24", "25", "29.97", "50", "59.94"};
    private JPanel jContentPane;
    private JPanel jPanelResolution;
    private JComboBox jComboBoxResolution;
    private JCheckBox jCheckBoxFrameRate;
    private JCheckBox jCheckBoxResolution;
    private JPanel jPanelFps;
    private JComboBox jComboBoxFpsSrc;
    private JComboBox jComboBoxFpsTrg;
    private JPanel jPanelMove;
    private JCheckBox jCheckBoxMove;
    private JPanel jPanelTimes;
    private JTextField jTextFieldDelay;
    private JCheckBox jCheckBoxFixMinTime;
    private JTextField jTextFieldMinTime;
    private JPanel jPanelDefaults;
    private JButton jButtonStore;
    private JButton jButtonRestore;
    private JButton jButtonReset;
    private JPanel jPanelButtons;
    private JButton jButtonOk;
    private JButton jButtonCancel;
    private JPanel jPanelScale;
    private JCheckBox jCheckBoxScale;
    private JTextField jTextFieldScaleX;
    private JTextField jTextFieldScaleY;
    private JPanel jPanelForced;
    private JComboBox jComboBoxForced;
    private final ConversionDialogModel model;

    public ConversionDialogView(ConversionDialogModel model, Frame owner) {
        super(owner, "Conversion Options", true);
        this.model = model;
        this.initialize();
        this.fillDialog();
        model.setReady(true);
    }

    void fillDialog() {
        this.jComboBoxResolution.setSelectedIndex(this.model.getOutputResolution().ordinal());
        this.jComboBoxResolution.setEnabled(this.model.getConvertResolution());
        this.jCheckBoxResolution.setSelected(this.model.getConvertResolution());
        this.jTextFieldDelay.setText(ToolBox.formatDouble((double)this.model.getDelayPTS() / 90.0));
        this.jCheckBoxFrameRate.setSelected(this.model.getConvertFPS());
        this.jComboBoxFpsSrc.setSelectedItem(ToolBox.formatDouble(this.model.getFpsSrc()));
        this.jComboBoxFpsSrc.setEnabled(this.model.getConvertFPS());
        this.jComboBoxFpsTrg.setSelectedItem(ToolBox.formatDouble(this.model.getFpsTrg()));
        this.jComboBoxFpsTrg.setEnabled(true);
        this.jTextFieldMinTime.setText(ToolBox.formatDouble((double)this.model.getMinTimePTS() / 90.0));
        this.jCheckBoxFixMinTime.setEnabled(true);
        this.jCheckBoxFixMinTime.setSelected(this.model.getFixShortFrames());
        this.jCheckBoxFixMinTime.setSelected(this.model.getFixShortFrames());
        this.jTextFieldMinTime.setEnabled(this.model.getFixShortFrames());
        this.jCheckBoxScale.setSelected(this.model.getApplyFreeScale());
        this.jTextFieldScaleX.setText(ToolBox.formatDouble(this.model.getFreeScaleFactorX()));
        this.jTextFieldScaleX.setEnabled(this.model.getApplyFreeScale());
        this.jTextFieldScaleY.setText(ToolBox.formatDouble(this.model.getFreeScaleFactorY()));
        this.jTextFieldScaleY.setEnabled(this.model.getApplyFreeScale());
        this.jComboBoxForced.setSelectedIndex(this.model.getForcedState().ordinal());
    }

    private void initialize() {
        this.setSize(500, 350);
        this.setPreferredSize(new Dimension(500, 350));
        this.setContentPane(this.getJContentPane());
        GuiUtils.centerRelativeToOwner(this);
        this.setResizable(false);
    }

    private JPanel getJPanelResolution() {
        if (this.jPanelResolution == null) {
            GridBagConstraints gridBagCheckBoxResolution = new GridBagConstraints();
            gridBagCheckBoxResolution.gridx = 0;
            gridBagCheckBoxResolution.gridy = 0;
            gridBagCheckBoxResolution.anchor = 17;
            gridBagCheckBoxResolution.gridwidth = 2;
            GridBagConstraints gridBagLabelResolution = new GridBagConstraints();
            gridBagLabelResolution.gridx = 0;
            gridBagLabelResolution.gridy = 1;
            gridBagLabelResolution.anchor = 17;
            gridBagLabelResolution.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboResolution = new GridBagConstraints();
            gridBagComboResolution.gridx = 1;
            gridBagComboResolution.gridy = 1;
            gridBagComboResolution.weightx = 1.0;
            gridBagComboResolution.anchor = 17;
            gridBagComboResolution.insets = new Insets(2, 4, 2, 4);
            this.jPanelResolution = new JPanel();
            this.jPanelResolution.setLayout(new GridBagLayout());
            this.jPanelResolution.setBorder(BorderFactory.createTitledBorder(null, "Resolution", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelResolution.setMinimumSize(new Dimension(200, 70));
            this.jPanelResolution.setPreferredSize(new Dimension(200, 70));
            JLabel label = new JLabel("Resolution");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelResolution.add((Component)this.getJCheckBoxResolution(), gridBagCheckBoxResolution);
            this.jPanelResolution.add((Component)label, gridBagLabelResolution);
            this.jPanelResolution.add((Component)this.getJComboBoxResolution(), gridBagComboResolution);
        }
        return this.jPanelResolution;
    }

    private JPanel getJPanelMove() {
        if (this.jPanelMove == null) {
            GridBagConstraints gridBagCheckBoxMove = new GridBagConstraints();
            gridBagCheckBoxMove.gridx = 0;
            gridBagCheckBoxMove.gridy = 0;
            gridBagCheckBoxMove.anchor = 17;
            gridBagCheckBoxMove.weightx = 1.0;
            this.jPanelMove = new JPanel();
            this.jPanelMove.setLayout(new GridBagLayout());
            this.jPanelMove.setBorder(BorderFactory.createTitledBorder(null, "Move", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelMove.setMinimumSize(new Dimension(200, 50));
            this.jPanelMove.setPreferredSize(new Dimension(200, 50));
            this.jPanelMove.add((Component)this.getJCheckBoxMove(), gridBagCheckBoxMove);
        }
        return this.jPanelMove;
    }

    private JPanel getJPanelFps() {
        if (this.jPanelFps == null) {
            GridBagConstraints gridBagCheckBoxFrameRate = new GridBagConstraints();
            gridBagCheckBoxFrameRate.gridx = 0;
            gridBagCheckBoxFrameRate.gridy = 0;
            gridBagCheckBoxFrameRate.anchor = 17;
            gridBagCheckBoxFrameRate.gridwidth = 2;
            GridBagConstraints gridBagLabelFpsSrc = new GridBagConstraints();
            gridBagLabelFpsSrc.gridx = 0;
            gridBagLabelFpsSrc.gridy = 1;
            gridBagLabelFpsSrc.anchor = 17;
            gridBagLabelFpsSrc.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboFpsSrc = new GridBagConstraints();
            gridBagComboFpsSrc.gridx = 1;
            gridBagComboFpsSrc.gridy = 1;
            gridBagComboFpsSrc.weightx = 1.0;
            gridBagComboFpsSrc.anchor = 17;
            gridBagComboFpsSrc.insets = new Insets(2, 4, 2, 4);
            GridBagConstraints gridBagLabelFpsTrg = new GridBagConstraints();
            gridBagLabelFpsTrg.gridx = 0;
            gridBagLabelFpsTrg.gridy = 2;
            gridBagLabelFpsTrg.anchor = 17;
            gridBagLabelFpsTrg.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboFpsTrg = new GridBagConstraints();
            gridBagComboFpsTrg.gridx = 1;
            gridBagComboFpsTrg.gridy = 2;
            gridBagComboFpsTrg.weightx = 1.0;
            gridBagComboFpsTrg.anchor = 17;
            gridBagComboFpsTrg.insets = new Insets(2, 4, 2, 4);
            this.jPanelFps = new JPanel();
            this.jPanelFps.setLayout(new GridBagLayout());
            this.jPanelFps.setBorder(BorderFactory.createTitledBorder(null, "Framerate", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelFps.setMinimumSize(new Dimension(200, 100));
            this.jPanelFps.setPreferredSize(new Dimension(200, 100));
            this.jPanelFps.add((Component)this.getJCheckBoxFrameRate(), gridBagCheckBoxFrameRate);
            JLabel label = new JLabel("FPS Source");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelFps.add((Component)label, gridBagLabelFpsSrc);
            label = new JLabel("FPS Target");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelFps.add((Component)label, gridBagLabelFpsTrg);
            this.jPanelFps.add((Component)this.getJComboBoxFpsSrc(), gridBagComboFpsSrc);
            this.jPanelFps.add((Component)this.getJComboBoxFpsTrg(), gridBagComboFpsTrg);
        }
        return this.jPanelFps;
    }

    private JPanel getJPanelTimes() {
        if (this.jPanelTimes == null) {
            GridBagConstraints gridBagLabelDelay = new GridBagConstraints();
            gridBagLabelDelay.gridx = 0;
            gridBagLabelDelay.gridy = 0;
            gridBagLabelDelay.anchor = 17;
            gridBagLabelDelay.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagTextDelay = new GridBagConstraints();
            gridBagTextDelay.gridx = 1;
            gridBagTextDelay.gridy = 0;
            gridBagTextDelay.weightx = 1.0;
            gridBagTextDelay.anchor = 17;
            gridBagTextDelay.insets = new Insets(2, 4, 2, 4);
            gridBagTextDelay.ipadx = 100;
            GridBagConstraints gridBagCheckBoxFixMinTime = new GridBagConstraints();
            gridBagCheckBoxFixMinTime.gridx = 0;
            gridBagCheckBoxFixMinTime.gridy = 1;
            gridBagCheckBoxFixMinTime.anchor = 17;
            gridBagCheckBoxFixMinTime.gridwidth = 2;
            gridBagCheckBoxFixMinTime.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagLabelMinTime = new GridBagConstraints();
            gridBagLabelMinTime.gridx = 0;
            gridBagLabelMinTime.gridy = 2;
            gridBagLabelMinTime.anchor = 17;
            gridBagLabelMinTime.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextMinTime = new GridBagConstraints();
            gridBagTextMinTime.gridx = 1;
            gridBagTextMinTime.gridy = 2;
            gridBagTextMinTime.anchor = 17;
            gridBagTextMinTime.weightx = 1.0;
            gridBagTextMinTime.ipadx = 100;
            gridBagTextMinTime.insets = new Insets(2, 4, 2, 4);
            this.jPanelTimes = new JPanel();
            this.jPanelTimes.setLayout(new GridBagLayout());
            this.jPanelTimes.setBorder(BorderFactory.createTitledBorder(null, "Times", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelTimes.setMinimumSize(new Dimension(200, 100));
            this.jPanelTimes.setPreferredSize(new Dimension(200, 100));
            JLabel label = new JLabel("Delay (ms)");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelTimes.add((Component)label, gridBagLabelDelay);
            this.jPanelTimes.add((Component)this.getJTextFieldDelay(), gridBagTextDelay);
            this.jPanelTimes.add((Component)this.getJCheckBoxFixMinTime(), gridBagCheckBoxFixMinTime);
            this.jPanelTimes.add((Component)this.getJTextFieldMinTime(), gridBagTextMinTime);
            label = new JLabel("Min Time (ms)");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelTimes.add((Component)label, gridBagLabelMinTime);
        }
        return this.jPanelTimes;
    }

    private JPanel getJPanelScale() {
        if (this.jPanelScale == null) {
            GridBagConstraints gridBagCheckBoxScale = new GridBagConstraints();
            gridBagCheckBoxScale.gridx = 0;
            gridBagCheckBoxScale.gridy = 0;
            gridBagCheckBoxScale.anchor = 17;
            gridBagCheckBoxScale.gridwidth = 2;
            GridBagConstraints gridBagLabelScaleX = new GridBagConstraints();
            gridBagLabelScaleX.gridx = 0;
            gridBagLabelScaleX.gridy = 1;
            gridBagLabelScaleX.anchor = 17;
            gridBagLabelScaleX.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextScaleX = new GridBagConstraints();
            gridBagTextScaleX.gridx = 1;
            gridBagTextScaleX.gridy = 1;
            gridBagTextScaleX.anchor = 17;
            gridBagTextScaleX.insets = new Insets(2, 4, 2, 4);
            gridBagTextScaleX.weightx = 1.0;
            gridBagTextScaleX.ipadx = 100;
            GridBagConstraints gridBagLabelScaleY = new GridBagConstraints();
            gridBagLabelScaleY.gridx = 0;
            gridBagLabelScaleY.gridy = 2;
            gridBagLabelScaleY.anchor = 17;
            gridBagLabelScaleY.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextScaleY = new GridBagConstraints();
            gridBagTextScaleY.gridx = 1;
            gridBagTextScaleY.gridy = 2;
            gridBagTextScaleY.anchor = 17;
            gridBagTextScaleY.insets = new Insets(2, 4, 2, 4);
            gridBagTextScaleY.weightx = 1.0;
            gridBagTextScaleY.ipadx = 100;
            this.jPanelScale = new JPanel();
            this.jPanelScale.setLayout(new GridBagLayout());
            this.jPanelScale.setBorder(BorderFactory.createTitledBorder(null, "Scale", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelScale.setMinimumSize(new Dimension(200, 100));
            this.jPanelScale.setPreferredSize(new Dimension(200, 100));
            this.jPanelScale.add((Component)this.getJCheckBoxScale(), gridBagCheckBoxScale);
            JLabel label = new JLabel("Scale X");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelScale.add((Component)label, gridBagLabelScaleX);
            this.jPanelScale.add((Component)this.getJTextFieldScaleX(), gridBagTextScaleX);
            label = new JLabel("Scale Y");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelScale.add((Component)label, gridBagLabelScaleY);
            this.jPanelScale.add((Component)this.getJTextFieldScaleY(), gridBagTextScaleY);
        }
        return this.jPanelScale;
    }

    private JPanel getJPanelDefaults() {
        if (this.jPanelDefaults == null) {
            GridBagConstraints gridBagButtonStore = new GridBagConstraints();
            gridBagButtonStore.gridx = 0;
            gridBagButtonStore.gridy = 0;
            gridBagButtonStore.anchor = 17;
            gridBagButtonStore.weightx = 1.0;
            gridBagButtonStore.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagButtonRestore = new GridBagConstraints();
            gridBagButtonRestore.gridx = 1;
            gridBagButtonRestore.gridy = 0;
            gridBagButtonRestore.anchor = 10;
            gridBagButtonRestore.weightx = 1.0;
            gridBagButtonRestore.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagButtonReset = new GridBagConstraints();
            gridBagButtonReset.gridx = 2;
            gridBagButtonReset.gridy = 0;
            gridBagButtonReset.anchor = 13;
            gridBagButtonReset.weightx = 1.0;
            gridBagButtonReset.insets = new Insets(2, 4, 2, 0);
            this.jPanelDefaults = new JPanel();
            this.jPanelDefaults.setLayout(new GridBagLayout());
            this.jPanelDefaults.setBorder(BorderFactory.createTitledBorder(null, "Defaults", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelDefaults.setMinimumSize(new Dimension(200, 60));
            this.jPanelDefaults.setPreferredSize(new Dimension(200, 60));
            this.jPanelDefaults.add((Component)this.getJButtonStore(), gridBagButtonStore);
            this.jPanelDefaults.add((Component)this.getJButtonRestore(), gridBagButtonRestore);
            this.jPanelDefaults.add((Component)this.getJButtonReset(), gridBagButtonReset);
        }
        return this.jPanelDefaults;
    }

    private JPanel getJPanelForced() {
        if (this.jPanelForced == null) {
            GridBagConstraints gridBagLabelForced = new GridBagConstraints();
            gridBagLabelForced.gridx = 0;
            gridBagLabelForced.gridy = 0;
            gridBagLabelForced.anchor = 17;
            gridBagLabelForced.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboForced = new GridBagConstraints();
            gridBagComboForced.gridx = 1;
            gridBagComboForced.gridy = 0;
            gridBagComboForced.weightx = 1.0;
            gridBagComboForced.anchor = 17;
            gridBagComboForced.insets = new Insets(2, 4, 2, 4);
            this.jPanelForced = new JPanel();
            this.jPanelForced.setLayout(new GridBagLayout());
            this.jPanelForced.setBorder(BorderFactory.createTitledBorder(null, "Global forced flags", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelForced.setMinimumSize(new Dimension(200, 70));
            this.jPanelForced.setPreferredSize(new Dimension(200, 70));
            JLabel label = new JLabel("Force all");
            label.setMinimumSize(DIM_LABEL);
            this.jPanelForced.add((Component)label, gridBagLabelForced);
            this.jPanelForced.add((Component)this.getJComboBoxForced(), gridBagComboForced);
        }
        return this.jPanelForced;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.gridx = 0;
            gridBagButtonCancel.gridy = 0;
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.weightx = 1.0;
            gridBagButtonCancel.insets = new Insets(2, 8, 4, 0);
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.gridx = 3;
            gridBagButtonOk.gridy = 0;
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.weightx = 1.0;
            gridBagButtonOk.insets = new Insets(2, 4, 4, 8);
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.setMinimumSize(new Dimension(200, 30));
            this.jPanelButtons.setPreferredSize(new Dimension(200, 30));
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
        }
        return this.jPanelButtons;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelResolution = new GridBagConstraints();
            gridBagPanelResolution.gridx = 0;
            gridBagPanelResolution.gridy = 0;
            gridBagPanelResolution.anchor = 18;
            gridBagPanelResolution.weightx = 1.0;
            gridBagPanelResolution.weighty = 1.0;
            gridBagPanelResolution.fill = 1;
            GridBagConstraints gridBagPanelMove = new GridBagConstraints();
            gridBagPanelMove.gridx = 0;
            gridBagPanelMove.gridy = 1;
            gridBagPanelMove.anchor = 18;
            gridBagPanelMove.weightx = 1.0;
            gridBagPanelMove.weighty = 1.0;
            gridBagPanelMove.fill = 1;
            GridBagConstraints gridBagPanelScale = new GridBagConstraints();
            gridBagPanelScale.gridx = 1;
            gridBagPanelScale.gridy = 0;
            gridBagPanelScale.anchor = 18;
            gridBagPanelScale.weightx = 1.0;
            gridBagPanelScale.weighty = 1.0;
            gridBagPanelScale.gridheight = 2;
            gridBagPanelScale.fill = 1;
            GridBagConstraints gridBagPanelFPS = new GridBagConstraints();
            gridBagPanelFPS.gridx = 0;
            gridBagPanelFPS.gridy = 2;
            gridBagPanelFPS.anchor = 18;
            gridBagPanelFPS.weightx = 1.0;
            gridBagPanelFPS.weighty = 1.0;
            gridBagPanelFPS.fill = 1;
            GridBagConstraints gridBagPanelTimes = new GridBagConstraints();
            gridBagPanelTimes.gridx = 1;
            gridBagPanelTimes.gridy = 2;
            gridBagPanelTimes.anchor = 18;
            gridBagPanelTimes.weightx = 1.0;
            gridBagPanelTimes.weighty = 1.0;
            gridBagPanelTimes.fill = 1;
            GridBagConstraints gridBagPanelForced = new GridBagConstraints();
            gridBagPanelForced.gridx = 0;
            gridBagPanelForced.gridy = 3;
            gridBagPanelForced.anchor = 18;
            gridBagPanelForced.weightx = 1.0;
            gridBagPanelForced.weighty = 1.0;
            gridBagPanelForced.fill = 1;
            GridBagConstraints gridBagPanelDefaults = new GridBagConstraints();
            gridBagPanelDefaults.gridx = 1;
            gridBagPanelDefaults.gridy = 3;
            gridBagPanelDefaults.anchor = 18;
            gridBagPanelDefaults.weightx = 1.0;
            gridBagPanelDefaults.weighty = 1.0;
            gridBagPanelDefaults.fill = 1;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.gridy = 4;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 1.0;
            gridBagPanelButtons.gridwidth = 2;
            gridBagPanelButtons.fill = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelResolution(), gridBagPanelResolution);
            this.jContentPane.add((Component)this.getJPanelMove(), gridBagPanelMove);
            this.jContentPane.add((Component)this.getJPanelFps(), gridBagPanelFPS);
            this.jContentPane.add((Component)this.getJPanelTimes(), gridBagPanelTimes);
            this.jContentPane.add((Component)this.getJPanelScale(), gridBagPanelScale);
            this.jContentPane.add((Component)this.getJPanelForced(), gridBagPanelForced);
            this.jContentPane.add((Component)this.getJPanelDefaults(), gridBagPanelDefaults);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
        }
        return this.jContentPane;
    }

    private JComboBox getJComboBoxResolution() {
        if (this.jComboBoxResolution == null) {
            this.jComboBoxResolution = new JComboBox();
            this.jComboBoxResolution.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxResolution.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxResolution.setEditable(false);
            this.jComboBoxResolution.setToolTipText("Select the target resolution");
            for (Resolution resolution : Resolution.values()) {
                this.jComboBoxResolution.addItem(resolution.toString());
            }
        }
        return this.jComboBoxResolution;
    }

    void addResolutionComboBoxItemListener(ItemListener itemListener) {
        this.jComboBoxResolution.addItemListener(itemListener);
    }

    int getResolutionComboBoxSelectedIndex() {
        return this.jComboBoxResolution.getSelectedIndex();
    }

    void setResolutionComboBoxEnabled(boolean enabled) {
        this.jComboBoxResolution.setEnabled(enabled);
    }

    private JCheckBox getJCheckBoxFrameRate() {
        if (this.jCheckBoxFrameRate == null) {
            this.jCheckBoxFrameRate = new JCheckBox();
            this.jCheckBoxFrameRate.setToolTipText("Convert frame rate from FPS Source to FPS target");
            this.jCheckBoxFrameRate.setText("Change frame rate");
            this.jCheckBoxFrameRate.setMnemonic('f');
            this.jCheckBoxFrameRate.setFocusable(false);
            this.jCheckBoxFrameRate.setIconTextGap(10);
        }
        return this.jCheckBoxFrameRate;
    }

    void addFrameRateCheckBoxActionListener(ActionListener actionListener) {
        this.jCheckBoxFrameRate.addActionListener(actionListener);
    }

    boolean isFrameRateCheckBoxSelected() {
        return this.jCheckBoxFrameRate.isSelected();
    }

    private JCheckBox getJCheckBoxResolution() {
        if (this.jCheckBoxResolution == null) {
            this.jCheckBoxResolution = new JCheckBox();
            this.jCheckBoxResolution.setToolTipText("Convert resolution");
            String text = "Convert resolution";
            this.jCheckBoxResolution.setText(text);
            this.jCheckBoxResolution.setMnemonic('r');
            this.jCheckBoxResolution.setDisplayedMnemonicIndex(text.indexOf("resolution"));
            this.jCheckBoxResolution.setFocusable(false);
            this.jCheckBoxResolution.setIconTextGap(10);
        }
        return this.jCheckBoxResolution;
    }

    void addResolutionCheckBoxActionListener(ActionListener actionListener) {
        this.jCheckBoxResolution.addActionListener(actionListener);
    }

    boolean isResolutionCheckBoxSelected() {
        return this.jCheckBoxResolution.isSelected();
    }

    private JCheckBox getJCheckBoxMove() {
        if (this.jCheckBoxMove == null) {
            this.jCheckBoxMove = new JCheckBox();
            this.jCheckBoxMove.setToolTipText("Apply settings for moving captions");
            this.jCheckBoxMove.setText("Apply 'move all' settings");
            this.jCheckBoxMove.setMnemonic('v');
            this.jCheckBoxMove.setFocusable(false);
            this.jCheckBoxMove.setIconTextGap(10);
            this.jCheckBoxMove.setEnabled(false);
            this.jCheckBoxMove.setSelected(this.model.getMoveCaptions());
        }
        return this.jCheckBoxMove;
    }

    void addMoveCheckBoxActionListener(ActionListener actionListener) {
        this.jCheckBoxMove.addActionListener(actionListener);
    }

    boolean isMoveCheckBoxSelected() {
        return this.jCheckBoxMove.isSelected();
    }

    boolean isMoveCheckBoxEnabled() {
        return this.jCheckBoxMove.isEnabled();
    }

    private JComboBox getJComboBoxFpsSrc() {
        if (this.jComboBoxFpsSrc == null) {
            this.jComboBoxFpsSrc = new JComboBox();
            this.jComboBoxFpsSrc.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxFpsSrc.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxFpsSrc.setEditable(true);
            this.jComboBoxFpsSrc.setEnabled(false);
            this.jComboBoxFpsSrc.setToolTipText("Set the source frame rate (only needed for frame rate conversion)");
            for (String fps : FRAMERATES) {
                this.jComboBoxFpsSrc.addItem(fps);
            }
        }
        return this.jComboBoxFpsSrc;
    }

    void addFpsSrcComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxFpsSrc.addActionListener(actionListener);
    }

    void addFpsSrcComboBoxDocumentListener(DocumentListener documentListener) {
        JTextField fpsSrcEditor = (JTextField)this.jComboBoxFpsSrc.getEditor().getEditorComponent();
        fpsSrcEditor.getDocument().addDocumentListener(documentListener);
    }

    String getFpsSrcComboBoxText() {
        JTextField fpsSrcEditor = (JTextField)this.jComboBoxFpsSrc.getEditor().getEditorComponent();
        return fpsSrcEditor.getText();
    }

    void setFpsSrcComboBoxEnabled(boolean enabled) {
        this.jComboBoxFpsSrc.setEnabled(enabled);
    }

    String getFpsSrcComboBoxSelectedItem() {
        return (String)this.jComboBoxFpsSrc.getSelectedItem();
    }

    void setFpsSrcComboBoxBackground(Color color) {
        this.jComboBoxFpsSrc.getEditor().getEditorComponent().setBackground(color);
    }

    void setFpsSrcComboBoxSelectedItem(String item) {
        this.jComboBoxFpsSrc.setSelectedItem(item);
    }

    private JComboBox getJComboBoxFpsTrg() {
        if (this.jComboBoxFpsTrg == null) {
            this.jComboBoxFpsTrg = new JComboBox();
            this.jComboBoxFpsTrg.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxFpsTrg.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxFpsTrg.setEditable(true);
            this.jComboBoxFpsTrg.setEnabled(false);
            this.jComboBoxFpsTrg.setToolTipText("Set the target frame rate");
            for (String fps : FRAMERATES) {
                this.jComboBoxFpsTrg.addItem(fps);
            }
        }
        return this.jComboBoxFpsTrg;
    }

    void addFpsTrgComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxFpsTrg.addActionListener(actionListener);
    }

    void addFpsTrgComboBoxDocumentListener(DocumentListener documentListener) {
        JTextField fpsTrgEditor = (JTextField)this.jComboBoxFpsTrg.getEditor().getEditorComponent();
        fpsTrgEditor.getDocument().addDocumentListener(documentListener);
    }

    String getFpsTrgComboBoxText() {
        JTextField fpsTrgEditor = (JTextField)this.jComboBoxFpsTrg.getEditor().getEditorComponent();
        return fpsTrgEditor.getText();
    }

    String getFpsTrgComboBoxSelectedItem() {
        return (String)this.jComboBoxFpsTrg.getSelectedItem();
    }

    void setFpsTrgComboBoxSelectedItem(String item) {
        this.jComboBoxFpsTrg.setSelectedItem(item);
    }

    void setFpsTrgComboBoxBackground(Color color) {
        this.jComboBoxFpsTrg.getEditor().getEditorComponent().setBackground(color);
    }

    private JTextField getJTextFieldDelay() {
        if (this.jTextFieldDelay == null) {
            this.jTextFieldDelay = new JTextField();
            this.jTextFieldDelay.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldDelay.setToolTipText("Set global delay (in milliseconds) added to all timestamps");
        }
        return this.jTextFieldDelay;
    }

    void addDelayTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldDelay.addActionListener(actionListener);
    }

    void addDelayTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldDelay.getDocument().addDocumentListener(documentListener);
    }

    String getDelayTextFieldText() {
        return this.jTextFieldDelay.getText();
    }

    void setDelayTextFieldText(String text) {
        this.jTextFieldDelay.setText(text);
    }

    void setDelayTextFieldBoxBackground(Color color) {
        this.jTextFieldDelay.setBackground(color);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Lose all changes and use the default values");
            this.jButtonCancel.setMnemonic('c');
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonStore() {
        if (this.jButtonStore == null) {
            this.jButtonStore = new JButton();
            this.jButtonStore.setText("Store");
            this.jButtonStore.setToolTipText("Store current settings as default");
            this.jButtonStore.setMnemonic('s');
        }
        return this.jButtonStore;
    }

    void addStoreButtonActionListener(ActionListener actionListener) {
        this.jButtonStore.addActionListener(actionListener);
    }

    private JButton getJButtonRestore() {
        if (this.jButtonRestore == null) {
            this.jButtonRestore = new JButton();
            this.jButtonRestore.setText("Restore");
            this.jButtonRestore.setToolTipText("Restore last default settings");
            this.jButtonRestore.setMnemonic('e');
        }
        return this.jButtonRestore;
    }

    void addRestoreButtonActionListener(ActionListener actionListener) {
        this.jButtonRestore.addActionListener(actionListener);
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setText("Reset");
            this.jButtonReset.setToolTipText("Reset defaults");
            this.jButtonReset.setMnemonic('t');
        }
        return this.jButtonReset;
    }

    void addResetButtonActionListener(ActionListener actionListener) {
        this.jButtonReset.addActionListener(actionListener);
    }

    private JCheckBox getJCheckBoxScale() {
        if (this.jCheckBoxScale == null) {
            this.jCheckBoxScale = new JCheckBox();
            this.jCheckBoxScale.setToolTipText("Allow free scaling of subtitles in X and Y direction");
            this.jCheckBoxScale.setText("Apply free scaling");
            this.jCheckBoxScale.setMnemonic('a');
            this.jCheckBoxScale.setFocusable(false);
            this.jCheckBoxScale.setIconTextGap(10);
        }
        return this.jCheckBoxScale;
    }

    void addScaleCheckBoxItemListener(ItemListener itemListener) {
        this.jCheckBoxScale.addItemListener(itemListener);
    }

    boolean isScaleCheckBoxSelected() {
        return this.jCheckBoxScale.isSelected();
    }

    private JCheckBox getJCheckBoxFixMinTime() {
        if (this.jCheckBoxFixMinTime == null) {
            this.jCheckBoxFixMinTime = new JCheckBox();
            this.jCheckBoxFixMinTime.setToolTipText("Force a minimum display duration of 'Min Time'");
            this.jCheckBoxFixMinTime.setText("Fix too short frames");
            this.jCheckBoxFixMinTime.setMnemonic('x');
            this.jCheckBoxFixMinTime.setFocusable(false);
            this.jCheckBoxFixMinTime.setIconTextGap(10);
        }
        return this.jCheckBoxFixMinTime;
    }

    void addFixMinTimeCheckBoxItemListener(ItemListener itemListener) {
        this.jCheckBoxFixMinTime.addItemListener(itemListener);
    }

    boolean isFixMinTimeCheckBoxSelected() {
        return this.jCheckBoxFixMinTime.isSelected();
    }

    private JTextField getJTextFieldMinTime() {
        if (this.jTextFieldMinTime == null) {
            this.jTextFieldMinTime = new JTextField();
            this.jTextFieldMinTime.setEditable(true);
            this.jTextFieldMinTime.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldMinTime.setEnabled(false);
            this.jTextFieldMinTime.setToolTipText("Set minimum display time for a subtitle");
        }
        return this.jTextFieldMinTime;
    }

    void addMinTimeTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldMinTime.addActionListener(actionListener);
    }

    void addMinTimeTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldMinTime.getDocument().addDocumentListener(documentListener);
    }

    String getMinTimeTextFieldText() {
        return this.jTextFieldMinTime.getText();
    }

    void setMinTimeTextFieldText(String text) {
        this.jTextFieldMinTime.setText(text);
    }

    void setMinTimeTextFieldBackground(Color color) {
        this.jTextFieldMinTime.setBackground(color);
    }

    void enableMinTimeTextField(boolean enabled) {
        this.jTextFieldMinTime.setEnabled(enabled);
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("  Ok  ");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.setToolTipText("Use current values and continue");
            this.jButtonOk.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonOk;
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.jButtonOk.addActionListener(actionListener);
    }

    private JTextField getJTextFieldScaleX() {
        if (this.jTextFieldScaleX == null) {
            this.jTextFieldScaleX = new JTextField();
            this.jTextFieldScaleX.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldScaleX.setToolTipText("Set free scaling factor in X direction");
        }
        return this.jTextFieldScaleX;
    }

    void addScaleXTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldScaleX.addActionListener(actionListener);
    }

    void addScaleXTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldScaleX.getDocument().addDocumentListener(documentListener);
    }

    String getScaleXTextFieldText() {
        return this.jTextFieldScaleX.getText();
    }

    void setScaleXTextFieldText(String text) {
        this.jTextFieldScaleX.setText(text);
    }

    void enableScaleXTextField(boolean enabled) {
        this.jTextFieldScaleX.setEnabled(enabled);
    }

    void setScaleXTextFieldBackground(Color color) {
        this.jTextFieldScaleX.setBackground(color);
    }

    private JTextField getJTextFieldScaleY() {
        if (this.jTextFieldScaleY == null) {
            this.jTextFieldScaleY = new JTextField();
            this.jTextFieldScaleY.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldScaleY.setToolTipText("Set free scaling factor in Y direction");
        }
        return this.jTextFieldScaleY;
    }

    void addScaleYTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldScaleY.addActionListener(actionListener);
    }

    void addScaleYTextFieldDocumentListener(DocumentListener documentListener) {
        this.jTextFieldScaleY.getDocument().addDocumentListener(documentListener);
    }

    String getScaleYTextFieldText() {
        return this.jTextFieldScaleY.getText();
    }

    void setScaleYTextFieldText(String text) {
        this.jTextFieldScaleY.setText(text);
    }

    void enableScaleYTextField(boolean enabled) {
        this.jTextFieldScaleY.setEnabled(enabled);
    }

    void setScaleYTextFieldBackground(Color color) {
        this.jTextFieldScaleY.setBackground(color);
    }

    private JComboBox getJComboBoxForced() {
        if (this.jComboBoxForced == null) {
            this.jComboBoxForced = new JComboBox();
            this.jComboBoxForced.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxForced.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxForced.setEditable(false);
            this.jComboBoxForced.setToolTipText("Select the target resolution");
            for (ForcedFlagState state : ForcedFlagState.values()) {
                this.jComboBoxForced.addItem(state.toString());
            }
        }
        return this.jComboBoxForced;
    }

    void addForcedComboBoxItemListener(ItemListener itemListener) {
        this.jComboBoxForced.addItemListener(itemListener);
    }

    int getForcedComboBoxSelectedIndex() {
        return this.jComboBoxForced.getSelectedIndex();
    }

    public void enableOptionMove(boolean e) {
        this.jCheckBoxMove.setEnabled(e);
    }
}

