/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.edit;

import bdsup2sub.bitmap.ErasePatch;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.gui.edit.EditDialogModel;
import bdsup2sub.gui.edit.EditDialogView;
import bdsup2sub.gui.support.EditPane;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditDialogController {
    private final EditDialogModel model;
    private final EditDialogView view;

    public EditDialogController(EditDialogModel model, EditDialogView view) {
        this.model = model;
        this.view = view;
        this.addListenersToView(view);
    }

    private void addListenersToView(EditDialogView view) {
        view.addWindowListener(new EditDialogWindowListener());
        view.addPreviewPanelSelectListener(new PreviewPanelSelectListener());
        view.addPrevButtonActionListener(new PrevButtonActionListener());
        view.addNextButtonActionListener(new NextButtonActionListener());
        view.addVerticalSliderChangeListener(new VerticalSliderChangeListener());
        view.addHorizontalSliderChangeListener(new HorizontalSliderChangeListener());
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addOkButtonActionListener(new OkButtonActionListener());
        view.addXTextFieldActionListener(new XTextFieldActionListener());
        view.addXTextFieldDocumentListener(new XTextFieldDocumentListener());
        view.addYTextFieldActionListener(new YTextFieldActionListener());
        view.addYTextFieldDocumentListener(new YTextFieldDocumentListener());
        view.addCenterButtonActionListener(new CenterButtonActionListener());
        view.addStartTextFieldActionListener(new StartTextFieldActionListener());
        view.addStartTextFieldDocumentListener(new StartTextFieldDocumentListener());
        view.addEndTextFieldActionListener(new EndTextFieldActionListener());
        view.addEndTextFieldDocumentListener(new EndTextFieldDocumentListener());
        view.addDurationTextFieldActionListener(new DurationTextFieldActionListener());
        view.addDurationTextFieldDocumentListener(new DurationTextFieldDocumentListener());
        view.addMinButtonActionListener(new MinButtonActionListener());
        view.addMaxButtonActionListener(new MaxButtonActionListener());
        view.addTopButtonActionListener(new TopButtonActionListener());
        view.addBottomButtonActionListener(new BottomButtonActionListener());
        view.addStoreButtonActionListener(new StoreButtonActionListener());
        view.addForcedCheckBoxActionListener(new ForcedCheckBoxActionListener());
        view.addExcludeCheckBoxActionListener(new ExcludeCheckBoxActionListener());
        view.addAddPatchButtonActionListener(new AddPatchButtonActionListener());
        view.addUndoPatchButtonActionListener(new UndoPatchButtonActionListener());
        view.addUndoAllPatchesButtonActionListener(new UndoAllPatchesButtonActionListener());
        view.addStoreNextButtonActionListener(new StoreNextButtonActionListener());
        view.addStorePrevButtonActionListener(new StorePrevButtonActionListener());
    }

    private void setEdited(boolean edited) {
        this.model.setEdited(edited);
        this.view.enableStoreButton(edited);
    }

    private void store() {
        SubPicture subPic = this.model.getSubPic();
        SubPicture s = Core.getSubPictureTrg(this.model.getIndex());
        s.setEndTime(subPic.getEndTime());
        s.setStartTime(subPic.getStartTime());
        s.setOfsX(subPic.getXOffset());
        s.setOfsY(subPic.getYOffset());
        s.setForced(subPic.isForced());
        s.setExcluded(subPic.isExcluded());
        s.setErasePatch(subPic.getErasePatch());
    }

    private class PreviewPanelSelectListener
    implements EditPane.SelectListener {
        private PreviewPanelSelectListener() {
        }

        public void selectionPerformed(boolean validSelection) {
            EditDialogController.this.view.setAddPatchButtonEnabled(validSelection);
        }
    }

    private class StorePrevButtonActionListener
    implements ActionListener {
        private StorePrevButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isEdited()) {
                EditDialogController.this.store();
            }
            if (EditDialogController.this.model.getIndex() > 0) {
                EditDialogController.this.view.setIndex(EditDialogController.this.model.getIndex() - 1);
                EditDialogController.this.setEdited(false);
            }
        }
    }

    private class StoreNextButtonActionListener
    implements ActionListener {
        private StoreNextButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isEdited()) {
                EditDialogController.this.store();
            }
            if (EditDialogController.this.model.getIndex() < Core.getNumFrames() - 1) {
                EditDialogController.this.view.setIndex(EditDialogController.this.model.getIndex() + 1);
                EditDialogController.this.setEdited(false);
            }
        }
    }

    private class UndoAllPatchesButtonActionListener
    implements ActionListener {
        private UndoAllPatchesButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            if (!subPic.getErasePatch().isEmpty()) {
                subPic.getErasePatch().clear();
                EditDialogController.this.model.setImage(Core.getTrgImagePatched(subPic));
                EditDialogController.this.view.setPreviewPanelImage(EditDialogController.this.model.getImage(), subPic.getImageWidth(), subPic.getImageHeight());
                EditDialogController.this.view.repaintPreviewPanel();
                EditDialogController.this.setEdited(true);
            }
            EditDialogController.this.view.setUndoPatchButtonEnabled(false);
            EditDialogController.this.view.setUndoAllPatchesButtonEnabled(false);
        }
    }

    private class UndoPatchButtonActionListener
    implements ActionListener {
        private UndoPatchButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            if (!subPic.getErasePatch().isEmpty()) {
                subPic.getErasePatch().remove(subPic.getErasePatch().size() - 1);
                if (subPic.getErasePatch().isEmpty()) {
                    EditDialogController.this.view.setUndoPatchButtonEnabled(false);
                    EditDialogController.this.view.setUndoAllPatchesButtonEnabled(false);
                }
                EditDialogController.this.model.setImage(Core.getTrgImagePatched(subPic));
                EditDialogController.this.view.setPreviewPanelImage(EditDialogController.this.model.getImage(), subPic.getImageWidth(), subPic.getImageHeight());
                EditDialogController.this.view.repaintPreviewPanel();
                EditDialogController.this.setEdited(true);
            }
        }
    }

    private class AddPatchButtonActionListener
    implements ActionListener {
        private AddPatchButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            int[] sel = EditDialogController.this.view.getPreviewPanelSelection();
            if (sel != null) {
                ErasePatch ep = new ErasePatch(sel[0], sel[1], sel[2] - sel[0] + 1, sel[3] - sel[1] + 1);
                subPic.getErasePatch().add(ep);
                EditDialogController.this.view.setUndoPatchButtonEnabled(true);
                EditDialogController.this.view.setUndoAllPatchesButtonEnabled(true);
                EditDialogController.this.model.setImage(Core.getTrgImagePatched(subPic));
                EditDialogController.this.view.setPreviewPanelImage(EditDialogController.this.model.getImage(), subPic.getImageWidth(), subPic.getImageHeight());
                EditDialogController.this.setEdited(true);
            }
            EditDialogController.this.view.setAddPatchButtonEnabled(false);
            EditDialogController.this.view.removePreviewPanelSelection();
            EditDialogController.this.view.repaintPreviewPanel();
        }
    }

    private class ExcludeCheckBoxActionListener
    implements ActionListener {
        private ExcludeCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            subPic.setExcluded(EditDialogController.this.view.isExcludeCheckBoxSelected());
            EditDialogController.this.view.setPreviewPanelExcluded(subPic.isExcluded());
            EditDialogController.this.view.repaintPreviewPanel();
            EditDialogController.this.setEdited(true);
        }
    }

    private class ForcedCheckBoxActionListener
    implements ActionListener {
        private ForcedCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            EditDialogController.this.model.getSubPic().setForced(EditDialogController.this.view.isForcedCheckBoxSelected());
            EditDialogController.this.setEdited(true);
        }
    }

    private class StoreButtonActionListener
    implements ActionListener {
        private StoreButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            EditDialogController.this.store();
            EditDialogController.this.setEdited(false);
        }
    }

    private class BottomButtonActionListener
    implements ActionListener {
        private BottomButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            int cineH = subPic.getHeight() * 5 / 42;
            int y = subPic.getHeight() - cineH;
            if (y + subPic.getImageHeight() > subPic.getHeight() - EditDialogController.this.model.getCropOffsetY()) {
                y = subPic.getHeight() - subPic.getImageHeight() - 10;
            }
            EditDialogController.this.model.setEnableSliders(false);
            subPic.setOfsY(y);
            EditDialogController.this.view.setVerticalSliderValue(subPic.getHeight() - subPic.getYOffset());
            EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
            EditDialogController.this.view.repaintPreviewPanel();
            EditDialogController.this.view.setYTextFieldText(String.valueOf(subPic.getYOffset()));
            EditDialogController.this.setEdited(true);
            EditDialogController.this.model.setEnableSliders(true);
        }
    }

    private class TopButtonActionListener
    implements ActionListener {
        private TopButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            int cineH = subPic.getHeight() * 5 / 42;
            int y = cineH - subPic.getImageHeight();
            if (y < 10) {
                y = 10;
            }
            if (y < EditDialogController.this.model.getCropOffsetY()) {
                y = EditDialogController.this.model.getCropOffsetY();
            }
            EditDialogController.this.model.setEnableSliders(false);
            subPic.setOfsY(y);
            EditDialogController.this.view.setVerticalSliderValue(subPic.getHeight() - subPic.getYOffset());
            EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
            EditDialogController.this.view.repaintPreviewPanel();
            EditDialogController.this.view.setYTextFieldText(String.valueOf(subPic.getYOffset()));
            EditDialogController.this.setEdited(true);
            EditDialogController.this.model.setEnableSliders(true);
        }
    }

    private class MaxButtonActionListener
    implements ActionListener {
        private MaxButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            SubPicture subPicNext = EditDialogController.this.model.getSubPicNext();
            long t = subPicNext != null ? subPicNext.getStartTime() : subPic.getEndTime() + 900000L;
            subPic.setEndTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
            EditDialogController.this.view.setEndTextFieldText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
            EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
            EditDialogController.this.setEdited(true);
        }
    }

    private class MinButtonActionListener
    implements ActionListener {
        private MinButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            long t = EditDialogController.this.model.getMinTimePTS();
            if (t >= 0L) {
                SubPicture subPicNext = EditDialogController.this.model.getSubPicNext();
                if (subPicNext != null && subPicNext.getStartTime() < (t += subPic.getStartTime())) {
                    t = subPicNext.getStartTime();
                }
                subPic.setEndTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
                EditDialogController.this.view.setEndTextFieldText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
                EditDialogController.this.setEdited(true);
            }
            EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
        }
    }

    private class DurationTextFieldDocumentListener
    implements DocumentListener {
        private DurationTextFieldDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (EditDialogController.this.model.isReady()) {
                EditDialogController.this.model.setReady(false);
                long t = (long)(ToolBox.getDouble(EditDialogController.this.view.getDurationTextFieldText()) * 90.0);
                if (t < (long)EditDialogController.this.model.getFrameTime()) {
                    EditDialogController.this.view.setDurationTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    SubPicture subPic = EditDialogController.this.model.getSubPic();
                    SubPicture subPicNext = EditDialogController.this.model.getSubPicNext();
                    if (subPicNext != null && subPicNext.getStartTime() < (t += subPic.getStartTime())) {
                        t = subPicNext.getStartTime();
                    }
                    subPic.setEndTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
                    EditDialogController.this.view.setEndTextFieldText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
                    EditDialogController.this.setEdited(true);
                    if (!EditDialogController.this.view.getDurationTextFieldText().equalsIgnoreCase(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0))) {
                        EditDialogController.this.view.setDurationTextFieldBackground(Configuration.WARN_BACKGROUND);
                    } else {
                        EditDialogController.this.view.setDurationTextFieldBackground(Configuration.OK_BACKGROUND);
                    }
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class DurationTextFieldActionListener
    implements ActionListener {
        private DurationTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isReady()) {
                EditDialogController.this.model.setReady(false);
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                long t = (long)(ToolBox.getDouble(EditDialogController.this.view.getDurationTextFieldText()) * 90.0);
                if (t >= 0L && t < (long)EditDialogController.this.model.getFrameTime()) {
                    t = EditDialogController.this.model.getFrameTime();
                }
                if (t > 0L) {
                    SubPicture subPicNext = EditDialogController.this.model.getSubPicNext();
                    if (subPicNext != null && subPicNext.getStartTime() < (t += subPic.getStartTime())) {
                        t = subPicNext.getStartTime();
                    }
                    subPic.setEndTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
                    EditDialogController.this.view.setEndTextFieldText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
                EditDialogController.this.view.setDurationTextFieldBackground(Configuration.OK_BACKGROUND);
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class EndTextFieldDocumentListener
    implements DocumentListener {
        private EndTextFieldDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (EditDialogController.this.model.isReady()) {
                EditDialogController.this.model.setReady(false);
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                long t = SubtitleUtils.syncTimePTS(TimeUtils.timeStrToPTS(EditDialogController.this.view.getEndTextFieldText()), EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg());
                if (t < 0L || t <= subPic.getStartTime() || EditDialogController.this.model.getSubPicNext() != null && EditDialogController.this.model.getSubPicNext().getStartTime() < t) {
                    EditDialogController.this.view.setEndTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    subPic.setEndTime(t);
                    EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
                    if (!EditDialogController.this.view.getEndTextFieldText().equalsIgnoreCase(TimeUtils.ptsToTimeStr(subPic.getEndTime()))) {
                        EditDialogController.this.view.setEndTextFieldBackground(Configuration.WARN_BACKGROUND);
                    } else {
                        EditDialogController.this.view.setEndTextFieldBackground(Configuration.OK_BACKGROUND);
                    }
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class EndTextFieldActionListener
    implements ActionListener {
        private EndTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isReady()) {
                SubPicture subPicNext;
                EditDialogController.this.model.setReady(false);
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                long t = SubtitleUtils.syncTimePTS(TimeUtils.timeStrToPTS(EditDialogController.this.view.getEndTextFieldText()), EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg());
                if (t <= subPic.getStartTime()) {
                    t = subPic.getStartTime() + (long)EditDialogController.this.model.getFrameTime();
                }
                if ((subPicNext = EditDialogController.this.model.getSubPicNext()) != null && subPicNext.getStartTime() < t) {
                    t = subPicNext.getStartTime();
                }
                if (t >= 0L) {
                    subPic.setEndTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
                    EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.view.setEndTextFieldText(TimeUtils.ptsToTimeStr(subPic.getEndTime()));
                EditDialogController.this.view.setEndTextFieldBackground(Configuration.OK_BACKGROUND);
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class StartTextFieldDocumentListener
    implements DocumentListener {
        private StartTextFieldDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (EditDialogController.this.model.isReady()) {
                EditDialogController.this.model.setReady(false);
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                long t = SubtitleUtils.syncTimePTS(TimeUtils.timeStrToPTS(EditDialogController.this.view.getStartTextFieldText()), EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg());
                if (t < 0L || t >= subPic.getEndTime() || EditDialogController.this.model.getSubPicPrev() != null && EditDialogController.this.model.getSubPicPrev().getEndTime() > t) {
                    EditDialogController.this.view.setStartTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    subPic.setStartTime(t);
                    EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
                    if (!EditDialogController.this.view.getStartTextFieldText().equalsIgnoreCase(TimeUtils.ptsToTimeStr(subPic.getStartTime()))) {
                        EditDialogController.this.view.setStartTextFieldBackground(Configuration.WARN_BACKGROUND);
                    } else {
                        EditDialogController.this.view.setStartTextFieldBackground(Configuration.OK_BACKGROUND);
                    }
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class StartTextFieldActionListener
    implements ActionListener {
        private StartTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isReady()) {
                SubPicture subPicPrev;
                EditDialogController.this.model.setReady(false);
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                long t = SubtitleUtils.syncTimePTS(TimeUtils.timeStrToPTS(EditDialogController.this.view.getStartTextFieldText()), EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg());
                if (t >= subPic.getEndTime()) {
                    t = subPic.getEndTime() - (long)EditDialogController.this.model.getFrameTime();
                }
                if ((subPicPrev = EditDialogController.this.model.getSubPicPrev()) != null && subPicPrev.getEndTime() > t) {
                    t = subPicPrev.getEndTime() + (long)EditDialogController.this.model.getFrameTime();
                }
                if (t >= 0L) {
                    subPic.setStartTime(SubtitleUtils.syncTimePTS(t, EditDialogController.this.model.getFPSTrg(), EditDialogController.this.model.getFPSTrg()));
                    EditDialogController.this.view.setDurationTextFieldText(ToolBox.formatDouble((double)(subPic.getEndTime() - subPic.getStartTime()) / 90.0));
                    EditDialogController.this.setEdited(true);
                }
                EditDialogController.this.view.setStartTextFieldText(TimeUtils.ptsToTimeStr(subPic.getStartTime()));
                EditDialogController.this.view.setStartTextFieldBackground(Configuration.OK_BACKGROUND);
                EditDialogController.this.model.setReady(true);
            }
        }
    }

    private class CenterButtonActionListener
    implements ActionListener {
        private CenterButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            subPic.setOfsX((subPic.getWidth() - subPic.getImageWidth()) / 2);
            EditDialogController.this.model.setEnableSliders(false);
            EditDialogController.this.view.setHorizontalSliderValue(subPic.getXOffset());
            EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
            EditDialogController.this.view.repaintPreviewPanel();
            EditDialogController.this.view.setXTextFieldText(String.valueOf(subPic.getXOffset()));
            EditDialogController.this.setEdited(true);
            EditDialogController.this.model.setEnableSliders(true);
        }
    }

    private class YTextFieldDocumentListener
    implements DocumentListener {
        private YTextFieldDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (EditDialogController.this.model.isReady()) {
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                int y = ToolBox.getInt(EditDialogController.this.view.getYTextFieldText());
                if (y < EditDialogController.this.model.getCropOffsetY() || y > subPic.getHeight() - subPic.getImageHeight() - EditDialogController.this.model.getCropOffsetY()) {
                    EditDialogController.this.view.setYTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (y != subPic.getYOffset()) {
                        EditDialogController.this.model.setEnableSliders(false);
                        subPic.setOfsY(y);
                        EditDialogController.this.view.setVerticalSliderValue(subPic.getHeight() - subPic.getYOffset());
                        EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                        EditDialogController.this.view.repaintPreviewPanel();
                        EditDialogController.this.setEdited(true);
                        EditDialogController.this.model.setEnableSliders(true);
                    }
                    EditDialogController.this.view.setYTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class YTextFieldActionListener
    implements ActionListener {
        private YTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            SubPicture subPic = EditDialogController.this.model.getSubPic();
            int y = ToolBox.getInt(EditDialogController.this.view.getYTextFieldText());
            if (y == -1) {
                y = subPic.getYOffset();
            } else if (y < EditDialogController.this.model.getCropOffsetY()) {
                y = EditDialogController.this.model.getCropOffsetY();
            } else if (y > subPic.getHeight() - subPic.getImageHeight() - EditDialogController.this.model.getCropOffsetY()) {
                y = subPic.getHeight() - subPic.getImageHeight() - EditDialogController.this.model.getCropOffsetY();
            }
            if (y != subPic.getYOffset()) {
                EditDialogController.this.model.setEnableSliders(false);
                subPic.setOfsY(y);
                EditDialogController.this.view.setVerticalSliderValue(subPic.getHeight() - subPic.getYOffset());
                EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                EditDialogController.this.view.repaintPreviewPanel();
                EditDialogController.this.setEdited(true);
                EditDialogController.this.model.setEnableSliders(true);
            }
            EditDialogController.this.view.setYTextFieldText(String.valueOf(subPic.getYOffset()));
            EditDialogController.this.view.setYTextFieldBackground(Configuration.OK_BACKGROUND);
        }
    }

    private class XTextFieldDocumentListener
    implements DocumentListener {
        private XTextFieldDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (EditDialogController.this.model.isReady()) {
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                int x = ToolBox.getInt(EditDialogController.this.view.getXTextFieldText());
                if (x < 0 || x > subPic.getWidth() - subPic.getImageWidth()) {
                    EditDialogController.this.view.setXTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (x != subPic.getXOffset()) {
                        EditDialogController.this.model.setEnableSliders(false);
                        subPic.setOfsX(x);
                        EditDialogController.this.view.setHorizontalSliderValue(subPic.getXOffset());
                        EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                        EditDialogController.this.view.repaintPreviewPanel();
                        EditDialogController.this.setEdited(true);
                        EditDialogController.this.model.setEnableSliders(true);
                    }
                    EditDialogController.this.view.setXTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class XTextFieldActionListener
    implements ActionListener {
        private XTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isReady()) {
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                int x = ToolBox.getInt(EditDialogController.this.view.getXTextFieldText());
                if (x == -1) {
                    x = subPic.getXOffset();
                } else if (x < 0) {
                    x = 0;
                } else if (x > subPic.getWidth() - subPic.getImageWidth()) {
                    x = subPic.getWidth() - subPic.getImageWidth();
                }
                if (x != subPic.getXOffset()) {
                    EditDialogController.this.model.setEnableSliders(false);
                    subPic.setOfsX(x);
                    EditDialogController.this.view.setHorizontalSliderValue(subPic.getXOffset());
                    EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                    EditDialogController.this.view.repaintPreviewPanel();
                    EditDialogController.this.setEdited(true);
                    EditDialogController.this.model.setEnableSliders(true);
                }
                EditDialogController.this.view.setXTextFieldText(String.valueOf(subPic.getXOffset()));
                EditDialogController.this.view.setXTextFieldBackground(Configuration.OK_BACKGROUND);
            }
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.isEdited()) {
                EditDialogController.this.store();
            }
            EditDialogController.this.view.dispose();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            EditDialogController.this.view.dispose();
        }
    }

    private class HorizontalSliderChangeListener
    implements ChangeListener {
        private HorizontalSliderChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            if (EditDialogController.this.model.isEnableSliders()) {
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                int x = EditDialogController.this.view.getHorizontalSliderValue();
                if (x < 0) {
                    x = 0;
                } else if (x > subPic.getWidth() - subPic.getImageWidth()) {
                    x = subPic.getWidth() - subPic.getImageWidth();
                }
                if (x != subPic.getXOffset()) {
                    subPic.setOfsX(x);
                    EditDialogController.this.view.setXTextFieldText(String.valueOf(subPic.getXOffset()));
                    EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                    EditDialogController.this.view.repaintPreviewPanel();
                    EditDialogController.this.setEdited(true);
                }
            }
        }
    }

    private class VerticalSliderChangeListener
    implements ChangeListener {
        private VerticalSliderChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            if (EditDialogController.this.model.isEnableSliders()) {
                SubPicture subPic = EditDialogController.this.model.getSubPic();
                int y = subPic.getHeight() - EditDialogController.this.view.getVerticalSliderValue();
                if (y < EditDialogController.this.model.getCropOffsetY()) {
                    y = EditDialogController.this.model.getCropOffsetY();
                } else if (y > subPic.getHeight() - subPic.getImageHeight() - EditDialogController.this.model.getCropOffsetY()) {
                    y = subPic.getHeight() - subPic.getImageHeight() - EditDialogController.this.model.getCropOffsetY();
                }
                if (y != subPic.getYOffset()) {
                    subPic.setOfsY(y);
                    EditDialogController.this.view.setYTextFieldText(String.valueOf(subPic.getYOffset()));
                    EditDialogController.this.view.setPreviewPanelOffsets(subPic.getXOffset(), subPic.getYOffset());
                    EditDialogController.this.view.setPreviewPanelAspectRatio(2.3333333333333335);
                    EditDialogController.this.view.repaintPreviewPanel();
                    EditDialogController.this.setEdited(true);
                }
            }
        }
    }

    private class NextButtonActionListener
    implements ActionListener {
        private NextButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.getIndex() < Core.getNumFrames() - 1) {
                EditDialogController.this.view.setIndex(EditDialogController.this.model.getIndex() + 1);
                EditDialogController.this.setEdited(false);
            }
        }
    }

    private class PrevButtonActionListener
    implements ActionListener {
        private PrevButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EditDialogController.this.model.getIndex() > 0) {
                EditDialogController.this.view.setIndex(EditDialogController.this.model.getIndex() - 1);
                EditDialogController.this.setEdited(false);
            }
        }
    }

    private class EditDialogWindowListener
    extends WindowAdapter {
        private EditDialogWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            EditDialogController.this.view.dispose();
        }
    }
}

