/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.main;

import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.InputMode;
import bdsup2sub.core.Logger;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.PaletteMode;
import bdsup2sub.core.Resolution;
import bdsup2sub.core.ScalingFilter;
import bdsup2sub.core.StreamID;
import bdsup2sub.gui.conversion.ConversionDialog;
import bdsup2sub.gui.edit.EditDialog;
import bdsup2sub.gui.export.ExportDialog;
import bdsup2sub.gui.main.MainFrameModel;
import bdsup2sub.gui.main.MainFrameView;
import bdsup2sub.gui.move.MoveDialog;
import bdsup2sub.gui.palette.DvdPaletteDialog;
import bdsup2sub.gui.palette.FramePaletteDialog;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.StreamUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;

class MainFrameController {
    private final MainFrameView view;
    private final MainFrameModel model;
    private final ApplicationListener applicationListener = new MacOSXApplicationListener();

    public MainFrameController(MainFrameModel model, MainFrameView view) {
        this.view = view;
        this.model = model;
        view.addWindowListener(new MainWindowListener());
        this.addFileMenuActionListeners();
        this.addEditMenuActionListeners();
        this.addSettingsMenuActionListeners();
        this.addAboutMenuActionListeners();
        this.addComboBoxActionListeners();
        this.addComboBoxDocumentListeners();
        this.addPopupMenuActionListeners();
        view.addLayoutPaneMouseListener(new LayoutPaneMouseListener());
        view.addTransferHandler(new DragAndDropTransferHandler());
        if (model.isSourceFileSpecifiedOnCmdLine()) {
            this.load(model.getLoadPath());
        }
    }

    public ApplicationListener getApplicationListener() {
        return this.applicationListener;
    }

    private void addFileMenuActionListeners() {
        this.view.addLoadMenuItemActionListener(new LoadMenuItemActionListener());
        this.view.addRecentFilesMenuItemActionListener(new RecentMenuItemActionListener());
        this.view.addSaveMenuItemActionListener(new SaveMenuItemActionListener());
        this.view.addCloseMenuItemActionListener(new CloseMenuItemActionListener());
        this.view.addQuitMenuItemActionListener(new QuitMenuItemActionListener());
    }

    private void addEditMenuActionListeners() {
        this.view.addEditFrameMenuItemActionListener(new EditFrameMenuItemActionListener());
        this.view.addEditDefaultDvdPaletteMenuItemActionListener(new EditDefaultDvdPaletteMenuItemActionListener());
        this.view.addEditImportedDvdPaletteMenuItemActionListener(new EditImportedDvdPaletteMenuItemActionListener());
        this.view.addEditDvdFramePaletteMenuItemActionListener(new EditDvdFramePaletteMenuItemActionListener());
        this.view.addMoveAllMenuItemActionListener(new MoveAllMenuItemActionListener());
        this.view.addResetCropOffsetMenuItemActionListener(new ResetCropOffsetMenuItemActionListener());
    }

    private void addSettingsMenuActionListeners() {
        this.view.addConversionSettingsMenuItemActionListener(new ConversionSettingsMenuItemActionListener());
        this.view.addSwapCrCbMenuItemActionListener(new SwapCrCbMenuItemActionListener());
        this.view.addFixInvisibleFramesMenuItemActionListener(new FixInvisibleFramesMenuItemActionListener());
        this.view.addVerboseOutputMenuItemActionListener(new VerboseOutputMenuItemActionListener());
    }

    private void addAboutMenuActionListeners() {
        this.view.addHelpMenuItemActionListener(new HelpMenuItemActionListener());
        this.view.addAboutMenuItemActionListener(new AboutMenuItemActionListener());
    }

    private void addComboBoxActionListeners() {
        this.view.addSubNumComboBoxActionListener(new SubNumComboBoxActionListener());
        this.view.addAlphaThresholdComboBoxActionListener(new AlphaThresholdComboBoxActionListener());
        this.view.addMedLowThresholdComboBoxActionListener(new MedLowThresholdComboBoxActionListener());
        this.view.addHiMedThresholdComboBoxActionListener(new HiMedThresholdComboBoxActionListener());
        this.view.addOutputFormatComboBoxActionListener(new OutputFormatComboBoxActionListener());
        this.view.addPaletteComboBoxActionListener(new PaletteComboBoxActionListener());
        this.view.addFilterComboBoxActionListener(new FilterComboBoxActionListener());
    }

    private void addComboBoxDocumentListeners() {
        this.view.addSubNumComboBoxDocumentListener(new SubNumComboBoxDocumentListener());
        this.view.addAlphaThresholdComboBoxDocumentListener(new AlphaThresholdComboBoxDocumentListener());
        this.view.addMedLowThresholdComboBoxDocumentListener(new MedLowThresholdComboBoxDocumentListener());
        this.view.addHiMedThresholdComboBoxDocumentListener(new HiMedThresholdComboBoxDocumentListener());
    }

    private void addPopupMenuActionListeners() {
        this.view.addCopyPopupMenuItemActionListener(new CopyPopupMenuItemActionListener());
        this.view.addClearPopupMenuItemActionListener(new ClearPopupMenuItemActionListener());
        this.view.addConsoleMouseListener(new MouseListener());
    }

    private void loadFile() {
        List<String> extensions = Arrays.asList("idx", "ifo", "sub", "sup", "xml");
        this.view.setConsoleText("");
        String parent = FilenameUtils.getParent(this.model.getLoadPath());
        String defaultFilename = FilenameUtils.getName(this.model.getLoadPath());
        String filename = ToolBox.getFilename(parent, defaultFilename, extensions, true, this.view);
        this.load(filename);
    }

    private void exit() {
        this.view.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String fname) {
        if (fname != null) {
            if (!new File(fname).exists()) {
                JOptionPane.showMessageDialog(this.view, "File '" + fname + "' does not exist", "File not found!", 2);
            } else {
                StreamID sid;
                boolean xml = FilenameUtils.getExtension(fname).equalsIgnoreCase("xml");
                boolean idx = FilenameUtils.getExtension(fname).equalsIgnoreCase("idx");
                boolean ifo = FilenameUtils.getExtension(fname).equalsIgnoreCase("ifo");
                byte[] id = ToolBox.getFileID(fname, 4);
                StreamID streamID = sid = id == null ? StreamID.UNKNOWN : StreamUtils.getStreamID(id);
                if (idx || xml || ifo || sid != StreamID.UNKNOWN) {
                    this.view.setTitle(Constants.APP_NAME + " " + Constants.APP_VERSION + " - " + fname);
                    this.model.setSubIndex(0);
                    this.model.setLoadPath(fname);
                    String loadPath = this.model.getLoadPath();
                    this.model.setSaveFilename(FilenameUtils.removeExtension(FilenameUtils.getName(loadPath)));
                    this.model.setSavePath(FilenameUtils.getParent(loadPath));
                    this.view.enableCoreComponents(false);
                    this.view.enableVobsubBits(false);
                    try {
                        Core.readStreamThreaded(loadPath, this.view, sid);
                        this.view.warningDialog();
                        int num = Core.getNumFrames();
                        Core.setReady(false);
                        this.view.initSubNumComboBox(num);
                        this.view.initAlphaThresholdComboBoxSelectedIndices();
                        if (this.model.getCropOffsetY() > 0 && JOptionPane.showConfirmDialog(this.view, "Reset Crop Offset?", "", 0) == 0) {
                            this.model.setCropOffsetY(0);
                        }
                        ConversionDialog conversionDialog = new ConversionDialog(this.view);
                        conversionDialog.enableOptionMove(this.model.getMoveCaptions());
                        conversionDialog.setVisible(true);
                        if (!conversionDialog.wasCanceled()) {
                            Core.scanSubtitles();
                            if (this.model.getMoveCaptions()) {
                                Core.moveAllThreaded(this.view);
                            }
                            int subIndex = this.model.getSubIndex();
                            Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                            Core.setReady(true);
                            this.view.setQuitMenuItemEnabled(true);
                            this.view.refreshSrcFrame(subIndex);
                            this.view.refreshTrgFrame(subIndex);
                            this.view.enableCoreComponents(true);
                            if (this.model.getOutputMode() == OutputMode.VOBSUB || Core.getInputMode() == InputMode.SUPIFO) {
                                this.view.enableVobsubBits(true);
                            }
                            this.model.addToRecentFiles(loadPath);
                            this.view.updateRecentFilesMenu();
                        }
                        this.view.closeSub();
                        Logger.getInstance().warn("Loading cancelled by user.");
                        Core.close();
                    }
                    catch (CoreException ex) {
                        this.view.setLoadMenuItemEnabled(true);
                        this.view.updateRecentFilesMenu();
                        this.view.setComboBoxOutFormatEnabled(true);
                        this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        this.view.exit(4);
                    }
                    finally {
                        this.view.flushConsole();
                    }
                } else {
                    JOptionPane.showMessageDialog(this.view, "This is not a supported SUP stream", "Wrong format!", 2);
                }
            }
        }
    }

    private void showAboutDialog() {
        JOptionPane.showMessageDialog(this.view, Constants.APP_NAME + " v" + Constants.APP_VERSION + "\n" + "Created by " + "Volker Oth, Miklos Juhasz" + "\n" + "\n" + "Built on " + Constants.BUILD_DATE + "\n" + "Copyright \u00a9 2009 Volker Oth, 2011-2013 Miklos Juhasz", Constants.APP_NAME, 1, new ImageIcon(this.getClass().getClassLoader().getResource("icons/bdsup2sub_32.png")));
    }

    public class MacOSXApplicationListener
    implements ApplicationListener {
        private void handle(ApplicationEvent event, String message) {
            event.setHandled(true);
            JOptionPane.showMessageDialog(MainFrameController.this.view, message, Constants.APP_NAME, 1, new ImageIcon(this.getClass().getClassLoader().getResource("icons/bdsup2sub_32.png")));
        }

        public void handleAbout(ApplicationEvent event) {
            event.setHandled(true);
            MainFrameController.this.showAboutDialog();
        }

        public void handleOpenApplication(ApplicationEvent event) {
            event.setHandled(true);
        }

        public void handleOpenFile(ApplicationEvent event) {
            event.setHandled(true);
            MainFrameController.this.loadFile();
        }

        public void handlePreferences(ApplicationEvent event) {
            event.setHandled(true);
            this.handle(event, "Preferences not implemented");
        }

        public void handlePrintFile(ApplicationEvent event) {
            event.setHandled(true);
            this.handle(event, "Printing not implemented");
        }

        public void handleQuit(ApplicationEvent event) {
            event.setHandled(true);
            MainFrameController.this.exit();
        }

        public void handleReOpenApplication(ApplicationEvent event) {
            event.setHandled(true);
            MainFrameController.this.view.setVisible(true);
        }
    }

    private class LayoutPaneMouseListener
    extends MouseAdapter {
        private LayoutPaneMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && Core.isReady()) {
                EditDialog ed = new EditDialog(MainFrameController.this.view);
                ed.setIndex(MainFrameController.this.model.getSubIndex());
                ed.setVisible(true);
                MainFrameController.this.model.setSubIndex(ed.getIndex());
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                    MainFrameController.this.view.setSubNumComboBoxSelectedIndex(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            MainFrameController.this.exit();
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            this.showPopupIfApplicable(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.showPopupIfApplicable(event);
        }

        private void showPopupIfApplicable(MouseEvent event) {
            if (event.isPopupTrigger()) {
                boolean canCopy = MainFrameController.this.view.getConsoleSelectedText() != null;
                MainFrameController.this.view.setCopyPopupMenuItemEnabled(canCopy);
                MainFrameController.this.view.showPopupMenu(event.getX(), event.getY());
            }
        }
    }

    private class ClearPopupMenuItemActionListener
    implements ActionListener {
        private ClearPopupMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.view.setConsoleText("");
        }
    }

    private class CopyPopupMenuItemActionListener
    implements ActionListener {
        private CopyPopupMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String selectedText = MainFrameController.this.view.getConsoleSelectedText();
            try {
                if (selectedText != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(""), MainFrameController.this.view);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(selectedText), MainFrameController.this.view);
                }
            }
            catch (OutOfMemoryError ex) {
                JOptionPane.showMessageDialog(MainFrameController.this.view, "Out of heap! Use -Xmx256m to increase heap!", "Error!", 2);
            }
        }
    }

    private class FilterComboBoxActionListener
    implements ActionListener {
        private FilterComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx = MainFrameController.this.view.getFilterComboBoxSelectedIndex();
                for (ScalingFilter s : ScalingFilter.values()) {
                    if (idx != s.ordinal()) continue;
                    MainFrameController.this.model.setScalingFilter(s);
                    break;
                }
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class PaletteComboBoxActionListener
    implements ActionListener {
        private PaletteComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx = MainFrameController.this.view.getPaletteComboBoxSelectedIndex();
                for (PaletteMode m : PaletteMode.values()) {
                    if (idx != m.ordinal()) continue;
                    MainFrameController.this.model.setPaletteMode(m);
                    break;
                }
                MainFrameController.this.view.enableVobSubMenuCombo();
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class OutputFormatComboBoxActionListener
    implements ActionListener {
        private OutputFormatComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx = MainFrameController.this.view.getOutputFormatComboBoxSelectedIndex();
                for (OutputMode m : OutputMode.values()) {
                    if (idx != m.ordinal()) continue;
                    MainFrameController.this.model.setOutputMode(m);
                    break;
                }
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                    if (MainFrameController.this.model.getOutputMode() == OutputMode.VOBSUB || MainFrameController.this.model.getOutputMode() == OutputMode.SUPIFO) {
                        MainFrameController.this.view.enableVobsubBits(true);
                    } else {
                        MainFrameController.this.view.enableVobsubBits(false);
                    }
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class HiMedThresholdComboBoxDocumentListener
    implements DocumentListener {
        private HiMedThresholdComboBoxDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (Core.isReady()) {
                int[] lumThr = MainFrameController.this.model.getLuminanceThreshold();
                int idx = ToolBox.getInt(MainFrameController.this.view.getHiMedThresholdComboBoxText());
                if (idx < 0 || idx > 255 | idx <= lumThr[1]) {
                    MainFrameController.this.view.setHiMedThresholdComboBoxBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    lumThr[0] = idx;
                    MainFrameController.this.model.setLuminanceThreshold(lumThr);
                    try {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                    catch (CoreException ex) {
                        MainFrameController.this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        MainFrameController.this.view.exit(4);
                    }
                    MainFrameController.this.view.setHiMedThresholdComboBoxBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class HiMedThresholdComboBoxActionListener
    implements ActionListener {
        private HiMedThresholdComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx;
                int[] lumThr = MainFrameController.this.model.getLuminanceThreshold();
                try {
                    idx = Integer.parseInt(MainFrameController.this.view.getHiMedThresholdComboBoxSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    idx = lumThr[0];
                }
                if (idx <= lumThr[1]) {
                    idx = lumThr[1] + 1;
                }
                if (idx < 0) {
                    idx = 0;
                }
                if (idx > 255) {
                    idx = 255;
                }
                lumThr[0] = idx;
                MainFrameController.this.model.setLuminanceThreshold(lumThr);
                MainFrameController.this.view.setHiMedThresholdComboBoxSelectedIndex(MainFrameController.this.model.getLuminanceThreshold()[0]);
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class MedLowThresholdComboBoxDocumentListener
    implements DocumentListener {
        private MedLowThresholdComboBoxDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (Core.isReady()) {
                int[] lumThr = MainFrameController.this.model.getLuminanceThreshold();
                int idx = ToolBox.getInt(MainFrameController.this.view.getMedLowThresholdComboBoxText());
                if (idx < 0 || idx > 255 | idx >= lumThr[0]) {
                    MainFrameController.this.view.setMedLowThresholdComboBoxBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    lumThr[1] = idx;
                    MainFrameController.this.model.setLuminanceThreshold(lumThr);
                    try {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                    catch (CoreException ex) {
                        MainFrameController.this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        MainFrameController.this.view.exit(4);
                    }
                    MainFrameController.this.view.setMedLowThresholdComboBoxBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class MedLowThresholdComboBoxActionListener
    implements ActionListener {
        private MedLowThresholdComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx;
                int[] lumThr = MainFrameController.this.model.getLuminanceThreshold();
                try {
                    idx = Integer.parseInt(MainFrameController.this.view.getMedLowThresholdComboBoxSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    idx = lumThr[1];
                }
                if (idx >= lumThr[0]) {
                    idx = lumThr[0] - 1;
                }
                if (idx < 0) {
                    idx = 0;
                }
                if (idx > 255) {
                    idx = 255;
                }
                lumThr[1] = idx;
                MainFrameController.this.model.setLuminanceThreshold(lumThr);
                int index = idx;
                MainFrameController.this.view.setMedLowThresholdComboBoxSelectedIndex(index);
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class AlphaThresholdComboBoxDocumentListener
    implements DocumentListener {
        private AlphaThresholdComboBoxDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (Core.isReady()) {
                int idx = ToolBox.getInt(MainFrameController.this.view.getAlphaThresholdComboBoxText());
                if (idx < 0 || idx > 255) {
                    MainFrameController.this.view.setAlphaThresholdComboBoxBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    MainFrameController.this.model.setAlphaThreshold(idx);
                    try {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                    catch (CoreException ex) {
                        MainFrameController.this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        MainFrameController.this.view.exit(4);
                    }
                    MainFrameController.this.view.setAlphaThresholdComboBoxBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class AlphaThresholdComboBoxActionListener
    implements ActionListener {
        private AlphaThresholdComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx;
                try {
                    idx = Integer.parseInt(MainFrameController.this.view.getAlphaThresholdComboBoxSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    idx = MainFrameController.this.model.getAlphaThreshold();
                }
                if (idx < 0) {
                    idx = 0;
                }
                if (idx > 255) {
                    idx = 255;
                }
                MainFrameController.this.model.setAlphaThreshold(idx);
                MainFrameController.this.view.setAlphaThresholdComboBoxSelectedIndex(MainFrameController.this.model.getAlphaThreshold());
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class SubNumComboBoxDocumentListener
    implements DocumentListener {
        private SubNumComboBoxDocumentListener() {
        }

        public void insertUpdate(DocumentEvent event) {
            this.check();
        }

        public void changedUpdate(DocumentEvent event) {
            this.check();
        }

        public void removeUpdate(DocumentEvent event) {
            this.check();
        }

        private void check() {
            if (Core.isReady()) {
                int idx = ToolBox.getInt(MainFrameController.this.view.getSubNumComboBoxText()) - 1;
                if (idx < 0 || idx >= Core.getNumFrames()) {
                    MainFrameController.this.view.setSubNumComboBoxBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    MainFrameController.this.model.setSubIndex(idx);
                    try {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshSrcFrame(subIndex);
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                    catch (CoreException ex) {
                        MainFrameController.this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        MainFrameController.this.view.exit(4);
                    }
                    MainFrameController.this.view.setSubNumComboBoxBackground(Configuration.OK_BACKGROUND);
                }
            }
        }
    }

    private class SubNumComboBoxActionListener
    implements ActionListener {
        private SubNumComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                int idx;
                int num = Core.getNumFrames();
                try {
                    idx = Integer.parseInt(MainFrameController.this.view.getSubNumComboBoxSelectedItem().toString()) - 1;
                }
                catch (NumberFormatException ex) {
                    idx = MainFrameController.this.model.getSubIndex();
                }
                if (idx < 0) {
                    idx = 0;
                }
                if (idx >= num) {
                    idx = num - 1;
                }
                MainFrameController.this.model.setSubIndex(idx);
                MainFrameController.this.view.setSubNumComboBoxSelectedIndex(MainFrameController.this.model.getSubIndex());
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class AboutMenuItemActionListener
    implements ActionListener {
        private AboutMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.showAboutDialog();
        }
    }

    private class HelpMenuItemActionListener
    implements ActionListener {
        private HelpMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Desktop.getDesktop().browse(URI.create("http://github.com/mjuhasz/BDSup2Sub/wiki"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class VerboseOutputMenuItemActionListener
    implements ActionListener {
        private VerboseOutputMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean selected = MainFrameController.this.view.isVerboseOutputSelected();
            MainFrameController.this.model.setVerbose(selected);
        }
    }

    private class FixInvisibleFramesMenuItemActionListener
    implements ActionListener {
        private FixInvisibleFramesMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean selected = MainFrameController.this.view.isFixInvisibleFramesSelected();
            MainFrameController.this.model.setFixZeroAlpha(selected);
        }
    }

    private class SwapCrCbMenuItemActionListener
    implements ActionListener {
        private SwapCrCbMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean selected = MainFrameController.this.view.isSwapCrCbSelected();
            MainFrameController.this.model.setSwapCrCb(selected);
            try {
                if (Core.isReady()) {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
            }
            catch (CoreException ex) {
                MainFrameController.this.view.error(ex.getMessage());
            }
            catch (Exception ex) {
                ToolBox.showException(ex);
                MainFrameController.this.view.exit(4);
            }
        }
    }

    private class ConversionSettingsMenuItemActionListener
    implements ActionListener {
        private ConversionSettingsMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            double fsYOld;
            double fsXOld;
            Resolution rOld = MainFrameController.this.model.getOutputResolution();
            double fpsTrgOld = MainFrameController.this.model.getFPSTrg();
            boolean changeFpsOld = MainFrameController.this.model.getConvertFPS();
            int delayOld = MainFrameController.this.model.getDelayPTS();
            if (MainFrameController.this.model.getApplyFreeScale()) {
                fsXOld = MainFrameController.this.model.getFreeScaleX();
                fsYOld = MainFrameController.this.model.getFreeScaleY();
            } else {
                fsXOld = 1.0;
                fsYOld = 1.0;
            }
            ConversionDialog trans = new ConversionDialog(MainFrameController.this.view);
            trans.enableOptionMove(false);
            trans.setVisible(true);
            if (!trans.wasCanceled()) {
                try {
                    if (Core.isReady()) {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.reScanSubtitles(rOld, fpsTrgOld, delayOld, changeFpsOld, fsXOld, fsYOld);
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class ResetCropOffsetMenuItemActionListener
    implements ActionListener {
        private ResetCropOffsetMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.model.setCropOffsetY(0);
            MainFrameController.this.view.setLayoutPaneCropOffsetY(MainFrameController.this.model.getCropOffsetY());
            MainFrameController.this.view.repaintLayoutPane();
        }
    }

    private class MoveAllMenuItemActionListener
    implements ActionListener {
        private MoveAllMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                MoveDialog moveDialog = new MoveDialog(MainFrameController.this.view);
                moveDialog.setCurrentSubtitleIndex(MainFrameController.this.model.getSubIndex());
                moveDialog.setVisible(true);
                if (MainFrameController.this.model.getMoveCaptions()) {
                    try {
                        Core.moveAllThreaded(MainFrameController.this.view);
                    }
                    catch (CoreException ex) {
                        MainFrameController.this.view.error(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ToolBox.showException(ex);
                        MainFrameController.this.view.exit(4);
                    }
                }
                MainFrameController.this.model.setSubIndex(moveDialog.getCurrentSubtitleIndex());
                MainFrameController.this.view.setLayoutPaneAspectRatio(moveDialog.getTrgRatio());
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                    MainFrameController.this.view.setSubNumComboBoxSelectedIndex(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class EditDvdFramePaletteMenuItemActionListener
    implements ActionListener {
        private EditDvdFramePaletteMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            FramePaletteDialog framePaletteDialog = new FramePaletteDialog(MainFrameController.this.view, MainFrameController.this.model.getSubIndex());
            framePaletteDialog.setVisible(true);
            try {
                if (Core.isReady()) {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                }
            }
            catch (CoreException ex) {
                MainFrameController.this.view.error(ex.getMessage());
            }
            catch (Exception ex) {
                ToolBox.showException(ex);
                MainFrameController.this.view.exit(4);
            }
        }
    }

    private class EditImportedDvdPaletteMenuItemActionListener
    implements ActionListener {
        private EditImportedDvdPaletteMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String[] colorNames = new String[]{"Color 0", "Color 1", "Color 2", "Color 3", "Color 4", "Color 5", "Color 6", "Color 7", "Color 8", "Color 9", "Color 10", "Color 11", "Color 12", "Color 13", "Color 14", "Color 15"};
            Color[] currentColors = new Color[16];
            Color[] defaultColors = new Color[16];
            for (int i = 0; i < currentColors.length; ++i) {
                currentColors[i] = Core.getCurSrcDVDPalette().getColor(i);
                defaultColors[i] = Core.getDefSrcDVDPalette().getColor(i);
            }
            DvdPaletteDialog dvdPaletteDialog = new DvdPaletteDialog(MainFrameController.this.view, colorNames, currentColors, defaultColors, MainFrameController.this.model.getColorProfilePath());
            dvdPaletteDialog.setVisible(true);
            if (!dvdPaletteDialog.wasCanceled()) {
                currentColors = dvdPaletteDialog.getColors();
                MainFrameController.this.model.setColorProfilePath(dvdPaletteDialog.getPath());
                Palette p = new Palette(currentColors.length, true);
                for (int i = 0; i < currentColors.length; ++i) {
                    p.setColor(i, currentColors[i]);
                }
                Core.setCurSrcDVDPalette(p);
                try {
                    if (Core.isReady()) {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshSrcFrame(subIndex);
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class EditDefaultDvdPaletteMenuItemActionListener
    implements ActionListener {
        private EditDefaultDvdPaletteMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String[] colorNames = new String[]{"white", "light gray", "dark gray", "Color 1 light", "Color 1 dark", "Color 2 light", "Color 2 dark", "Color 3 light", "Color 3 dark", "Color 4 light", "Color 4 dark", "Color 5 light", "Color 5 dark", "Color 6 light", "Color 6 dark"};
            Color[] currentColors = new Color[15];
            Color[] defaultColors = new Color[15];
            for (int i = 0; i < currentColors.length; ++i) {
                currentColors[i] = Core.getCurrentDVDPalette().getColor(i + 1);
                defaultColors[i] = Constants.DEFAULT_DVD_PALETTE.getColor(i + 1);
            }
            DvdPaletteDialog dvdPaletteDialog = new DvdPaletteDialog(MainFrameController.this.view, colorNames, currentColors, defaultColors, MainFrameController.this.model.getColorProfilePath());
            dvdPaletteDialog.setVisible(true);
            if (!dvdPaletteDialog.wasCanceled()) {
                currentColors = dvdPaletteDialog.getColors();
                MainFrameController.this.model.setColorProfilePath(dvdPaletteDialog.getPath());
                for (int i = 0; i < currentColors.length; ++i) {
                    Core.getCurrentDVDPalette().setColor(i + 1, currentColors[i]);
                }
                try {
                    if (Core.isReady()) {
                        int subIndex = MainFrameController.this.model.getSubIndex();
                        Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                        MainFrameController.this.view.refreshTrgFrame(subIndex);
                    }
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class EditFrameMenuItemActionListener
    implements ActionListener {
        private EditFrameMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Core.isReady()) {
                EditDialog ed = new EditDialog(MainFrameController.this.view);
                ed.setIndex(MainFrameController.this.model.getSubIndex());
                ed.setVisible(true);
                MainFrameController.this.model.setSubIndex(ed.getIndex());
                try {
                    int subIndex = MainFrameController.this.model.getSubIndex();
                    Core.convertSup(subIndex, subIndex + 1, Core.getNumFrames());
                    MainFrameController.this.view.refreshSrcFrame(subIndex);
                    MainFrameController.this.view.refreshTrgFrame(subIndex);
                    MainFrameController.this.view.setSubNumComboBoxSelectedIndex(subIndex);
                }
                catch (CoreException ex) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    MainFrameController.this.view.exit(4);
                }
            }
        }
    }

    private class DragAndDropTransferHandler
    extends TransferHandler {
        private DragAndDropTransferHandler() {
        }

        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            try {
                List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                MainFrameController.this.load(((File)flist.get(0)).getAbsolutePath());
            }
            catch (UnsupportedFlavorException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }
    }

    private class QuitMenuItemActionListener
    implements ActionListener {
        private QuitMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.exit();
        }
    }

    private class CloseMenuItemActionListener
    implements ActionListener {
        private CloseMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Core.close();
            MainFrameController.this.view.closeSub();
        }
    }

    private class SaveMenuItemActionListener
    implements ActionListener {
        private SaveMenuItemActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            boolean showException = true;
            OutputMode outputMode = MainFrameController.this.model.getOutputMode();
            try {
                String path = MainFrameController.this.model.getSavePath() + File.separatorChar + MainFrameController.this.model.getSaveFilename() + "_exp.";
                path = outputMode == OutputMode.VOBSUB ? path + "idx" : (outputMode == OutputMode.SUPIFO ? path + "ifo" : (outputMode == OutputMode.BDSUP ? path + "sup" : path + "xml"));
                ExportDialog exportDialog = new ExportDialog(path, MainFrameController.this.view);
                exportDialog.setVisible(true);
                String fn = exportDialog.getFilename();
                if (!exportDialog.wasCanceled() && !fn.isEmpty()) {
                    File fs;
                    File fi;
                    MainFrameController.this.model.setSavePath(FilenameUtils.getParent(fn));
                    MainFrameController.this.model.setSaveFilename(FilenameUtils.removeExtension(FilenameUtils.getName(fn)).replaceAll("_exp$", ""));
                    if (outputMode == OutputMode.VOBSUB) {
                        fi = new File(FilenameUtils.removeExtension(fn) + ".idx");
                        fs = new File(FilenameUtils.removeExtension(fn) + ".sub");
                    } else if (outputMode == OutputMode.SUPIFO) {
                        fi = new File(FilenameUtils.removeExtension(fn) + ".ifo");
                        fs = new File(FilenameUtils.removeExtension(fn) + ".sup");
                    } else {
                        fi = fs = new File(FilenameUtils.removeExtension(fn) + ".sup");
                    }
                    if (fi.exists() || fs.exists()) {
                        showException = false;
                        if (fi.exists() && !fi.canWrite() || fs.exists() && !fs.canWrite()) {
                            throw new CoreException("Target is write protected.");
                        }
                        if (JOptionPane.showConfirmDialog(MainFrameController.this.view, "Target exists! Overwrite?", "", 0) == 1) {
                            throw new CoreException("Target exists. Aborted by user.");
                        }
                        showException = true;
                    }
                    Core.createSubThreaded(fn, MainFrameController.this.view);
                    MainFrameController.this.view.warningDialog();
                }
            }
            catch (CoreException ex) {
                if (showException) {
                    MainFrameController.this.view.error(ex.getMessage());
                }
            }
            catch (Exception ex) {
                ToolBox.showException(ex);
                MainFrameController.this.view.exit(4);
            }
            finally {
                MainFrameController.this.view.flushConsole();
            }
        }
    }

    private class RecentMenuItemActionListener
    implements ActionListener {
        private RecentMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.view.setConsoleText("");
            String fname = event.getActionCommand();
            MainFrameController.this.load(fname);
        }
    }

    private class LoadMenuItemActionListener
    implements ActionListener {
        private LoadMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MainFrameController.this.loadFile();
        }
    }
}

