/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class ZoomableGraphicsPanel
extends JPanel {
    private int zoomScale = 1;
    private BufferedImage image;
    private final Color color1 = Color.BLUE;
    private final Color color2 = Color.BLACK;

    public ZoomableGraphicsPanel() {
        this.addMouseListener(new MouseListener());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.draw(g);
    }

    public void update(Graphics g) {
        super.update(g);
        this.draw(g);
    }

    private void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.color1, this.getWidth(), this.getHeight(), this.color2));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            if (this.zoomScale == 1) {
                g.drawImage(this.image, 0, 0, this);
            } else {
                g2.drawImage(this.image, 0, 0, this.image.getWidth() * this.zoomScale, this.image.getHeight() * this.zoomScale, this);
            }
        }
    }

    private void setZoomScale(int s) {
        if (s != this.zoomScale && this.image != null) {
            this.zoomScale = s;
            Dimension dim = new Dimension(this.zoomScale * this.image.getWidth(), this.zoomScale * this.image.getHeight());
            this.setPreferredSize(dim);
            this.getParent().setSize(dim);
            this.getParent().getParent().revalidate();
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        Dimension dim = image != null ? new Dimension(this.zoomScale * image.getWidth(), this.zoomScale * image.getHeight()) : new Dimension(1, 1);
        this.setPreferredSize(dim);
        this.getParent().setSize(dim);
        this.getParent().getParent().revalidate();
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            int s = ZoomableGraphicsPanel.this.zoomScale;
            if (event.getButton() == 1) {
                if (s < 8) {
                    ++s;
                }
            } else if (s > 1) {
                --s;
            }
            if (s != ZoomableGraphicsPanel.this.zoomScale) {
                ZoomableGraphicsPanel.this.setZoomScale(s);
            }
        }
    }
}

