/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.move;

import bdsup2sub.core.CaptionMoveModeX;
import bdsup2sub.core.CaptionMoveModeY;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.gui.move.MoveDialogModel;
import bdsup2sub.gui.move.MoveDialogView;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.utils.ToolBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class MoveDialogController {
    private static final double SCREEN_ASPECT_RATIO = 1.7777777777777777;
    private final MoveDialogModel model;
    private final MoveDialogView view;

    public MoveDialogController(MoveDialogModel model, MoveDialogView view) {
        this.model = model;
        this.view = view;
        view.addWindowListener(new MoveDialogListener());
        view.addPrevButtonActionListener(new PrevButtonActionListener());
        view.addNextButtonActionListener(new NextButtonActionListener());
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addOkButtonActionListener(new OkButtonActionListener());
        view.addRatioTextFieldActionListener(new RatioTextFieldActionListener());
        view.addRatioTextFieldDocumentListener(new RatioTextFieldDocumentListener());
        view.addOffsetYTextFieldActionListener(new OffsetYTextFieldActionListener());
        view.addOffsetYTextFieldDocumentListener(new OffsetYTextFieldDocumentListener());
        view.add_21_9_ButtonActionListener(new RatioButtonActionListener(2.3333333333333335));
        view.add_240_1_ButtonActionListener(new RatioButtonActionListener(2.4));
        view.add_235_1_ButtonActionListener(new RatioButtonActionListener(2.35));
        view.addInsideRadioButtonActionListener(new InsideRadioButtonActionListener());
        view.addOutsideRadioButtonActionListener(new OutsideRadioButtonActionListener());
        view.addKeepYRadioButtonActionListener(new KeepYRadioButtonActionListener());
        view.addCropOfsYTextFieldActionListener(new CropOfsYTextFieldActionListener());
        view.addCropOfsYTextFieldDocumentListener(new CropOfsYTextFieldDocumentListener());
        view.addCropBarsButtonActionListener(new CropBarsButtonActionListener());
        view.addKeepXRadioButtonActionListener(new KeepXRadioButtonActionListener());
        view.addLeftRadioButtonActionListener(new LeftRadioButtonActionListener());
        view.addRightRadioButtonActionListener(new RightRadioButtonActionListener());
        view.addCenterRadioButtonActionListener(new CenterRadioButtonActionListener());
        view.addOffsetXTextFieldActionListener(new OffsetXTextFieldActionListener());
        view.addOffsetXTextFieldDocumentListener(new OffsetXTextFieldDocumentListener());
    }

    private void setRatio(double targetScreenAspectRatio) {
        if (!ToolBox.formatDouble(this.model.getTargetScreenAspectRatio()).equalsIgnoreCase(ToolBox.formatDouble(targetScreenAspectRatio))) {
            this.view.setRatioTextFieldText(ToolBox.formatDouble(targetScreenAspectRatio));
        }
        this.model.setTargetScreenAspectRatio(targetScreenAspectRatio);
        this.model.setCinemascopeBarFactor((1.0 - 1.7777777777777777 / targetScreenAspectRatio) / 2.0);
        this.move();
        this.view.setPreviewPanelAspectRatio(targetScreenAspectRatio);
        this.view.setPreviewPanelSubtitleOffsets(this.model.getSubPic().getXOffset(), this.model.getSubPic().getYOffset());
        this.view.repaintPreviewPanel();
    }

    private void move() {
        Core.moveToBounds(this.model.getSubPic(), this.model.getCurrentSubtitleIndex() + 1, this.model.getCinemascopeBarFactor(), this.model.getOffsetX(), this.model.getOffsetY(), this.model.getMoveModeX(), this.model.getMoveModeY(), this.model.getCropOfsY());
    }

    void setCurrentSubtitleIndex(int idx) {
        this.model.setReady(false);
        this.model.setCurrentSubtitleIndex(idx);
        try {
            Core.convertSup(idx, idx + 1, Core.getNumFrames());
            SubPicture subPic = new SubPicture(Core.getSubPictureTrg(idx));
            this.model.setSubPic(subPic);
            this.model.setImage(Core.getTrgImagePatched(subPic));
            this.model.setOriginalX(subPic.getXOffset());
            this.model.setOriginalY(subPic.getYOffset());
            this.view.setInfoLabelText("Frame " + (idx + 1) + " of " + Core.getNumFrames());
            this.move();
            this.view.setPreviewPanelSubtitleOffsets(subPic.getXOffset(), subPic.getYOffset());
            this.view.setPreviewPanelScreenDimension(subPic.getWidth(), subPic.getHeight());
            this.view.setPreviewPanelImage(this.model.getImage(), subPic.getImageWidth(), subPic.getImageHeight());
            this.view.setPreviewPanelAspectRatio(this.model.getTargetScreenAspectRatio());
            this.view.setPreviewPanelCropOffsetY(this.model.getCropOfsY());
            this.view.setPreviewPanelExcluded(subPic.isExcluded());
            this.view.repaintPreviewPanel();
            this.model.setReady(true);
        }
        catch (CoreException ex) {
            this.view.error(ex.getMessage());
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
            Core.exit();
            System.exit(4);
        }
    }

    private class OffsetXTextFieldDocumentListener
    implements DocumentListener {
        private OffsetXTextFieldDocumentListener() {
        }

        private void check() {
            if (MoveDialogController.this.model.isReady()) {
                int offsetX = ToolBox.getInt(MoveDialogController.this.view.getOffsetXTextFieldText());
                if (offsetX < 0 || offsetX > MoveDialogController.this.model.getSubPic().getWidth() / 3) {
                    MoveDialogController.this.view.setOffsetXTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (offsetX != MoveDialogController.this.model.getOffsetX()) {
                        MoveDialogController.this.model.setOffsetX(offsetX);
                        MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                    }
                    MoveDialogController.this.view.setOffsetXTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class OffsetXTextFieldActionListener
    implements ActionListener {
        private OffsetXTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.isReady()) {
                int offsetX = ToolBox.getInt(MoveDialogController.this.view.getOffsetXTextFieldText());
                if (offsetX == -1) {
                    offsetX = MoveDialogController.this.model.getOffsetX();
                } else if (offsetX < 0) {
                    offsetX = 0;
                } else if (offsetX > MoveDialogController.this.model.getSubPic().getWidth() / 3) {
                    offsetX = MoveDialogController.this.model.getSubPic().getWidth() / 3;
                }
                if (offsetX != MoveDialogController.this.model.getOffsetX()) {
                    MoveDialogController.this.model.setOffsetX(offsetX);
                    MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                }
                MoveDialogController.this.view.setOffsetXTextFieldText(String.valueOf(offsetX));
            }
        }
    }

    private class CenterRadioButtonActionListener
    implements ActionListener {
        private CenterRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeX(CaptionMoveModeX.CENTER);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class RightRadioButtonActionListener
    implements ActionListener {
        private RightRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeX(CaptionMoveModeX.RIGHT);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class LeftRadioButtonActionListener
    implements ActionListener {
        private LeftRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeX(CaptionMoveModeX.LEFT);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class KeepXRadioButtonActionListener
    implements ActionListener {
        private KeepXRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeX(CaptionMoveModeX.KEEP_POSITION);
            MoveDialogController.this.model.getSubPic().setOfsX(MoveDialogController.this.model.getOriginalX());
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class CropBarsButtonActionListener
    implements ActionListener {
        private CropBarsButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            int cropOffsetY = (int)((double)MoveDialogController.this.model.getSubPic().getHeight() * MoveDialogController.this.model.getCinemascopeBarFactor() + 0.5);
            MoveDialogController.this.model.setCropOfsY(cropOffsetY);
            MoveDialogController.this.view.setPreviewPanelCropOfsY(cropOffsetY);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
            MoveDialogController.this.view.setCropOfsYTextFieldText(String.valueOf(cropOffsetY));
        }
    }

    private class CropOfsYTextFieldDocumentListener
    implements DocumentListener {
        private CropOfsYTextFieldDocumentListener() {
        }

        private void check() {
            if (MoveDialogController.this.model.isReady()) {
                int cropOffsetY = ToolBox.getInt(MoveDialogController.this.view.getCropOfsYTextFieldText());
                if (cropOffsetY < 0 || cropOffsetY > MoveDialogController.this.model.getSubPic().getHeight() / 3) {
                    MoveDialogController.this.view.setCropOfsYTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (cropOffsetY != MoveDialogController.this.model.getCropOfsY()) {
                        MoveDialogController.this.model.setCropOfsY(cropOffsetY);
                        MoveDialogController.this.view.setPreviewPanelCropOfsY(cropOffsetY);
                        MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                    }
                    MoveDialogController.this.view.setCropOfsYTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class CropOfsYTextFieldActionListener
    implements ActionListener {
        private CropOfsYTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.isReady()) {
                int cropOffsetY = ToolBox.getInt(MoveDialogController.this.view.getCropOfsYTextFieldText());
                if (cropOffsetY == -1) {
                    cropOffsetY = MoveDialogController.this.model.getCropOfsY();
                } else if (cropOffsetY < 0) {
                    cropOffsetY = 0;
                } else if (cropOffsetY > MoveDialogController.this.model.getSubPic().getHeight() / 3) {
                    cropOffsetY = MoveDialogController.this.model.getSubPic().getHeight() / 3;
                }
                if (cropOffsetY != MoveDialogController.this.model.getCropOfsY()) {
                    MoveDialogController.this.model.setCropOfsY(cropOffsetY);
                    MoveDialogController.this.view.setPreviewPanelCropOfsY(cropOffsetY);
                    MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                }
                MoveDialogController.this.view.setCropOfsYTextFieldText(String.valueOf(cropOffsetY));
            }
        }
    }

    private class KeepYRadioButtonActionListener
    implements ActionListener {
        private KeepYRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeY(CaptionMoveModeY.KEEP_POSITION);
            MoveDialogController.this.model.getSubPic().setOfsY(MoveDialogController.this.model.getOriginalY());
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class OutsideRadioButtonActionListener
    implements ActionListener {
        private OutsideRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeY(CaptionMoveModeY.MOVE_OUTSIDE_BOUNDS);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class InsideRadioButtonActionListener
    implements ActionListener {
        private InsideRadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.setMoveModeY(CaptionMoveModeY.MOVE_INSIDE_BOUNDS);
            MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
        }
    }

    private class RatioButtonActionListener
    implements ActionListener {
        private final double ratio;

        private RatioButtonActionListener(double ratio) {
            this.ratio = ratio;
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.setRatio(this.ratio);
        }
    }

    private class OffsetYTextFieldDocumentListener
    implements DocumentListener {
        private OffsetYTextFieldDocumentListener() {
        }

        private void check() {
            if (MoveDialogController.this.model.isReady()) {
                int y = ToolBox.getInt(MoveDialogController.this.view.getOffsetYTextFieldText());
                if (y < 0 || y > MoveDialogController.this.model.getSubPic().getHeight() / 3) {
                    MoveDialogController.this.view.setOffsetYTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (y != MoveDialogController.this.model.getOffsetY()) {
                        MoveDialogController.this.model.setOffsetY(y);
                        MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                    }
                    MoveDialogController.this.view.setOffsetYTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class OffsetYTextFieldActionListener
    implements ActionListener {
        private OffsetYTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.isReady()) {
                int y = ToolBox.getInt(MoveDialogController.this.view.getOffsetYTextFieldText());
                if (y == -1) {
                    y = MoveDialogController.this.model.getOffsetY();
                } else if (y < 0) {
                    y = 0;
                } else if (y > MoveDialogController.this.model.getSubPic().getHeight() / 3) {
                    y = MoveDialogController.this.model.getSubPic().getHeight() / 3;
                }
                if (y != MoveDialogController.this.model.getOffsetY()) {
                    MoveDialogController.this.model.setOffsetY(y);
                    MoveDialogController.this.setRatio(MoveDialogController.this.model.getTargetScreenAspectRatio());
                }
                MoveDialogController.this.view.setOffsetYTextFieldText(String.valueOf(MoveDialogController.this.model.getOffsetY()));
            }
        }
    }

    private class RatioTextFieldDocumentListener
    implements DocumentListener {
        private RatioTextFieldDocumentListener() {
        }

        private void check() {
            if (MoveDialogController.this.model.isReady()) {
                double targetScreenAspectRatio = ToolBox.getDouble(MoveDialogController.this.view.getRatioTextFieldText());
                if (targetScreenAspectRatio < 1.7777777777777777 || targetScreenAspectRatio > 4.0) {
                    MoveDialogController.this.view.setRatioTextFieldBackground(Configuration.ERROR_BACKGROUND);
                } else {
                    if (!ToolBox.formatDouble(targetScreenAspectRatio).equalsIgnoreCase(ToolBox.formatDouble(MoveDialogController.this.model.getTargetScreenAspectRatio()))) {
                        MoveDialogController.this.model.setTargetScreenAspectRatio(targetScreenAspectRatio);
                        MoveDialogController.this.setRatio(targetScreenAspectRatio);
                    }
                    MoveDialogController.this.view.setRatioTextFieldBackground(Configuration.OK_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class RatioTextFieldActionListener
    implements ActionListener {
        private RatioTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.isReady()) {
                double targetScreenAspectRatio = ToolBox.getDouble(MoveDialogController.this.view.getRatioTextFieldText());
                if (targetScreenAspectRatio == -1.0) {
                    targetScreenAspectRatio = MoveDialogController.this.model.getTargetScreenAspectRatio();
                } else if (targetScreenAspectRatio > 4.0) {
                    targetScreenAspectRatio = 4.0;
                } else if (targetScreenAspectRatio < 1.7777777777777777) {
                    targetScreenAspectRatio = 1.7777777777777777;
                }
                if (targetScreenAspectRatio != MoveDialogController.this.model.getTargetScreenAspectRatio()) {
                    MoveDialogController.this.model.setTargetScreenAspectRatio(targetScreenAspectRatio);
                    MoveDialogController.this.setRatio(targetScreenAspectRatio);
                }
                MoveDialogController.this.view.setRatioTextFieldText(ToolBox.formatDouble(targetScreenAspectRatio));
            }
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.model.storeCropOfsY();
            MoveDialogController.this.model.storeMoveModeX();
            MoveDialogController.this.model.storeMoveModeY();
            MoveDialogController.this.model.storeMoveOffsetX();
            MoveDialogController.this.model.storeMoveOffsetY();
            MoveDialogController.this.model.storeCinemascopeBarFactor();
            MoveDialogController.this.view.dispose();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MoveDialogController.this.view.dispose();
        }
    }

    private class NextButtonActionListener
    implements ActionListener {
        private NextButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.getCurrentSubtitleIndex() < Core.getNumFrames() - 1) {
                MoveDialogController.this.setCurrentSubtitleIndex(MoveDialogController.this.model.getCurrentSubtitleIndex() + 1);
            }
        }
    }

    private class PrevButtonActionListener
    implements ActionListener {
        private PrevButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MoveDialogController.this.model.getCurrentSubtitleIndex() > 0) {
                MoveDialogController.this.setCurrentSubtitleIndex(MoveDialogController.this.model.getCurrentSubtitleIndex() - 1);
            }
        }
    }

    private class MoveDialogListener
    extends WindowAdapter {
        private MoveDialogListener() {
        }

        public void windowClosing(WindowEvent event) {
            MoveDialogController.this.view.dispose();
        }
    }
}

