/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.palette;

import bdsup2sub.core.Constants;
import bdsup2sub.core.CoreException;
import bdsup2sub.gui.palette.DvdPaletteDialogModel;
import bdsup2sub.gui.palette.DvdPaletteDialogView;
import bdsup2sub.tools.Props;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;

class DvdPaletteDialogController {
    private final DvdPaletteDialogModel model;
    private final DvdPaletteDialogView view;

    public DvdPaletteDialogController(DvdPaletteDialogModel model, DvdPaletteDialogView view) {
        this.model = model;
        this.view = view;
        view.addWindowListener(new ColorDialogWindowListener());
        view.setColorListCellRenderer(new ColorListCellRenderer());
        view.setColorListMouseListener(new ColorListMouseListener());
        view.addOkButtonActionListener(new OkButtonActionListener());
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addDefaultButtonActionListener(new DefaultButtonActionListener());
        view.addColorButtonActionListener(new ColorButtonActionListener());
        view.addSaveButtonActionListener(new SaveButtonActionListener());
        view.addLoadButtonActionListener(new LoadButtonActionListener());
    }

    private class ColorListMouseListener
    extends MouseAdapter {
        private ColorListMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                DvdPaletteDialogController.this.view.changeColor(((JList)event.getSource()).locationToIndex(event.getPoint()));
            }
        }
    }

    private class ColorListCellRenderer
    extends DefaultListCellRenderer {
        private ColorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(DvdPaletteDialogController.this.model.getColorNames()[index]);
            this.setIcon(DvdPaletteDialogController.this.model.getColorIcons()[index]);
            return retValue;
        }
    }

    private class LoadButtonActionListener
    implements ActionListener {
        private LoadButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            block7: {
                String defaultFilename;
                String parent = FilenameUtils.getParent(DvdPaletteDialogController.this.model.getColorProfilePath());
                String filename = ToolBox.getFilename(parent, defaultFilename = FilenameUtils.getName(DvdPaletteDialogController.this.model.getColorProfilePath()), Collections.singletonList("ini"), true, DvdPaletteDialogController.this.view);
                if (filename != null) {
                    File file = new File(filename);
                    try {
                        if (file.exists()) {
                            byte[] id = ToolBox.getFileID(filename, 4);
                            if (id == null || id[0] != 35 || id[1] != 67 || id[2] != 79 || id[3] != 76) {
                                JOptionPane.showMessageDialog(DvdPaletteDialogController.this.view, "This is not a valid palette file", "Wrong format!", 2);
                                throw new CoreException();
                            }
                        } else {
                            throw new CoreException("File not found.");
                        }
                        Props colProps = new Props();
                        colProps.load(filename);
                        DvdPaletteDialogController.this.model.setColorProfilePath(filename);
                        for (int i = 0; i < DvdPaletteDialogController.this.model.getSelectedColors().length; ++i) {
                            String s = colProps.get("Color_" + i, "0,0,0");
                            String[] sp = s.split(",");
                            if (sp.length < 3) continue;
                            int r = Integer.valueOf(sp[0].trim()) & 0xFF;
                            int g = Integer.valueOf(sp[1].trim()) & 0xFF;
                            int b = Integer.valueOf(sp[2].trim()) & 0xFF;
                            ((DvdPaletteDialogController)DvdPaletteDialogController.this).model.getSelectedColors()[i] = new Color(r, g, b);
                            DvdPaletteDialogController.this.view.paintIcon(DvdPaletteDialogController.this.model.getColorIcons()[i], DvdPaletteDialogController.this.model.getSelectedColors()[i]);
                        }
                        DvdPaletteDialogController.this.view.repaintColorList();
                    }
                    catch (CoreException ex) {
                        if (ex.getMessage() == null) break block7;
                        JOptionPane.showMessageDialog(DvdPaletteDialogController.this.view, ex.getMessage(), "Error!", 2);
                    }
                }
            }
        }
    }

    private class SaveButtonActionListener
    implements ActionListener {
        private SaveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            block7: {
                String defaultFilename;
                String parent = FilenameUtils.getParent(DvdPaletteDialogController.this.model.getColorProfilePath());
                String filename = ToolBox.getFilename(parent, defaultFilename = FilenameUtils.getName(DvdPaletteDialogController.this.model.getColorProfilePath()), Collections.singletonList("ini"), false, DvdPaletteDialogController.this.view);
                if (filename != null) {
                    filename = FilenameUtils.removeExtension(filename) + ".ini";
                    File file = new File(filename);
                    try {
                        if (file.exists()) {
                            if (file.exists() && !file.canWrite() || file.exists() && !file.canWrite()) {
                                throw new CoreException("Target is write protected.");
                            }
                            if (JOptionPane.showConfirmDialog(DvdPaletteDialogController.this.view, "Target exists! Overwrite?", "", 0) == 1) {
                                throw new CoreException();
                            }
                        }
                        DvdPaletteDialogController.this.model.setColorProfilePath(filename);
                        Props colProps = new Props();
                        colProps.setHeader("COL - created by " + Constants.APP_NAME + " " + Constants.APP_VERSION);
                        for (int i = 0; i < DvdPaletteDialogController.this.model.getSelectedColors().length; ++i) {
                            String s = String.valueOf(DvdPaletteDialogController.this.model.getSelectedColors()[i].getRed()) + "," + DvdPaletteDialogController.this.model.getSelectedColors()[i].getGreen() + "," + DvdPaletteDialogController.this.model.getSelectedColors()[i].getBlue();
                            colProps.set("Color_" + i, s);
                        }
                        colProps.save(DvdPaletteDialogController.this.model.getColorProfilePath());
                    }
                    catch (CoreException ex) {
                        if (ex.getMessage() == null) break block7;
                        JOptionPane.showMessageDialog(DvdPaletteDialogController.this.view, ex.getMessage(), "Error!", 2);
                    }
                }
            }
        }
    }

    private class ColorButtonActionListener
    implements ActionListener {
        private ColorButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DvdPaletteDialogController.this.view.changeColor(DvdPaletteDialogController.this.view.getSelectedColor());
        }
    }

    private class DefaultButtonActionListener
    implements ActionListener {
        private DefaultButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < DvdPaletteDialogController.this.model.getColorNames().length; ++i) {
                ((DvdPaletteDialogController)DvdPaletteDialogController.this).model.getSelectedColors()[i] = new Color(DvdPaletteDialogController.this.model.getDefaultColors()[i].getRGB());
                DvdPaletteDialogController.this.view.paintIcon(DvdPaletteDialogController.this.model.getColorIcons()[i], DvdPaletteDialogController.this.model.getSelectedColors()[i]);
            }
            DvdPaletteDialogController.this.view.repaintColorList();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DvdPaletteDialogController.this.model.setSelectedColors(DvdPaletteDialogController.this.model.getDefaultColors());
            DvdPaletteDialogController.this.view.dispose();
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DvdPaletteDialogController.this.model.setCanceled(false);
            DvdPaletteDialogController.this.view.dispose();
        }
    }

    private class ColorDialogWindowListener
    extends WindowAdapter {
        private ColorDialogWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            DvdPaletteDialogController.this.model.setSelectedColors(DvdPaletteDialogController.this.model.getDefaultColors());
        }
    }
}

