/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.palette;

import bdsup2sub.gui.palette.DvdPaletteDialogModel;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DvdPaletteDialogView
extends JDialog {
    private JPanel jContentPane;
    private JScrollPane jScrollPane;
    private JList jListColor;
    private JButton jButtonOk;
    private JButton jButtonCancel;
    private JButton jButtonDefault;
    private JButton jButtonColor;
    private JButton jButtonSave;
    private JButton jButtonLoad;
    private final DvdPaletteDialogModel model;

    public DvdPaletteDialogView(DvdPaletteDialogModel model, Frame frame) {
        super(frame, "Choose Colors", true);
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setSize(372, 231);
        this.setResizable(false);
        GuiUtils.centerRelativeToOwner(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            JLabel lblColor = new JLabel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            lblColor.setText("Choose Color");
            lblColor.setBounds(15, 9, 80, 16);
            this.jContentPane.add((Component)lblColor, null);
            this.jContentPane.add((Component)this.getJButtonOk(), null);
            this.jContentPane.add((Component)this.getJButtonCancel(), null);
            this.jContentPane.add((Component)this.getJButtonDefault(), null);
            this.jContentPane.add((Component)this.getJButtonColor(), null);
            this.jContentPane.add((Component)this.getJButtonSave(), null);
            this.jContentPane.add((Component)this.getJButtonLoad(), null);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
            this.initColorList();
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setBounds(280, 162, 66, 20);
            this.jButtonOk.setText("OK");
            this.jButtonOk.setToolTipText("Apply changes and return");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonOk;
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.jButtonOk.addActionListener(actionListener);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setBounds(175, 161, 70, 20);
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Lose changes and return");
            this.jButtonCancel.setMnemonic('c');
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonDefault() {
        if (this.jButtonDefault == null) {
            this.jButtonDefault = new JButton();
            this.jButtonDefault.setBounds(175, 60, 170, 20);
            this.jButtonDefault.setText("Restore default Colors");
            this.jButtonDefault.setToolTipText("Revert to default colors");
            this.jButtonDefault.setMnemonic('r');
        }
        return this.jButtonDefault;
    }

    void addDefaultButtonActionListener(ActionListener actionListener) {
        this.jButtonDefault.addActionListener(actionListener);
    }

    private JButton getJButtonColor() {
        if (this.jButtonColor == null) {
            this.jButtonColor = new JButton();
            this.jButtonColor.setBounds(175, 30, 170, 20);
            this.jButtonColor.setText("Change Color");
            this.jButtonColor.setToolTipText("Edit the selected color");
            this.jButtonColor.setMnemonic('h');
        }
        return this.jButtonColor;
    }

    void addColorButtonActionListener(ActionListener actionListener) {
        this.jButtonColor.addActionListener(actionListener);
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setBounds(new Rectangle(175, 92, 170, 20));
            this.jButtonSave.setText("Save Palette");
            this.jButtonSave.setToolTipText("Save the current palette settings in an INI file");
            this.jButtonSave.setMnemonic('s');
        }
        return this.jButtonSave;
    }

    void addSaveButtonActionListener(ActionListener actionListener) {
        this.jButtonSave.addActionListener(actionListener);
    }

    private JButton getJButtonLoad() {
        if (this.jButtonLoad == null) {
            this.jButtonLoad = new JButton();
            this.jButtonLoad.setBounds(new Rectangle(178, 126, 168, 18));
            this.jButtonLoad.setText("Load Palette");
            this.jButtonLoad.setToolTipText("Load palette settings from an INI file");
            this.jButtonLoad.setMnemonic('l');
        }
        return this.jButtonLoad;
    }

    void addLoadButtonActionListener(ActionListener actionListener) {
        this.jButtonLoad.addActionListener(actionListener);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(15, 30, 150, 152);
        }
        return this.jScrollPane;
    }

    private void initColorList() {
        this.jListColor = new JList<String>(this.model.getColorNames());
        this.jListColor.setSelectedIndex(0);
        this.jListColor.setSelectionMode(0);
        for (int i = 0; i < this.model.getColorNames().length; ++i) {
            this.model.getColorIcons()[i] = new ImageIcon(new BufferedImage(12, 12, 1));
            this.paintIcon(this.model.getColorIcons()[i], this.model.getSelectedColors()[i]);
        }
        this.jScrollPane.setViewportView(this.jListColor);
    }

    void setColorListMouseListener(MouseListener mouseListener) {
        this.jListColor.addMouseListener(mouseListener);
    }

    void setColorListCellRenderer(DefaultListCellRenderer cellRenderer) {
        this.jListColor.setCellRenderer(cellRenderer);
    }

    void repaintColorList() {
        this.jListColor.repaint();
    }

    int getSelectedColor() {
        return this.jListColor.getSelectedIndex();
    }

    void paintIcon(ImageIcon icon, Color color) {
        Graphics g = icon.getImage().getGraphics();
        g.setColor(color);
        g.setPaintMode();
        g.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
    }

    void changeColor(int index) {
        Color color = JColorChooser.showDialog(null, "Input Color " + this.model.getColorNames()[index], this.model.getSelectedColors()[index]);
        if (color != null) {
            this.model.getSelectedColors()[index] = color;
        }
        this.paintIcon(this.model.getColorIcons()[index], this.model.getSelectedColors()[index]);
        this.jListColor.repaint();
    }
}

