/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.support;

import bdsup2sub.gui.support.PopupUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

public final class GuiUtils {
    public static final Color GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);

    private GuiUtils() {
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static String getGtkThemeName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && "GTKLookAndFeel".equals(laf.getClass().getSimpleName())) {
            try {
                Method method = laf.getClass().getDeclaredMethod("getGtkThemeName", new Class[0]);
                method.setAccessible(true);
                Object theme = method.invoke((Object)laf, new Object[0]);
                if (theme != null) {
                    return theme.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void applyGtkThemeWorkarounds() {
        GuiUtils.fixGtkPopupStyle();
        GuiUtils.fixGtkPopupWeight();
    }

    private static void fixGtkPopupStyle() {
        if (!GuiUtils.isUnderGTKLookAndFeel()) {
            return;
        }
        final SynthStyleFactory original = SynthLookAndFeel.getStyleFactory();
        SynthLookAndFeel.setStyleFactory(new SynthStyleFactory(){

            public SynthStyle getStyle(JComponent c, Region id) {
                SynthStyle style = original.getStyle(c, id);
                if (id == Region.POPUP_MENU) {
                    this.fixPopupMenuStyle(style);
                } else if (id == Region.POPUP_MENU_SEPARATOR) {
                    this.fixPopupMenuSeparatorStyle(style);
                }
                return style;
            }

            private void fixPopupMenuStyle(SynthStyle style) {
                try {
                    Field f = this.getAccessibleFieldFromStyle(style, "xThickness");
                    Object x = f.get(style);
                    if (x instanceof Integer && (Integer)x == 0) {
                        f.set(style, 1);
                        f = this.getAccessibleFieldFromStyle(style, "yThickness");
                        f.set(style, 3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private void fixPopupMenuSeparatorStyle(SynthStyle style) {
                try {
                    Field f = this.getAccessibleFieldFromStyle(style, "yThickness");
                    Object y = f.get(style);
                    if (y instanceof Integer && (Integer)y == 0) {
                        f.set(style, 2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private Field getAccessibleFieldFromStyle(SynthStyle style, String fieldName) throws NoSuchFieldException {
                Field f = style.getClass().getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
        });
        new JPopupMenu();
        new JPopupMenu.Separator();
        SynthLookAndFeel.setStyleFactory(original);
    }

    private static void fixGtkPopupWeight() {
        if (!GuiUtils.isUnderGTKLookAndFeel()) {
            return;
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof MyPopupFactory)) {
            factory = new MyPopupFactory(factory);
            PopupFactory.setSharedInstance(factory);
        }
    }

    public static void centerRelativeToOwner(Window window) {
        Window owner = window.getOwner();
        Point p = owner.getLocation();
        window.setLocation(p.x + owner.getWidth() / 2 - window.getWidth() / 2, p.y + owner.getHeight() / 2 - window.getHeight() / 2);
    }

    private static class MyPopupFactory
    extends PopupFactory {
        private static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        public MyPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
            int popupType;
            int n = popupType = GuiUtils.isUnderGTKLookAndFeel() ? 2 : PopupUtil.getPopupType(this);
            if (popupType >= 0) {
                PopupUtil.setPopupType(this.myDelegate, popupType);
            }
            return this.myDelegate.getPopup(owner, contents, x, y);
        }
    }
}

