/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.bd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.ImageObjectFragment;
import bdsup2sub.supstream.PaletteInfo;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.SubtitleStream;
import bdsup2sub.supstream.bd.SubPictureBD;
import bdsup2sub.supstream.bd.SupBDParser;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.ToolBox;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SupBD
implements SubtitleStream {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private FileBuffer buffer;
    private List<SubPictureBD> subPictures = new ArrayList<SubPictureBD>();
    private int forcedFrameCount;
    private Palette palette;
    private Bitmap bitmap;
    private int primaryColorIndex;

    public SupBD(String filename) throws CoreException {
        SupBDParser parser = new SupBDParser(filename);
        this.buffer = parser.getBuffer();
        this.subPictures = parser.getSubPictures();
        this.forcedFrameCount = parser.getForcedFrameCount();
    }

    private Bitmap decodeImage(SubPictureBD subPictureBD, int transparentColorIndex) throws CoreException {
        int width = subPictureBD.getImageWidth();
        int height = subPictureBD.getImageHeight();
        ImageObjectFragment imageObjectFragment = subPictureBD.getImageObject().getFragmentList().get(0);
        long startOfs = imageObjectFragment.getImageBufferOfs();
        if (width > subPictureBD.getWidth() || height > subPictureBD.getHeight()) {
            throw new CoreException("Subpicture too large: " + width + "x" + height + " at offset " + ToolBox.toHexLeftZeroPadded(startOfs, 8));
        }
        Bitmap bm = new Bitmap(width, height, (byte)transparentColorIndex);
        int index = 0;
        int ofs = 0;
        int xpos = 0;
        try {
            byte[] buffer = new byte[subPictureBD.getImageObject().getBufferSize()];
            index = 0;
            Iterator<ImageObjectFragment> i$ = subPictureBD.getImageObject().getFragmentList().iterator();
            while (i$.hasNext()) {
                ImageObjectFragment fragment;
                imageObjectFragment = fragment = i$.next();
                for (int i = 0; i < imageObjectFragment.getImagePacketSize(); ++i) {
                    buffer[index + i] = (byte)this.buffer.getByte(imageObjectFragment.getImageBufferOfs() + (long)i);
                }
                index += imageObjectFragment.getImagePacketSize();
            }
            index = 0;
            do {
                int b;
                if ((b = buffer[index++] & 0xFF) == 0) {
                    int size;
                    if ((b = buffer[index++] & 0xFF) == 0) {
                        ofs = ofs / width * width;
                        if (xpos < width) {
                            ofs += width;
                        }
                        xpos = 0;
                        continue;
                    }
                    if ((b & 0xC0) == 64) {
                        size = (b - 64 << 8) + (buffer[index++] & 0xFF);
                        for (int i = 0; i < size; ++i) {
                            bm.getInternalBuffer()[ofs++] = 0;
                        }
                        xpos += size;
                        continue;
                    }
                    if ((b & 0xC0) == 128) {
                        size = b - 128;
                        b = buffer[index++] & 0xFF;
                        for (int i = 0; i < size; ++i) {
                            bm.getInternalBuffer()[ofs++] = (byte)b;
                        }
                        xpos += size;
                        continue;
                    }
                    if ((b & 0xC0) != 0) {
                        size = (b - 192 << 8) + (buffer[index++] & 0xFF);
                        b = buffer[index++] & 0xFF;
                        for (int i = 0; i < size; ++i) {
                            bm.getInternalBuffer()[ofs++] = (byte)b;
                        }
                        xpos += size;
                        continue;
                    }
                    for (int i = 0; i < b; ++i) {
                        bm.getInternalBuffer()[ofs++] = 0;
                    }
                    xpos += b;
                    continue;
                }
                bm.getInternalBuffer()[ofs++] = (byte)b;
                ++xpos;
            } while (index < buffer.length);
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.warn("Problems during RLE decoding of picture OBJ at offset " + ToolBox.toHexLeftZeroPadded(startOfs + (long)index, 8) + "\n");
            return bm;
        }
    }

    private Palette decodePalette(SubPictureBD pic) throws CoreException {
        boolean fadeOut = false;
        List<PaletteInfo> paletteInfos = pic.getPalettes().get(pic.getImageObject().getPaletteID());
        if (paletteInfos == null) {
            throw new CoreException("Palette ID out of bounds.");
        }
        Palette palette = new Palette(256, Core.usesBT601());
        try {
            for (PaletteInfo paletteInfo : paletteInfos) {
                int index = paletteInfo.getPaletteOffset();
                for (int i = 0; i < paletteInfo.getPaletteSize(); ++i) {
                    int cr;
                    int cb;
                    int paletteIndex = this.buffer.getByte(index);
                    int y = this.buffer.getByte(++index);
                    if (configuration.isSwapCrCb()) {
                        cb = this.buffer.getByte(++index);
                        cr = this.buffer.getByte(++index);
                    } else {
                        cr = this.buffer.getByte(++index);
                        cb = this.buffer.getByte(++index);
                    }
                    int alpha = this.buffer.getByte(++index);
                    int alphaOld = palette.getAlpha(paletteIndex);
                    if (alpha >= alphaOld) {
                        if (alpha < configuration.getAlphaCrop()) {
                            y = 16;
                            cr = 128;
                            cb = 128;
                        }
                        palette.setAlpha(paletteIndex, alpha);
                    } else {
                        fadeOut = true;
                    }
                    palette.setYCbCr(paletteIndex, y, cb, cr);
                    ++index;
                }
            }
            if (fadeOut) {
                logger.warn("fade out detected -> patched palette\n");
            }
            return palette;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private void decode(SubPictureBD pic) throws CoreException {
        this.palette = this.decodePalette(pic);
        this.bitmap = this.decodeImage(pic, this.palette.getIndexOfMostTransparentPaletteEntry());
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette.getAlpha(), configuration.getAlphaThreshold(), this.palette.getY());
    }

    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    public Palette getPalette() {
        return this.palette;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette.getColorModel());
    }

    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette.getColorModel());
    }

    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    public int getFrameCount() {
        return this.subPictures.size();
    }

    public int getForcedFrameCount() {
        return this.forcedFrameCount;
    }

    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    public long getEndTime(int index) {
        return this.subPictures.get(index).getEndTime();
    }

    public long getStartTime(int index) {
        return this.subPictures.get(index).getStartTime();
    }

    public boolean isForced(int index) {
        return this.subPictures.get(index).isForced();
    }

    public long getStartOffset(int index) {
        SubPictureBD pic = this.subPictures.get(index);
        return pic.getImageObject().getFragmentList().get(0).getImageBufferOfs();
    }

    public double getFps(int index) {
        return Framerate.valueForId(this.subPictures.get(index).getType());
    }
}

