/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.bd;

import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.ImageObject;
import bdsup2sub.supstream.ImageObjectFragment;
import bdsup2sub.supstream.PaletteInfo;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.bd.PGSCompositionState;
import bdsup2sub.supstream.bd.SubPictureBD;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupBDParser {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private static final int PGSSUP_FILE_MAGIC = 20551;
    private static final int PGSSUP_PALETTE_SEGMENT = 20;
    private static final int PGSSUP_PICTURE_SEGMENT = 21;
    private static final int PGSSUP_PRESENTATION_SEGMENT = 22;
    private static final int PGSSUP_WINDOW_SEGMENT = 23;
    private static final int PGSSUP_DISPLAY_SEGMENT = 128;
    private FileBuffer buffer;
    private List<SubPictureBD> subPictures = new ArrayList<SubPictureBD>();
    private int forcedFrameCount;

    public SupBDParser(String filename) throws CoreException {
        try {
            this.buffer = new FileBuffer(filename);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        this.parse();
    }

    private void parse() throws CoreException {
        int index = 0;
        long bufferSize = this.buffer.getSize();
        SubPicture subPictureBD = null;
        SubPicture lastSubPicture = null;
        SubPicture picTmp = null;
        int odsCounter = 0;
        int pdsCounter = 0;
        int odsCounterOld = 0;
        int pdsCounterOld = 0;
        int compositionNumber = -1;
        int compositionNumberOld = -1;
        int compositionCount = 0;
        long ptsPCS = 0L;
        boolean paletteUpdate = false;
        PGSCompositionState compositionState = PGSCompositionState.INVALID;
        try {
            while ((long)index < bufferSize) {
                if (Core.isCanceled()) {
                    throw new CoreException("Canceled by user!");
                }
                Core.setProgress(index);
                PCSSegment segment = this.readPCSSegment(index);
                switch (segment.type) {
                    case 20: {
                        StringBuffer message = new StringBuffer("PDS offset: ").append(ToolBox.toHexLeftZeroPadded(index, 8)).append(", size: ").append(ToolBox.toHexLeftZeroPadded(segment.size, 4));
                        if (compositionNumber != compositionNumberOld) {
                            if (subPictureBD != null) {
                                StringBuffer result = new StringBuffer();
                                int paletteSize = this.parsePDS(segment, (SubPictureBD)subPictureBD, result);
                                if (paletteSize >= 0) {
                                    logger.trace(message + ", " + result + "\n");
                                    if (paletteSize <= 0) break;
                                    ++pdsCounter;
                                    break;
                                }
                                logger.trace(message + "\n");
                                logger.warn(result + "\n");
                                break;
                            }
                            logger.trace(message + "\n");
                            logger.warn("Missing PTS start -> ignored\n");
                            break;
                        }
                        logger.trace(message + ", composition number unchanged -> ignored\n");
                        break;
                    }
                    case 21: {
                        StringBuffer message = new StringBuffer("ODS offset: ").append(ToolBox.toHexLeftZeroPadded(index, 8)).append(", size: ").append(ToolBox.toHexLeftZeroPadded(segment.size, 4));
                        if (compositionNumber != compositionNumberOld) {
                            if (!paletteUpdate) {
                                if (subPictureBD != null) {
                                    StringBuffer result = new StringBuffer();
                                    if (this.parseODS(segment, (SubPictureBD)subPictureBD, result)) {
                                        ++odsCounter;
                                    }
                                    logger.trace(message + ", img size: " + ((SubPictureBD)subPictureBD).getImageWidth() + "*" + ((SubPictureBD)subPictureBD).getImageHeight() + (result.length() == 0 ? "\n" : ", " + result) + "\n");
                                    break;
                                }
                                logger.trace(message + "\n");
                                logger.warn("missing PTS start -> ignored\n");
                                break;
                            }
                            logger.trace(message + "\n");
                            logger.warn("palette update only -> ignored\n");
                            break;
                        }
                        logger.trace(message + ", composition number unchanged -> ignored\n");
                        break;
                    }
                    case 22: {
                        StringBuffer message;
                        compositionNumber = this.getCompositionNumber(segment);
                        compositionState = this.getCompositionState(segment);
                        paletteUpdate = this.getPaletteUpdateFlag(segment);
                        ptsPCS = segment.pts;
                        compositionCount = segment.size >= 19 ? 1 : 0;
                        if (compositionState == PGSCompositionState.INVALID) {
                            logger.warn("Illegal composition state at offset " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                            break;
                        }
                        if (compositionState == PGSCompositionState.EPOCH_START) {
                            if (this.subPictures.size() > 0 && (odsCounter == 0 || pdsCounter == 0)) {
                                logger.warn("Missing PDS/ODS: last epoch is discarded\n");
                                this.subPictures.remove(this.subPictures.size() - 1);
                                compositionNumberOld = compositionNumber - 1;
                                lastSubPicture = this.subPictures.size() > 0 ? this.subPictures.get(this.subPictures.size() - 1) : null;
                            } else {
                                lastSubPicture = subPictureBD;
                            }
                            subPictureBD = new SubPictureBD();
                            this.subPictures.add((SubPictureBD)subPictureBD);
                            subPictureBD.setStartTime(segment.pts);
                            logger.info("#> " + this.subPictures.size() + " (" + TimeUtils.ptsToTimeStr(subPictureBD.getStartTime()) + ")\n");
                            StringBuffer result = new StringBuffer();
                            this.parsePCS(segment, (SubPictureBD)subPictureBD, result);
                            if (lastSubPicture != null && lastSubPicture.getEndTime() == 0L) {
                                lastSubPicture.setEndTime(subPictureBD.getStartTime());
                            }
                            message = new StringBuffer("PCS offset: ").append(ToolBox.toHexLeftZeroPadded(index, 8)).append(", START, size: ").append(ToolBox.toHexLeftZeroPadded(segment.size, 4)).append(", composition number: ").append(compositionNumber).append(", forced: ").append(subPictureBD.isForced()).append(result.length() == 0 ? "\n" : ", " + result + "\n");
                            message.append("PTS start: ").append(TimeUtils.ptsToTimeStr(subPictureBD.getStartTime())).append(", screen size: ").append(subPictureBD.getWidth()).append("*").append(subPictureBD.getHeight()).append("\n");
                            logger.trace(message.toString());
                            odsCounter = 0;
                            pdsCounter = 0;
                            odsCounterOld = 0;
                            pdsCounterOld = 0;
                            picTmp = null;
                            break;
                        }
                        if (subPictureBD == null) {
                            logger.warn("Missing start of epoch at offset " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                            break;
                        }
                        message = new StringBuffer("PCS offset: ").append(ToolBox.toHexLeftZeroPadded(index, 8)).append(", ");
                        switch (compositionState) {
                            case EPOCH_CONTINUE: {
                                message.append("CONT, ");
                                break;
                            }
                            case ACQU_POINT: {
                                message.append("ACQU, ");
                                break;
                            }
                            case NORMAL: {
                                message.append("NORM, ");
                            }
                        }
                        message.append(" size: ").append(ToolBox.toHexLeftZeroPadded(segment.size, 4)).append(", composition number: ").append(compositionNumber).append(", forced: ").append(subPictureBD.isForced());
                        StringBuffer result = new StringBuffer();
                        if (compositionNumber != compositionNumberOld) {
                            picTmp = new SubPictureBD((SubPictureBD)subPictureBD);
                            this.parsePCS(segment, (SubPictureBD)subPictureBD, result);
                        }
                        if (result.length() > 0) {
                            message.append(", ").append(result);
                        }
                        message.append(", pal update: ").append(paletteUpdate).append("\n").append("PTS: ").append(TimeUtils.ptsToTimeStr(segment.pts)).append("\n");
                        logger.trace(message.toString());
                        break;
                    }
                    case 23: {
                        StringBuffer message = new StringBuffer("WDS offset: ").append(ToolBox.toHexLeftZeroPadded(index, 8)).append(", size: ").append(ToolBox.toHexLeftZeroPadded(segment.size, 4));
                        if (subPictureBD != null) {
                            this.parseWDS(segment, (SubPictureBD)subPictureBD);
                            logger.trace(message + ", dim: " + ((SubPictureBD)subPictureBD).getWindowWidth() + "*" + ((SubPictureBD)subPictureBD).getWindowHeight() + "\n");
                            break;
                        }
                        logger.trace(message + "\n");
                        logger.warn("Missing PTS start -> ignored\n");
                        break;
                    }
                    case 128: {
                        logger.trace("END offset: " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                        if (compositionState == PGSCompositionState.EPOCH_START) {
                            if (compositionCount > 0 && odsCounter > odsCounterOld && compositionNumber != compositionNumberOld && subPictureBD != null && ((SubPictureBD)subPictureBD).isMergableWith((SubPictureBD)lastSubPicture)) {
                                this.subPictures.remove(this.subPictures.size() - 1);
                                subPictureBD = lastSubPicture;
                                lastSubPicture = this.subPictures.size() > 0 ? this.subPictures.get(this.subPictures.size() - 1) : null;
                                logger.info("#< caption merged\n");
                            }
                        } else {
                            long startTime = 0L;
                            if (subPictureBD != null) {
                                startTime = subPictureBD.getStartTime();
                                subPictureBD.setStartTime(ptsPCS);
                            }
                            if (!(compositionCount <= 0 || odsCounter <= odsCounterOld || compositionNumber == compositionNumberOld || subPictureBD != null && ((SubPictureBD)subPictureBD).isMergableWith((SubPictureBD)picTmp))) {
                                if (odsCounter - odsCounterOld > 1 || pdsCounter - pdsCounterOld > 1) {
                                    logger.warn("Multiple PDS/ODS definitions: result may be erratic\n");
                                }
                                this.subPictures.set(this.subPictures.size() - 1, (SubPictureBD)picTmp);
                                lastSubPicture = picTmp;
                                this.subPictures.add((SubPictureBD)subPictureBD);
                                logger.info("#< " + this.subPictures.size() + " (" + TimeUtils.ptsToTimeStr(subPictureBD.getStartTime()) + ")\n");
                                odsCounterOld = odsCounter;
                            } else if (subPictureBD != null) {
                                subPictureBD.setStartTime(startTime);
                                subPictureBD.setEndTime(ptsPCS);
                                if (picTmp != null && picTmp.isForced()) {
                                    subPictureBD.setForced(true);
                                }
                                if (pdsCounter > pdsCounterOld || paletteUpdate) {
                                    logger.warn("Palette animation: result may be erratic\n");
                                }
                            } else {
                                logger.warn("End without at least one epoch start\n");
                            }
                        }
                        pdsCounterOld = pdsCounter;
                        compositionNumberOld = compositionNumber;
                        break;
                    }
                    default: {
                        logger.warn("<unknown> " + ToolBox.toHexLeftZeroPadded(segment.type, 2) + " ofs:" + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                    }
                }
                index += 13;
                index += segment.size;
            }
        }
        catch (CoreException ex) {
            if (this.subPictures.size() == 0) {
                throw ex;
            }
            logger.error(ex.getMessage() + "\n");
            logger.trace("Probably not all caption imported due to error.\n");
        }
        catch (FileBufferException ex) {
            if (this.subPictures.size() == 0) {
                throw new CoreException(ex.getMessage());
            }
            logger.error(ex.getMessage() + "\n");
            logger.trace("Probably not all caption imported due to error.\n");
        }
        this.removeLastFrameIfInvalid(odsCounter, pdsCounter);
        Core.setProgress(bufferSize);
        this.countForcedFrames();
    }

    private void removeLastFrameIfInvalid(int odsCounter, int pdsCounter) {
        if (this.subPictures.size() > 0 && (odsCounter == 0 || pdsCounter == 0)) {
            logger.warn("Missing PDS/ODS: last epoch is discarded\n");
            this.subPictures.remove(this.subPictures.size() - 1);
        }
    }

    private void countForcedFrames() {
        this.forcedFrameCount = 0;
        for (SubPictureBD p : this.subPictures) {
            if (!p.isForced()) continue;
            ++this.forcedFrameCount;
        }
        logger.info("\nDetected " + this.forcedFrameCount + " forced captions.\n");
    }

    private PCSSegment readPCSSegment(int offset) throws FileBufferException, CoreException {
        PCSSegment pcsSegment = new PCSSegment();
        if (this.buffer.getWord(offset) != 20551) {
            throw new CoreException("PG missing at index " + ToolBox.toHexLeftZeroPadded(offset, 8) + "\n");
        }
        pcsSegment.pts = this.buffer.getDWord(offset += 2);
        offset += 4;
        pcsSegment.type = this.buffer.getByte(offset += 4);
        pcsSegment.size = this.buffer.getWord(++offset);
        pcsSegment.offset = offset + 2;
        return pcsSegment;
    }

    private int getCompositionNumber(PCSSegment segment) throws FileBufferException {
        return this.buffer.getWord(segment.offset + 5);
    }

    private PGSCompositionState getCompositionState(PCSSegment segment) throws FileBufferException {
        int type = this.buffer.getByte(segment.offset + 7);
        for (PGSCompositionState state : PGSCompositionState.values()) {
            if (type != state.getType()) continue;
            return state;
        }
        return PGSCompositionState.INVALID;
    }

    private boolean getPaletteUpdateFlag(PCSSegment segment) throws FileBufferException {
        return this.buffer.getByte(segment.offset + 8) == 128;
    }

    private void parsePCS(PCSSegment segment, SubPictureBD subPictureBD, StringBuffer message) throws FileBufferException {
        int index = segment.offset;
        if (segment.size >= 4) {
            subPictureBD.setWidth(this.buffer.getWord(index));
            subPictureBD.setHeight(this.buffer.getWord(index + 2));
            int type = this.buffer.getByte(index + 4);
            int compositionNumber = this.buffer.getWord(index + 5);
            int paletteId = this.buffer.getByte(index + 9);
            int compositionObjectCount = this.buffer.getByte(index + 10);
            if (compositionObjectCount > 0) {
                ImageObject imageObject;
                int objectId = this.buffer.getWord(index + 11);
                message.append("paletteId: ").append(paletteId).append(", objectId: ").append(objectId);
                if (objectId >= subPictureBD.getImageObjectList().size()) {
                    imageObject = new ImageObject();
                    subPictureBD.getImageObjectList().add(imageObject);
                } else {
                    imageObject = subPictureBD.getImageObject(objectId);
                }
                imageObject.setPaletteID(paletteId);
                subPictureBD.setObjectID(objectId);
                if (segment.size >= 19) {
                    subPictureBD.setType(type);
                    int forcedCropped = this.buffer.getByte(index + 14);
                    subPictureBD.setCompositionNumber(compositionNumber);
                    subPictureBD.setForced((forcedCropped & 0x40) == 64);
                    imageObject.setXOffset(this.buffer.getWord(index + 15));
                    imageObject.setYOffset(this.buffer.getWord(index + 17));
                }
            }
        }
    }

    private void parseWDS(PCSSegment pcsSegment, SubPictureBD subPictureBD) throws FileBufferException {
        int index = pcsSegment.offset;
        if (pcsSegment.size >= 10) {
            subPictureBD.setXWindowOffset(this.buffer.getWord(index + 2));
            subPictureBD.setYWindowOffset(this.buffer.getWord(index + 4));
            subPictureBD.setWindowWidth(this.buffer.getWord(index + 6));
            subPictureBD.setWindowHeight(this.buffer.getWord(index + 8));
        }
    }

    private boolean parseODS(PCSSegment pcsSegment, SubPictureBD subPictureBD, StringBuffer message) throws FileBufferException {
        ImageObject imageObject;
        boolean last;
        int index = pcsSegment.offset;
        int objectID = this.buffer.getWord(index);
        int objectVersion = this.buffer.getByte(index + 1);
        int objectSequenceOrder = this.buffer.getByte(index + 3);
        boolean first = (objectSequenceOrder & 0x80) == 128;
        boolean bl = last = (objectSequenceOrder & 0x40) == 64;
        if (objectID >= subPictureBD.getImageObjectList().size()) {
            imageObject = new ImageObject();
            subPictureBD.getImageObjectList().add(imageObject);
        } else {
            imageObject = subPictureBD.getImageObject(objectID);
        }
        if (imageObject.getFragmentList().isEmpty() || first) {
            int width = this.buffer.getWord(index + 7);
            int height = this.buffer.getWord(index + 9);
            if (width <= subPictureBD.getWidth() && height <= subPictureBD.getHeight()) {
                ImageObjectFragment imageObjectFragment = new ImageObjectFragment(index + 11, pcsSegment.size - (index + 11 - pcsSegment.offset));
                imageObject.getFragmentList().add(imageObjectFragment);
                imageObject.setBufferSize(imageObjectFragment.getImagePacketSize());
                imageObject.setHeight(height);
                imageObject.setWidth(width);
                message.append("ID: ").append(objectID).append(", update: ").append(objectVersion).append(", seq: ").append(first ? "first" : "").append(first && last ? "/" : "").append(last ? "last" : "");
                return true;
            }
            logger.warn("Invalid image size - ignored\n");
            return false;
        }
        ImageObjectFragment imageObjectFragment = new ImageObjectFragment(index + 4, pcsSegment.size - (index + 4 - pcsSegment.offset));
        imageObject.getFragmentList().add(imageObjectFragment);
        imageObject.setBufferSize(imageObject.getBufferSize() + imageObjectFragment.getImagePacketSize());
        message.append("ID: ").append(objectID).append(", update: ").append(objectVersion).append(", seq: ").append(first ? "first" : "").append(first && last ? "/" : "").append(last ? "last" : "");
        return false;
    }

    private int parsePDS(PCSSegment pcsSegment, SubPictureBD subPictureBD, StringBuffer message) throws FileBufferException {
        int index = pcsSegment.offset;
        int paletteID = this.buffer.getByte(index);
        int paletteUpdate = this.buffer.getByte(index + 1);
        if (paletteID > 7) {
            message.append("Illegal palette id at offset ").append(ToolBox.toHexLeftZeroPadded(index, 8));
            return -1;
        }
        PaletteInfo paletteInfo = new PaletteInfo(index + 2, (pcsSegment.size - 2) / 5);
        subPictureBD.getPalettes().get(paletteID).add(paletteInfo);
        message.append("ID: ").append(paletteID).append(", update: ").append(paletteUpdate).append(", ").append(paletteInfo.getPaletteSize()).append(" entries");
        return paletteInfo.getPaletteSize();
    }

    public FileBuffer getBuffer() {
        return this.buffer;
    }

    public List<SubPictureBD> getSubPictures() {
        return this.subPictures;
    }

    public int getForcedFrameCount() {
        return this.forcedFrameCount;
    }

    private static class PCSSegment {
        int type;
        int size;
        long pts;
        int offset;

        private PCSSegment() {
        }
    }
}

