/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.bd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.tools.QuantizeFilter;
import bdsup2sub.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;

public final class SupBDWriter {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private static final byte[] PACKET_HEADER = new byte[]{80, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HEADER_PCS_START = new byte[]{0, 0, 0, 0, 16, 0, 0, -128, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HEADER_PCS_END = new byte[]{0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0};
    private static final byte[] HEADER_ODS_FIRST = new byte[]{0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HEADER_ODS_NEXT = new byte[]{0, 0, 0, 64};
    private static final byte[] HEADER_WDS = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private SupBDWriter() {
    }

    public static byte[] createSupFrame(SubPicture pic, Bitmap bm, Palette pal) {
        byte[] rleBuf;
        int size;
        if (pal.getSize() > 255 && pal.getAlpha(255) > 0) {
            QuantizeFilter qf = new QuantizeFilter();
            Bitmap bmQ = new Bitmap(bm.getWidth(), bm.getHeight());
            int[] ct = qf.quantize(bm.toARGB(pal), bmQ.getInternalBuffer(), bm.getWidth(), bm.getHeight(), 255, false, false);
            size = ct.length;
            if (size > 255) {
                size = 255;
                logger.trace("Palette had to be reduced from " + pal.getSize() + " to " + size + " entries.\n");
                logger.warn("Quantizer failed.\n");
            } else {
                logger.trace("Palette had to be reduced from " + pal.getSize() + " to " + size + " entries.\n");
            }
            pal = new Palette(size);
            for (int i = 0; i < size; ++i) {
                pal.setARGB(i, ct[i]);
            }
            bm = bmQ;
        }
        int numAddPackets = (rleBuf = SupBDWriter.encodeImage(bm)).length <= 65508 ? 0 : 1 + (rleBuf.length - 65508) / 65515;
        int palSize = bm.getHighestVisibleColorIndex(pal.getAlpha()) + 1;
        size = PACKET_HEADER.length * (8 + numAddPackets);
        size += HEADER_PCS_START.length + HEADER_PCS_END.length;
        size += 2 * HEADER_WDS.length + HEADER_ODS_FIRST.length;
        size += numAddPackets * HEADER_ODS_NEXT.length;
        size += 2 + palSize * 5;
        size += rleBuf.length;
        int yOfs = pic.getYOffset() - configuration.getCropOffsetY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.getHeight() - pic.getImageHeight() - 2 * configuration.getCropOffsetY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        int h = pic.getHeight() - 2 * configuration.getCropOffsetY();
        byte[] buf = new byte[size];
        int index = 0;
        int fpsId = Framerate.idForFramerate(configuration.getFpsTrg());
        int frameInitTime = (pic.getWidth() * pic.getHeight() * 9 + 3199) / 3200;
        int windowInitTime = (bm.getWidth() * bm.getHeight() * 9 + 3199) / 3200;
        int imageDecodeTime = (bm.getWidth() * bm.getHeight() * 9 + 1599) / 1600;
        SupBDWriter.PACKET_HEADER[10] = 22;
        ByteUtils.setDWord(PACKET_HEADER, 2, (int)pic.getStartTime());
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, HEADER_PCS_START.length);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        ByteUtils.setWord(HEADER_PCS_START, 0, pic.getWidth());
        ByteUtils.setWord(HEADER_PCS_START, 2, h);
        ByteUtils.setByte(HEADER_PCS_START, 4, fpsId);
        ByteUtils.setWord(HEADER_PCS_START, 5, pic.getCompositionNumber());
        SupBDWriter.HEADER_PCS_START[14] = pic.isForced() ? 64 : 0;
        ByteUtils.setWord(HEADER_PCS_START, 15, pic.getXOffset());
        ByteUtils.setWord(HEADER_PCS_START, 17, yOfs);
        for (byte b : HEADER_PCS_START) {
            buf[index++] = b;
        }
        SupBDWriter.PACKET_HEADER[10] = 23;
        int timeStamp = (int)pic.getStartTime() - windowInitTime;
        ByteUtils.setDWord(PACKET_HEADER, 2, timeStamp);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, HEADER_WDS.length);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        ByteUtils.setWord(HEADER_WDS, 2, pic.getXOffset());
        ByteUtils.setWord(HEADER_WDS, 4, yOfs);
        ByteUtils.setWord(HEADER_WDS, 6, bm.getWidth());
        ByteUtils.setWord(HEADER_WDS, 8, bm.getHeight());
        for (byte b : HEADER_WDS) {
            buf[index++] = b;
        }
        SupBDWriter.PACKET_HEADER[10] = 20;
        int dts = (int)pic.getStartTime() - (frameInitTime + windowInitTime);
        ByteUtils.setDWord(PACKET_HEADER, 2, dts);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, 2 + palSize * 5);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        buf[index++] = 0;
        buf[index++] = 0;
        for (int i = 0; i < palSize; ++i) {
            buf[index++] = (byte)i;
            buf[index++] = pal.getY()[i];
            buf[index++] = pal.getCr()[i];
            buf[index++] = pal.getCb()[i];
            buf[index++] = pal.getAlpha()[i];
        }
        int bufSize = rleBuf.length;
        int rleIndex = 0;
        if (bufSize > 65508) {
            bufSize = 65508;
        }
        SupBDWriter.PACKET_HEADER[10] = 21;
        timeStamp = dts + imageDecodeTime;
        ByteUtils.setDWord(PACKET_HEADER, 2, timeStamp);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, HEADER_ODS_FIRST.length + bufSize);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        int marker = numAddPackets == 0 ? -1073741824 : Integer.MIN_VALUE;
        ByteUtils.setDWord(HEADER_ODS_FIRST, 3, marker | rleBuf.length + 4);
        ByteUtils.setWord(HEADER_ODS_FIRST, 7, bm.getWidth());
        ByteUtils.setWord(HEADER_ODS_FIRST, 9, bm.getHeight());
        for (byte b : HEADER_ODS_FIRST) {
            buf[index++] = b;
        }
        for (int i = 0; i < bufSize; ++i) {
            buf[index++] = rleBuf[rleIndex++];
        }
        bufSize = rleBuf.length - bufSize;
        for (int p = 0; p < numAddPackets; ++p) {
            int psize = bufSize;
            if (psize > 65515) {
                psize = 65515;
            }
            SupBDWriter.PACKET_HEADER[10] = 21;
            ByteUtils.setWord(PACKET_HEADER, 11, HEADER_ODS_NEXT.length + psize);
            for (byte b : PACKET_HEADER) {
                buf[index++] = b;
            }
            for (byte b : HEADER_ODS_NEXT) {
                buf[index++] = b;
            }
            for (int i = 0; i < psize; ++i) {
                buf[index++] = rleBuf[rleIndex++];
            }
            bufSize -= psize;
        }
        SupBDWriter.PACKET_HEADER[10] = -128;
        ByteUtils.setDWord(PACKET_HEADER, 2, timeStamp);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, 0);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        SupBDWriter.PACKET_HEADER[10] = 22;
        ByteUtils.setDWord(PACKET_HEADER, 2, (int)pic.getEndTime());
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, HEADER_PCS_END.length);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        ByteUtils.setWord(HEADER_PCS_END, 0, pic.getWidth());
        ByteUtils.setWord(HEADER_PCS_END, 2, h);
        ByteUtils.setByte(HEADER_PCS_END, 4, fpsId);
        ByteUtils.setWord(HEADER_PCS_END, 5, pic.getCompositionNumber() + 1);
        for (byte b : HEADER_PCS_END) {
            buf[index++] = b;
        }
        SupBDWriter.PACKET_HEADER[10] = 23;
        timeStamp = (int)pic.getEndTime() - windowInitTime;
        ByteUtils.setDWord(PACKET_HEADER, 2, timeStamp);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, HEADER_WDS.length);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        ByteUtils.setWord(HEADER_WDS, 2, pic.getXOffset());
        ByteUtils.setWord(HEADER_WDS, 4, yOfs);
        ByteUtils.setWord(HEADER_WDS, 6, bm.getWidth());
        ByteUtils.setWord(HEADER_WDS, 8, bm.getHeight());
        for (byte b : HEADER_WDS) {
            buf[index++] = b;
        }
        SupBDWriter.PACKET_HEADER[10] = -128;
        ByteUtils.setDWord(PACKET_HEADER, 2, timeStamp);
        ByteUtils.setDWord(PACKET_HEADER, 6, 0);
        ByteUtils.setWord(PACKET_HEADER, 11, 0);
        for (byte b : PACKET_HEADER) {
            buf[index++] = b;
        }
        return buf;
    }

    private static byte[] encodeImage(Bitmap bm) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int y = 0; y < bm.getHeight(); ++y) {
            int ofs = y * bm.getWidth();
            int x = 0;
            while (x < bm.getWidth()) {
                byte color = bm.getInternalBuffer()[ofs];
                int len = 1;
                while (x + len < bm.getWidth() && bm.getInternalBuffer()[ofs + len] == color) {
                    ++len;
                }
                if (len <= 2 && color != 0) {
                    bytes.add(color);
                    if (len == 2) {
                        bytes.add(color);
                    }
                } else {
                    if (len > 16383) {
                        len = 16383;
                    }
                    bytes.add((byte)0);
                    if (color == 0 && len < 64) {
                        bytes.add((byte)len);
                    } else if (color == 0) {
                        bytes.add((byte)(0x40 | len >> 8));
                        bytes.add((byte)len);
                    } else if (len < 64) {
                        bytes.add((byte)(0x80 | len));
                        bytes.add(color);
                    } else {
                        bytes.add((byte)(0xC0 | len >> 8));
                        bytes.add((byte)len);
                        bytes.add(color);
                    }
                }
                x += len;
                ofs += len;
            }
            if (x != bm.getWidth()) continue;
            bytes.add((byte)0);
            bytes.add((byte)0);
        }
        int size = bytes.size();
        byte[] retval = new byte[size];
        Iterator it = bytes.iterator();
        for (int i = 0; i < size; ++i) {
            retval[i] = (Byte)it.next();
        }
        return retval;
    }
}

