/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.CoreException;
import bdsup2sub.utils.ByteUtils;
import bdsup2sub.utils.ToolBox;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public final class IfoWriter {
    private static final Configuration configuration = Configuration.getInstance();

    private IfoWriter() {
    }

    public static void writeIFO(String fname, int pictureHeight, Palette palette) throws CoreException {
        byte[] buf = new byte[6144];
        int index = 0;
        int vidAttr = pictureHeight == 480 ? 20225 : 24321;
        ToolBox.setString(buf, index, "DVDVIDEO-VTS");
        ByteUtils.setDWord(buf, index + 18, 4);
        ByteUtils.setDWord(buf, index + 28, 4);
        ByteUtils.setDWord(buf, index + 128, 2047);
        ByteUtils.setDWord(buf, index + 200, 1);
        ByteUtils.setDWord(buf, index + 204, 2);
        ByteUtils.setWord(buf, index + 256, vidAttr);
        ByteUtils.setWord(buf, index + 512, vidAttr);
        String l = Constants.LANGUAGES[configuration.getLanguageIdx()][1];
        ByteUtils.setWord(buf, index + 596, 1);
        ByteUtils.setByte(buf, index + 598, 1);
        ByteUtils.setByte(buf, index + 600, (byte)l.charAt(0));
        ByteUtils.setByte(buf, index + 601, (byte)l.charAt(1));
        index = 2048;
        ByteUtils.setWord(buf, index, 1);
        ByteUtils.setWord(buf, index + 4, 15);
        ByteUtils.setDWord(buf, index + 4, 12);
        ByteUtils.setWord(buf, index + 12, 1);
        ByteUtils.setWord(buf, index + 14, 1);
        index = 4096;
        ByteUtils.setWord(buf, index, 1);
        ByteUtils.setDWord(buf, index + 4, 281);
        ByteUtils.setDWord(buf, index + 8, -2130706432);
        ByteUtils.setDWord(buf, index + 12, 16);
        index = 4112;
        ByteUtils.setByte(buf, index + 2, 1);
        ByteUtils.setByte(buf, index + 3, 1);
        for (int i = 0; i < 16; ++i) {
            int[] ycbcr = palette.getYCbCr(i);
            ByteUtils.setByte(buf, index + 164 + 4 * i + 1, ycbcr[0]);
            ByteUtils.setByte(buf, index + 164 + 4 * i + 2, ycbcr[1]);
            ByteUtils.setByte(buf, index + 164 + 4 * i + 3, ycbcr[2]);
        }
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fname));
            out.write(buf);
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }
}

