/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.ImageObjectFragment;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.ToolBox;
import java.util.ArrayList;
import java.util.Iterator;

public final class SupDvdUtil {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();

    private SupDvdUtil() {
    }

    public static byte[] encodeLines(Bitmap bm, boolean even) {
        ArrayList<Byte> nibbles = new ArrayList<Byte>();
        for (int y = even ? 0 : 1; y < bm.getHeight(); y += 2) {
            int ofs = y * bm.getWidth();
            int x = 0;
            while (x < bm.getWidth()) {
                byte color = bm.getInternalBuffer()[ofs];
                int len = 1;
                while (x + len < bm.getWidth() && bm.getInternalBuffer()[ofs + len] == color) {
                    ++len;
                }
                if (len < 4) {
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (len < 16) {
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (len < 64) {
                    nibbles.add((byte)0);
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (x + len == bm.getWidth()) {
                    nibbles.add((byte)0);
                    nibbles.add((byte)0);
                    nibbles.add((byte)0);
                    nibbles.add(color);
                } else {
                    if (len > 255) {
                        len = 255;
                    }
                    nibbles.add((byte)0);
                    nibbles.add((byte)(len >> 6));
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                }
                x += len;
                ofs += len;
            }
            if ((nibbles.size() & 1) != 1) continue;
            nibbles.add((byte)0);
        }
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        int size = nibbles.size() / 2;
        byte[] retval = new byte[size];
        Iterator it = nibbles.iterator();
        for (int i = 0; i < size; ++i) {
            int hi = (Byte)it.next() & 0xF;
            int lo = (Byte)it.next() & 0xF;
            retval[i] = (byte)(hi << 4 | lo);
        }
        return retval;
    }

    public static Palette decodePalette(SubPictureDVD pic, Palette pal) {
        Palette miniPal = new Palette(4, true);
        for (int i = 0; i < 4; ++i) {
            int a = pic.getAlpha()[i] * 255 / 15;
            if (a >= configuration.getAlphaCrop()) {
                miniPal.setRGB(i, pal.getR()[pic.getPal()[i]] & 0xFF, pal.getG()[pic.getPal()[i]] & 0xFF, pal.getB()[pic.getPal()[i]] & 0xFF);
                miniPal.setAlpha(i, a);
                continue;
            }
            miniPal.setARGB(i, 0);
        }
        return miniPal;
    }

    public static Bitmap decodeImage(SubPictureDVD pic, FileBuffer fBuf, int transIdx) throws CoreException {
        int sizeOdd;
        int sizeEven;
        int w = pic.getOriginalWidth();
        int h = pic.getOriginalHeight();
        int warnings = 0;
        ImageObjectFragment info = pic.getRleFragments().get(0);
        long startOfs = info.getImageBufferOfs();
        if (w > pic.getWidth() || h > pic.getHeight()) {
            logger.warn("Subpicture too large: " + w + "x" + h + " at offset " + ToolBox.toHexLeftZeroPadded(startOfs, 8) + "\n");
        }
        Bitmap bm = new Bitmap(w, h, (byte)transIdx);
        byte[] buf = new byte[pic.getRleSize()];
        int index = 0;
        if (pic.getOddOffset() > pic.getEvenOffset()) {
            sizeEven = pic.getOddOffset() - pic.getEvenOffset();
            sizeOdd = pic.getRleSize() - pic.getOddOffset();
        } else {
            sizeOdd = pic.getEvenOffset() - pic.getOddOffset();
            sizeEven = pic.getRleSize() - pic.getEvenOffset();
        }
        if (sizeEven <= 0 || sizeOdd <= 0) {
            throw new CoreException("Corrupt buffer offset information");
        }
        try {
            try {
                for (int p = 0; p < pic.getRleFragments().size(); ++p) {
                    info = pic.getRleFragments().get(p);
                    for (int i = 0; i < info.getImagePacketSize(); ++i) {
                        buf[index + i] = (byte)fBuf.getByte(info.getImageBufferOfs() + (long)i);
                    }
                    index += info.getImagePacketSize();
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                SupDvdUtil.decodeLine(buf, pic.getEvenOffset(), sizeEven, bm.getInternalBuffer(), 0, w, w * (h / 2 + (h & 1)));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                SupDvdUtil.decodeLine(buf, pic.getOddOffset(), sizeOdd, bm.getInternalBuffer(), w, w, h / 2 * w);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            if (warnings > 0) {
                logger.warn("problems during RLE decoding of picture at offset " + ToolBox.toHexLeftZeroPadded(startOfs, 8) + "\n");
            }
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private static void decodeLine(byte[] src, int srcOfs, int srcLen, byte[] trg, int trgOfs, int width, int maxPixels) {
        int b;
        byte[] nibbles = new byte[srcLen * 2];
        for (int i = 0; i < srcLen; ++i) {
            b = src[srcOfs + i] & 0xFF;
            nibbles[2 * i] = (byte)(b >> 4);
            nibbles[2 * i + 1] = (byte)(b & 0xF);
        }
        int index = 0;
        int sumPixels = 0;
        int x = 0;
        while (index < nibbles.length && sumPixels < maxPixels) {
            int len;
            if ((b = nibbles[index++] & 0xFF) == 0) {
                if (((b = nibbles[index++] & 0xFF) & 0xC) != 0) {
                    len = b << 2;
                    b = nibbles[index++] & 0xFF;
                    len |= b >> 2;
                } else {
                    len = b << 6;
                    b = nibbles[index++] & 0xFF;
                    len |= b << 2;
                    if ((len |= (b = nibbles[index++] & 0xFF) >> 2) == 0) {
                        len = width - x;
                        if (len <= 0 || sumPixels >= maxPixels) {
                            len = 0;
                            sumPixels = (trgOfs += 2 * width) / width / 2 * width;
                            x = 0;
                        }
                        if ((index & 1) == 1) {
                            ++index;
                        }
                    }
                }
            } else {
                len = b >> 2;
                if (len == 0) {
                    len = b << 2;
                    b = nibbles[index++] & 0xFF;
                    len |= b >> 2;
                }
            }
            int col = b & 3;
            sumPixels += len;
            for (int i = 0; i < len; ++i) {
                trg[trgOfs + x] = (byte)col;
                if (++x < width) continue;
                trgOfs += 2 * width;
                x = 0;
                if ((index & 1) != 1) continue;
                ++index;
            }
        }
    }
}

