/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.tools;

import bdsup2sub.tools.FileBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileBuffer {
    private static final int BUFFERSIZE = 0x100000;
    private byte[] buf;
    private String filename;
    private FileInputStream fi;
    private FileChannel fc;
    private long offset;
    private long offsetEnd;
    private long length;

    public FileBuffer(String filename) throws FileBufferException {
        this.filename = filename;
        this.length = new File(filename).length();
        this.buf = this.length < 0x100000L ? new byte[(int)this.length] : new byte[0x100000];
        try {
            this.fi = new FileInputStream(filename);
            this.fc = this.fi.getChannel();
            this.offset = 0L;
            this.readBuffer(this.offset);
        }
        catch (FileNotFoundException ex) {
            throw new FileBufferException("File '" + filename + "' not found");
        }
    }

    private void readBuffer(long offset) throws FileBufferException {
        try {
            this.offset = offset;
            this.fc.position(offset);
            long l = this.length - offset;
            if (l < 0L) {
                throw new FileBufferException("Offset " + offset + " out of bounds for file " + this.filename);
            }
            int numRead = l < (long)this.buf.length ? this.fi.read(this.buf, 0, (int)l) : this.fi.read(this.buf, 0, this.buf.length);
            this.offsetEnd = offset + (long)numRead - 1L;
        }
        catch (IOException ex) {
            throw new FileBufferException("IO error at offset +" + offset + " of file '" + this.filename + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new FileBufferException("IO error at offset +" + offset + " of file '" + this.filename + "'");
        }
    }

    public int getByte(long offset) throws FileBufferException {
        if (offset < this.offset || offset > this.offsetEnd) {
            this.readBuffer(offset);
        }
        return this.buf[(int)(offset - this.offset)] & 0xFF;
    }

    public int getWord(long offset) throws FileBufferException {
        if (offset < this.offset || offset + 1L > this.offsetEnd) {
            this.readBuffer(offset);
        }
        int idx = (int)(offset - this.offset);
        return this.buf[idx + 1] & 0xFF | (this.buf[idx] & 0xFF) << 8;
    }

    public int getWordLE(long offset) throws FileBufferException {
        if (offset < this.offset || offset + 1L > this.offsetEnd) {
            this.readBuffer(offset);
        }
        int idx = (int)(offset - this.offset);
        return this.buf[idx] & 0xFF | (this.buf[idx + 1] & 0xFF) << 8;
    }

    public int getDWord(long offset) throws FileBufferException {
        if (offset < this.offset || offset + 3L > this.offsetEnd) {
            this.readBuffer(offset);
        }
        int idx = (int)(offset - this.offset);
        return this.buf[idx + 3] & 0xFF | (this.buf[idx + 2] & 0xFF) << 8 | (this.buf[idx + 1] & 0xFF) << 16 | (this.buf[idx] & 0xFF) << 24;
    }

    public int getDWordLE(long offset) throws FileBufferException {
        if (offset < this.offset || offset + 3L > this.offsetEnd) {
            this.readBuffer(offset);
        }
        int idx = (int)(offset - this.offset);
        return this.buf[idx] & 0xFF | (this.buf[idx + 1] & 0xFF) << 8 | (this.buf[idx + 2] & 0xFF) << 16 | (this.buf[idx + 3] & 0xFF) << 24;
    }

    public void getBytes(long ofs, byte[] b, int len) throws FileBufferException {
        if (ofs < this.offset || ofs + (long)len - 1L > this.offsetEnd) {
            this.readBuffer(ofs);
        }
        for (int i = 0; i < len; ++i) {
            b[i] = this.buf[(int)(ofs - this.offset + (long)i)];
        }
    }

    public long getSize() {
        return this.length;
    }

    public void close() {
        try {
            if (this.fc != null) {
                this.fc.close();
            }
            if (this.fi != null) {
                this.fi.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.fi != null) {
            this.fi.close();
        }
        super.finalize();
    }
}

