/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.utils;

import bdsup2sub.core.Framerate;
import bdsup2sub.core.Resolution;

public final class SubtitleUtils {
    private SubtitleUtils() {
    }

    public static double getFps(String fps) {
        double d;
        if ((fps = fps.toLowerCase().trim()).equals("pal") || fps.equals("25p") || fps.equals("25")) {
            return Framerate.PAL.getValue();
        }
        if (fps.equals("ntsc") || fps.equals("30p") || fps.equals("29.97") || fps.equals("29.970")) {
            return Framerate.NTSC.getValue();
        }
        if (fps.equals("24p") || fps.equals("23.976")) {
            return Framerate.FPS_23_976.getValue();
        }
        if (fps.equals("23.975")) {
            return Framerate.FPS_23_975.getValue();
        }
        if (fps.equals("24")) {
            return Framerate.FPS_24.getValue();
        }
        if (fps.equals("50i") || fps.equals("50")) {
            return Framerate.PAL_I.getValue();
        }
        if (fps.equals("60i") || fps.equals("59.94")) {
            return Framerate.NTSC_I.getValue();
        }
        try {
            d = Double.parseDouble(fps);
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
        if (Math.abs(d - Framerate.FPS_23_975.getValue()) < 0.001) {
            return Framerate.FPS_23_975.getValue();
        }
        if (Math.abs(d - Framerate.FPS_23_976.getValue()) < 0.001) {
            return Framerate.FPS_23_976.getValue();
        }
        if (Math.abs(d - Framerate.FPS_24.getValue()) < 0.001) {
            return Framerate.FPS_24.getValue();
        }
        if (Math.abs(d - Framerate.PAL.getValue()) < 0.001) {
            return Framerate.PAL.getValue();
        }
        if (Math.abs(d - Framerate.NTSC.getValue()) < 0.001) {
            return Framerate.NTSC.getValue();
        }
        if (Math.abs(d - Framerate.NTSC_I.getValue()) < 0.001) {
            return Framerate.NTSC_I.getValue();
        }
        if (Math.abs(d - Framerate.PAL_I.getValue()) < 0.001) {
            return Framerate.PAL_I.getValue();
        }
        return d;
    }

    public static long syncTimePTS(long timeStamp, double fps, double fpsTrg) {
        long retval;
        if (fps == Framerate.NTSC.getValue() || fps == Framerate.PAL.getValue() || fps == Framerate.FPS_24.getValue()) {
            int tpfi = (int)((90000.0 + fps / 2.0) / fps);
            int tpfh = tpfi / 2;
            retval = (timeStamp + (long)tpfh) / (long)tpfi * (long)tpfi;
        } else if (fpsTrg == Framerate.FPS_23_976.getValue()) {
            retval = (timeStamp + 1877L) * 4L / 15015L * 15015L / 4L;
        } else {
            double tpf = 90000.0 / fpsTrg;
            retval = (long)((double)((long)((double)timeStamp / tpf)) * tpf + 0.5);
        }
        return retval;
    }

    public static double getDefaultFramerateForResolution(Resolution resolution) {
        double fps;
        switch (resolution.getDimensions()[1]) {
            case 480: {
                fps = Framerate.NTSC.getValue();
                break;
            }
            case 576: {
                fps = Framerate.PAL.getValue();
                break;
            }
            default: {
                fps = Framerate.FPS_23_976.getValue();
            }
        }
        return fps;
    }

    public static Resolution getResolutionForDimension(int width, int height) {
        if (width <= Resolution.NTSC.getDimensions()[0] && height <= Resolution.NTSC.getDimensions()[1]) {
            return Resolution.NTSC;
        }
        if (width <= Resolution.PAL.getDimensions()[0] && height <= Resolution.PAL.getDimensions()[1]) {
            return Resolution.PAL;
        }
        if (width <= Resolution.HD_720.getDimensions()[0] && height <= Resolution.HD_720.getDimensions()[1]) {
            return Resolution.HD_720;
        }
        if (width <= Resolution.HD_1440x1080.getDimensions()[0] && height <= Resolution.HD_1440x1080.getDimensions()[1]) {
            return Resolution.HD_1440x1080;
        }
        return Resolution.HD_1080;
    }
}

