/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.utils;

import bdsup2sub.utils.ToolBox;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final int PTS_FREQUENCY_IN_KHZ = 90;
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+)[:\\.](\\d+)");

    public static String ptsToTimeStr(long pts) {
        int[] time = TimeUtils.ptsToTime(pts);
        return ToolBox.leftZeroPad(time[0], 2) + ":" + ToolBox.leftZeroPad(time[1], 2) + ":" + ToolBox.leftZeroPad(time[2], 2) + "." + ToolBox.leftZeroPad(time[3], 3);
    }

    public static String ptsToTimeStrIdx(long pts) {
        int[] time = TimeUtils.ptsToTime(pts);
        return ToolBox.leftZeroPad(time[0], 2) + ":" + ToolBox.leftZeroPad(time[1], 2) + ":" + ToolBox.leftZeroPad(time[2], 2) + ":" + ToolBox.leftZeroPad(time[3], 3);
    }

    public static String ptsToTimeStrXml(long pts, double fps) {
        int[] time = TimeUtils.ptsToTime(pts);
        return ToolBox.leftZeroPad(time[0], 2) + ":" + ToolBox.leftZeroPad(time[1], 2) + ":" + ToolBox.leftZeroPad(time[2], 2) + ":" + ToolBox.leftZeroPad((int)(fps * (double)time[3] / 1000.0 + 0.5), 2);
    }

    private static int[] ptsToTime(long pts) {
        return TimeUtils.msToTime((pts + 45L) / 90L);
    }

    private static int[] msToTime(long ms) {
        int[] time;
        time = new int[]{(int)(ms / 3600000L), (int)((ms -= (long)(time[0] * 60 * 60 * 1000)) / 60000L), (int)((ms -= (long)(time[1] * 60 * 1000)) / 1000L), (int)(ms -= (long)(time[2] * 1000))};
        return time;
    }

    public static long timeStrToPTS(String s) {
        Matcher m = TIME_PATTERN.matcher(s);
        if (m.matches()) {
            long hour = Integer.parseInt(m.group(1));
            long min = Integer.parseInt(m.group(2));
            long sec = Integer.parseInt(m.group(3));
            long ms = Integer.parseInt(m.group(4));
            long temp = hour * 60L;
            temp += min;
            temp *= 60L;
            temp += sec;
            return ((temp *= 1000L) + ms) * 90L;
        }
        return -1L;
    }

    public static long timeStrXmlToPTS(String s, double fps) {
        Matcher m = TIME_PATTERN.matcher(s);
        if (m.matches()) {
            long hour = Integer.parseInt(m.group(1));
            long min = Integer.parseInt(m.group(2));
            long sec = Integer.parseInt(m.group(3));
            long frames = Integer.parseInt(m.group(4));
            long temp = hour * 60L;
            temp += min;
            temp *= 60L;
            temp += sec;
            return ((temp *= 1000L) + (long)((int)((double)frames / fps * 1000.0 + 0.5))) * 90L;
        }
        return -1L;
    }
}

