package org.springframework.batch;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(MyBatchJobConfiguration.class)
public class MyBatchJobTest {

    @Autowired
    private Job job;

    @Autowired
    private JobOperator jobOperator;

    @Test
    void testJobExecution() throws Exception {
        // given
        JobParameters jobParameters = new JobParameters();

        // when
        JobExecution jobExecution = jobOperator.start(job, jobParameters);

        // then
        Assertions.assertEquals(ExitStatus.COMPLETED, jobExecution.getExitStatus());
    }
}
