-- Creates Lahman Baseball database tables
-- based on Lahman package and scripts
-- http://www.seanlahman.com/baseball-archive/statistics/
-- Lahman's Baseball Database is copyright 1996-2013 by Sean Lahman.

-- create master table
DROP TABLE IF EXISTS public.master;
CREATE TABLE public.master  (
playerID varchar(255), 
birthYear integer, 
birthMonth integer, 
birthDay integer, 
birthCountry varchar(255), 
birthState varchar(255), 
birthCity varchar(255), 
deathYear integer, 
deathMonth integer, 
deathDay integer, 
deathCountry varchar(255), 
deathState varchar(255), 
deathCity varchar(255), 
nameFirst varchar(255), 
nameLast varchar(255), 
nameGiven varchar(255), 
weight integer, 
height integer, 
bats varchar(255), 
throws varchar(255), 
debut date, 
finalGame date, 
retroID varchar(255), 
bbrefID varchar(255)--,
--"deathDate date,
--birthDate date
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.teamsfranchises;
CREATE TABLE public.teamsfranchises  (
franchID varchar(255), 
franchName varchar(255), 
active varchar(255), 
NAassoc varchar(255)
) DISTRIBUTE BY HASH(franchID);

DROP TABLE IF EXISTS public.teams;
CREATE TABLE public.teams  (
yearID integer, 
lgID varchar(255), 
teamID varchar(255), 
franchID varchar(255), 
divID varchar(255), 
Rank integer, 
G integer, 
Ghome integer, 
W integer, 
L integer, 
DivWin varchar(255), 
WCWin varchar(255), 
LgWin varchar(255), 
WSWin varchar(255), 
R integer, 
AB integer, 
H integer, 
X2B integer, 
X3B integer, 
HR integer, 
BB integer, 
SO integer, 
SB integer, 
CS integer, 
HBP integer, 
SF integer, 
RA integer, 
ER integer, 
ERA double precision, 
CG integer, 
SHO integer, 
SV integer, 
IPouts integer, 
HA integer, 
HRA integer, 
BBA integer, 
SOA integer, 
E integer, 
DP integer, 
FP double precision, 
name varchar(255), 
park varchar(255), 
attendance integer, 
BPF integer, 
PPF integer, 
teamIDBR varchar(255), 
teamIDlahman45 varchar(255), 
teamIDretro varchar(255)
) DISTRIBUTE BY HASH(franchID);

DROP TABLE IF EXISTS public.appearances;
CREATE TABLE public.appearances  (
yearID integer, 
teamID varchar(255), 
lgID varchar(255), 
playerID varchar(255), 
G_all integer, 
GS integer, 
G_batting integer, 
G_defense integer, 
G_p integer, 
G_c integer, 
G_1b integer, 
G_2b integer, 
G_3b integer, 
G_ss integer, 
G_lf integer, 
G_cf integer, 
G_rf integer, 
G_of integer, 
G_dh integer, 
G_ph integer, 
G_pr integer
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.salaries;
CREATE TABLE public.salaries  (
yearID integer, 
teamID varchar(255), 
lgID varchar(255), 
playerID varchar(255), 
salary integer
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.batting;
CREATE TABLE public.batting  (
playerID varchar(255), 
yearID integer, 
stint integer, 
teamID varchar(255), 
lgID varchar(255), 
G integer,
AB integer, 
R integer, 
H integer, 
X2B integer, 
X3B integer, 
HR integer, 
RBI integer, 
SB integer, 
CS integer, 
BB integer, 
SO integer, 
IBB integer, 
HBP integer, 
SH integer, 
SF integer, 
GIDP integer
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.pitching;
CREATE TABLE public.pitching  (
playerID varchar(255),
yearID integer, 
stint varchar(255), 
teamID varchar(255), 
lgID varchar(255), 
W integer, 
L integer, 
G integer, 
GS integer, 
CG integer, 
SHO integer, 
SV integer, 
IPouts integer, 
H integer, 
ER integer, 
HR integer, 
BB integer, 
SO integer, 
BAOpp numeric, 
ERA numeric, 
IBB integer, 
WP integer, 
HBP integer, 
BK integer, 
BFP integer, 
GF integer, 
R integer, 
SH varchar(255), 
SF varchar(255), 
GIDP varchar(255)
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.fielding;
CREATE TABLE public.fielding  (
playerID varchar(255), 
yearID integer, 
stint varchar(255), 
teamID varchar(255), 
lgID varchar(255), 
POS varchar(255), 
G varchar(255), 
GS varchar(255), 
InnOuts varchar(255), 
PO varchar(255), 
A varchar(255), 
E varchar(255), 
DP varchar(255), 
PB varchar(255), 
WP varchar(255), 
SB varchar(255), 
CS varchar(255), 
ZR varchar(255)
) DISTRIBUTE BY HASH(playerID);

DROP TABLE IF EXISTS public.collegeplaying;
CREATE TABLE public.collegeplaying (
playerID varchar(255),
schoolID varchar(255),
yearID integer
) DISTRIBUTE BY HASH(playerID);
