#! /bin/bash
# Call this script with at least 3 parameters, for example
# sh load_dallas_data -d mydbname -U beehive -w beehive

function usage
{
    echo "usage: load_dallas_data [-h host] [-p port] -d dbname -U username -w password"
}

# Test if arguments are present
if [ -z "$1" ]
  then
	echo "No arguments supplied."
    	usage
    	exit 1
fi

# Parse arguments
host=localhost
port=2406
dbname=baseball
username=beehive
password=beehive

while [ "$1" != "" ]; do
    case $1 in
        -h | --host )           shift
                                host=$1
                                ;;
	-p | --port )           shift
                                port=$1	
				;;
	-d | --dbname )         shift
	                        dbname=$1
				;;
        -U | --username )       shift
	 			username=$1
                                ;;
        -w | --password )       shift
	 			password=$1
                                ;;
        -h | --help )           usage
                                exit
                                ;;
        * )                     usage
                                exit 1
    esac
    shift
done


# MAIN SCRIPT
act -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -f create_tables.sql

ncluster_loader -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -c --skip-rows 1 --el-enabled public.dallaspolice Police_Bulk_Data.csv

ncluster_loader -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -c --skip-rows 1 --el-enabled public.dallaspolicenarrative Bulk_Police_Narrative.csv

ncluster_loader -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -c --skip-rows 1 --el-enabled public.dallasbuildingpermits Building_Inspection_Master_Permits.csv

act -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -f enhance_dallas.sql

act -h "$host" -p "$port" -d "$dbname" -U "$username" -w "$password" -f graph_dallas.sql
