<?php
class flow_ctrl_main extends L {
    /**
     * 描述 :x请求验证
     * 作者 : Edgar.lee
     */
    public function __construct() {
        //定义全局规则
        $rule = array(
            'getMsgs' => array(
                'get' => array(
                    'size' => 'int'
                )
            ),
            'index' => array(),
            'apiTest' => array(),
            'door' => array(),
            'login' => array(),
            'logout' => array(),
            'unRole' => array(),
        );

        L::rule($rule);
    }

    /**
     * 描述 : 显示主界面
     * 作者 : Edgar.lee
     */
    public function index() {
        $this->view->title = '接口演示';
        $this->display('/index.html');
    }

    /**
     * 描述 : 获取消息列表
     * 作者 : Edgar.lee
     */
    public function getMsgs() {
        $data = array(
            'list' => array(
                array(
                    'img'   => '/img/a1.jpg',
                    'name'  => '谨斯里',
                    'title' => '上传了一个文件',
                    'time'  => '2014.11.8 12:22',
                    'msgs'  => '消息1',
                ),
                array(
                    'img'   => '/img/a2.jpg',
                    'name'  => '田亮',
                    'title' => '参加了《粑粑去哪儿》',
                    'time'  => '2014.12.8 12:22',
                    'msgs'  => '消息1',
                ),
                array(
                    'img'   => '/img/a3.jpg',
                    'name'  => '林依晨',
                    'title' => 'Ariel',
                    'time'  => '2015.12.8 12:22',
                    'msgs'  => '消息3',
                ),
                array(
                    'img'   => '/img/a4.jpg',
                    'name'  => '颜文字君',
                    'title' => '评论了',
                    'time'  => '2016.11.8 12:22',
                    'msgs'  => '消息4',
                )
            )
        );
        return array(
            'code' => 200,
            'data' => &$data,
            'info' => "读取成功"
        );
    }

    /**
     * 描述 : 接口测试
     * 作者 : Edgar.lee
     */
    public function apiTest() {
        //模拟GET, POST, COOKIE 等数据
        //$_POST = array('aa' => '123');
        $error = of_base_tool_test::check('flow_ctrl_main', 'getMsgs');

        if ($error) {
            echo '<pre>';
            echo 'flow_ctrl_main::getMsgs    ';
            echo '<a href="?c=flow_ctrl_main&a=apiTest&size=1" style="color: red;">传入size为int的get参数会响应正确信息</a> <br>';
            print_r($error);
            echo '</pre>';
        } else {
            echo '无数据返回';
        }
    }

    /**
     * 描述 : 显示登录界面
     * 作者 : Edgar.lee
     */
    public function door() {
        $this->display('/login.html');
    }

    /**
     * 描述 : 登录帐号
     * 作者 : Edgar.lee
     */
    public function login() {
        if (isset($_POST['user']) && isset($_POST['pwd']) && isset($_POST['captcha'])) {
            //验证通过
            if (of_base_com_com::captcha($_POST['captcha'])) {
                //校验用户名和密码
                $state = of_base_sso_tool::login(array(
                    'user' => &$_POST['user'],
                    'pwd'  => &$_POST['pwd']
                ));

                //登录成功
                if ($state === true) {
                    echo 'done';
                //登录出错
                } else if ($state) {
                    echo $state['msg'];
                //登录失败
                } else {
                    echo '帐号密码错误';
                }
            //验证失败
            } else {
                echo '验证码错误';
            }
        }
    }

    /**
     * 描述 : 退出帐号
     * 作者 : Edgar.lee
     */
    public function logout() {
        of_base_sso_tool::logout();
        L::header(ROOT_URL . '/flow/index.php');
    }

    /**
     * 描述 : 无权访问界面
     * 作者 : Edgar.lee
     */
    public function unRole() {
        $this->view->title = '无权访问';
        $this->view->info = '您无权访问当前页面, 请联系管理员开通';
        $this->display('/error.html');
    }
}
return true;