var cityGeo = {};
for (var p in chinaCityGeo) {
    var province = chinaCityGeo[p];
    for (var city in province) {
        cityGeo[city] = province[city];
    }
}
// 补充几个地理信息
cityGeo['盘锦'] = {y:41.119997, x:122.070714};
cityGeo['舟山'] = {y:29.985295, x:122.207216};
cityGeo['葫芦岛'] = {y:40.711052, x:120.836932};
cityGeo['胶州'] = {y:36.264622, x:120.03336};
cityGeo['台州'] = {y:28.656386, x:121.420757};
cityGeo['鄂尔多斯'] = {y:39.608266, x:109.781327};
cityGeo['三亚'] = {y:18.252847, x:109.511909};
cityGeo['莱州'] = {y:37.177017, x:119.942327};
cityGeo['瓦房店'] = {y:39.627114, x:121.979603};
cityGeo['嘉峪关'] = {y:39.77313, x:98.289152};
cityGeo['湛江'] = {y:21.270708, x:110.359377};
cityGeo['张家港'] = {y:31.875428, x:120.555821};
cityGeo['汕尾'] = {y:22.786211, x:115.375279};
cityGeo['攀枝花'] = {y:26.582347, x:101.718637};
cityGeo['南充'] = {y:30.837793, x:106.110698};
cityGeo['自贡'] = {y:29.33903, x:104.778442};
cityGeo['金昌'] = {y:38.520089, x:102.188043};
cityGeo['张家界'] = {y:29.117096, x:110.479191};
cityGeo['荆州'] = {y:30.335165, x:112.239741};
cityGeo['菏泽'] = {y:35.23375, x:115.480656};

var data = {
    oriData : [],
    cityToData : {},
    //cityArray : [],
    aqi : [],   aqiMin:0,   aqiMax:500,
    pm25 : [],  pm25Min:0,  pm25Max:800,
    pm10 : [],  pm10Min:0,  pm10Max:800,
    co : [],    coMin:0,    coMax:15,
    no2 : [],   no2Min:0,   no2Max:300,
    o3 : [],    o3Min:0,    o3Max:300,
    so2 : [],   so2Min:0,   so2Max:500,
    geoCoord : {}
};
data.format = function (oriData) {
    data.oriData = oriData;
    var city;
    var cityToData = {};
    //var cityArray = [];
    var geoCoord = {};
    function pushData(key, city, value) {
        data[key].push({name:city, value:value});
        // data[key+'Min'] = Math.min(data[key+'Min'], value);
        // data[key+'Max'] = Math.max(data[key+'Max'], value);
    }
    var singleData;
    for (var i = 0, l = oriData.length; i < l; i++) {
        singleData = oriData[i]
        city = singleData.area;
        //cityArray.push(city);
        cityToData[city] = singleData;
        pushData('aqi', city, singleData.aqi);
        pushData('pm25', city, singleData.pm2_5);
        pushData('pm10', city, singleData.pm10);
        pushData('co', city, singleData.co);
        pushData('no2', city, singleData.no2);
        pushData('o3', city, singleData.o3);
        pushData('so2', city, singleData.so2);
        geoCoord[city] = cityGeo[city];
    }
    
    function sortData(a, b) {
        return a.value - b.value
    }
    data['aqi'].sort(sortData);
    data['pm25'].sort(sortData);
    data['pm10'].sort(sortData);
    data['co'].sort(sortData);
    data['no2'].sort(sortData);
    data['o3'].sort(sortData);
    data['so2'].sort(sortData);
    
    data.oriData = oriData;
    data.cityToData = cityToData;
    //data.cityArray = cityArray;
    data.geoCoord = geoCoord;
}

// 重点城市的人口和GDP
var PG = {
    '北京':{pop:1297.46, gdp:17879.4},
    '天津':{pop:993.2, gdp:12893.88},
    '石家庄':{pop:1005.33, gdp:4500.2},
    '太原':{pop:365.84, gdp:2311.4},
    '呼和浩特':{pop:230.32, gdp:2475.6},
    '沈阳':{pop:724.79, gdp:6602.6},
    '大连':{pop:590.31, gdp:7002.8},
    '长春':{pop:756.9, gdp:4456.6},
    '哈尔滨':{pop:993.53, gdp:4550.2},
    '上海':{pop:1426.93, gdp:20181.72},
    '南京':{pop:638.48, gdp:7201.6},
    '杭州':{pop:700.52, gdp:7802},
    '宁波':{pop:577.71, gdp:6582.2},
    '合肥':{pop:710.53, gdp:4164.3},
    '福州':{pop:655.27, gdp:4218.3},
    '厦门':{pop:190.92, gdp:2817.1},
    '南昌':{pop:507.87, gdp:3000.5},
    '济南':{pop:609.21, gdp:4803.7},
    '青岛':{pop:769.56, gdp:7302.1},
    '郑州':{pop:1072.5, gdp:5549.8},
    '武汉':{pop:821.71, gdp:8003.8},
    '长沙':{pop:660.62, gdp:6399.9},
    '广州':{pop:822.3, gdp:13551.2},
    '深圳':{pop:287.62, gdp:12950.1},
    '南宁':{pop:713.5, gdp:2503.2},
    '海口':{pop:161.59, gdp:818.8},
    '重庆':{pop:3343.44, gdp:11409.6},
    '成都':{pop:1173.3, gdp:8138.9},
    '贵阳':{pop:374.53, gdp:1700.3},
    '昆明':{pop:543.48, gdp:3011.1},
    '拉萨':{pop:50, gdp:260.1},
    '西安':{pop:795.98, gdp:4366.1},
    '兰州':{pop:321.52, gdp:1563.8},
    '西宁':{pop:198.46, gdp:851.1},
    '银川':{pop:167.22, gdp:1150.9},
    '乌鲁木齐':{pop:257.8, gdp:2004.1}
};

//颜色映射
var eColorMap = {
    'aqi' : '#87cefa',
    'pm25' : '#ff7f50',
    'pm10' : '#da70d6',
    'co' : '#32cd32',
    'no2' : '#6495ed',
    'o3' : '#ff69b4',
    'so2' : '#87cefa'
};

var testData = [{"aqi":23,"area":"北京","co":0.4,"co_24h":0.464,"no2":11,"no2_24h":25,"o3":58,"o3_24h":62,"o3_8h":44,"o3_8h_24h":57,"pm10":23,"pm10_24h":20,"pm2_5":14,"pm2_5_24h":17,"quality":"优","level":"一级","so2":11,"so2_24h":14,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":26,"area":"莱西","co":0.135,"co_24h":0.652,"no2":10,"no2_24h":30,"o3":66,"o3_24h":65,"o3_8h":52,"o3_8h_24h":59,"pm10":25,"pm10_24h":87,"pm2_5":13,"pm2_5_24h":61,"quality":"优","level":"一级","so2":16,"so2_24h":46,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":26,"area":"荣成","co":0.084,"co_24h":0.436,"no2":9,"no2_24h":15,"o3":25,"o3_24h":40,"o3_8h":27,"o3_8h_24h":36,"pm10":25,"pm10_24h":65,"pm2_5":8,"pm2_5_24h":46,"quality":"优","level":"一级","so2":14,"so2_24h":28,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":26,"area":"盘锦","co":1.031,"co_24h":0.862,"no2":5,"no2_24h":20,"o3":73,"o3_24h":67,"o3_8h":50,"o3_8h_24h":56,"pm10":25,"pm10_24h":25,"pm2_5":12,"pm2_5_24h":32,"quality":"优","level":"一级","so2":24,"so2_24h":38,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":26,"area":"丹东","co":0.566,"co_24h":1.083,"no2":12,"no2_24h":30,"o3":60,"o3_24h":60,"o3_8h":47,"o3_8h_24h":47,"pm10":25,"pm10_24h":69,"pm2_5":11,"pm2_5_24h":47,"quality":"优","level":"一级","so2":19,"so2_24h":64,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":27,"area":"营口","co":0.379,"co_24h":0.494,"no2":8,"no2_24h":16,"o3":67,"o3_24h":67,"o3_8h":53,"o3_8h_24h":58,"pm10":20,"pm10_24h":23,"pm2_5":8,"pm2_5_24h":10,"quality":"优","level":"一级","so2":27,"so2_24h":45,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":28,"area":"本溪","co":2.274,"co_24h":2.538,"no2":25,"no2_24h":33,"o3":39,"o3_24h":49,"o3_8h":35,"o3_8h_24h":37,"pm10":27,"pm10_24h":50,"pm2_5":12,"pm2_5_24h":25,"quality":"优","level":"一级","so2":52,"so2_24h":57,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":29,"area":"文登","co":0.454,"co_24h":0.733,"no2":16,"no2_24h":12,"o3":57,"o3_24h":78,"o3_8h":49,"o3_8h_24h":78,"pm10":28,"pm10_24h":51,"pm2_5":10,"pm2_5_24h":67,"quality":"优","level":"一级","so2":12,"so2_24h":28,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":29,"area":"平度","co":0,"co_24h":0.673,"no2":15,"no2_24h":34,"o3":63,"o3_24h":65,"o3_8h":57,"o3_8h_24h":57,"pm10":0,"pm10_24h":0,"pm2_5":14,"pm2_5_24h":67,"quality":"优","level":"一级","so2":12,"so2_24h":36,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":29,"area":"义乌","co":0.574,"co_24h":1.02,"no2":43,"no2_24h":65,"o3":30,"o3_24h":30,"o3_8h":10,"o3_8h_24h":10,"pm10":26,"pm10_24h":91,"pm2_5":20,"pm2_5_24h":75,"quality":"优","level":"一级","so2":9,"so2_24h":7,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":30,"area":"临汾","co":1.835,"co_24h":1.946,"no2":3,"no2_24h":10,"o3":67,"o3_24h":69,"o3_8h":60,"o3_8h_24h":60,"pm10":20,"pm10_24h":45,"pm2_5":6,"pm2_5_24h":24,"quality":"优","level":"一级","so2":5,"so2_24h":12,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":30,"area":"锦州","co":0.56,"co_24h":0.77,"no2":6,"no2_24h":20,"o3":79,"o3_24h":80,"o3_8h":60,"o3_8h_24h":65,"pm10":24,"pm10_24h":41,"pm2_5":7,"pm2_5_24h":23,"quality":"优","level":"一级","so2":17,"so2_24h":61,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":31,"area":"宁波","co":0.973,"co_24h":1.519,"no2":42,"no2_24h":71,"o3":47,"o3_24h":49,"o3_8h":19,"o3_8h_24h":20,"pm10":30,"pm10_24h":87,"pm2_5":22,"pm2_5_24h":66,"quality":"优","level":"一级","so2":11,"so2_24h":18,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":32,"area":"鞍山","co":1.671,"co_24h":1.972,"no2":5,"no2_24h":16,"o3":62,"o3_24h":63,"o3_8h":51,"o3_8h_24h":52,"pm10":31,"pm10_24h":44,"pm2_5":11,"pm2_5_24h":21,"quality":"优","level":"一级","so2":18,"so2_24h":48,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":32,"area":"舟山","co":0.503,"co_24h":0.912,"no2":9,"no2_24h":53,"o3":90,"o3_24h":235,"o3_8h":63,"o3_8h_24h":82,"pm10":15,"pm10_24h":70,"pm2_5":8,"pm2_5_24h":40,"quality":"优","level":"一级","so2":3,"so2_24h":22,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":32,"area":"承德","co":0.374,"co_24h":0.602,"no2":9,"no2_24h":24,"o3":70,"o3_24h":71,"o3_8h":49,"o3_8h_24h":69,"pm10":31,"pm10_24h":48,"pm2_5":13,"pm2_5_24h":25,"quality":"优","level":"一级","so2":15,"so2_24h":26,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":33,"area":"抚顺","co":0.825,"co_24h":0.978,"no2":8,"no2_24h":16,"o3":66,"o3_24h":68,"o3_8h":54,"o3_8h_24h":56,"pm10":32,"pm10_24h":50,"pm2_5":11,"pm2_5_24h":20,"quality":"优","level":"一级","so2":12,"so2_24h":22,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":33,"area":"葫芦岛","co":1.6,"co_24h":1.711,"no2":10,"no2_24h":16,"o3":74,"o3_24h":75,"o3_8h":60,"o3_8h_24h":63,"pm10":32,"pm10_24h":34,"pm2_5":11,"pm2_5_24h":21,"quality":"优","level":"一级","so2":29,"so2_24h":56,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":34,"area":"烟台","co":0.606,"co_24h":0.978,"no2":20,"no2_24h":37,"o3":68,"o3_24h":85,"o3_8h":53,"o3_8h_24h":73,"pm10":33,"pm10_24h":41,"pm2_5":17,"pm2_5_24h":52,"quality":"优","level":"一级","so2":21,"so2_24h":27,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":34,"area":"胶南","co":0.203,"co_24h":0.865,"no2":15,"no2_24h":25,"o3":64,"o3_24h":73,"o3_8h":56,"o3_8h_24h":73,"pm10":33,"pm10_24h":103,"pm2_5":21,"pm2_5_24h":77,"quality":"优","level":"一级","so2":26,"so2_24h":25,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":34,"area":"蓬莱","co":0.678,"co_24h":1.083,"no2":15,"no2_24h":25,"o3":74,"o3_24h":74,"o3_8h":68,"o3_8h_24h":68,"pm10":24,"pm10_24h":69,"pm2_5":13,"pm2_5_24h":40,"quality":"优","level":"一级","so2":14,"so2_24h":24,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":34,"area":"乳山","co":0.236,"co_24h":0.653,"no2":8,"no2_24h":16,"o3":58,"o3_24h":58,"o3_8h":52,"o3_8h_24h":54,"pm10":33,"pm10_24h":51,"pm2_5":9,"pm2_5_24h":63,"quality":"优","level":"一级","so2":12,"so2_24h":25,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":35,"area":"威海","co":0.331,"co_24h":0.583,"no2":9,"no2_24h":24,"o3":70,"o3_24h":73,"o3_8h":69,"o3_8h_24h":69,"pm10":25,"pm10_24h":59,"pm2_5":12,"pm2_5_24h":38,"quality":"优","level":"一级","so2":11,"so2_24h":16,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":35,"area":"胶州","co":0.599,"co_24h":1.424,"no2":21,"no2_24h":47,"o3":44,"o3_24h":46,"o3_8h":34,"o3_8h_24h":34,"pm10":34,"pm10_24h":99,"pm2_5":15,"pm2_5_24h":66,"quality":"优","level":"一级","so2":27,"so2_24h":44,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":35,"area":"延安","co":0.906,"co_24h":1.149,"no2":14,"no2_24h":29,"o3":56,"o3_24h":58,"o3_8h":28,"o3_8h_24h":47,"pm10":34,"pm10_24h":65,"pm2_5":16,"pm2_5_24h":21,"quality":"优","level":"一级","so2":24,"so2_24h":32,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":36,"area":"沈阳","co":0.258,"co_24h":0.385,"no2":12,"no2_24h":29,"o3":59,"o3_24h":62,"o3_8h":49,"o3_8h_24h":53,"pm10":35,"pm10_24h":56,"pm2_5":13,"pm2_5_24h":23,"quality":"优","level":"一级","so2":39,"so2_24h":70,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":36,"area":"台州","co":1.198,"co_24h":1.597,"no2":26,"no2_24h":53,"o3":32,"o3_24h":45,"o3_8h":28,"o3_8h_24h":28,"pm10":35,"pm10_24h":105,"pm2_5":24,"pm2_5_24h":68,"quality":"优","level":"一级","so2":12,"so2_24h":18,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":36,"area":"吉林","co":0.958,"co_24h":1.273,"no2":12,"no2_24h":24,"o3":61,"o3_24h":64,"o3_8h":49,"o3_8h_24h":62,"pm10":35,"pm10_24h":59,"pm2_5":19,"pm2_5_24h":36,"quality":"优","level":"一级","so2":18,"so2_24h":19,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":36,"area":"牡丹江","co":0.449,"co_24h":0.993,"no2":16,"no2_24h":37,"o3":67,"o3_24h":69,"o3_8h":44,"o3_8h_24h":47,"pm10":35,"pm10_24h":84,"pm2_5":22,"pm2_5_24h":60,"quality":"优","level":"一级","so2":20,"so2_24h":29,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":37,"area":"福州","co":1.026,"co_24h":0.877,"no2":21,"no2_24h":60,"o3":68,"o3_24h":71,"o3_8h":48,"o3_8h_24h":59,"pm10":32,"pm10_24h":55,"pm2_5":26,"pm2_5_24h":36,"quality":"优","level":"一级","so2":9,"so2_24h":16,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":37,"area":"鄂尔多斯","co":0.424,"co_24h":0.44,"no2":9,"no2_24h":14,"o3":83,"o3_24h":83,"o3_8h":73,"o3_8h_24h":77,"pm10":14,"pm10_24h":39,"pm2_5":5,"pm2_5_24h":11,"quality":"优","level":"一级","so2":6,"so2_24h":8,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":38,"area":"齐齐哈尔","co":0.622,"co_24h":0.7,"no2":20,"no2_24h":22,"o3":41,"o3_24h":45,"o3_8h":34,"o3_8h_24h":36,"pm10":37,"pm10_24h":36,"pm2_5":6,"pm2_5_24h":13,"quality":"优","level":"一级","so2":26,"so2_24h":31,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":38,"area":"银川","co":0.969,"co_24h":1.054,"no2":27,"no2_24h":33,"o3":51,"o3_24h":61,"o3_8h":41,"o3_8h_24h":49,"pm10":37,"pm10_24h":68,"pm2_5":22,"pm2_5_24h":28,"quality":"优","level":"一级","so2":89,"so2_24h":84,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":38,"area":"玉溪","co":1.844,"co_24h":2.873,"no2":9,"no2_24h":30,"o3":108,"o3_24h":74,"o3_8h":44,"o3_8h_24h":70,"pm10":37,"pm10_24h":67,"pm2_5":19,"pm2_5_24h":35,"quality":"优","level":"一级","so2":13,"so2_24h":41,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":39,"area":"即墨","co":0.111,"co_24h":0.588,"no2":21,"no2_24h":38,"o3":50,"o3_24h":56,"o3_8h":40,"o3_8h_24h":52,"pm10":38,"pm10_24h":55,"pm2_5":8,"pm2_5_24h":37,"quality":"优","level":"一级","so2":26,"so2_24h":35,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":39,"area":"日照","co":0.258,"co_24h":0.961,"no2":14,"no2_24h":36,"o3":69,"o3_24h":84,"o3_8h":57,"o3_8h_24h":81,"pm10":38,"pm10_24h":106,"pm2_5":18,"pm2_5_24h":79,"quality":"优","level":"一级","so2":19,"so2_24h":37,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":40,"area":"东营","co":0.586,"co_24h":1.206,"no2":12,"no2_24h":37,"o3":65,"o3_24h":74,"o3_8h":54,"o3_8h_24h":54,"pm10":39,"pm10_24h":111,"pm2_5":13,"pm2_5_24h":67,"quality":"优","level":"一级","so2":26,"so2_24h":57,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":40,"area":"丽水","co":1.052,"co_24h":1.43,"no2":40,"no2_24h":59,"o3":31,"o3_24h":39,"o3_8h":20,"o3_8h_24h":20,"pm10":24,"pm10_24h":103,"pm2_5":28,"pm2_5_24h":76,"quality":"优","level":"一级","so2":26,"so2_24h":29,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":40,"area":"上海","co":0.687,"co_24h":0.851,"no2":42,"no2_24h":56,"o3":59,"o3_24h":70,"o3_8h":61,"o3_8h_24h":61,"pm10":33,"pm10_24h":44,"pm2_5":28,"pm2_5_24h":45,"quality":"优","level":"一级","so2":13,"so2_24h":18,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":41,"area":"章丘","co":0.04,"co_24h":1.19,"no2":35,"no2_24h":56,"o3":0,"o3_24h":0,"o3_8h":0,"o3_8h_24h":0,"pm10":40,"pm10_24h":101,"pm2_5":25,"pm2_5_24h":79,"quality":"优","level":"一级","so2":68,"so2_24h":98,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":41,"area":"淮安","co":1.375,"co_24h":1.461,"no2":21,"no2_24h":30,"o3":60,"o3_24h":101,"o3_8h":37,"o3_8h_24h":90,"pm10":0,"pm10_24h":93,"pm2_5":29,"pm2_5_24h":80,"quality":"优","level":"一级","so2":0,"so2_24h":21,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":42,"area":"滨州","co":2.259,"co_24h":3.001,"no2":20,"no2_24h":49,"o3":37,"o3_24h":40,"o3_8h":29,"o3_8h_24h":29,"pm10":41,"pm10_24h":126,"pm2_5":24,"pm2_5_24h":89,"quality":"优","level":"一级","so2":43,"so2_24h":91,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":42,"area":"唐山","co":0.726,"co_24h":1.958,"no2":16,"no2_24h":53,"o3":62,"o3_24h":62,"o3_8h":33,"o3_8h_24h":34,"pm10":41,"pm10_24h":110,"pm2_5":19,"pm2_5_24h":68,"quality":"优","level":"一级","so2":19,"so2_24h":117,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":42,"area":"寿光","co":0.471,"co_24h":1.24,"no2":15,"no2_24h":45,"o3":53,"o3_24h":54,"o3_8h":47,"o3_8h_24h":47,"pm10":41,"pm10_24h":140,"pm2_5":19,"pm2_5_24h":101,"quality":"优","level":"一级","so2":40,"so2_24h":92,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"天津","co":0.565,"co_24h":1.54,"no2":19,"no2_24h":52,"o3":55,"o3_24h":52,"o3_8h":29,"o3_8h_24h":38,"pm10":42,"pm10_24h":80,"pm2_5":28,"pm2_5_24h":51,"quality":"优","level":"一级","so2":30,"so2_24h":73,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"云浮","co":2.133,"co_24h":2.34,"no2":28,"no2_24h":60,"o3":14,"o3_24h":51,"o3_8h":9,"o3_8h_24h":51,"pm10":10,"pm10_24h":228,"pm2_5":30,"pm2_5_24h":145,"quality":"优","level":"一级","so2":26,"so2_24h":25,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"诸暨","co":0.504,"co_24h":1.217,"no2":31,"no2_24h":77,"o3":29,"o3_24h":29,"o3_8h":24,"o3_8h_24h":24,"pm10":29,"pm10_24h":107,"pm2_5":30,"pm2_5_24h":95,"quality":"优","level":"一级","so2":8,"so2_24h":14,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"潍坊","co":0.382,"co_24h":1.253,"no2":2,"no2_24h":36,"o3":70,"o3_24h":70,"o3_8h":61,"o3_8h_24h":61,"pm10":42,"pm10_24h":137,"pm2_5":14,"pm2_5_24h":90,"quality":"优","level":"一级","so2":21,"so2_24h":54,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"湖州","co":0.768,"co_24h":1.399,"no2":36,"no2_24h":60,"o3":49,"o3_24h":111,"o3_8h":54,"o3_8h_24h":54,"pm10":35,"pm10_24h":74,"pm2_5":30,"pm2_5_24h":85,"quality":"优","level":"一级","so2":17,"so2_24h":19,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":43,"area":"招远","co":0.169,"co_24h":0.759,"no2":15,"no2_24h":34,"o3":53,"o3_24h":55,"o3_8h":49,"o3_8h_24h":50,"pm10":42,"pm10_24h":104,"pm2_5":7,"pm2_5_24h":65,"quality":"优","level":"一级","so2":25,"so2_24h":41,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":45,"area":"昆明","co":1.344,"co_24h":1.082,"no2":27,"no2_24h":45,"o3":73,"o3_24h":76,"o3_8h":32,"o3_8h_24h":69,"pm10":44,"pm10_24h":88,"pm2_5":27,"pm2_5_24h":37,"quality":"优","level":"一级","so2":18,"so2_24h":23,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":45,"area":"长春","co":0.365,"co_24h":0.628,"no2":14,"no2_24h":31,"o3":60,"o3_24h":70,"o3_8h":45,"o3_8h_24h":51,"pm10":44,"pm10_24h":72,"pm2_5":22,"pm2_5_24h":38,"quality":"优","level":"一级","so2":27,"so2_24h":56,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":46,"area":"铜川","co":1.286,"co_24h":1.546,"no2":16,"no2_24h":24,"o3":79,"o3_24h":79,"o3_8h":69,"o3_8h_24h":72,"pm10":45,"pm10_24h":71,"pm2_5":17,"pm2_5_24h":28,"quality":"优","level":"一级","so2":19,"so2_24h":43,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":46,"area":"杭州","co":0.658,"co_24h":1.389,"no2":39,"no2_24h":63,"o3":39,"o3_24h":66,"o3_8h":28,"o3_8h_24h":30,"pm10":45,"pm10_24h":92,"pm2_5":24,"pm2_5_24h":62,"quality":"优","level":"一级","so2":16,"so2_24h":19,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":46,"area":"富阳","co":0.768,"co_24h":1.838,"no2":26,"no2_24h":57,"o3":46,"o3_24h":60,"o3_8h":40,"o3_8h_24h":49,"pm10":31,"pm10_24h":158,"pm2_5":32,"pm2_5_24h":147,"quality":"优","level":"一级","so2":11,"so2_24h":27,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":46,"area":"梅州","co":2.263,"co_24h":2.378,"no2":23,"no2_24h":55,"o3":64,"o3_24h":122,"o3_8h":30,"o3_8h_24h":121,"pm10":41,"pm10_24h":123,"pm2_5":32,"pm2_5_24h":71,"quality":"优","level":"一级","so2":8,"so2_24h":14,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":47,"area":"赤峰","co":0.172,"co_24h":0.413,"no2":11,"no2_24h":22,"o3":36,"o3_24h":37,"o3_8h":24,"o3_8h_24h":27,"pm10":46,"pm10_24h":59,"pm2_5":13,"pm2_5_24h":27,"quality":"优","level":"一级","so2":32,"so2_24h":56,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":48,"area":"三亚","co":0.493,"co_24h":0.671,"no2":8,"no2_24h":18,"o3":64,"o3_24h":98,"o3_8h":43,"o3_8h_24h":98,"pm10":47,"pm10_24h":69,"pm2_5":20,"pm2_5_24h":34,"quality":"优","level":"一级","so2":2,"so2_24h":3,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":48,"area":"连云港","co":0.928,"co_24h":1.438,"no2":20,"no2_24h":39,"o3":59,"o3_24h":76,"o3_8h":40,"o3_8h_24h":67,"pm10":47,"pm10_24h":102,"pm2_5":24,"pm2_5_24h":76,"quality":"优","level":"一级","so2":32,"so2_24h":26,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":49,"area":"莱州","co":0.091,"co_24h":1.294,"no2":0,"no2_24h":37,"o3":55,"o3_24h":31,"o3_8h":24,"o3_8h_24h":24,"pm10":48,"pm10_24h":109,"pm2_5":14,"pm2_5_24h":71,"quality":"优","level":"一级","so2":18,"so2_24h":59,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":49,"area":"瓦房店","co":0.19,"co_24h":0.367,"no2":97,"no2_24h":26,"o3":61,"o3_24h":61,"o3_8h":52,"o3_8h_24h":52,"pm10":36,"pm10_24h":33,"pm2_5":15,"pm2_5_24h":23,"quality":"优","level":"一级","so2":40,"so2_24h":47,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":49,"area":"宝鸡","co":1.58,"co_24h":1.709,"no2":15,"no2_24h":23,"o3":76,"o3_24h":76,"o3_8h":59,"o3_8h_24h":68,"pm10":48,"pm10_24h":72,"pm2_5":16,"pm2_5_24h":27,"quality":"优","level":"一级","so2":20,"so2_24h":22,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":49,"area":"盐城","co":0.447,"co_24h":0.616,"no2":5,"no2_24h":10,"o3":68,"o3_24h":91,"o3_8h":55,"o3_8h_24h":86,"pm10":43,"pm10_24h":53,"pm2_5":34,"pm2_5_24h":34,"quality":"优","level":"一级","so2":15,"so2_24h":10,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":49,"area":"绍兴","co":0.924,"co_24h":1.675,"no2":36,"no2_24h":64,"o3":45,"o3_24h":45,"o3_8h":18,"o3_8h_24h":18,"pm10":40,"pm10_24h":109,"pm2_5":34,"pm2_5_24h":87,"quality":"优","level":"一级","so2":30,"so2_24h":49,"primary_pollutant":"","time_point":"2014-01-08T14:00:00Z"},{"aqi":50,"area":"秦皇岛","co":0.869,"co_24h":0.949,"no2":18,"no2_24h":32,"o3":49,"o3_24h":48,"o3_8h":34,"o3_8h_24h":43,"pm10":49,"pm10_24h":55,"pm2_5":20,"pm2_5_24h":31,"quality":"优","level":"一级","so2":43,"so2_24h":64,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":50,"area":"绵阳","co":0.324,"co_24h":0.726,"no2":20,"no2_24h":47,"o3":85,"o3_24h":86,"o3_8h":53,"o3_8h_24h":76,"pm10":49,"pm10_24h":82,"pm2_5":23,"pm2_5_24h":52,"quality":"优","level":"一级","so2":14,"so2_24h":18,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":50,"area":"临安","co":0.59,"co_24h":1.408,"no2":20,"no2_24h":39,"o3":81,"o3_24h":93,"o3_8h":73,"o3_8h_24h":73,"pm10":30,"pm10_24h":137,"pm2_5":35,"pm2_5_24h":111,"quality":"优","level":"一级","so2":4,"so2_24h":14,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":50,"area":"大连","co":0.306,"co_24h":0.749,"no2":16,"no2_24h":30,"o3":48,"o3_24h":49,"o3_8h":39,"o3_8h_24h":40,"pm10":49,"pm10_24h":74,"pm2_5":15,"pm2_5_24h":39,"quality":"优","level":"一级","so2":22,"so2_24h":43,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":50,"area":"张家口","co":0.623,"co_24h":0.756,"no2":7,"no2_24h":16,"o3":64,"o3_24h":70,"o3_8h":42,"o3_8h_24h":70,"pm10":49,"pm10_24h":60,"pm2_5":12,"pm2_5_24h":32,"quality":"优","level":"一级","so2":40,"so2_24h":58,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":51,"area":"咸阳","co":0.814,"co_24h":1.211,"no2":13,"no2_24h":23,"o3":54,"o3_24h":56,"o3_8h":33,"o3_8h_24h":38,"pm10":50,"pm10_24h":75,"pm2_5":16,"pm2_5_24h":34,"quality":"良","level":"二级","so2":26,"so2_24h":33,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":51,"area":"嘉峪关","co":0.494,"co_24h":0.652,"no2":12,"no2_24h":32,"o3":77,"o3_24h":178,"o3_8h":64,"o3_8h_24h":72,"pm10":50,"pm10_24h":59,"pm2_5":11,"pm2_5_24h":20,"quality":"良","level":"二级","so2":40,"so2_24h":55,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":51,"area":"太原","co":1.678,"co_24h":2.05,"no2":10,"no2_24h":28,"o3":50,"o3_24h":53,"o3_8h":36,"o3_8h_24h":36,"pm10":50,"pm10_24h":75,"pm2_5":11,"pm2_5_24h":38,"quality":"良","level":"二级","so2":25,"so2_24h":59,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":51,"area":"宿迁","co":1.263,"co_24h":1.697,"no2":25,"no2_24h":40,"o3":47,"o3_24h":53,"o3_8h":30,"o3_8h_24h":45,"pm10":51,"pm10_24h":89,"pm2_5":26,"pm2_5_24h":64,"quality":"良","level":"二级","so2":34,"so2_24h":31,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":52,"area":"湛江","co":0.972,"co_24h":0.865,"no2":21,"no2_24h":13,"o3":71,"o3_24h":91,"o3_8h":49,"o3_8h_24h":86,"pm10":49,"pm10_24h":31,"pm2_5":36,"pm2_5_24h":24,"quality":"良","level":"二级","so2":30,"so2_24h":12,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":52,"area":"河源","co":1.907,"co_24h":1.939,"no2":21,"no2_24h":45,"o3":45,"o3_24h":93,"o3_8h":20,"o3_8h_24h":93,"pm10":52,"pm10_24h":108,"pm2_5":36,"pm2_5_24h":73,"quality":"良","level":"二级","so2":15,"so2_24h":17,"primary_pollutant":"颗粒物(PM2.5),颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":52,"area":"淄博","co":0.799,"co_24h":1.759,"no2":27,"no2_24h":71,"o3":54,"o3_24h":63,"o3_8h":35,"o3_8h_24h":40,"pm10":53,"pm10_24h":175,"pm2_5":32,"pm2_5_24h":133,"quality":"良","level":"二级","so2":70,"so2_24h":152,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":53,"area":"成都","co":0.504,"co_24h":0.955,"no2":25,"no2_24h":65,"o3":62,"o3_24h":65,"o3_8h":37,"o3_8h_24h":54,"pm10":54,"pm10_24h":95,"pm2_5":30,"pm2_5_24h":68,"quality":"良","level":"二级","so2":14,"so2_24h":21,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":54,"area":"泉州","co":0.963,"co_24h":0.889,"no2":21,"no2_24h":45,"o3":78,"o3_24h":99,"o3_8h":27,"o3_8h_24h":99,"pm10":57,"pm10_24h":117,"pm2_5":31,"pm2_5_24h":44,"quality":"良","level":"二级","so2":7,"so2_24h":13,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":54,"area":"张家港","co":0.605,"co_24h":2.467,"no2":24,"no2_24h":38,"o3":48,"o3_24h":88,"o3_8h":73,"o3_8h_24h":79,"pm10":56,"pm10_24h":79,"pm2_5":37,"pm2_5_24h":410,"quality":"良","level":"二级","so2":10,"so2_24h":34,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":54,"area":"温州","co":1.567,"co_24h":1.758,"no2":55,"no2_24h":75,"o3":8,"o3_24h":15,"o3_8h":8,"o3_8h_24h":8,"pm10":56,"pm10_24h":126,"pm2_5":34,"pm2_5_24h":66,"quality":"良","level":"二级","so2":15,"so2_24h":23,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":55,"area":"太仓","co":1.454,"co_24h":1.624,"no2":30,"no2_24h":52,"o3":70,"o3_24h":82,"o3_8h":76,"o3_8h_24h":76,"pm10":50,"pm10_24h":67,"pm2_5":38,"pm2_5_24h":49,"quality":"良","level":"二级","so2":50,"so2_24h":29,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":55,"area":"海口","co":0.419,"co_24h":0.794,"no2":12,"no2_24h":16,"o3":44,"o3_24h":60,"o3_8h":33,"o3_8h_24h":58,"pm10":58,"pm10_24h":55,"pm2_5":24,"pm2_5_24h":27,"quality":"良","level":"二级","so2":5,"so2_24h":4,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":55,"area":"清远","co":2.16,"co_24h":2.05,"no2":33,"no2_24h":68,"o3":30,"o3_24h":53,"o3_8h":17,"o3_8h_24h":51,"pm10":47,"pm10_24h":129,"pm2_5":38,"pm2_5_24h":124,"quality":"良","level":"二级","so2":21,"so2_24h":34,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":55,"area":"石嘴山","co":0.525,"co_24h":0.574,"no2":14,"no2_24h":22,"o3":76,"o3_24h":88,"o3_8h":51,"o3_8h_24h":85,"pm10":59,"pm10_24h":75,"pm2_5":18,"pm2_5_24h":24,"quality":"良","level":"二级","so2":48,"so2_24h":64,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":56,"area":"德阳","co":0.841,"co_24h":1.599,"no2":48,"no2_24h":75,"o3":88,"o3_24h":88,"o3_8h":51,"o3_8h_24h":81,"pm10":60,"pm10_24h":99,"pm2_5":28,"pm2_5_24h":64,"quality":"良","level":"二级","so2":13,"so2_24h":30,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":56,"area":"廊坊","co":0.287,"co_24h":0.498,"no2":13,"no2_24h":41,"o3":49,"o3_24h":73,"o3_8h":41,"o3_8h_24h":69,"pm10":61,"pm10_24h":54,"pm2_5":16,"pm2_5_24h":27,"quality":"良","level":"二级","so2":10,"so2_24h":24,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":56,"area":"阳江","co":1.346,"co_24h":1.625,"no2":16,"no2_24h":41,"o3":45,"o3_24h":55,"o3_8h":14,"o3_8h_24h":54,"pm10":61,"pm10_24h":113,"pm2_5":35,"pm2_5_24h":62,"quality":"良","level":"二级","so2":6,"so2_24h":11,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":56,"area":"海门","co":0.578,"co_24h":0.48,"no2":10,"no2_24h":14,"o3":66,"o3_24h":92,"o3_8h":84,"o3_8h_24h":87,"pm10":48,"pm10_24h":48,"pm2_5":39,"pm2_5_24h":34,"quality":"良","level":"二级","so2":4,"so2_24h":5,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":57,"area":"青岛","co":0.502,"co_24h":0.907,"no2":17,"no2_24h":42,"o3":59,"o3_24h":80,"o3_8h":52,"o3_8h_24h":76,"pm10":63,"pm10_24h":76,"pm2_5":19,"pm2_5_24h":58,"quality":"良","level":"二级","so2":26,"so2_24h":38,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":57,"area":"哈尔滨","co":0.666,"co_24h":1.191,"no2":32,"no2_24h":54,"o3":37,"o3_24h":38,"o3_8h":30,"o3_8h_24h":36,"pm10":54,"pm10_24h":107,"pm2_5":40,"pm2_5_24h":77,"quality":"良","level":"二级","so2":72,"so2_24h":93,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"大庆","co":0.293,"co_24h":0.482,"no2":13,"no2_24h":26,"o3":55,"o3_24h":84,"o3_8h":38,"o3_8h_24h":68,"pm10":64,"pm10_24h":44,"pm2_5":10,"pm2_5_24h":27,"quality":"良","level":"二级","so2":41,"so2_24h":34,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"徐州","co":0.729,"co_24h":1.586,"no2":28,"no2_24h":54,"o3":45,"o3_24h":49,"o3_8h":19,"o3_8h_24h":31,"pm10":64,"pm10_24h":162,"pm2_5":28,"pm2_5_24h":124,"quality":"良","level":"二级","so2":47,"so2_24h":63,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"吴江","co":0.67,"co_24h":0.943,"no2":44,"no2_24h":61,"o3":62,"o3_24h":73,"o3_8h":67,"o3_8h_24h":67,"pm10":51,"pm10_24h":81,"pm2_5":41,"pm2_5_24h":66,"quality":"良","level":"二级","so2":19,"so2_24h":32,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"三门峡","co":0.966,"co_24h":1.284,"no2":23,"no2_24h":42,"o3":62,"o3_24h":81,"o3_8h":53,"o3_8h_24h":53,"pm10":64,"pm10_24h":87,"pm2_5":16,"pm2_5_24h":44,"quality":"良","level":"二级","so2":81,"so2_24h":105,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"嘉兴","co":1.427,"co_24h":1.739,"no2":62,"no2_24h":72,"o3":51,"o3_24h":67,"o3_8h":49,"o3_8h_24h":49,"pm10":50,"pm10_24h":82,"pm2_5":41,"pm2_5_24h":68,"quality":"良","level":"二级","so2":41,"so2_24h":29,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":58,"area":"汕尾","co":0.833,"co_24h":0.916,"no2":14,"no2_24h":26,"o3":88,"o3_24h":103,"o3_8h":53,"o3_8h_24h":100,"pm10":63,"pm10_24h":88,"pm2_5":41,"pm2_5_24h":58,"quality":"良","level":"二级","so2":5,"so2_24h":8,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":59,"area":"大同","co":1.768,"co_24h":1.93,"no2":14,"no2_24h":24,"o3":42,"o3_24h":51,"o3_8h":28,"o3_8h_24h":51,"pm10":66,"pm10_24h":44,"pm2_5":22,"pm2_5_24h":26,"quality":"良","level":"二级","so2":28,"so2_24h":39,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":59,"area":"沧州","co":0.505,"co_24h":1.622,"no2":15,"no2_24h":42,"o3":62,"o3_24h":62,"o3_8h":34,"o3_8h_24h":34,"pm10":67,"pm10_24h":126,"pm2_5":21,"pm2_5_24h":80,"quality":"良","level":"二级","so2":15,"so2_24h":50,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":59,"area":"攀枝花","co":2.99,"co_24h":3.074,"no2":31,"no2_24h":42,"o3":59,"o3_24h":70,"o3_8h":21,"o3_8h_24h":63,"pm10":66,"pm10_24h":129,"pm2_5":23,"pm2_5_24h":61,"quality":"良","level":"二级","so2":16,"so2_24h":32,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":60,"area":"泰安","co":0.903,"co_24h":2.404,"no2":31,"no2_24h":47,"o3":31,"o3_24h":31,"o3_8h":19,"o3_8h_24h":19,"pm10":67,"pm10_24h":161,"pm2_5":42,"pm2_5_24h":116,"quality":"良","level":"二级","so2":57,"so2_24h":110,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":60,"area":"衡水","co":0.609,"co_24h":2.242,"no2":16,"no2_24h":64,"o3":55,"o3_24h":56,"o3_8h":22,"o3_8h_24h":23,"pm10":68,"pm10_24h":235,"pm2_5":30,"pm2_5_24h":145,"quality":"良","level":"二级","so2":24,"so2_24h":78,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":61,"area":"常熟","co":0.56,"co_24h":0.76,"no2":78,"no2_24h":86,"o3":48,"o3_24h":69,"o3_8h":60,"o3_8h_24h":63,"pm10":49,"pm10_24h":51,"pm2_5":43,"pm2_5_24h":43,"quality":"良","level":"二级","so2":35,"so2_24h":48,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":61,"area":"昆山","co":0.642,"co_24h":0.741,"no2":36,"no2_24h":45,"o3":133,"o3_24h":137,"o3_8h":94,"o3_8h_24h":94,"pm10":49,"pm10_24h":66,"pm2_5":43,"pm2_5_24h":72,"quality":"良","level":"二级","so2":8,"so2_24h":26,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":61,"area":"长治","co":0.938,"co_24h":3.514,"no2":26,"no2_24h":47,"o3":72,"o3_24h":521,"o3_8h":64,"o3_8h_24h":127,"pm10":64,"pm10_24h":212,"pm2_5":43,"pm2_5_24h":114,"quality":"良","level":"二级","so2":24,"so2_24h":31,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":62,"area":"兰州","co":1.497,"co_24h":1.175,"no2":39,"no2_24h":25,"o3":53,"o3_24h":64,"o3_8h":33,"o3_8h_24h":61,"pm10":72,"pm10_24h":50,"pm2_5":34,"pm2_5_24h":16,"quality":"良","level":"二级","so2":41,"so2_24h":24,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":62,"area":"泰州","co":2.137,"co_24h":2.005,"no2":9,"no2_24h":13,"o3":37,"o3_24h":55,"o3_8h":38,"o3_8h_24h":52,"pm10":56,"pm10_24h":92,"pm2_5":44,"pm2_5_24h":54,"quality":"良","level":"二级","so2":14,"so2_24h":19,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":63,"area":"南通","co":0.763,"co_24h":0.667,"no2":13,"no2_24h":27,"o3":62,"o3_24h":84,"o3_8h":85,"o3_8h_24h":79,"pm10":48,"pm10_24h":54,"pm2_5":45,"pm2_5_24h":42,"quality":"良","level":"二级","so2":4,"so2_24h":10,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":63,"area":"德州","co":1.263,"co_24h":1.869,"no2":38,"no2_24h":71,"o3":32,"o3_24h":29,"o3_8h":12,"o3_8h_24h":18,"pm10":75,"pm10_24h":176,"pm2_5":41,"pm2_5_24h":149,"quality":"良","level":"二级","so2":128,"so2_24h":95,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":63,"area":"西安","co":2.094,"co_24h":2.411,"no2":26,"no2_24h":42,"o3":37,"o3_24h":37,"o3_8h":21,"o3_8h_24h":25,"pm10":75,"pm10_24h":93,"pm2_5":24,"pm2_5_24h":36,"quality":"良","level":"二级","so2":39,"so2_24h":50,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":63,"area":"佛山","co":1.93,"co_24h":1.979,"no2":47,"no2_24h":97,"o3":28,"o3_24h":49,"o3_8h":15,"o3_8h_24h":48,"pm10":74,"pm10_24h":190,"pm2_5":36,"pm2_5_24h":100,"quality":"良","level":"二级","so2":25,"so2_24h":47,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":63,"area":"潮州","co":0.983,"co_24h":1.258,"no2":22,"no2_24h":49,"o3":84,"o3_24h":149,"o3_8h":54,"o3_8h_24h":149,"pm10":74,"pm10_24h":122,"pm2_5":27,"pm2_5_24h":79,"quality":"良","level":"二级","so2":10,"so2_24h":28,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":64,"area":"金华","co":1.442,"co_24h":1.269,"no2":45,"no2_24h":56,"o3":5,"o3_24h":7,"o3_8h":3,"o3_8h_24h":5,"pm10":52,"pm10_24h":72,"pm2_5":46,"pm2_5_24h":107,"quality":"良","level":"二级","so2":37,"so2_24h":39,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":66,"area":"洛阳","co":1.332,"co_24h":2.002,"no2":18,"no2_24h":65,"o3":50,"o3_24h":61,"o3_8h":31,"o3_8h_24h":43,"pm10":80,"pm10_24h":221,"pm2_5":33,"pm2_5_24h":172,"quality":"良","level":"二级","so2":12,"so2_24h":70,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":66,"area":"揭阳","co":1.747,"co_24h":2.009,"no2":19,"no2_24h":49,"o3":87,"o3_24h":196,"o3_8h":68,"o3_8h_24h":187,"pm10":80,"pm10_24h":153,"pm2_5":44,"pm2_5_24h":117,"quality":"良","level":"二级","so2":18,"so2_24h":53,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":67,"area":"江门","co":1.763,"co_24h":1.636,"no2":58,"no2_24h":66,"o3":21,"o3_24h":53,"o3_8h":11,"o3_8h_24h":53,"pm10":82,"pm10_24h":122,"pm2_5":45,"pm2_5_24h":74,"quality":"良","level":"二级","so2":26,"so2_24h":29,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":68,"area":"临沂","co":1.342,"co_24h":1.914,"no2":27,"no2_24h":56,"o3":35,"o3_24h":44,"o3_8h":31,"o3_8h_24h":43,"pm10":71,"pm10_24h":151,"pm2_5":49,"pm2_5_24h":116,"quality":"良","level":"二级","so2":35,"so2_24h":69,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":68,"area":"茂名","co":0.945,"co_24h":1.124,"no2":9,"no2_24h":22,"o3":82,"o3_24h":79,"o3_8h":39,"o3_8h_24h":78,"pm10":80,"pm10_24h":98,"pm2_5":49,"pm2_5_24h":59,"quality":"良","level":"二级","so2":11,"so2_24h":14,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":70,"area":"渭南","co":0.606,"co_24h":0.859,"no2":24,"no2_24h":39,"o3":58,"o3_24h":60,"o3_8h":42,"o3_8h_24h":42,"pm10":89,"pm10_24h":94,"pm2_5":27,"pm2_5_24h":41,"quality":"良","level":"二级","so2":87,"so2_24h":64,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":72,"area":"苏州","co":0.646,"co_24h":0.94,"no2":48,"no2_24h":60,"o3":47,"o3_24h":59,"o3_8h":51,"o3_8h_24h":51,"pm10":44,"pm10_24h":62,"pm2_5":52,"pm2_5_24h":73,"quality":"良","level":"二级","so2":13,"so2_24h":15,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":72,"area":"枣庄","co":0.651,"co_24h":1.264,"no2":15,"no2_24h":54,"o3":60,"o3_24h":64,"o3_8h":44,"o3_8h_24h":59,"pm10":92,"pm10_24h":246,"pm2_5":40,"pm2_5_24h":147,"quality":"良","level":"二级","so2":46,"so2_24h":97,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":72,"area":"济宁","co":0.919,"co_24h":2.435,"no2":30,"no2_24h":74,"o3":42,"o3_24h":81,"o3_8h":19,"o3_8h_24h":57,"pm10":92,"pm10_24h":274,"pm2_5":49,"pm2_5_24h":174,"quality":"良","level":"二级","so2":65,"so2_24h":149,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":73,"area":"无锡","co":1.466,"co_24h":1.161,"no2":45,"no2_24h":55,"o3":24,"o3_24h":56,"o3_8h":45,"o3_8h_24h":50,"pm10":61,"pm10_24h":86,"pm2_5":53,"pm2_5_24h":67,"quality":"良","level":"二级","so2":18,"so2_24h":20,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":74,"area":"北海","co":1.998,"co_24h":1.237,"no2":20,"no2_24h":16,"o3":34,"o3_24h":94,"o3_8h":39,"o3_8h_24h":94,"pm10":87,"pm10_24h":96,"pm2_5":54,"pm2_5_24h":48,"quality":"良","level":"二级","so2":17,"so2_24h":12,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":74,"area":"南充","co":0.57,"co_24h":0.892,"no2":34,"no2_24h":53,"o3":32,"o3_24h":58,"o3_8h":32,"o3_8h_24h":34,"pm10":82,"pm10_24h":126,"pm2_5":54,"pm2_5_24h":96,"quality":"良","level":"二级","so2":30,"so2_24h":41,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":75,"area":"呼和浩特","co":2.545,"co_24h":2.461,"no2":27,"no2_24h":29,"o3":36,"o3_24h":45,"o3_8h":23,"o3_8h_24h":43,"pm10":98,"pm10_24h":68,"pm2_5":38,"pm2_5_24h":21,"quality":"良","level":"二级","so2":51,"so2_24h":45,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":76,"area":"惠州","co":0.971,"co_24h":0.834,"no2":33,"no2_24h":55,"o3":65,"o3_24h":89,"o3_8h":29,"o3_8h_24h":82,"pm10":86,"pm10_24h":100,"pm2_5":55,"pm2_5_24h":56,"quality":"良","level":"二级","so2":25,"so2_24h":21,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":76,"area":"贵阳","co":1.129,"co_24h":1.091,"no2":32,"no2_24h":36,"o3":36,"o3_24h":60,"o3_8h":28,"o3_8h_24h":60,"pm10":63,"pm10_24h":122,"pm2_5":55,"pm2_5_24h":102,"quality":"良","level":"二级","so2":33,"so2_24h":49,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":77,"area":"广州","co":1.801,"co_24h":1.767,"no2":48,"no2_24h":87,"o3":32,"o3_24h":74,"o3_8h":17,"o3_8h_24h":68,"pm10":71,"pm10_24h":129,"pm2_5":56,"pm2_5_24h":105,"quality":"良","level":"二级","so2":16,"so2_24h":18,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":77,"area":"保定","co":1.428,"co_24h":3.11,"no2":56,"no2_24h":85,"o3":44,"o3_24h":50,"o3_8h":33,"o3_8h_24h":39,"pm10":102,"pm10_24h":213,"pm2_5":36,"pm2_5_24h":145,"quality":"良","level":"二级","so2":37,"so2_24h":86,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":77,"area":"自贡","co":0.242,"co_24h":0.925,"no2":17,"no2_24h":26,"o3":22,"o3_24h":28,"o3_8h":21,"o3_8h_24h":22,"pm10":69,"pm10_24h":142,"pm2_5":56,"pm2_5_24h":113,"quality":"良","level":"二级","so2":18,"so2_24h":27,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":78,"area":"西宁","co":1.856,"co_24h":1.066,"no2":33,"no2_24h":29,"o3":26,"o3_24h":38,"o3_8h":22,"o3_8h_24h":36,"pm10":97,"pm10_24h":99,"pm2_5":57,"pm2_5_24h":40,"quality":"良","level":"二级","so2":105,"so2_24h":38,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":80,"area":"拉萨","co":1.831,"co_24h":1.88,"no2":25,"no2_24h":25,"o3":68,"o3_24h":97,"o3_8h":50,"o3_8h_24h":97,"pm10":109,"pm10_24h":78,"pm2_5":43,"pm2_5_24h":30,"quality":"良","level":"二级","so2":12,"so2_24h":13,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":82,"area":"衢州","co":1.247,"co_24h":1.087,"no2":43,"no2_24h":57,"o3":14,"o3_24h":17,"o3_8h":12,"o3_8h_24h":14,"pm10":0,"pm10_24h":101,"pm2_5":60,"pm2_5_24h":77,"quality":"良","level":"二级","so2":19,"so2_24h":20,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":82,"area":"阳泉","co":3.177,"co_24h":2.1,"no2":7,"no2_24h":54,"o3":32,"o3_24h":30,"o3_8h":21,"o3_8h_24h":24,"pm10":84,"pm10_24h":244,"pm2_5":60,"pm2_5_24h":92,"quality":"良","level":"二级","so2":14,"so2_24h":122,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":82,"area":"深圳","co":1.258,"co_24h":1.161,"no2":55,"no2_24h":52,"o3":59,"o3_24h":77,"o3_8h":34,"o3_8h_24h":74,"pm10":95,"pm10_24h":77,"pm2_5":60,"pm2_5_24h":48,"quality":"良","level":"二级","so2":13,"so2_24h":9,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":82,"area":"南宁","co":1.374,"co_24h":1.545,"no2":33,"no2_24h":43,"o3":57,"o3_24h":195,"o3_8h":60,"o3_8h_24h":89,"pm10":75,"pm10_24h":108,"pm2_5":60,"pm2_5_24h":71,"quality":"良","level":"二级","so2":25,"so2_24h":35,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":83,"area":"肇庆","co":1.514,"co_24h":2.048,"no2":29,"no2_24h":107,"o3":24,"o3_24h":24,"o3_8h":12,"o3_8h_24h":15,"pm10":0,"pm10_24h":292,"pm2_5":61,"pm2_5_24h":209,"quality":"良","level":"二级","so2":13,"so2_24h":62,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":84,"area":"溧阳","co":1.826,"co_24h":1.863,"no2":81,"no2_24h":83,"o3":9,"o3_24h":40,"o3_8h":29,"o3_8h_24h":33,"pm10":88,"pm10_24h":91,"pm2_5":62,"pm2_5_24h":65,"quality":"良","level":"二级","so2":45,"so2_24h":33,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":85,"area":"东莞","co":1.909,"co_24h":1.267,"no2":61,"no2_24h":69,"o3":29,"o3_24h":117,"o3_8h":12,"o3_8h_24h":117,"pm10":79,"pm10_24h":96,"pm2_5":63,"pm2_5_24h":74,"quality":"良","level":"二级","so2":34,"so2_24h":26,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":85,"area":"韶关","co":2.64,"co_24h":3.404,"no2":36,"no2_24h":71,"o3":32,"o3_24h":32,"o3_8h":19,"o3_8h_24h":21,"pm10":60,"pm10_24h":89,"pm2_5":63,"pm2_5_24h":152,"quality":"良","level":"二级","so2":36,"so2_24h":41,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":87,"area":"莱芜","co":0.747,"co_24h":1.859,"no2":44,"no2_24h":93,"o3":46,"o3_24h":47,"o3_8h":32,"o3_8h_24h":32,"pm10":56,"pm10_24h":186,"pm2_5":64,"pm2_5_24h":150,"quality":"良","level":"二级","so2":52,"so2_24h":200,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":87,"area":"柳州","co":1.653,"co_24h":1.575,"no2":30,"no2_24h":35,"o3":58,"o3_24h":103,"o3_8h":37,"o3_8h_24h":98,"pm10":57,"pm10_24h":88,"pm2_5":64,"pm2_5_24h":76,"quality":"良","level":"二级","so2":40,"so2_24h":45,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":87,"area":"宜兴","co":2.02,"co_24h":1.736,"no2":59,"no2_24h":60,"o3":6,"o3_24h":52,"o3_8h":32,"o3_8h_24h":36,"pm10":62,"pm10_24h":93,"pm2_5":64,"pm2_5_24h":68,"quality":"良","level":"二级","so2":28,"so2_24h":31,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":88,"area":"济南","co":1.164,"co_24h":1.745,"no2":46,"no2_24h":65,"o3":32,"o3_24h":33,"o3_8h":22,"o3_8h_24h":23,"pm10":125,"pm10_24h":229,"pm2_5":62,"pm2_5_24h":146,"quality":"良","level":"二级","so2":150,"so2_24h":139,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":90,"area":"江阴","co":1.53,"co_24h":1.042,"no2":35,"no2_24h":52,"o3":27,"o3_24h":86,"o3_8h":61,"o3_8h_24h":70,"pm10":0,"pm10_24h":51,"pm2_5":67,"pm2_5_24h":55,"quality":"良","level":"二级","so2":22,"so2_24h":30,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":91,"area":"石家庄","co":0.928,"co_24h":3.37,"no2":29,"no2_24h":75,"o3":43,"o3_24h":48,"o3_8h":22,"o3_8h_24h":27,"pm10":131,"pm10_24h":365,"pm2_5":59,"pm2_5_24h":242,"quality":"良","level":"二级","so2":94,"so2_24h":150,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":91,"area":"汕头","co":1.18,"co_24h":1.007,"no2":31,"no2_24h":51,"o3":84,"o3_24h":115,"o3_8h":52,"o3_8h_24h":86,"pm10":126,"pm10_24h":119,"pm2_5":68,"pm2_5_24h":78,"quality":"良","level":"二级","so2":16,"so2_24h":30,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":91,"area":"芜湖","co":0.694,"co_24h":0.61,"no2":32,"no2_24h":35,"o3":41,"o3_24h":74,"o3_8h":46,"o3_8h_24h":53,"pm10":82,"pm10_24h":94,"pm2_5":68,"pm2_5_24h":68,"quality":"良","level":"二级","so2":59,"so2_24h":55,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":95,"area":"常州","co":1.761,"co_24h":1.093,"no2":34,"no2_24h":39,"o3":18,"o3_24h":60,"o3_8h":40,"o3_8h_24h":55,"pm10":78,"pm10_24h":70,"pm2_5":71,"pm2_5_24h":56,"quality":"良","level":"二级","so2":17,"so2_24h":22,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":95,"area":"金昌","co":1.554,"co_24h":1.689,"no2":34,"no2_24h":21,"o3":51,"o3_24h":80,"o3_8h":43,"o3_8h_24h":79,"pm10":130,"pm10_24h":65,"pm2_5":71,"pm2_5_24h":35,"quality":"良","level":"二级","so2":83,"so2_24h":38,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":96,"area":"镇江","co":1.347,"co_24h":1.046,"no2":39,"no2_24h":39,"o3":16,"o3_24h":61,"o3_8h":32,"o3_8h_24h":54,"pm10":0,"pm10_24h":74,"pm2_5":72,"pm2_5_24h":81,"quality":"良","level":"二级","so2":9,"so2_24h":10,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":96,"area":"桂林","co":1.341,"co_24h":1.514,"no2":20,"no2_24h":31,"o3":38,"o3_24h":337,"o3_8h":46,"o3_8h_24h":99,"pm10":73,"pm10_24h":74,"pm2_5":72,"pm2_5_24h":74,"quality":"良","level":"二级","so2":20,"so2_24h":29,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":100,"area":"马鞍山","co":3.983,"co_24h":3.474,"no2":34,"no2_24h":35,"o3":25,"o3_24h":71,"o3_8h":30,"o3_8h_24h":49,"pm10":84,"pm10_24h":104,"pm2_5":75,"pm2_5_24h":82,"quality":"良","level":"二级","so2":32,"so2_24h":36,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":100,"area":"金坛","co":0,"co_24h":1.852,"no2":33,"no2_24h":50,"o3":15,"o3_24h":75,"o3_8h":42,"o3_8h_24h":55,"pm10":84,"pm10_24h":84,"pm2_5":75,"pm2_5_24h":88,"quality":"良","level":"二级","so2":23,"so2_24h":26,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":100,"area":"扬州","co":1.292,"co_24h":0.838,"no2":24,"no2_24h":28,"o3":18,"o3_24h":58,"o3_8h":25,"o3_8h_24h":52,"pm10":92,"pm10_24h":81,"pm2_5":75,"pm2_5_24h":64,"quality":"良","level":"二级","so2":18,"so2_24h":18,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":102,"area":"厦门","co":1.083,"co_24h":0.823,"no2":61,"no2_24h":74,"o3":84,"o3_24h":105,"o3_8h":33,"o3_8h_24h":96,"pm10":127,"pm10_24h":84,"pm2_5":76,"pm2_5_24h":54,"quality":"轻度污染","level":"三级","so2":33,"so2_24h":36,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":103,"area":"焦作","co":3.131,"co_24h":4.509,"no2":72,"no2_24h":98,"o3":13,"o3_24h":13,"o3_8h":9,"o3_8h_24h":10,"pm10":147,"pm10_24h":250,"pm2_5":77,"pm2_5_24h":153,"quality":"轻度污染","level":"三级","so2":142,"so2_24h":172,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":103,"area":"聊城","co":2.325,"co_24h":3.225,"no2":60,"no2_24h":72,"o3":12,"o3_24h":22,"o3_8h":8,"o3_8h_24h":14,"pm10":103,"pm10_24h":200,"pm2_5":77,"pm2_5_24h":130,"quality":"轻度污染","level":"三级","so2":467,"so2_24h":126,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":105,"area":"遵义","co":0.978,"co_24h":1.277,"no2":31,"no2_24h":45,"o3":30,"o3_24h":42,"o3_8h":20,"o3_8h_24h":40,"pm10":99,"pm10_24h":146,"pm2_5":78,"pm2_5_24h":108,"quality":"轻度污染","level":"三级","so2":38,"so2_24h":67,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":107,"area":"句容","co":1.63,"co_24h":0.939,"no2":44,"no2_24h":44,"o3":30,"o3_24h":114,"o3_8h":65,"o3_8h_24h":95,"pm10":0,"pm10_24h":39,"pm2_5":80,"pm2_5_24h":64,"quality":"轻度污染","level":"三级","so2":37,"so2_24h":36,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":112,"area":"郑州","co":2.764,"co_24h":3.319,"no2":64,"no2_24h":83,"o3":21,"o3_24h":22,"o3_8h":16,"o3_8h_24h":19,"pm10":118,"pm10_24h":164,"pm2_5":84,"pm2_5_24h":130,"quality":"轻度污染","level":"三级","so2":72,"so2_24h":132,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":114,"area":"克拉玛依","co":1.241,"co_24h":1.025,"no2":39,"no2_24h":37,"o3":27,"o3_24h":44,"o3_8h":15,"o3_8h_24h":43,"pm10":134,"pm10_24h":85,"pm2_5":86,"pm2_5_24h":72,"quality":"轻度污染","level":"三级","so2":22,"so2_24h":9,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":117,"area":"中山","co":1.409,"co_24h":0.869,"no2":77,"no2_24h":61,"o3":24,"o3_24h":59,"o3_8h":19,"o3_8h_24h":57,"pm10":126,"pm10_24h":87,"pm2_5":88,"pm2_5_24h":56,"quality":"轻度污染","level":"三级","so2":29,"so2_24h":20,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":127,"area":"宜宾","co":3.078,"co_24h":3.025,"no2":31,"no2_24h":35,"o3":19,"o3_24h":49,"o3_8h":14,"o3_8h_24h":29,"pm10":132,"pm10_24h":112,"pm2_5":96,"pm2_5_24h":83,"quality":"轻度污染","level":"三级","so2":41,"so2_24h":28,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":127,"area":"南京","co":2.014,"co_24h":1.15,"no2":48,"no2_24h":46,"o3":14,"o3_24h":76,"o3_8h":29,"o3_8h_24h":56,"pm10":106,"pm10_24h":95,"pm2_5":96,"pm2_5_24h":76,"quality":"轻度污染","level":"三级","so2":23,"so2_24h":17,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":132,"area":"重庆","co":1.267,"co_24h":1.277,"no2":40,"no2_24h":37,"o3":9,"o3_24h":18,"o3_8h":7,"o3_8h_24h":14,"pm10":121,"pm10_24h":137,"pm2_5":100,"pm2_5_24h":102,"quality":"轻度污染","level":"三级","so2":46,"so2_24h":48,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":135,"area":"开封","co":1.762,"co_24h":2.163,"no2":30,"no2_24h":45,"o3":14,"o3_24h":14,"o3_8h":6,"o3_8h_24h":8,"pm10":120,"pm10_24h":164,"pm2_5":103,"pm2_5_24h":145,"quality":"轻度污染","level":"三级","so2":64,"so2_24h":85,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":137,"area":"安阳","co":1.656,"co_24h":2.048,"no2":52,"no2_24h":96,"o3":31,"o3_24h":33,"o3_8h":17,"o3_8h_24h":20,"pm10":0,"pm10_24h":186,"pm2_5":104,"pm2_5_24h":155,"quality":"轻度污染","level":"三级","so2":68,"so2_24h":106,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":142,"area":"包头","co":2.083,"co_24h":2.414,"no2":22,"no2_24h":35,"o3":48,"o3_24h":49,"o3_8h":27,"o3_8h_24h":44,"pm10":233,"pm10_24h":155,"pm2_5":86,"pm2_5_24h":46,"quality":"轻度污染","level":"三级","so2":63,"so2_24h":65,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":144,"area":"南昌","co":1.863,"co_24h":1.668,"no2":40,"no2_24h":38,"o3":20,"o3_24h":34,"o3_8h":17,"o3_8h_24h":22,"pm10":124,"pm10_24h":71,"pm2_5":110,"pm2_5_24h":62,"quality":"轻度污染","level":"三级","so2":21,"so2_24h":13,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":146,"area":"九江","co":1.895,"co_24h":1.856,"no2":55,"no2_24h":51,"o3":3,"o3_24h":11,"o3_8h":1,"o3_8h_24h":11,"pm10":144,"pm10_24h":117,"pm2_5":112,"pm2_5_24h":86,"quality":"轻度污染","level":"三级","so2":42,"so2_24h":21,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":149,"area":"岳阳","co":1.889,"co_24h":1.965,"no2":32,"no2_24h":33,"o3":21,"o3_24h":23,"o3_8h":15,"o3_8h_24h":16,"pm10":191,"pm10_24h":214,"pm2_5":114,"pm2_5_24h":120,"quality":"轻度污染","level":"三级","so2":44,"so2_24h":30,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":149,"area":"泸州","co":1.405,"co_24h":0.869,"no2":36,"no2_24h":49,"o3":51,"o3_24h":49,"o3_8h":15,"o3_8h_24h":29,"pm10":124,"pm10_24h":151,"pm2_5":114,"pm2_5_24h":110,"quality":"轻度污染","level":"三级","so2":70,"so2_24h":51,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":157,"area":"曲靖","co":1.469,"co_24h":1.325,"no2":21,"no2_24h":24,"o3":70,"o3_24h":115,"o3_8h":48,"o3_8h_24h":114,"pm10":263,"pm10_24h":124,"pm2_5":106,"pm2_5_24h":46,"quality":"中度污染","level":"四级","so2":69,"so2_24h":47,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":173,"area":"库尔勒","co":1.37,"co_24h":1.796,"no2":14,"no2_24h":22,"o3":62,"o3_24h":72,"o3_8h":55,"o3_8h_24h":67,"pm10":294,"pm10_24h":281,"pm2_5":83,"pm2_5_24h":68,"quality":"中度污染","level":"四级","so2":23,"so2_24h":15,"primary_pollutant":"颗粒物(PM10)","time_point":"2014-01-08T14:00:00Z"},{"aqi":176,"area":"常德","co":1.599,"co_24h":1.701,"no2":24,"no2_24h":24,"o3":31,"o3_24h":39,"o3_8h":28,"o3_8h_24h":36,"pm10":162,"pm10_24h":189,"pm2_5":133,"pm2_5_24h":154,"quality":"中度污染","level":"四级","so2":66,"so2_24h":38,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":180,"area":"张家界","co":1.135,"co_24h":1.357,"no2":20,"no2_24h":25,"o3":50,"o3_24h":94,"o3_8h":63,"o3_8h_24h":87,"pm10":150,"pm10_24h":147,"pm2_5":136,"pm2_5_24h":133,"quality":"中度污染","level":"四级","so2":47,"so2_24h":33,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":186,"area":"长沙","co":1.516,"co_24h":1.673,"no2":45,"no2_24h":51,"o3":32,"o3_24h":33,"o3_8h":22,"o3_8h_24h":23,"pm10":0,"pm10_24h":70,"pm2_5":140,"pm2_5_24h":148,"quality":"中度污染","level":"四级","so2":40,"so2_24h":29,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":186,"area":"平顶山","co":2.212,"co_24h":2.362,"no2":81,"no2_24h":88,"o3":13,"o3_24h":62,"o3_8h":10,"o3_8h_24h":49,"pm10":195,"pm10_24h":225,"pm2_5":140,"pm2_5_24h":167,"quality":"中度污染","level":"四级","so2":124,"so2_24h":112,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":192,"area":"荆州","co":1.839,"co_24h":1.847,"no2":34,"no2_24h":36,"o3":39,"o3_24h":43,"o3_8h":26,"o3_8h_24h":38,"pm10":224,"pm10_24h":250,"pm2_5":144,"pm2_5_24h":174,"quality":"中度污染","level":"四级","so2":76,"so2_24h":61,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":194,"area":"乌鲁木齐","co":2.255,"co_24h":2.216,"no2":59,"no2_24h":67,"o3":18,"o3_24h":19,"o3_8h":7,"o3_8h_24h":17,"pm10":190,"pm10_24h":185,"pm2_5":146,"pm2_5_24h":138,"quality":"中度污染","level":"四级","so2":99,"so2_24h":71,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":197,"area":"邯郸","co":1.477,"co_24h":2.695,"no2":56,"no2_24h":71,"o3":21,"o3_24h":21,"o3_8h":9,"o3_8h_24h":10,"pm10":205,"pm10_24h":236,"pm2_5":148,"pm2_5_24h":191,"quality":"中度污染","level":"四级","so2":76,"so2_24h":115,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":197,"area":"湘潭","co":1.686,"co_24h":1.773,"no2":36,"no2_24h":41,"o3":29,"o3_24h":30,"o3_8h":23,"o3_8h_24h":24,"pm10":177,"pm10_24h":167,"pm2_5":148,"pm2_5_24h":143,"quality":"中度污染","level":"四级","so2":47,"so2_24h":35,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":200,"area":"株洲","co":1.284,"co_24h":1.423,"no2":33,"no2_24h":45,"o3":21,"o3_24h":20,"o3_8h":14,"o3_8h_24h":14,"pm10":169,"pm10_24h":167,"pm2_5":150,"pm2_5_24h":139,"quality":"中度污染","level":"四级","so2":53,"so2_24h":41,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":209,"area":"邢台","co":0.946,"co_24h":2.009,"no2":55,"no2_24h":87,"o3":38,"o3_24h":69,"o3_8h":15,"o3_8h_24h":51,"pm10":266,"pm10_24h":330,"pm2_5":158,"pm2_5_24h":200,"quality":"重度污染","level":"五级","so2":132,"so2_24h":170,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":219,"area":"珠海","co":1.887,"co_24h":1.128,"no2":162,"no2_24h":80,"o3":43,"o3_24h":78,"o3_8h":35,"o3_8h_24h":76,"pm10":194,"pm10_24h":87,"pm2_5":168,"pm2_5_24h":56,"quality":"重度污染","level":"五级","so2":33,"so2_24h":18,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":230,"area":"武汉","co":1.892,"co_24h":2.082,"no2":44,"no2_24h":57,"o3":46,"o3_24h":138,"o3_8h":29,"o3_8h_24h":38,"pm10":173,"pm10_24h":133,"pm2_5":179,"pm2_5_24h":213,"quality":"重度污染","level":"五级","so2":63,"so2_24h":49,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":232,"area":"菏泽","co":2.211,"co_24h":3.133,"no2":51,"no2_24h":86,"o3":43,"o3_24h":37,"o3_8h":17,"o3_8h_24h":26,"pm10":211,"pm10_24h":329,"pm2_5":181,"pm2_5_24h":245,"quality":"重度污染","level":"五级","so2":82,"so2_24h":130,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":260,"area":"宜昌","co":1.817,"co_24h":1.83,"no2":28,"no2_24h":29,"o3":23,"o3_24h":23,"o3_8h":13,"o3_8h_24h":14,"pm10":239,"pm10_24h":253,"pm2_5":210,"pm2_5_24h":226,"quality":"重度污染","level":"五级","so2":83,"so2_24h":63,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"},{"aqi":317,"area":"合肥","co":2.452,"co_24h":1.438,"no2":36,"no2_24h":29,"o3":25,"o3_24h":76,"o3_8h":30,"o3_8h_24h":46,"pm10":213,"pm10_24h":175,"pm2_5":266,"pm2_5_24h":127,"quality":"严重污染","level":"六级","so2":29,"so2_24h":18,"primary_pollutant":"颗粒物(PM2.5)","time_point":"2014-01-08T14:00:00Z"}]