<?php
/**
 * 描述 : 单点登录系统封装包
 * 注明 :
 *      为了更方便嵌入, 本封装设计为单文件, sso 类可以随意改名
 *      不同系统的 SESSION 可能不同, 所以要相对修改 sso::init 的 self::$config['cookie'] 和 sso::data 两个位置
 * 作者 : Edgar.lee
 */
class sso {
    private static $config = array(
        //对接网址
        'url'    => 'http://edgar/oFramework/oFrame/include/of/?c=of_base_sso_api',
        //对接帐号
        'name'   => 'sso',
        //对接密码
        'key'    => '123456',
        //帐号变动回调URL
        'notify' => '',
    );
    //默认请求参数
    private static $params = null;
    //默认空间
    private static $space = 'default';

    /**
     * 描述 : 初始化
     * 作者 : Edgar.lee
     */
    public static function init() {
        $temp = empty($_SERVER['HTTP_HOST']) ? array('127.0.0.1') : explode(':', $_SERVER['HTTP_HOST']);
        self::$params = array(
            'scheme' => empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off' ? 'http' : 'https',
            'host'   => &$temp[0],
            'path'   => $_SERVER['SCRIPT_NAME'],
            'port'   => isset($temp[1]) ? (int)$temp[1] : 80,
            'query'  => ''
        );
        //附带notify的cookie
        self::$config['cookie'] = session_name() . '=' . session_id();
    }

    /**
     * 描述 : 检查登录状态
     * 参数 :
     *      type  : 登录类型, false = 跳转登录, true = 接口登录
     *      space : 验证登录的空间
     * 返回 :
     *      str=登录名,false=未登录,exit=未知
     * 作者 : Edgar.lee
     */
    public static function check($type = false, $space = '') {
        //指定空间 ? 设置默认空间 : 使用默认空间
        $space ? self::$space = $space : $space = self::$space;
        //工具包session引用
        $tool = &self::session(1, $space);
        //引用配置文件
        $config = &$tool['config'];

        //跳转登录 && 跳转回写
        if (
            !$type &&
            isset($_SERVER['HTTP_REFERER']) &&
            strpos($_SERVER['HTTP_REFERER'], '=of_base_sso_main') &&
            isset($_REQUEST['data']) && isset($_REQUEST['md5'])
        ) {
            //去斜线
            $data = $_REQUEST['data'][1] === '"' ?
                $_REQUEST['data'] : stripslashes($_REQUEST['data']);

            //校验通过
            if (
                isset($tool['check']) && isset($_REQUEST['md5']) &&
                md5($data . $tool['check'] . $config['key']) === $_REQUEST['md5']
            ) {
                //解码json
                $data = json_decode($data, true);
                $tool['ticket'] = $data['ticket'];
                //刷新当前页面
                header('Location: ?' . http_build_query(
                    array_diff_key($_GET, array('data' => 1, 'md5' => 1))
                ));
                exit;
            //校验失败
            } else {
                //跳转登录
                header('Location: ' . self::login('', $space));
                exit;
            }
        //接口登录 && 票据为空
        } else if ($type && empty($tool['ticket'])) {
            //接口回写
            if (isset($_COOKIE['of_base_sso']['ticket'][$space])) {
                $tool['ticket'] = $_COOKIE['of_base_sso']['ticket'][$space];
                //删除票据
                setcookie(rawurlencode('of_base_sso[ticket][' .$space. ']'), null, null, null);
            } else {
                //计算服务端路径
                $temp = self::getUrl($config['url'], array(
                    'a'        => 'ticket',
                    'c'        => 'of_base_sso_api',
                    'space'    => $space,
                    'name'     => $config['name'],
                    'callback' => 'callback'
                ));

                echo "<script>var callback = function (json) {
                    if (json.state === 200) {
                        document.cookie = 'of_base_sso[ticket][{$space}]=' + encodeURIComponent(json.ticket);
                        window.location.reload();
                    } else {
                        alert(json.msg);
                        throw new Error('SSO system response error : ' + json.msg);
                    }
                };</script>",
                "<script src='{$temp}'></script>";
                exit;
            }
        }

        //票据存在 && 未登录状态 && 校验登入状态
        isset($tool['ticket']) && empty($tool['online'][$space]['user']) &&
            self::login(null, $space);

        //保存数据
        self::session(8, $space);
        //没登入
        if (empty($tool['online'][$space]['user'])) {
            return false;
        //已登录
        } else {
            return $tool['online'][$space]['name'];
        }
    }

    /**
     * 描述 : 登录用户
     * 参数 :
     *      args  : 登录参数, 
     *          null  = 验证当前用户是否登录, 
     *          str   = 生成跳转模式下跳转的连接, 
     *          array = 接口模式下的登录帐号{
     *              "user" : 用户名
     *              "pwd"  : 登录密码
     *          }
     *      space : ("default")登录的空间
     * 注明 :
     *      帐号与密码为null时,表示查询当前登录用户及权限
     * 返回 :
     *      true=成功,false=失败,数组=出错{"state" : 状态码, "msg" : 错误信息}
     * 作者 : Edgar.lee
     */
    public static function login($args = '', $space = '') {
        //使用默认空间
        $space || $space = self::$space;
        //工具包session引用
        $tool = &self::session(1, $space);
        //引用配置文件
        $config = &$tool['config'];

        $data = array(
            'a'      => 'check',
            'space'  => &$space,
            'notify' => $config['notify'],
            'cookie' => $config['cookie'],
            //获取没有的权限
            'role'   => 3
        );

        //跳转模式的登录路径
        if (is_string($args)) {
            $data = array(
                'a'       => 'index',
                'c'       => 'of_base_sso_main',
                'referer' => self::getUrl($args),
                'check'   => $tool['check'],
                'name'    => &$config['name'],
            ) + $data;
            $data = self::getUrl($config['url'], $data);
            self::session(8, $space);
            return $data;
        } else {
            //用户登录
            if (is_array($args) && !empty($args['user'])) {
                //指定帐号密码登入
                $data += array(
                    'user' => &$args['user'],
                    'pwd'  => &$args['pwd']
                );
                //附加用户数据
                $extra['server'] = json_encode($_SERVER);
            } else {
                $extra = array();
            }

            $data = &self::request($data, $space, $extra);
            if ($data['state'] === 200) {
                //用户未登录
                if (empty($data['user'])) {
                    //移除登入状态
                    unset($tool['online'][$space]);
                } else {
                    //添加登录信息
                    $tool['online'][$space] = array(
                        'user' => &$data['user'],
                        'name' => &$data['name'],
                        'nick' => &$data['nick'],
                        'role' => &$data['role'],
                        'notes' => &$data['notes'],
                        //兼容历史错误nike应为nick
                        'nike' => &$data['nike']
                    );
                }

                self::session(8, $space);
                return !empty($data['user']);
            }
            return $data;
        }
    }

    /**
     * 描述 : 退出登录用户
     * 参数 :
     *      space : ("default")登录的空间
     * 作者 : Edgar.lee
     */
    public static function logout($space = '') {
        //使用默认空间
        $space || $space = self::$space;
        //发送退出请求
        $params = array(
            'a'     => 'logout',
            'space' => &$space
        );
        $data = &self::request($params, $space);

        //解析成功
        if ($data['state'] === 200) {
            //退出登录
            self::session(2, $space);
            return true;
        }

        self::session(8, $space);
        return $data['msg'];
    }

    /**
     * 描述 : 获取当前登录用户信息
     * 返回 :
     *      null=未登录, 数组=登录结构 {
     *          "user"   : SSO中的用户ID
     *          "name"   : 用户帐号
     *          "nick"   : 用户昵称
     *          "notes"  : 用户备注
     *          "role"   : 角色权限包, 如果登录了存在 {
     *              "allow" : 允许访问接口,当获取拥有权限时存在 {
     *                  "pack" : {
     *                      "角色名" : {
     *                          "data" : 角色自带的数据
     *                          "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                      }
     *                  }
     *                  "func" : {
     *                      "功能名" : {
     *                          "data" : 功能自带的数据
     *                      }
     *                  }
     *              },
     *              "deny"  : 拒绝访问接口,当获取没有权限时存在 {
     *                  "pack" : {
     *                      "角色名" : {
     *                          "data" : 角色自带的数据
     *                          "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                      }
     *                  }
     *                  "func" : {
     *                      "功能名" : {
     *                          "data" : 功能自带的数据
     *                      }
     *                  }
     *              }
     *          }
     *      }
     * 作者 : Edgar.lee
     */
    public static function &user($key = null, $space = '') {
        //使用默认空间
        $space || $space = self::$space;
        //工具包session引用
        $tool = &self::session(1, $space);
        if (isset($tool['online'][$space])) {
            $result = &$tool['online'][$space];
            if (is_string($key)) {
                isset($result[$key]) ?
                    $result = &$result[$key] : $result = &$index;
            }
        }

        return $result;
    }

    /**
     * 描述 : 用户状态变化回调
     * 作者 : Edgar.lee
     */
    public static function state() {
        //工具包session引用
        $tool = &self::session(1, $_GET['space']);

        if (isset($tool['ticket']) && $tool['ticket'] === $_GET['ticket']) {
            self::login(null, $_GET['space']);
        }
    }

    /**
     * 描述 : 验证权限
     * 参数 :
     *      role  : 验证权限的键值
     *      space : ("default")登录的空间
     * 注明 :
     *      同时包含有权和无权的包时,系统认定有权
     * 返回 :
     *      true=有权限, false=无权限
     * 作者 : Edgar.lee
     */
    public static function role($role, $space = '') {
        //使用默认空间
        $space || $space = self::$space;
        //工具包session引用
        $tool = &self::session(1, $space);
        return isset($tool['online'][$space]) && !isset($tool['online'][$space]['role']['deny']['func'][$role]);
    }

    /**
     * 描述 : 集成功能
     * 参数 :
     *      func : 功能名
     *      data : 对应功能的数据参数
     * 返回 :
     *      
     * 作者 : Edgar.lee
     */
    public static function func($func = null, $data = array(), $space = '') {
        $data['a'] = 'func';
        $data['type'] = &$func;
        return self::request($data, $space ? $space : self::$space);
    }

    /**
     * 描述 : 发送get请求
     * 参数 :
     *     &url : 带GET参数的
     * 返回 :
     *      响应数据
     * 作者 : Edgar.lee
     */
    private static function &request(&$params, $space, &$extra = array()) {
        //工具包session引用
        $tool = &self::session(1, $space);
        //引用配置文件
        $config = &$tool['config'];

        $params += array(
            'c'      => 'of_base_sso_api',
            'name'   => &$config['name'], 
            'ticket' => $tool['ticket']
        );
        $url = self::getUrl($config['url'], $params, $config['key']);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //设置post方式提交
        if ($extra) {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($extra));
        }
        //引用响应值
        $response = $data = curl_exec($ch);
        curl_close($ch);

        if ($data = json_decode($data, true)) {
            isset($data['ticket']) && $tool['ticket'] = $data['ticket'];
            unset($data['ticket']);
        } else {
            $data = array(
                'state' => 500,
                'msg'   => '通信失败'
            );
        }

        if ($data['state'] >= 500) {
            self::session(4, $space);

            if ($data['state'] !== 504) {
                //相关校验信息未通过
                trigger_error("Bad request: " . print_r($response, true));
                exit;
            }
        }
        return $data;
    }

    /**
     * 描述 : 合并路径的get参数
     * 参数 :
     *      url : 待合并的URL
     *      get : 整合的get数组
     *      key : ''=不生成md5,字符串=md5的密钥
     * 返回 :
     *      合并后的url
     * 作者 : Edgar.lee
     */
    private static function getUrl($url, $get = array(), $key = '') {
        $url = $url ? parse_url(stripslashes($url)) : array();
        isset($url['host']) && empty($url['port']) && $url['port'] = '';
        $url += self::$params;
        $url['port'] && $url['port'] = ':' . $url['port'];
        parse_str($url['query'], $url['query']);
        $url['query'] = $get + $url['query'];
        $key && $url['query']['md5'] = md5(join($url['query']) . $key);
        $url = "{$url['scheme']}://{$url['host']}{$url['port']}{$url['path']}?" . http_build_query($url['query']);
        return $url;
    }

    /**
     * 描述 : 操作会话数据
     * 参数 :
     *      order : 操作指令, 1=读取会话, 2=退出会话, 4=清空会话, 8=重置会话
     *      space : 操作空间
     * 返回 :
     *      {
     *          "config" :&SSO配置
     *          "ticket" :&通信票据
     *          "online" :&在线用户
     *          "check"  :&票据校验
     *      }
     * 注明 :
     *      客户端的信息包 {
     *              "client" : {
     *                  登录空间 : {
     *                      "digest" : 配置标识
     *                      "ticket" : 通信票据
     *                      "check"  : 票据校验
     *                  }, ...
     *              }
     *              "online" : {
     *                  登录空间 : 在线用户 {
     *                  "user" : SSO中的用户ID
     *                  "name" : 用户名
     *                  "nick" : 昵称
     *                  "role" : 角色权限包, 如果登录了存在 {
     *                      "allow" : 允许访问接口,当获取拥有权限时存在 {
     *                          "pack" : {
     *                              角色名 : {
     *                                  "data" : 角色自带的数据
     *                                  "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                              }
     *                          }
     *                          "func" : {
     *                              功能名 : {
     *                                  "data" : 功能自带的数据
     *                              }
     *                          }
     *                      },
     *                      "deny"  : 拒绝访问接口,当获取没有权限时存在 {
     *                          "pack" : {
     *                              角色名 : {
     *                                  "data" : 角色自带的数据
     *                                  "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                              }
     *                          }
     *                          "func" : {
     *                              功能名 : {
     *                                  "data" : 功能自带的数据
     *                              }
     *                          }
     *                      }
     *                  }
     *              }
     *          }
     *      }
     * 作者 : Edgar.lee
     */
    private static function &session($order, $space) {
        //登录配置 {空间正则 : SSO配置, ...}
        static $config = null;
        //空间配置 {配置标识 : {"ticket" : 通信票据, "config" : SSO配置}, ...}
        static $sConf = array();
        //缓存结果集
        static $result = null;
        //读取SESSION数据
        $tool = &self::data();

        //初始化sso配置
        if ($config === null) {
            //读取sso配置
            $config = self::$config;
            //追加重置会话
            $order |= 8;

            //单点配置客户端 || 单点配置服务端
            if (isset($config['name']) || isset($config['dbPool'])) {
                //格式sso配置=>{空间正则 : SSO配置, ...}
                $config = array('@.@' => $config);
            }

            //生成空间配置
            foreach ($config as $k => &$v) {
                //含客户端配置
                if (isset($v['name'])) {
                    //计算服务端标识
                    $v['digest'] = md5($v['url']);
                    //通过标识引用配置
                    $sConf[$v['digest']]['config'] = &$v;
                //移除服务端配置
                } else {
                    unset($config[$k]);
                }
            }
        }

        if ($order & 8) {
            //初始化在线列表
            isset($tool['online']) || $tool['online'] = array();
            //初始客户端ticket列表
            ($index = &$tool['client']) || $index = array();

            //整理客户端连接
            foreach ($index as $k => &$v) {
                //空间配置存在
                if (isset($sConf[$v['digest']])) {
                    //共享相同配置的相同 ticket
                    $sConf[$v['digest']]['ticket'] = &$v['ticket'];
                //清理无效登录
                } else {
                    unset($tool['client'][$k], $tool['online'][$k]);
                }
            }

            //回写SESSION数据
            self::data($tool);
        }

        //空间连接不存在
        if (empty($tool['client'][$space])) {
            //匹配SSO登录配置
            foreach ($config as $k => &$v) {
                //空间匹配成功
                if (preg_match($k, $space)) {
                    $tool['client'][$space] = array(
                        'digest' => &$v['digest'],
                        'ticket' => &$sConf[$v['digest']]['ticket'],
                        'check'  => ''
                    );
                    break ;
                }
            }
        }

        //客户端有效
        if (isset($tool['client'][$space])) {
            //引用框架客户端连接
            $index = &$tool['client'][$space];

            //退出会话
            if ($order & 2) {
                unset($tool['online'][$space]);
            //清空会话
            } else if ($order & 4) {
                //清空所有共享的ticket
                $index['ticket'] = null;
                //清空所有共享ticket登录信息
                foreach ($tool['online'] as $k => &$v) {
                    if (!$tool['client'][$k]['ticket']) unset($tool['online'][$k]);
                }
            }

            //修改空间会话数据
            $result = array(
                'config' => &$sConf[$index['digest']]['config'],
                'ticket' => &$index['ticket'],
                'online' => &$tool['online'],
                'check'  => &$index['check'],
            );
            return $result;
        //SSO空间无效
        } else {
            throw new Exception('SSO space is invalid: ' . $space);
        }
    }

    /**
     * 描述 : 数据读取与设置
     * 参数 :
     *      value : null = 读取数据, array = 保存数据
     * 注明 :
     *      客户端的信息包 {
     *              "client" : {
     *                  登录空间 : {
     *                      "digest" : 配置标识
     *                      "ticket" : 通信票据
     *                      "check"  : 票据校验
     *                  }, ...
     *              }
     *              "online" : {
     *                  登录空间 : 在线用户 {
     *                  "user" : SSO中的用户ID
     *                  "name" : 用户名
     *                  "nick" : 昵称
     *                  "role" : 角色权限包, 如果登录了存在 {
     *                      "allow" : 允许访问接口,当获取拥有权限时存在 {
     *                          "pack" : {
     *                              角色名 : {
     *                                  "data" : 角色自带的数据
     *                                  "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                              }
     *                          }
     *                          "func" : {
     *                              功能名 : {
     *                                  "data" : 功能自带的数据
     *                              }
     *                          }
     *                      },
     *                      "deny"  : 拒绝访问接口,当获取没有权限时存在 {
     *                          "pack" : {
     *                              角色名 : {
     *                                  "data" : 角色自带的数据
     *                                  "func" : {功能名1：功能名1，功能名2;功能名2...}
     *                              }
     *                          }
     *                          "func" : {
     *                              功能名 : {
     *                                  "data" : 功能自带的数据
     *                              }
     *                          }
     *                      }
     *                  }
     *              }
     *          }
     *      }
     * 作者 : Edgar.lee
     */
    private static function &data(&$value = null) {
        $value === null || $_SESSION['_of']['of_base_sso']['tool'] = $value;
        return $_SESSION['_of']['of_base_sso']['tool'];
    }
}
sso::init();