/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int width, int height, int[] pixels) {
        super(width, height);
        this.dataWidth = width;
        this.dataHeight = height;
        this.left = 0;
        this.top = 0;
        this.luminances = new byte[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[offset + x];
                int r = pixel >> 16 & 0xFF;
                int g2 = pixel >> 8 & 0xFF;
                int b2 = pixel & 0xFF;
                this.luminances[offset + x] = r == g2 && g2 == b2 ? (byte)r : (byte)((r + 2 * g2 + b2) / 4);
            }
        }
    }

    private RGBLuminanceSource(byte[] pixels, int dataWidth, int dataHeight, int left, int top, int width, int height) {
        super(width, height);
        if (left + width > dataWidth || top + height > dataHeight) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.luminances = pixels;
        this.dataWidth = dataWidth;
        this.dataHeight = dataHeight;
        this.left = left;
        this.top = top;
    }

    @Override
    public byte[] getRow(int y, byte[] row) {
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + y);
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        int offset = (y + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.luminances, offset, row, 0, width);
        return row;
    }

    @Override
    public byte[] getMatrix() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == this.dataWidth && height == this.dataHeight) {
            return this.luminances;
        }
        int area = width * height;
        byte[] matrix = new byte[area];
        int inputOffset = this.top * this.dataWidth + this.left;
        if (width == this.dataWidth) {
            System.arraycopy(this.luminances, inputOffset, matrix, 0, area);
            return matrix;
        }
        byte[] rgb = this.luminances;
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            System.arraycopy(rgb, inputOffset, matrix, outputOffset, width);
            inputOffset += this.dataWidth;
        }
        return matrix;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int left, int top, int width, int height) {
        return new RGBLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + left, this.top + top, width, height);
    }
}

