/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

public final class RSSUtils {
    private RSSUtils() {
    }

    public static int getRSSvalue(int[] widths, int maxWidth, boolean noNarrow) {
        int elements = widths.length;
        int n2 = 0;
        for (int width : widths) {
            n2 += width;
        }
        int val = 0;
        int narrowMask = 0;
        for (int bar = 0; bar < elements - 1; ++bar) {
            int elmWidth = 1;
            narrowMask |= 1 << bar;
            while (elmWidth < widths[bar]) {
                int subVal = RSSUtils.combins(n2 - elmWidth - 1, elements - bar - 2);
                if (noNarrow && narrowMask == 0 && n2 - elmWidth - (elements - bar - 1) >= elements - bar - 1) {
                    subVal -= RSSUtils.combins(n2 - elmWidth - (elements - bar), elements - bar - 2);
                }
                if (elements - bar - 1 > 1) {
                    int lessVal = 0;
                    for (int mxwElement = n2 - elmWidth - (elements - bar - 2); mxwElement > maxWidth; --mxwElement) {
                        lessVal += RSSUtils.combins(n2 - elmWidth - mxwElement - 1, elements - bar - 3);
                    }
                    subVal -= lessVal * (elements - 1 - bar);
                } else if (n2 - elmWidth > maxWidth) {
                    --subVal;
                }
                val += subVal;
                ++elmWidth;
                narrowMask &= ~(1 << bar);
            }
            n2 -= elmWidth;
        }
        return val;
    }

    private static int combins(int n2, int r) {
        int maxDenom;
        int minDenom;
        if (n2 - r > r) {
            minDenom = r;
            maxDenom = n2 - r;
        } else {
            minDenom = n2 - r;
            maxDenom = r;
        }
        int val = 1;
        int j2 = 1;
        for (int i2 = n2; i2 > maxDenom; --i2) {
            val *= i2;
            if (j2 > minDenom) continue;
            val /= j2;
            ++j2;
        }
        while (j2 <= minDenom) {
            val /= j2;
            ++j2;
        }
        return val;
    }
}

