/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.DataMask;
import com.google.zxing.qrcode.decoder.FormatInformation;
import com.google.zxing.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int dimension = bitMatrix.getHeight();
        if (dimension < 21 || (dimension & 3) != 1) {
            throw FormatException.getFormatInstance();
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() throws FormatException {
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int formatInfoBits1 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            formatInfoBits1 = this.copyBit(i2, 8, formatInfoBits1);
        }
        formatInfoBits1 = this.copyBit(7, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 7, formatInfoBits1);
        for (int j2 = 5; j2 >= 0; --j2) {
            formatInfoBits1 = this.copyBit(8, j2, formatInfoBits1);
        }
        int dimension = this.bitMatrix.getHeight();
        int formatInfoBits2 = 0;
        int jMin = dimension - 7;
        for (int j3 = dimension - 1; j3 >= jMin; --j3) {
            formatInfoBits2 = this.copyBit(8, j3, formatInfoBits2);
        }
        for (int i3 = dimension - 8; i3 < dimension; ++i3) {
            formatInfoBits2 = this.copyBit(i3, 8, formatInfoBits2);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(formatInfoBits1, formatInfoBits2);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int i2;
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int dimension = this.bitMatrix.getHeight();
        int provisionalVersion = (dimension - 17) / 4;
        if (provisionalVersion <= 6) {
            return Version.getVersionForNumber(provisionalVersion);
        }
        int versionBits = 0;
        int ijMin = dimension - 11;
        for (int j2 = 5; j2 >= 0; --j2) {
            for (i2 = dimension - 9; i2 >= ijMin; --i2) {
                versionBits = this.copyBit(i2, j2, versionBits);
            }
        }
        Version theParsedVersion = Version.decodeVersionInformation(versionBits);
        if (theParsedVersion != null && theParsedVersion.getDimensionForVersion() == dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        versionBits = 0;
        for (i2 = 5; i2 >= 0; --i2) {
            for (int j3 = dimension - 9; j3 >= ijMin; --j3) {
                versionBits = this.copyBit(i2, j3, versionBits);
            }
        }
        theParsedVersion = Version.decodeVersionInformation(versionBits);
        if (theParsedVersion != null && theParsedVersion.getDimensionForVersion() == dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int i2, int j2, int versionBits) {
        boolean bit = this.mirror ? this.bitMatrix.get(j2, i2) : this.bitMatrix.get(i2, j2);
        return bit ? versionBits << 1 | 1 : versionBits << 1;
    }

    byte[] readCodewords() throws FormatException {
        FormatInformation formatInfo = this.readFormatInformation();
        Version version = this.readVersion();
        DataMask dataMask = DataMask.forReference(formatInfo.getDataMask());
        int dimension = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, dimension);
        BitMatrix functionPattern = version.buildFunctionPattern();
        boolean readingUp = true;
        byte[] result = new byte[version.getTotalCodewords()];
        int resultOffset = 0;
        int currentByte = 0;
        int bitsRead = 0;
        for (int j2 = dimension - 1; j2 > 0; j2 -= 2) {
            if (j2 == 6) {
                --j2;
            }
            for (int count = 0; count < dimension; ++count) {
                int i2 = readingUp ? dimension - 1 - count : count;
                for (int col = 0; col < 2; ++col) {
                    if (functionPattern.get(j2 - col, i2)) continue;
                    ++bitsRead;
                    currentByte <<= 1;
                    if (this.bitMatrix.get(j2 - col, i2)) {
                        currentByte |= 1;
                    }
                    if (bitsRead != 8) continue;
                    result[resultOffset++] = (byte)currentByte;
                    bitsRead = 0;
                    currentByte = 0;
                }
            }
            readingUp ^= true;
        }
        if (resultOffset != version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return result;
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        DataMask dataMask = DataMask.forReference(this.parsedFormatInfo.getDataMask());
        int dimension = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, dimension);
    }

    void setMirror(boolean mirror) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = mirror;
    }

    void mirror() {
        for (int x = 0; x < this.bitMatrix.getWidth(); ++x) {
            for (int y = x + 1; y < this.bitMatrix.getHeight(); ++y) {
                if (this.bitMatrix.get(x, y) == this.bitMatrix.get(y, x)) continue;
                this.bitMatrix.flip(y, x);
                this.bitMatrix.flip(x, y);
            }
        }
    }
}

