/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.ResultPoint;

public final class AlignmentPattern
extends ResultPoint {
    private final float estimatedModuleSize;

    AlignmentPattern(float posX, float posY, float estimatedModuleSize) {
        super(posX, posY);
        this.estimatedModuleSize = estimatedModuleSize;
    }

    boolean aboutEquals(float moduleSize, float i2, float j2) {
        if (Math.abs(i2 - this.getY()) <= moduleSize && Math.abs(j2 - this.getX()) <= moduleSize) {
            float moduleSizeDiff = Math.abs(moduleSize - this.estimatedModuleSize);
            return moduleSizeDiff <= 1.0f || moduleSizeDiff <= this.estimatedModuleSize;
        }
        return false;
    }

    AlignmentPattern combineEstimate(float i2, float j2, float newModuleSize) {
        float combinedX = (this.getX() + j2) / 2.0f;
        float combinedY = (this.getY() + i2) / 2.0f;
        float combinedModuleSize = (this.estimatedModuleSize + newModuleSize) / 2.0f;
        return new AlignmentPattern(combinedX, combinedY, combinedModuleSize);
    }
}

