/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int mark;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.mark = -1;
    }

    @Override
    public final int available() {
        return this.buf.remaining();
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized void mark(int n2) {
        this.mark = this.buf.position();
    }

    @Override
    public final synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.buf.position(this.mark);
    }

    @Override
    public final long skip(long l2) throws IOException {
        if (0L > l2) {
            return 0L;
        }
        int n2 = (int)Math.min((long)this.buf.remaining(), l2);
        this.buf.position(this.buf.position() + n2);
        return n2;
    }

    @Override
    public final int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("offset " + n2 + ", length " + n3 + ", b.length " + byArray.length);
        }
        if (0 == n3) {
            return 0;
        }
        int n4 = this.buf.remaining();
        if (0 == n4) {
            return -1;
        }
        int n5 = Math.min(n4, n3);
        if (this.buf.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byArray, n2, n5);
            this.buf.position(this.buf.position() + n5);
        } else {
            this.buf.get(byArray, n2, n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n2 + ", b " + byteBuffer);
        }
        if (0 == n2) {
            return 0;
        }
        int n3 = this.buf.remaining();
        if (0 == n3) {
            return -1;
        }
        int n4 = Math.min(n3, n2);
        if (this.buf.hasArray() && byteBuffer.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n4);
            this.buf.position(this.buf.position() + n4);
            byteBuffer.position(byteBuffer.position() + n4);
        } else if (n4 == n3) {
            byteBuffer.put(this.buf);
        } else {
            int n5 = this.buf.limit();
            this.buf.limit(n4);
            try {
                byteBuffer.put(this.buf);
            }
            finally {
                this.buf.limit(n5);
            }
        }
        return n4;
    }

    public final ByteBuffer getBuffer() {
        return this.buf;
    }
}

